COMMENT _

     Ŀ
       Sound Deluxe System 5                                          
       by Maple Leaf (a.k.a Gruian Radu), 1996-97                     
        Module player kernel                                         
       Assemble it with TASM 3.x: tasm /mx /o /w0 sds.asm             
       Ignore those stupid warnings!          			       
     
_



.model TPascal
.386
JUMPS

.CODE
        org 0

Description  db  "Sound Deluxe System 5.04, by Maple Leaf, 1996-1997",0,0



; macros 

CallFunc macro   FunctionNumber
         push    bx
         mov     bx,cs:Func
         mov     bx,cs:[bx+(FunctionNumber-1)*2]
         call    bx
         pop     bx
         endm

MoveD    macro   address   ; destroys EAX, SI !!!
         lodsd
         mov     address,eax
         endm

MoveW    macro   address   ; destroys AX, SI !!!
         lodsw
         mov     address,ax
         endm

MoveB    macro   address   ; destroys AL, SI !!!
         lodsb
         mov     address,al
         endm

; code public definitions 

        public   Pascal SDS_Init
        public   Pascal SDS_Done
        public   Pascal SDS_StartPlay
        public   Pascal SDS_StartFromPosition
        public   Pascal SDS_StopPlay
        public   Pascal SDS_SetPollMix
        public   Pascal SDS_Poll
        public   Pascal SDS_SetSurround
        public   Pascal SDS_SetAmplification
        public   Pascal SDS_Services
        public   Pascal SDS_FX_OpenChannel
        public   Pascal SDS_FX_Shoot

; code's local data/routines 

include macros.inc   ; macros - FIRST included file !
include equ.inc      ; symbols, constants
include stack.inc    ; dynamic stack
include debug.inc    ; developer's switches/debugging macros
include tables.inc   ; vol/vibrato/tremolo/VRI tables
include gdata.inc    ; Global data (common to all drivers)
include esb.inc      ; External Syncronization Block definitions
include jumps.inc    ; Macros - replacers for tasm's Jxx instructions
include timer.inc    ; Macros - timer specific jobs
include drv_gen.inc  ; Macros - drivers' general
include memory.inc   ; Memory allocation and deallocation routines
include dma.inc      ; 8/16 bit DMA routines
include irq.inc      ; IRQ-specific routines
include ems.inc      ; some EMS specific routines
include mixer199.inc ; DMA-based mono/stereo mixers
include efx_offs.inc ; Effects offsets table

; SDS drivers 

;  Warning!: this is a beta version of SDS and some of the drivers listed
;            below were not tested at all, so it's possible they will not
;            work right. (those marked with ;* WERE tested)

include sds_sb.asm       ;*  works
include sds_sbp.asm      ;*  works
include sds_sb16.asm     ;*  works
include sds_gus.asm      ;*  works
include sds_pas.asm      ;\
include sds_wss.asm      ; | ...still no information...
include sds_aria.asm     ;/
include sds_us.asm       ;*  works


;
; Drivers offsets.
;

driver  dw       offset sb_driver    ; 1. SB and SB 2.0 (DSP 1.x, 2.x)
        dw       offset sbp_driver   ; 2. SB Pro (DSP 3.x)
        dw       offset sb16_driver  ; 3. SB 16ASP (DSP 4.0+)
        dw       offset gus_driver   ; 4. Gravis UltraSound
        dw       offset pas_driver   ; 5. ProAudio Spectrum
        dw       offset wss_driver   ; 6. Windows Sound System/AudioTrix Pro
        dw       offset aria_driver  ; 7. Aria (Sierra SC18025/SC18026 DSP)
                                     ;
                                     ; The list remains open for
                                     ; any possible future addition
                                     ; (AdLib Gold, JAZZ16, AWE32 ...)
                                     ;
        dw       offset us_driver    ; 8. UltraSilence!(tm)...



; here we go! 


        db       "<STARTSDS>"

;
;   SDS_Init ( word Card, word Base, word Irq, word Dma )
;

SDS_Init proc    Card:WORD, Base:WORD, Irq:WORD, Dma:WORD
        push     ax bx dx ds
        call     stack_alloc   ; allocate SDS dynamic stack
        mov      bx,Card
        mov      cs:CCard,bx
        dec      bx
        add      bx,bx
        mov      ax,cs:[bx+offset driver]
        mov      cs:func,ax      ; Store offset of current driver function list
        mov      ax,Dma
        mov      ah,byte ptr Irq
        mov      dx,Base
        CallFunc 1   ; fn #1 = init specific driver
        push     0                                       ; Sets the 4 bytes at
        pop      ds                                      ; 0:4FCh to point to an
        mov      word ptr ds:[4FCh],offset ExtSyncrBlock ; internal block which is
        mov      word ptr ds:[4FEh],cs                   ; updated while playing.
        mov      ax,offset cs:sdsp              ;\
        mov      word ptr cs:DoPollAddr,ax      ; | SDS_Poll() routine address
        mov      word ptr cs:DoPollAddr[2],cs   ;/
        mov      ax,offset cs:bug2__            ;\
        mov      word ptr cs:ServRoutAddr,ax    ; | SDS_Services() routine address
        mov      word ptr cs:ServRoutAddr[2],cs ;/
        mov      ax,offset cs:Description       ;\
        mov      word ptr cs:Signature,ax       ; | Description string (ASCIIZ) address
        mov      word ptr cs:Signature[2],cs    ;/
        mov      cs:UserCounter,0
        mov      byte ptr cs:fx_channels,0      ; no fx channels yet
        mov      byte ptr cs:fx_startchn,0      ; no fx start channel yet
if API_2_enable ne 0
        call     OpenServices                   ; opens INT xx/xx API entry point
endif
        mov      ah,3
        mov      bx,100   ; normal amplification, has no effect on GUS
        call     cs:sds_services
        pop      ds dx bx ax
        leave
        retf
SDS_Init endp


;
;   SDS_Done ()
;

fproc   SDS_Done
        CallFunc 2                   ; fn #2 = shut down specific driver
if API_2_enable ne 0
        call     CloseServices
endif
        call     stack_free          ; deallocates dynamic stack
        retf
fendp   SDS_Done


;
;   byte SDS_FX_OpenChannel ()
;   Opens another channel for FX. The returned value is a FX-channel number
;   which is used later by the "shooting" routine and APIs service #25.
;

fproc   SDS_FX_OpenChannel
        mov      al,byte ptr cs:fx_channels
        inc      byte ptr cs:fx_channels
        retf
fendp   SDS_FX_OpenChannel

;
;   SDS_FX_Shoot(channel:byte; FX_structure:POINTER)
;   Starts playing an FX an the specified (!)_FX_(!) channel. The dword
;   is a pointer to an FX-structure described in SDS.PAS
;

SDS_FX_Shoot proc FX_CHN:BYTE, FX_STRUC:DWORD
        mov      al,FX_CHN
        mov      edi,dword ptr FX_STRUC
        mov      ah,25
        call     cs:sds_services
        leave
        retf
SDS_FX_Shoot endp

;
;   SDS_StartPlay ( pointer Module,
;                   word    InitSpd,
;                   word    MixSpeed,
;                   word    PAL )
;

Rate    dw       44100               ; User's mixing rate (temporary var)

SDS_StartPlay proc Module:DWORD, InitSpd:WORD, MixSpeed:WORD, PAL:WORD
        mov      cs:S_Row,0
        mov      cs:S_Order,0
        mov      eax,Module
        mov      cs:S_Module,eax
        mov      ax,InitSpd
        mov      cs:S_InitSpd,ax
        mov      ax,MixSpeed
        mov      cs:S_MixSpeed,ax
        mov      ax,PAL
        mov      cs:S_PAL,ax
        call     sds_Go
        leave
        retf
SDS_StartPlay endp

;
;   SDS_StartFromPosition ( pointer Module,
;                           word    InitSpd,
;                           word    MixSpeed,
;                           word    PAL,
;                           word    Start_Order,
;                           word    Start_Row )
;

SDS_StartFromPosition proc Module:DWORD, InitSpd:WORD, MixSpeed:WORD, PAL:WORD, Start_Order:WORD, Start_Row:WORD
        mov      ax,Start_Order
        mov      cs:S_Order,ax
        mov      ax,Start_Row
        mov      cs:S_Row,ax
        mov      eax,Module
        mov      cs:S_Module,eax
        mov      ax,InitSpd
        mov      cs:S_InitSpd,ax
        mov      ax,MixSpeed
        mov      cs:S_MixSpeed,ax
        mov      ax,PAL
        mov      cs:S_PAL,ax
        call     sds_Go
        leave
        retf
SDS_StartFromPosition endp

sds_Go  proc     near
        push     eax bx cx dx si di ds
        mov      cs:Speed,6  ; Default
        mov      ax,cs:S_InitSpd
        or       ax,ax
        sjz      sdse1
        mov      cs:Speed,ax
sdse1:
;----------------<< "Comprehensing" module >>------------------
        lds      si,dword ptr cs:S_Module

        MoveW    cs:Patterns            ; Number of patterns
        MoveW    cs:Entries             ; Number of entries in order list
        MoveW    cs:Samples             ; Number of samples (instruments)
        MoveB    cs:Channels            ; Max. number of channels (voices)
        MoveB    cs:GlobalVolume        ; Initial volume

        mov      al,cs:Channels
        mov      cs:fx_startchn,al      ; this is the start channel for FX

        lodsb
        cmp      cs:S_InitSpd,0
        ja       sdse2
        xor      ah,ah
        mov      cs:Speed,ax           ; Initial speed (if case)

sdse2:  lodsb
        xor      ah,ah
        mov      cs:BPM,ax             ; Initial BPM based tempo

        mov      cx,32
sdse3:  lodsb
        CallFunc 7                     ; Set voice repartition info for each chn.
        inc      ah
        loop     sdse3

        MoveB    cs:MasterVolume       ; Master volume (for SB only)
        MoveD    cs:PattAddrTabPtr     ; Pointer to Pattern Addresses Table
        MoveD    cs:ChannelsStatus     ; status (on/off) for each channel

        mov      cx,cs:Patterns
        mov      di,offset PattSizeTab

sdse4:  MoveB    cs:[di]               ; LinesPerPattern for each pattern
        inc      di
        loop     sdse4

        mov      cx,cs:Entries
        mov      di,offset Order

sdse5:  MoveB    cs:[di]               ; Pattern order
        inc      di
        loop     sdse5

        ; --- "load" each sample descriptor ... ---
        mov      cx,cs:Samples
        xor      di,di

sdse6:  MoveB    cs:SVol[di],al        ; Sample's volume
        shl      di,1
        MoveW    cs:SC2Spd[di],ax      ; Sample's C2 Speed
        shl      di,1
        MoveD    cs:SAddress[di],eax   ; Sample's address (seg for SB/PAS/etc, DRAM address for GUS)
        shr      di,1
        MoveW    cs:SSize[di],ax       ; Sample's size
        MoveW    cs:SLoopStart[di],ax  ; Sample's loop start
        MoveW    cs:SLoopEnd[di],ax    ; Sample's loop end
        shr      di,1
        inc      di   ; next descriptor
        loop     sdse6

; ----------<< some syncronizations >>--------------------
        call     TimerSync

; --------------<< Start the main mixer >>----------------
        mov      ax,cs:S_PAL
        mov      cs:FreqMod,ax    ; 0 = NTSC, 1 = PAL
        mov      dx,cs:S_MixSpeed ; Mixing speed
        mov      cs:Rate,dx
        movzx    ax,cs:Channels   ; # of voices
        add      al,cs:fx_channels
        CallFunc 3                ; FUNCTION #3 = "Start specific mixer"

; -----------<< timer/poll mode init >>------------
        cmp      cs:CCard,GUS    ; GUS uses system timer anyway
        sje      sdse81          ;

        cmp      cs:CCard,Silence; Silence uses system timer anyway
        sje      sdse81          ;

        cmp      cs:PollMod,1    ; otherwise don't use timer if in POLL mode
        sje      sdse7           ;

sdse81: call     UseSystemTimer
sdse7:
; -----------<< shut down all voices >>------------
        mov      si,0
        movzx    cx,cs:Channels
        add      cl,cs:fx_channels
sdse12: mov      ax,si
        shl      ax,8
        CallFunc 5     ; fn #5 = set voice volume
        mov      byte ptr cs:COffs[si],0
        inc      si
        loop     sdse12

; -----------<< some initializations >>------------
        mov      cs:SpeedCounter,1      ; will restart at first tick
        mov      cs:IsPlaying,1         ; set flag to ON
        mov      cs:CLinesPerPatt,64    ; lines/patt = 64
        mov      cs:CRow,64             ; = clinesperpatt

        mov      cs:mustBreak,1         ;*
        mov      ax,cs:S_Row            ;*
        mov      cs:RestartRow,al       ;*
                                        ;*
        mov      ax,cs:S_Order          ;*
        dec      ax                     ;*
        mov      cs:CEntry,ax           ;*

        mov      cs:CPattern,0          ; doesn't matter
        mov      cs:ExistEffects,0      ; no effects yet
        mov      al,cs:SDS_Flags_1      ; read flags            ;  ** FLAGS **
        and      al,0FEh                ; "not finished yet"    ;
        or       al,2                   ; "SDS is playing"      ;    ! ! ! !
        mov      cs:SDS_Flags_1,al      ; rewrite flags         ;
        mov      cs:UserCounter,0       ; reset user counter (incr BPM*2/5 times per second)

;-------<< Init vibrato table >>--------
        mov      cx,16
        mov      si,offset WaveForms ; start w/ waveform 0 = sine
        mov      di,offset VibratoTable
sdsl99: mov      eax,cs:[si]
        mov      cs:[di],eax
        add      si,4
        add      di,4
        loop     sdsl99

; Disabled for the moment, although it works okay... (the vol is too loud on SB!:)
; Set it using Services, if you really need it.
;       mov      al,cs:MasterVolume
;       CallFunc 16                     ; mastervolume = fixed

        pop      ds di si dx cx bx eax  ; restore registers
        retn
SDS_Go  endp


;
;   SDS_StopPlay ()
;

fproc   SDS_StopPlay
        cmp      cs:CCard,GUS        ; GUS has used timer anyway
        sje      sdse112             ;
        cmp      cs:CCard,Silence    ; Silence has used timer anyway
        sje      sdse112             ;
        cmp      cs:PollMod,1        ; don't restore timer in POLL mode
        sje      sdse11              ;
sdse112:call     RestoreTimer        ;
sdse11: CallFunc 4                   ; Fn #4 = "stop specific mixer"
        mov      cs:IsPlaying,0      ; Set flag to OFF
        and      cs:SDS_Flags_1,0FDh ; the same shit (new mode)
        SetDefTimerFreq              ; original 18.2067 Hz timer rate
        retf
fendp   SDS_StopPlay



;
;   SDS_SetPollMix ( boolean PollMode )
;

SDS_SetPollMix proc PollMode:BYTE  ; 1=poll, 0=system's timer
        push     ax
        mov      al,PollMode

        mov      ah,cs:PollMod
        cmp      al,ah            ; The same shit ?
        sje      sdse8            ; If yes, do nothing.

        cmp      cs:IsPlaying,1   ; Is SDS currently playing ?
        sjne     sdse9            ; If not, just change the PollMod flag, else ...

        cmp      cs:CCard,GUS     ; POLL/TIMER modes on GUS make no difference
        sje      sdse9

        cmp      cs:CCard,Silence ; POLL/TIMER modes on Silence make no difference
        sje      sdse9

        cmp      al,1             ; POLL mode request ?
        sje      sdse10           ;

        call     TimerSync
        call     UseSystemTimer   ; TIMER mode from now on
        jmp      short sdse9

sdse10: call     RestoreTimer     ; Restore timer, use POLL mode from now on

sdse9:  mov      cs:PollMod,al    ; Store the poll-mode flag
sdse8:  pop      ax
        leave
        retf
SDS_SetPollMix endp



;
;   SDS_Poll ()
;

fproc   SDS_Poll
sdsp:

        cmp      cs:PollMod,0  ; no "frame-polling" in TIMER mode...
        je       sdso20        ;

        cmp      cs:CCard,GUS  ; no "frame-polling" on GUS...
        je       sdso20

        cmp      cs:CCard,Silence ; no "frame-polling" on UltraSilence...
        je       sdso20

;#############################################################################

        cli
        stack_init
        sti

        CallFunc 17                ; test: can this one be a SDS tick ?
        sjc      tkskip2           ; no, skip it

        ; when in this point, this is a wonderful tick which
        ; can be used by SDS to keep up the song; so do it...

if TimingBar ne 0
        push     dx ax
        RasterBar 63,10,10
endif

        call     TICK            ; Keep up all patterns' updating and all others
        CallFunc 15              ; Do a new poll-mixing

        inc      cs:UserCounter  ; Increment user's counter

if TimingBar ne 0
        RasterBar 0,0,0
        pop      ax dx
endif

tkskip2:

        cli
        stack_done
        sti

;#############################################################################

sdso20: retf
fendp   SDS_Poll



;
;   SDS_SetSurround ( boolean SurroundMod )
;

SDS_SetSurround  proc SurroundMod:BYTE  ; 1=on, 0=off
        push     ax
        mov      al,SurroundMod
        mov      cs:SurroundMode,al    ; Store the surround-mode flag
        pop      ax
        leave
        retf
SDS_SetSurround  endp



;
;   SDS_SetAmplification ( word AmplifPercent )
;

SDS_SetAmplification proc AmplifPercent:WORD  ; 0=no sound, 100=normal, 200=double ...
        push     ax
        mov      ax,AmplifPercent
        mov      cs:AmplPercent,ax    ; Store the amplification percent
        CallFunc 14
        pop      ax
        leave
        retf
SDS_SetAmplification endp

include services.inc  ;--- (services routines) ------------------------------



;
;   Other routines (internally used)
;



SyncrVal dw      0

TSync:  cli
        pushf
        push     ax
        inc      cs:SyncrVal
        mov      al,20h
        out      20h,al
        pop      ax
        popf
        sti
        iret


nproc   TimerSync

@sync:  push     eax ebx ecx edx es

        mov      ax,cs:BPM
        add      ax,ax                 ; compute timer rate
        mov      cl,5                  ;
        div      cl                    ; rate = BPM * 2 / 5
        movzx    ecx,al                ;
        cmp      ecx,18                ;
        ja       @@@ok1
        mov      ecx,18
@@@ok1:

    ; compute the max. amount of mix-ahead

        mov      eax,cs:mxMixSpd
        xor      edx,edx
        div      ecx        ; ax = MixingRate/TicksPerSecond
        mov      cs:mxMaxMix,ax  ; one word is enough...

        SetTimerFreq cx                ; Set timer rate (BPM*2/5 Hz)

        mov      ax,34DCh
        mov      dx,12h
        mov      cx,cs:TicksPerSec
        div      cx
        mov      cs:TimerSpeed,ax

    ; save old vector

        ReadInt8Vect cs:OldInt8        ; Store old timer vector

    ; set a temporary routine as INT 8 entry

        cli
        SetInt8VectTo cs,TSync         ; Set new timer vector
        mov      cs:SyncrVal,0
        sti

    ; wait increment (int8 sync)

        mov      ax,cs:SyncrVal
        inc      ax
@sdw1:  cmp      cs:SyncrVal,ax     ; wait increment
        jl       short @sdw1        ; hope it won't freeze ...

     ; yup, the increment was detected

        cli
        SetInt8VectFrom cs:OldInt8  ; restore old timer routine
        sti

        mov      dword ptr cs:exact18Hz,0

     ; the frequency is left at 50 Hz  ...

        pop      es edx ecx ebx eax

@nosync:

        retn
nendp   TimerSync


nproc   UseSystemTimer
        push     es dx cx ebx eax
        ReadInt8Vect   cs:OldInt8      ; Store old timer vector
        cli
        mov      cs:UserCounter,0      ; reset user counter
        SetInt8VectTo  cs,SDS_Int8     ; Set new timer vector
        mov      dword ptr cs:exact18Hz,0
        sti
        pop      eax ebx cx dx es
        retn
nendp   UseSystemTimer


nproc   RestoreTimer
        push     eax es
        cli
        SetInt8VectFrom cs:OldInt8  ; restore old timer routine
        SetDefTimerFreq             ; restore the original 18.2067 Hz timer rate
        sti
        pop      es eax
        retn
nendp   RestoreTimer


;
; This is the routine which both solves the INT 8h jobs and takes care about
; sound mixing (if case, of course - on SB for instance). Used only when SDS
; is in TIMER mode. Called BPM*2/5 times per second.
;

exact18Hz dd 0

nproc   SDS_Int8

        pushf

        cli
        stack_init

if TimingBar ne 0
        RasterBar 0,40,40
endif

        CallFunc 17                ; test: can this one be a SDS tick ?
        jc       tkskip            ; no, skip it

          ; when in this point, this is a wonderful tick which
          ; can be used by SDS to keep up the song; so do it...

          call     TICK            ; Keep up all patterns' updating and all others
          CallFunc 15              ; Do a new poll-mixing
          inc      cs:UserCounter  ; Increment user's counter (usually 50 Hz)

tkskip:

if TimingBar ne 0
          RasterBar 0,0,0
endif

        push     eax
        movzx    eax,word ptr cs:TimerSpeed
        add      dword ptr cs:exact18Hz,eax
        pop      eax

        cmp      dword ptr cs:exact18Hz,10000h
        jb       NormalExit

        sub      dword ptr cs:exact18Hz,10000h

        stack_done
        sti
        sti

        popf
        db       0eah
OldInt8 dd       0          ; Do a far jump to the original INT 8h routine.


NormalExit:

        push ax
        mov al,20h
        out 20h,al
        out 0a0h,al
        pop ax

        stack_done
        sti
        sti

        popf
        db 0cfh ;IRET!!!!!!!!!!!!!!!!!!!!!

nendp   SDS_Int8


;
; This routine is called each time a new logical "TICK" is to happen. It
; must keep up rows and patterns updating (for both SB-type and GUS cards).
;

nproc   TICK  ; ----- ALL registers MUST remain unchanged !!! ---------------
        push     ds
        push     cs
        pop      ds
        dec      SpeedCounter        ; decrement speed counter
        sjle     sdse142             ; is time to take a new row ?
sdse14: cmp      ExistEffects,1      ; Are there any effects ?
        sjne     sdse15              ; If not, skip next line
        call     EFFECTS             ; Yes, treat'em
sdse15: pop      ds
        retn
sdse142:call     NEWROW              ; take a new row
        push     ax
        mov      ax,Speed
        mov      SpeedCounter,ax     ; Reset counter
        pop      ax
        jmp      short sdse14
nendp   TICK


;
; This routine is called each time a new row is to be started
;

nproc   NEWROW
        push     eax
        cmp      mustBreak,1
        je       sdsnr1
        inc      CRow
        mov      ax,CRow
        cmp      ax,CLinesPerPatt   ; lines per pattern for current one
        sjb      sdse20
sdsnr1: mov      CRow,0
        call     NEWPATTERN
sdse20: call     STARTROW
        pop      eax
        retn
nendp   NEWROW


;
; This routine is called each time a new pattern is to be started
;

nproc   NEWPATTERN
        push     ebx
sdse22: inc      cs:CEntry
        mov      bx,cs:CEntry
        cmp      bx,cs:Entries
        sjb      sdse21
np1:    mov      cs:CEntry,0     ; The song is automatically restarted after ending
        or       cs:SDS_Flags_1,1 ; set the flag "song has finished once"
        mov      bx,0
sdse21: movzx    ebx,byte ptr cs:Order[bx]; Takes the corresponding entry
        cmp      bx,254          ; Must be skipped ?
        sje      sdse22          ; If yes, repeat
        cmp      bx,255          ; Must end ?
        sje      np1             ; If yeh, restart it
        mov      cs:CPattern,bx  ; Store it into CPattern variable
        movzx    ax,cs:PattSizeTab[bx]  ; How many lines per pattern ?
        mov      cs:CLinesPerPatt,ax    ; Store this number
        shl      bx,2     ; bx:=pattern*4
        add      bx,word ptr cs:PattAddrTabPtr
        push     es
        mov      es,word ptr cs:PattAddrTabPtr[2]
        mov      eax,es:[bx]
        pop      es
        mov      cs:RowPtr,eax   ; update RowPtr pointer

        ; now update row pointer such that pattern will start from the
        ; right restart position (RestartRow, initialized by effect Cxx
        ; and set to zero by default)

        push     cx

        movzx    cx,byte ptr cs:RestartRow
        test     cl,cl
        jz       npusual

        mov      cs:CRow,cx

nploop: call     UNPACKROW
        loop     nploop

        mov      cs:RestartRow,0

npusual:pop      cx

        mov      cs:efx_FirstSB,1
        mov      cs:mustBreak,0
        pop      ebx
        retn
nendp   NEWPATTERN

;
; This routine unpacks a line and advances the pattern pointer
;

nproc   UNPACKROW

        push     ax cx si di ds

        lds      si,dword ptr cs:RowPtr
        mov      cs:efx_RowOffs,si

; --<< decompress the current row (packed) into EVENT table >>--

        movzx    cx,cs:Channels
        mov      di,offset cs:Event
sdse30: mov      al,[si]    ; load note
        cmp      al,0FFh    ; the same event as the previous one ?
        jne      sdse31     ; no, go on
        inc      si         ; yeah, skip event
        jmp      short sdse32

sdse31: cmp      al,0FDh                  ; null event ?
        jne      short sdse39             ; no, skip
        mov      word ptr cs:[di],0       ;
        mov      byte ptr cs:[di+2],41h   ; ... yeah, reset it
        mov      word ptr cs:[di+3],0     ;
        inc      si
        jmp      short sdse32

sdse39: mov      cs:[di],al ; store note
        mov      ax,[si+1]
        mov      cs:[di+1],al ; store sample #
        test     ah,80h
        pushf
        and      ah,7Fh       ; clear the 7th bit
        mov      cs:[di+2],ah ; store volume
        mov      word ptr cs:[di+3],0   ; reset eff+para fields
        popf
        sjnz     sdse33       ; ... was the 7th bit set ? no, go futher on
        add      si,3         ; yeah, it was, so there isn't any effect+para here
        jmp      short sdse32
sdse33: mov      ax,[si+3]    ; load the effect and its parameter
        mov      cs:[di+3],ax ; store effect+para
        add      si,5
sdse32: add      di,5       ; jump to the next event to be processed
        dec      cx
        jnz      sdse30     ; loop it

        mov      word ptr cs:RowPtr,si    ; Update row pointer

        pop      ds di si cx ax
        retn
nendp   UNPACKROW

;
; This routine is called each time a new row has to be unpacked and started
;

tVol    db       0FFh            ; offset 0     -> volume
tPer    dw       0FFFFh          ; offset 1     -> period
tROffs  db       00h             ; offset 3     -> rel. offset
tAddr   dd       0FFFFFFFFh      ; offset 4     -> address
tSize   dw       0FFFFh          ; offset 8     -> size
tLS     dw       0FFFFh          ; offset 10    -> loop start
tLE     dw       0FFFFh          ; offset 12    -> loop end
tStop   db       0               ; offset 14    -> stop voice if 1

nproc   STARTROW
        push     ebp ecx bx di si ds

        mov      byte ptr cs:RestartRow,0  ; default
        mov      byte ptr cs:mustBreak,0   ; default

; ----<< Unpack a new line in EVENT table >>----

        call     UNPACKROW

; ----<< Now the EVENT table will be processed >>----

        mov      cs:ExistEffects,0     ; init flag

        mov      si,cs
        mov      ds,si
        mov      si,offset Event
        movzx    cx,Channels  ; ds is already equal to cs
        mov      bx,0         ; BX = channel no ...
        mov      ebp,80000000h ; init channel mask

sdse40: rol      ebp,1        ; shift the channel mask
        mov      al,[si+3]    ; extract the effect
        cmp      al,7         ; is it tone portamento ?
        sje      sdse50       ; yeah, do not set the frequency.
        cmp      al,12        ; is it toneporta+volslide ?
        sje      sdse50       ; yeah, the same shit

     ; init temporary variables

        mov      tVol,0FFh          ; "don't change"
        mov      tPer,0FFFFh        ; "don't change"
        mov      tROffs,0           ; "zero start"
        mov      tAddr,0FFFFFFFFh   ; "don't change"
        mov      tSize,0FFFFh       ; "don't change"
        mov      tLS,0FFFFh         ; "don't change"
        mov      tLE,0FFFFh         ; "don't change"
        mov      tStop,0            ; "don't stop"

     ; settings

        call     SetEvent
        call     SetAll
        call     SetEffect

        jmp      short sdse41

sdse50: call     SetSpecial   ; Special update (w/out changing the freq.)

sdse41: inc      bx
        add      si,5         ; next channel
        dec      cx
        sjg      sdse40

        pop      ds si di bx ecx ebp
        retn
nendp   STARTROW

;-----------------------------------------------------------------------------

nproc   _Vol_                     ; sets tVol to the value in AL (or zero if case)
        test     ChannelsStatus,ebp; is channel active ?
        sjnz     sv1
        mov      al,0             ; no, set volume to 0
sv1:    shl      bx,2
        mov      byte ptr TremoloOrig[bx],al
        mov      tVol,al          ; set it
        shr      bx,2
        mov      CVol[bx],al
        retn
nendp   _Vol_

;-----------------------------------------------------------------------------

nproc   _InstVol_                 ; sets the sample's default volume
        push     si
        movzx    si,CSam[bx]
        mov      al,SVol[si]
        call     _Vol_
        pop      si
        retn
nendp   _InstVol_

;-----------------------------------------------------------------------------

nproc   _Inst_                    ; sets instrument's parameters using CSam[bx]
        push     eax si
        movzx    si,CSam[bx]      ; actual instrument #
;       mov      al,SVol[si]
;       call     _Vol_            ; store sample's volume
        add      si,si
        mov      ax,SSize[si]
        mov      tSize,ax         ; store sample's size
        mov      ax,SLoopStart[si]
        mov      tLS,ax           ; store sample's loop start
        mov      ax,SLoopEnd[si]
        mov      tLE,ax           ; store sample's loop end
        add      si,si
        mov      eax,SAddress[si]
        mov      tAddr,eax        ; store address
        mov      tROffs,0         ; default relative offset = 0
        pop      si eax
        retn
nendp   _Inst_

;-----------------------------------------------------------------------------

nproc   _Freq_                    ; sets instrument's frequency using CSam[bx] and CNote[bx]
        push     eax ecx edx si
        mov      al,CNote[bx]
        movzx    si,al            ; actual note
        dec      si
        add      si,si
        movzx    eax,word ptr Pitch[si]
        mov      ecx,8363
        mul      ecx              ; eax=pitch*8363
        movzx    si,CSam[bx]
        add      si,si
        movzx    ecx,word ptr SC2Spd[si]
        test     cx,cx
        sjnz     sf1
        inc      ecx
sf1:    div      ecx              ; scale note with instrument's C2speed
        and      eax,0000FFFFh
        shl      bx,2
        mov      ToNoteAttended[bx],eax
        mov      VibratoOrig[bx],eax
        shr      bx,2
        mov      tPer,ax          ; store period
        pop      si edx ecx eax
        retn
nendp   _Freq_

;-----------------------------------------------------------------------------

nproc   SetEvent                  ; BX=channel, AL=effect #, SI=offset note

        push     ax

;
;   Do we have any instrument in this event ?  Set it if yes.
;

        mov      al,[si+1]        ; instrument #
        test     al,al
        jz       see1             ; skip, no instrument

        dec      al               ; SDS instruments start from #0
        cmp      al,CSam[bx]      ; already active ?
        jne      see6

        call     _InstVol_        ; store only the instrument's volume
        jmp      short see1

see6:   mov      CSam[bx],al      ; store it
        call     _Inst_           ; store instrument's parameters

;;;     mov      al,[si]
;;;     test     al,al            ; note, too ?
;;;     sjnz     see10            ; yeh, don't set zero volume
;;;     mov      al,0             ; set quiet
;;;     call     _Vol_            ; some songs work better with this shit...

        call     _InstVol_

;;;     jmp      short see1

;;;see10:  call     _InstVol_

;
;   Do we have any note in this event ?  Set it if yes.
;

see1:   mov      al,[si]          ; note #
        test     al,al
        jz       see3             ; skip, no note

        cmp      al,254           ; note off ?
        jne      see4             ; no, go on

        mov      tStop,1          ; voice must be stopped
        jmp      seOut

see4:   mov      CNote[bx],al     ; store it

        call     _Inst_           ; set instrument's parameters
        call     _Freq_           ; store frequency (scaled with C2Speed)

        mov      al,CVol[bx]      ; last volume must be set
        call     _Vol_            ;

;
;   Do we have any volume in this event ?  Set it if yes.
;

see3:   mov      al,[si+2]        ; volume
        cmp      al,40h           ; is valid/activable ?
        ja       see8
        call     _Vol_            ; store this volume

;
;   If we have "Set sample offset" effect, set ROffs accordingly
;

see8:   mov      tROffs,0         ; relative offset = 0
        mov      al,[si+3]        ; effect id
        cmp      al,15            ; "set offset" ?
        jne      see5
        mov      al,[si+4]        ; parameter
        test     al,al
        sjne     see7
        mov      al,COffs[bx]     ; last offset must be used !
see7:   mov      tROffs,al        ; store relative offset / 256
        mov      COffs[bx],al     ; store the last one !
see5:
        


seOut:  pop      ax

        retn
nendp   SetEvent

;-----------------------------------------------------------------------------

nproc   SetSpecial                ; BX=channel, AL=effect #, SI=offset note

        mov      ExistEffects,1   ; there is an effect in this event

;
;   Do we have any instrument in this event ?  Borrow its volume if yes.
;

        mov      al,[si+1]        ; instrument #
        test     al,al
        sjz      sse1

        push     si
        movzx    si,al
        dec      si
        mov      al,SVol[si]      ; al = instrument's default volume
        call     _Vol_            ; store it!
        pop      si

        mov      ah,bl
        CallFunc 5                ; set it!

;
;   Do we have any volume in this event ?  Borrow it if yes.
;

sse1:   mov      al,[si+2]        ; volume
        cmp      al,40h           ; valid ?
        sja      sse2             ; no, skip
        call     _Vol_            ; yes, store it!

        mov      ah,bl
        CallFunc 5                ; set it!

;
;   TonePorta+VolSlide ?  If yes, store parameter (if not zero).
;

sse2:   mov      al,[si+3]        ; effect
        cmp      al,7             ; Tone Portamento ?
        sje      sse3             ; yes, skip
        mov      al,[si+4]        ; parameter
        test     al,al
        jz       ssOut
        mov      BPara[bx],al     ; store parameter (for later use)
        jmp      ssOut

;
;   We're in Tone Portamento.  Do all the updates necessary.
;

sse3:   mov      al,[si]          ; note
        test     al,al
        sjz      sse4
        mov      CNote[bx],al     ; store note if not zero
        call     _Freq_           ; compute the frequency to fly at

sse4:   mov      al,[si+4]        ; parameter
        test     al,al
        sjz      sse5
        mov      BPara[bx],al     ; store parameter
        mov      ToNoteSpeed[bx],al

;
;   and get the fuck outta here
;

sse5:

ssOut:
        retn
nendp   SetSpecial

;-----------------------------------------------------------------------------

nproc   SetAll         ; sets all the parameters stored into tXXXX variables
                       ; In: BX=channel

        push     ax bx cx dx si edi

;
;   First check whether the voice must be stopped or not, and stop it if yes
;

        cmp      tStop,1      ; must stop ?
        sjne     sae1
        mov      ah,bl
        CallFunc 12           ; stop voice !
        jmp      sao1

;
;   set voice volume to zero if needed (GUS anticlick)
;

sae1:   cmp      tSize,0FFFFh
        sje      sae2
        mov      ah,bl
        mov      al,0
        CallFunc 5

;
;   Check if period must be modified, and do it if yes
;

sae2:   cmp      tPer,0FFFFh  ; must be modified ?
        sje      sae3
        mov      ah,bl
        mov      cx,tPer
        CallFunc 9            ; set period !

;
;   Check if a sample must play, and start it if yes
;

sae3:   cmp      tSize,0FFFFh ; play sample ?
        sje      sae4
        mov      ah,bl        ; channel
        mov      al,tROffs    ; relative offset
        mov      edi,tAddr    ; 32-bit address
        mov      cx,tSize     ; size
        mov      dx,tLS       ; loop start
        mov      si,tLE       ; loop end
        CallFunc 11           ; start playing it !

;
;   If volume was turned to 0, rise it up
;

sae4:   cmp      tVol,0FFh    ; volume change ?
        sje      sae5
        mov      ah,bl
        mov      al,tVol
        CallFunc 5            ; set volume !

sae5:

sao1:   pop      edi si dx cx bx ax

        retn
nendp   SetAll

;-----------------------------------------------------------------------------

nproc   SetEffect             ; BX=channel
        mov      al,[si+3]    ; extract effect #
        test     al,al        ; is it zero ? (exists?)
        sjz      sdse63       ; zero, so skip it
        mov      ExistEffects,1 ; Init effects flag
        call     InitEffect   ; Initialize effect for channel BX
sdse63: retn
nendp   SetEffect

;-----------------------------------------------------------------------------

nproc   InitEffect   ; BX=channel, SI=event offset
        push     cx bx
        mov      al,[si+4]        ; parameter
        movzx    bx,[si+3]        ; effect
        add      bx,bx            ; bx:=bx*2
        mov      cx,IETable[bx]
        pop      bx
        test     cx,cx            ; implemented ?
        sjz      sdse100          ; no way, get da fuck out
        call     cx               ; call effect's init routine
sdse100:pop      cx
        retn
nendp   InitEffect

;
; This routine is called each time the effects on a line are to be treated
;

nproc   EFFECTS ; All registers MUST remain unchanged
        push     ax bx cx si di ds
        mov      ax,cs
        mov      ds,ax
        movzx    cx,Channels
        mov      bx,0                ; BX=# of channel
        mov      si,offset Event + 3 ; SI=effect field offset
sdsl1:  movzx    di,[si]             ; load effect #
        add      di,di               ; mul 2
        mov      di,ETable[di]       ; routine's offset
        test     di,di               ; implemented ?
        sjz      sdso10
        call     di                  ; call specif. routine
sdso10: inc      bx                  ; next channel
        add      si,5
        dec      cx
        sjg      sdsl1
        pop      ds di si cx bx ax
        retn
nendp   EFFECTS

include efx.inc  ;---- (effects routines definitions) ------------------

;

        db       "<ENDSDS>"

   ; asm rules, yep yep, the others suck
   ; asm forever

        END



                                    /^\
                              ____/     \____
                              \             /
                             __\           /__
                             \               /
                               \_____ _____/
                                     |
                              Maple  /  Leaf
                               shit forever