COMMENT _

     //----------------------------------------------------------------\
     |  Sound Deluxe System 5                                          |
     |  by Maple Leaf (a.k.a Gruian Radu), 1996,1997                   |
     |   SoundBlaster 16 ASP driver (stereo only)                     |
     \----------------------------------------------------------------//
_

sb16Desc    db       "SB 16 ASP driver v1.18, by Maple Leaf, 1996-1997"

;
;   Functions-Offsets Table
;

sb16_driver dw       offset drvg_InitDriver
            dw       offset drvg_DoneDriver
            dw       offset sb16_StartMixer
            dw       offset sb16_StopMixer
            dw       offset mx_SetVoiceVolume
            dw       offset mx_GetVoiceVolume
            dw       offset mx_SetVoicePanning
            dw       offset mx_GetVoicePanning
            dw       offset mx_SetVoiceFreq
            dw       offset mx_GetVoiceFreq
            dw       offset mx_PlayVoice
            dw       offset mx_StopVoice
            dw       offset mx_SetGlobalVolume
            dw       offset mx_SetAmplification
            dw       offset mx_DoPoll_stereo
            dw       offset sb16_SetMasterVolume
            dw       offset mx_TickAwaited

;
;   StartMixer (DX=Mixing speed, AX=# of voices)
;

nproc   sb16_StartMixer

        ClipFreq 8000, 44100

        and      edx,0FFFFh
        mov      cs:cmixspd,dx
        add      edx,edx
        mov      cs:mxMixSpd,edx

        ClipVoices 4, 32

        mov      cs:mxVoices,ax        ; Store max # of active voices
        mov      cs:dmAutoInit,1       ; autoinit-dma mode !

        call     mxBuildPeriods_stereo ; Build the periods table
        call     mxBuildProcTab_stereo ; Build the Post-Processing Table
        call     mxInitVars_stereo     ; Init all internal counters

        call     sbResetDSP            ; Reset SoundBlaster's DSP
        call     sb16_SetDSPMixRate    ; Setup DSP (timing)
        call     sbSpeakerOn           ; Turn the speaker on
        call     sbpStereoOn           ; Turn Stereo mode on

        mov      dx,offset sb16_MainIRQ
        call     irqRedirectIRQ

        call     dmStartDMA            ; Start DMA using channel mxDMA
        call     sb16_StartDSP         ; Start DMA Play

        retn
nendp   sb16_StartMixer

;
;   StopMixer ()
;

nproc   sb16_StopMixer
        push     ax
        call     irqRestoreIRQ
        mov      al,0d0h
        call     dsp_command   ; Stop 8/16-bit DMA receiving
        call     dmStopDMA     ; Stop DMA transmission
        call     sbSpeakerOff
        call     sbpStereoOff
        pop      ax
        retn
nendp   sb16_StopMixer

;
;   Main IRQ routine
;

nproc   sb16_MainIRQ
        pushf
        cli
        push     ax dx

        mov      al,20h
        out      20h,al
        cmp      cs:mxIRQ,8
        sjb      sb16e21
        out      0A0h,al

sb16e21:mov      dx,cs:mxPort
        add      dx,0Eh
        cmp      cs:mxDMA,4
        sjb      sb16e20
        inc      dx

sb16e20:in       al,dx  ; clear IRQ pending

        ; Initialize another DMA play

;       call     dmStartDMA      ; v5.04: SINCE WE'RE IN AUTOINIT DMA MODE,
;       call     sb16_StartDSP   ; THESE ARE NOT NECESSARY ANYMORE!

        pop      dx ax
        sti ; Quite useless ...
        popf
        iret
nendp   sb16_MainIRQ

;
;   SetMasterVolume ( AL=volume (0-255) )
;

nproc   sb16_SetMasterVolume
        push     dx ax
        mov      ah,al
        mov      dx,cs:mxPort
        add      dx,4     ; Base+4
        mov      al,30h
        out      dx,al    ; mastervolume LEFT set
        inc      dx       ; Base+5
        mov      al,ah
        out      dx,al    ; set it
        dec      dx       ; Base+4
        mov      al,31h   ; mastervolume RIGHT set
        out      dx,al
        inc      dx       ; Base+5
        mov      al,ah
        out      dx,al    ; set it
        dec      dx       ; Base+4
        mov      al,32h
        out      dx,al    ; dsp volume LEFT
        inc      dx       ; Base+5
        mov      al,ah    ; set it
        out      dx,al
        dec      dx       ; Base+4
        mov      al,33h
        out      dx,al    ; dsp volume RIGHT
        inc      dx       ; Base+5
        mov      al,ah
        out      dx,al    ; set it
        pop      ax dx
        retn
nendp   sb16_SetMasterVolume


; Other routines 

;
;  DSP 4.00+ StartPlay codes: 
;
; Start 16bit stereo signed   : B4/30/xx/xx
; Start 16bit mono signed     : B4/10/xx/xx
; Start 8bit stereo unsigned  : C6/20/xx/xx
; Start 8bit mono unsigned    : C6/00/xx/xx
;
; where xx/xx is the size of the transfer block (low/high)
;

nproc   sb16_StartDSP
        push     ax
        mov      al,0C6h
        call     dsp_command
        mov      al,20h
        call     dsp_command
        mov      ax,DMABufSize*16 ; -1
        call     dsp_command
        mov      al,ah
        call     dsp_command
        pop      ax
        retn
nendp   sb16_StartDSP


;

;
;  DSP 4.00+ SetRate code: 
;
; 41/High(Frequency)/Low(Frequency)
;

nproc   sb16_SetDSPMixRate
        push     ax
        mov      al,41h
        call     dsp_command
        mov      al,byte ptr cs:cMixSpd[1]
        call     dsp_command
        mov      al,byte ptr cs:cMixSpd
        call     dsp_command
        pop      ax
        retn
nendp   sb16_SetDSPMixRate

