COMMENT _

     /-----------------------------------------------------------------\
     |  Sound Deluxe System 5                                          |
     |  by Maple Leaf (a.k.a Gruian Radu), 1996                        |
     |   UltraSilence!(tm) driver - no sound, I mean...               |
     \-----------------------------------------------------------------/
_

usDesc    db       "UltraSilence!(tm) driver v2.02, by Maple Leaf, 1996."

;
;   Functions-Offsets Table
;

us_driver dw       offset us_InitDriver
          dw       offset us_NOP          ; done driver
          dw       offset us_StartMixer
          dw       offset us_NOP          ; stop mixer
          dw       offset mx_SetVoiceVolume
          dw       offset mx_GetVoiceVolume
          dw       offset mx_SetVoicePanning
          dw       offset mx_GetVoicePanning
          dw       offset mx_SetVoiceFreq
          dw       offset mx_GetVoiceFreq
          dw       offset mx_PlayVoice
          dw       offset mx_StopVoice
          dw       offset mx_SetGlobalVolume
          dw       offset mx_SetAmplification
          dw       offset us_NOP              ; poll
          dw       offset us_NOP              ; set master volume
          dw       offset us_TickAwaited      ; fn #17


;
;   Driver's internal data
;

us_NOP: retn

;
;   InitDriver (AH=Irq, AL=Dma, DX=Port)
;

nproc   us_InitDriver
        mov      cs:mxport,378h ; a "safe" I/O port
        mov      cs:mxdma,al    ; not used, anyway
        mov      cs:mxirq,ah    ; not used, anyway
        retn
nendp   us_InitDriver

;
;   StartMixer (DX=Mixing speed, AX=# of voices)
;

nproc   us_StartMixer
        ClipFreq 8000, 44100
        mov      cs:cmixspd,dx  ; !!! mono: cmixspd=sbmixspd
        and      edx,0FFFFh
        mov      cs:mxmixspd,edx ; Store mix speed for future calculations
        mov      cs:mxVoices,ax  ; Store max # of active voices
        call     mxBuildPeriods_mono ; Build the periods table (mono)
        call     mxInitVars_mono
        retn
nendp   us_StartMixer

;
;   TickAwaited()
;

nproc   us_TickAwaited
        clc  ; always awaited, don't care about it anyway...
        retn
nendp   us_TickAwaited
