
;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        SDS API Functions (services)                                 
;     


;*****************************************************************************
;  SDS_Services ()
;  ---------------
;  This routine may be called each time you wish to "change" something in the
;  normal playing process of the song (to change volume from outside, for
;  example). The changing of any variable into the ESB usually has no any
;  effect, so this routine (Services) should be used instead.
;  The services can be called right after SDS_Init, but many of them have no
;  effect if SDS is not playing (SDS_StartPlay)
;
;  services:     0    = unused (nop!)
;  (AH=serv.no)  1    = set global volume (AL=vol)
;                2    = set master volume (AL=vol)
;                3    = set amplification (BX=percent - 0=quiet, 100=normal)
;                4    = set surround mode (AL=1=on/AL=0=off)
;                5    = set poll mode (AL=1=poll/AL=0=timer)
;                6    = increase global volume
;                7    = decrease global volume
;                8    = set channel panning (AL=channel,BL=panning(bits 0-3))
;                9    = channel on (AL=channel(0-31))
;                10   = channel off (AL=channel(0-31))
;                11   = allow BPM changes (AL=1=on/AL=0=off)
;                12   = allow panning (AL=1=on/AL=0=off)
;                13   = unused - unlucky number, hehe ;) ...
;                14   = set semaphore value (AL=semaphore #, BL=value)
;                15   = reset all semaphores
;                16   = jump to order (AL=order)
;                17   = IMEDIATELY cancel the current pattern
;            New services in SDS 5.01:
;                18   = reset user counter
;                19   = old, "FX: seek free channel", UNUSED ANYMORE !!!!
;                20   = PAUSE!
;                21   = RESTART!
;            New services in SDS 5.02
;                22   = Set arpeggio mode (AL=mode: 0=normal,1=fast)
;            New services in SDS 5.04
;                23   = Identify SDS API
;                24   = Do a poll mix
;                25   = Shoot FX (AL=FX-channel, EDI=32bit _rmode_ address of FX-struc)
;            the rest = unused
;*****************************************************************************

Services equ     25   ; max # of a service

ServOffs dw      0                         ; unused
         dw      offset serv01
         dw      offset serv02
         dw      offset serv03
         dw      offset serv04
         dw      offset serv05
         dw      offset serv06
         dw      offset serv07
         dw      offset serv08
         dw      offset serv09
         dw      offset serv10
         dw      offset serv11
         dw      offset serv12
         dw      0                         ; unused
         dw      offset serv14
         dw      offset serv15
         dw      offset serv16
         dw      offset serv17
         dw      offset serv18
         dw      offset serv19
         dw      offset serv20
         dw      offset serv21
         dw      offset serv22
         dw      offset serv23
         dw      offset serv24
         dw      offset serv25

SDS_Services proc far
bug2__: cmp      ah,Services
        ja       sdso90       ; don't play with me...
        push     si
        movzx    si,ah
        add      si,si
        mov      si,cs:ServOffs[si]
        test     si,si
        jz       sdse91
        call     si
sdse91: pop      si
sdso90: retf
SDS_Services endp

;-<< Services >>--------------------------------------------------------------

serv01  proc     near  ; service #1: set global volume
        CallFunc 13
        retn
serv01  endp

serv02  proc     near  ; service #2: set master volume
        mov      cs:MasterVolume,al
        CallFunc 16
        retn
serv02  endp

serv03  proc     near  ; service #3: set amplification
        push     ax
        mov      cs:AmplPercent,bx
        mov      ax,bx
        CallFunc 14
        pop      ax
        retn
serv03  endp

serv04  proc     near  ; service #4: set surround mode
        mov      cs:SurroundMode,al
        retn
serv04  endp

serv05  proc     near  ; service #5: set poll mode
        push     ax
        mov      ah,cs:PollMod

        cmp      al,ah            ; The same shit ?
        sje      sdse92           ; If yes, do nothing.

        cmp      cs:IsPlaying,1   ; Is SDS currently playing ?
        sjne     sdse93           ; If not, just change the PollMod flag, else ...

        cmp      cs:CCard,GUS     ; GUS and UltraSilence do not really work
        sje      sdse93           ; in poll mode... they are fast enough.
        cmp      cs:CCard,Silence ;
        sje      sdse93           ;

        cmp      ah,0             ; Was TIMER mode ?
        sje      sdse94           ; Yes, go restore timer
        call     TimerSync  ;@@@
        call     UseSystemTimer   ; No, use TIMER mode from now on
        jmp      short sdse93
sdse94: call     RestoreTimer     ; Restore timer, use POLL mode from now on

sdse93: mov      cs:PollMod,al    ; Store the poll-mode flag
sdse92: pop      ax
        retn
serv05  endp

serv06  proc     near  ; service #6: increase global volume
        push     ax
        mov      al,cs:GlobalVolume   ; an ESB field
        inc      al
        cmp      al,40h
        jbe      s6e1
        mov      al,40h
s6e1:   CallFunc 13
        pop      ax
        retn
serv06  endp

serv07  proc     near  ; service #7: decrease global volume
        push     ax
        mov      al,cs:GlobalVolume    ; an ESB field
        dec      al
        jge      s7e1
        mov      al,0
s7e1:   CallFunc 13
        pop      ax
        retn
serv07  endp

serv08  proc     near  ; service #8: set channel panning
        push     ax
        mov      ah,al
        mov      al,bl
        CallFunc 7
        pop      ax
        retn
serv08  endp

serv09  proc     near  ; service #9: channel on
        push     eax cx
        mov      cl,al
        mov      eax,1
        shl      eax,cl
        or       dword ptr cs:ChannelsStatus,eax
        pop      cx eax
        retn
serv09  endp

serv10  proc     near  ; service #10: channel off
        push     eax cx
        mov      cl,al
        mov      eax,1
        shl      eax,cl
        not      eax
        and      dword ptr cs:ChannelsStatus,eax
        mov      ah,cl
        CallFunc 12 ; stop channel
        pop      cx eax
        retn
serv10  endp

serv11  proc     near  ; service #11: allow BPM changes
        mov      cs:AllowBPM,al
        retn
serv11  endp

serv12  proc     near  ; service #12: allow panning changes
        mov      cs:AllowPanning,al
        retn
serv12  endp

serv14  proc     near  ; service #14: set semaphore #...
        movzx    si,al
        and      si,0Fh
        mov      cs:Semaphores[si],bl
        retn
serv14  endp

serv15  proc     near  ; service #15: reset all semaphores
        mov      dword ptr cs:Semaphores[00],0
        mov      dword ptr cs:Semaphores[04],0
        mov      dword ptr cs:Semaphores[08],0
        mov      dword ptr cs:Semaphores[12],0
        retn
serv15  endp

serv16  proc     near  ; service #16: jump to order #...
        push     cx
        mov      cx,cs:CLinesPerPatt
        dec      cx
        mov      cs:CRow,cx
        movzx    cx,al
        dec      cx
        mov      cs:CEntry,cx
        sjge     s16o1
        mov      cx,cs:Entries
        dec      cx
        mov      cs:CEntry,cx
s16o1:  pop      cx
        retn
serv16  endp

serv17  proc     near  ; service #17: IMEDIATELY cancel the current pattern
        push     cx
        mov      cx,cs:CLinesPerPatt
        dec      cx
        mov      cs:CRow,cx
        mov      SpeedCounter,0  ; make it imediately !
        pop      cx
        retn
serv17  endp

serv18  proc     near  ; service #18: reset user counter
        mov      cs:UserCounter,0 ; can be set by the user directly into ESB
        retn
serv18  endp

serv19  proc     near  ; service #19: seek free channel, NOT USED ANYMORE!
        mov      al,0FFh  ; "not found" - there is no free channel anyway...:)
        retn
serv19  endp

serv20  proc     near  ; service #20: PAUSE!  (the frequency remains the same!!!)
        test     cs:SDS_Flags_1,2  ; is SDS playing ?
        jz       s20o
        push     ax cx dx
        SetInt8VectFrom cs:OldInt8  ; restore old timer routine
        CallFunc 4  ; stop specific mixer
        and      cs:SDS_Flags_1,0FDh ; SDS is logically shut down now
        or       cs:SDS_Flags_1,4    ; SDS is logically paused now
        pop      dx cx ax
s20o:   retn
serv20  endp

serv21  proc     near  ; service #21: RESTART!
        test     cs:SDS_Flags_1,4    ; was SDS paused ?
        jz       s21o
        test     cs:SDS_Flags_1,2    ; is SDS playing ?
        jnz      s21o
        push     es dx cx ebx eax
        mov      dx,cs:Rate
        movzx    ax,cs:Channels
        add      al,cs:fx_channels
        CallFunc 3  ; start specific mixer
        SetInt8VectTo  cs,SDS_Int8   ; Set new timer vector
        or       cs:SDS_Flags_1,2    ; SDS is now playing
        and      cs:SDS_Flags_1,0FBh ; SDS is not paused anymore
        pop      eax ebx cx dx es
s21o:   retn
serv21  endp

serv22  proc     near  ; service #22: Set Arpeggio Mode (AL=mode: 0=normal,1=fast)
        and      al,1   ; only 0 or 1 !
        mov      cs:ArpeggioMode,al
        sjnz     s22e1
      ; set the normal arpeggio address
        mov      cs:IETable[20],offset i_J  ; [2*10], 10=Arpeggio !!!
        mov      cs:ETable[20],offset c_J   ; [2*10], 10=Arpeggio !!!
        jmp      short s22out
s22e1:; set the fast arpeggio address
        mov      cs:IETable[20],offset i_J2 ; [2*10], 10=Arpeggio !!!
        mov      cs:ETable[20],offset c_J2  ; [2*10], 10=Arpeggio !!!
s22out: retn
serv22  endp

serv23  proc     near  ; service #23: Identify SDS API (out: EAX=35534453h="SDS5")
        mov      eax,35534453h
        retn
serv23  endp

serv24  proc     near  ; service #24: Do a poll mix (for PMODE compatibility)
        call     dword ptr cs:DoPollAddr
        retn
serv24  endp

tchn	db       0

serv25  proc     near ; service #25: Shoot FX
                      ; In:  AL=FX-channel(! _NOT_ _real_ channel !)
                      ;      EDI=FX-struc rmode address (DI=offset,E=segment)

        push     ax cx dx si edi gs

        rol      edi,16       ;
        mov      gs,di        ; real-mode fx-struc address now in es:di
        rol      edi,16       ;

        mov      ah,al                       ;
        add      ah,byte ptr cs:fx_startchn  ;  compute real FX channel
        mov      al,cs:Channels              ;
        add      al,cs:fx_channels           ;
        cmp      ah,al                       ;
        jb       s25e1                       ;
        mov      ah,al                       ;
        dec      ah                          ;
s25e1:  cmp      ah,cs:fx_startchn           ;
        jae      s25e2                       ;
        mov      ah,cs:fx_startchn           ;
s25e2:  mov      cs:tchn,ah                  ;  NOW CHANNEL IN AH and tchn
                                             ;

;       mov      al,0          ; first: set vol to zero
;       CallFunc 5             ;

        mov      ah,cs:tchn    ;
        mov      cx,gs:[di+8]  ; second: set FX pitch (amiga freq value)
        CallFunc 9             ;

        push     edi           ;
        mov      al,0          ;
        mov	 ah,cs:tchn    ;
        mov      cx,gs:[di+4]  ;
        mov      dx,0          ; third: shoot FX sample
        mov      si,0FFFFh     ;
        mov      edi,gs:[di]   ;
        CallFunc 11            ;
        pop      edi           ;

        mov      ah,cs:tchn    ;
        mov      al,gs:[di+11] ; fourth: set FX channel panning
        CallFunc 7             ;

        mov      ah,cs:tchn    ;
        mov      al,gs:[di+10] ; fifth: set FX volume
        CallFunc 5             ;

        pop      gs edi si dx cx ax

        retn
serv25  endp

;----------------------------------------------------------------------------

if API_2_enable ne 0

nproc   OpenServices  ; opens INT API_2_int API entry point (PMODE comp)
        push     ds eax
        xor      ax,ax
        mov      ds,ax
        mov      eax,ds:[API_2_int*4]
        mov      cs:Old_API,eax
        mov      ax,cs
        shl      eax,16
        mov      ax,offset Int_API
        cli
        mov      ds:[API_2_int*4],eax
        sti
        pop      eax ds
        retn
nendp   OpenServices

nproc   CloseServices
        push     ds eax
        xor      ax,ax
        mov      ds,ax
        mov      eax,cs:Old_API
        cli
        mov      ds:[API_2_int*4],eax
        sti
        pop      eax ds
        retn
nendp   CloseServices

;--- API entry point #2 (pmode comp.) ---------------------------------------

;
;  calling convention:
;  ===================
;  AH=API_2_func
;  service number in DH instead of AH
;  the rest of regs exactly as for API #1
;  INT API_2_int
;
;  out: some para in registers

Int_API:
        pushf
        cmp      ah,API_2_func          ; do we have a SDS API call ?
        sjne     do_old                 ; no, do the orig INT

        mov      ah,dh                  ; service # in DH for API #2 !!!
                                        ; so load it into AH fo calling
                                        ; the API #1

        call     dword ptr cs:ServRoutAddr ; DO IT!

        push     eax
        mov      al,20h
        out      20h,al                 ; EOI
        pop      eax

        popf
        iret                            ; 16-bit IRET !!!

do_old: popf
        db       0eah
Old_API dd       0

endif

;----------------------------------------------------------------------------
