
program Efecto1;

{ Programa que realiza un efecto de transformacin sobre un bitmap

  Copyright (C) 1997 por FAC Software.

  Este programa es PRESTAWARE, lo que significa que:

       1) Queda prohibido usar el programa con fines de lucro
       2) Queda prohibido distribur el programa en forma modificada
       3) Queda prohibido no dar crdito a FAC Software por el uso
          de este programa o parte de l.
       4) Queda prohibida cualquier otra cosa que estn pensando en
          este momento


  Que lo disfruten...
}



uses Mode_13, Crt;

const picfile = 'pic1.pcx'; { Nombre del archivo de imagen }
{ Asegrense de que el archivo est en el mismo directorio que el
  programa ejecutable }


type matrix = array[-80..80, -80..80] of integer;
     Pmatrix = ^matrix;


var Image : array[0..119, 0..159] of byte;
    TransX : Pmatrix; { Estas son las matrices de transformacin }
    TransY : Pmatrix;
    pal : TPalette;
    xp, yp, n : integer; { Variables globales }
    VirScr : PTVirtual; { La pantalla virtual }
    VirSeg : word;
    sint, cost : array[0..360] of real;
    { Tablas precalculadas para el seno y el coseno }


function sgn(n : integer) : integer;
{ Esta funcin devuelve:

       0 si n = 0;
       1 si n > 0;
      -1 si n < 0;
}
begin
     if n > 0 then
     begin
          sgn := 1;
     end
     else
         if n < 0 then sgn := -1 else sgn := 0;
end;


procedure SetTrigTables;
{ Este procedimiento calcula las tablas trigonomtricas }
var ang : integer;

begin
     writeln('Generando tablas trigonomtricas...');
     for ang := 0 to 360 do
     begin
          sint[ang] := sin(ang * 3.14159265 / 180);
          cost[ang] := cos(ang * 3.14159265 / 180);
     end;
end;


procedure SetTransMatrix;
{ Este procedimiento calcula las matrices de transformacin }

var x, y : integer;
    d : longint;
    a, b : integer;

begin
     writeln('Generando matrices de transformacin...');
     TransX := new(Pmatrix); { Reservamos memoria para las matrices }
     TransY := new(Pmatrix);
     for x := -80 to 80 do
         for y := -80 to 80 do
         begin
              d := (x*x + y*y) div 640;
              a := round((x + 80) * 36 / 16);
              b := round((y + 80) * 36 / 16);
              TransX^[x, y] := round(sint[a] * (d * sgn(x)));
              TransY^[x, y] := round(sint[b] * (d * sgn(y)));
         end;
     { No pregunten cmo gener las matrices de transformacin.
       Fu un INVENTO }

end;


procedure LoadImage;
var x, y : word;

begin
     writeln('Cargando la imagen PCX...');
     LoadPCX(picfile, VirSeg, 120, 160, 0, 0, pal);

     { Ahora guardamos la imagen en un arreglo }
     { Notese que el arreglo Image[] no se encuentra en el heap,
       es decir que no se accede a l con un apuntador. Esto se
       hace para que el acceso al arreglo sea ms rpido, pero
       existe el riesgo de terminarse la memoria disponible para
       variables, por lo tanto, convendra usar apuntadores}


     writeln('Almacenando la imagen en un arreglo...');
     for x := 0 to 119 do
         for y := 0 to 159 do
             Image[x, y] := GetPixel(x, y, VirSeg);

     ClearScreen(0, VirSeg); { Borramos la pantalla virtual }
end;



procedure DrawImage(xpos, ypos : integer);
{ Este procedimiento muestra la imagen en la pantalla PERO transformada }

var x, y : byte;
    u, v : integer;
    x1, y1 : integer;

begin
     for x := 0 to 119 do
         for y := 0 to 159 do
         begin
              u := (x shr 2) + xpos - 15;
              v := (y shr 2) + ypos - 20;

              x1 := x + TransX^[u, v];
              if x1 > 119 then x1 := 119;
              if x1 < 0 then x1 := 0;
              y1 := y + TransY^[u, v];
              if y1 > 159 then y1 := 159;
              if y1 < 0 then y1 := 0;

         { (x1, y1) es la coordenada transformada de cada punto }

              PutPixel(x+100, y+20, Image[x1, y1], VirSeg);
         end;
     VRetrace;
     CopyScreen(VirSeg, VGA);
end;


begin
     clrscr;
     writeln;
     writeln('Programa que muestra un efecto interesante, haciendo uso');
     writeln('del formato PCX, las pantallas virtuales y los arreglos');
     writeln('precalculadas para generar matrices de transformacin y');
     writeln('tablas trigonomtricas.');
     writeln;
     writeln('Equipo mnimo recomendado: 486DX a 33 Mhz');
     writeln;
     writeln('Presiona una tecla...');
     readkey;
     clrscr;

     SetupVirtual(VirScr, VirSeg);
     ClearScreen(0, VirSeg);
     LoadImage;
     SetTrigTables;
     SetTransMatrix;

     SetMode13;

     SetPalette(pal);

     n := 0;
     while not keypressed do
     begin
          xp := round(sint[n*3] * 65);
          yp := round(cost[n*3] * 60);
          { (xp, yp) es la posicin dentro de las matrices de transf.
            con la cual se calcular la imagen final }
          DrawImage(xp, yp);
          inc(n);
          if n > 119 then n := 0; { Esto es un invento, pero funciona }
     end;

     readkey;

     ShutDownVirtual(VirScr);
     dispose(TransX);
     dispose(TransY);
     SetTextMode;
     clrscr;
end.