
// MODE13.CPP
// por FAC

// Implementacin de las funciones para trabajar en el modo 13h

#include <dos.h>         // MK_FP, geninterrupt
#include <mem.h>         // memset, memcpy
#include <alloc.h>       // farcalloc, farfree
#include <stdio.h>       // fopen, fclose, fseek, fgetc
#include "mode13.h"

#define iAbs(x) (x<0) ? -x : x

// Funciones para cambiar el modo grfico

void SetMode13()
{
        _AX = 0x0013;
        geninterrupt(0x10);
        CurrentMode = m13h;
        for (int y = 0; y < 200; y++) YOffset[y] = y * 320;
}

void SetTextMode()
{
        _AX = 0x0003;
        geninterrupt(0x10);
        CurrentMode = mText;
}


// Funciones de dibujo

void ClearScreen(byte color, word where)
{ asm {
        mov es, [where]
        xor di, di
        mov al, [color]
        mov ah, al
        mov dx, ax
        db Long; shl ax, 16
        mov cx, 16000
        mov ax, dx
        db 0xF3, 0x66, 0xAB
      }
}

void PutPixel(word x, word y, byte color, word where)
{ asm {
        mov es, [where]
        mov bx, [y]
        add bx, bx
        mov di, word ptr [YOffset + bx]
        add di, [x]
        mov al, color
        mov es:[di], al
      }
}

byte GetPixel(word x, word y, word where)
{ asm {
        mov es, [where]
        mov bx, [y]
        add bx, bx
        mov di, word ptr [YOffset + bx]
        add di, [x]
        mov al, es:[di]
      }
      return _AL;
}

void HLine(word x1, word x2, word y, byte color, word where)
{ asm {
        mov bx, y
        mov es, [where]
        add bx, bx
        mov cx, x2
        mov di, word ptr [YOffset + bx]
        sub cx, x1
        add di, x1
        mov al, color
        mov ah, al
        shr cx, 1
        jnc start
        stosb
      }
  start:  asm rep stosw;
}

int iSgn(int n)
{
    if (n > 0) return 1; else if (n < 0) return -1; else return 0;
}

void Line(word x1, word y1, word x2, word y2, byte color, word where)
{
     int i, s, d1x, d1y, d2x, d2y, u, v, m, n;
     u = x2 - x1;
     v = y2 - y1;
     d1x = d2x = iSgn(u);
     d1y = iSgn(v);
     d2y = 0;
     m = iAbs(u);
     n = iAbs(v);
     if (!(m > n))
     {
        d2x = 0;
        d2y = iSgn(v);
        m = iAbs(v);
        n = iAbs(u);
     }
     s = m >> 1;
     for (i = 0; i <= m; i++)
     {
        memset(MK_FP(where, YOffset[y1] + x1), color, 1);
        s += n;
        if (!(s < m))
        {
                s -= m;
                x1 += d1x;
                y1 += d1y;
        }
        else
        {
                x1 += d2x;
                y1 += d2y;
        }
     }
}

// Manejo de paleta

void GetPal(byte color, byte &R, byte &G, byte &B)
{
     byte red, green, blue;
     asm {
           mov dx, 0x03C7
           mov al, [color]
           out dx, al
           add dx, 2
           in al, dx
           mov [red], al
           in al, dx
           mov [green], al
           in al, dx
           mov [blue], al
         }
     R = red;
     G = green;
     B = blue;
}

void SetPal(byte color, byte R, byte G, byte B)
{
     asm {
           mov dx, 0x03C8
           mov al, [color]
           out dx, al
           inc dx
           mov al, [R]
           out dx, al
           mov al, [G]
           out dx, al
           mov al, [B]
           out dx, al
         }
}

void GetPalette(TPalette &pal)
{
     TPalette temp;
     word tseg = FP_SEG(temp);
     word toff = FP_OFF(temp);
     asm {
           mov es, [tseg]
           mov di, [toff]
           mov dx, 0x03C7
           mov al, 0
           out dx, al
           add dx, 2
           mov cx, 768
           rep insb
         }
     memcpy(pal, temp, 768);
}

void SetPalette(TPalette pal)
{
     asm {
           push ds
           lds si, pal
           mov dx, 0x03C8
           mov al, 0
           out dx, al
           inc dx
           mov cx, 768
           rep outsb
           pop ds
         }
}

void RotatePalette(TPalette &pal, byte first, byte last)
{
     byte i;
     TColor c;

     if (first < last)
     {
        memcpy(c, pal[last], 3);
        for (i = last; i > first; i--) memcpy(pal[i], pal[i - 1], 3);
        memcpy(pal[first], c, 3);
     }
     else
     {
        memcpy(c, pal[last], 3);
        for (i = last; i < first; i++) memcpy(pal[i], pal[i + 1], 3);
        memcpy(pal[first], c, 3);
     }
}

void FadeOut(word d)
{
     TPalette p;
     word i, j;

     GetPalette(p);
     for (i = 0; i < 64; i++)
     {
        for (j = 0; j < 256; j++)
        {
                if (p[j][0]) p[j][0]--;
                if (p[j][1]) p[j][1]--;
                if (p[j][2]) p[j][2]--;
        }
        VRetrace;
        SetPalette(p);
        delay(d);
     }
}

void FadeTo(TPalette pal, word d)
{
     TPalette p;
     word i, j;

     GetPalette(p);
     for (i = 0; i < 64; i++)
     {
        for (j = 0; j < 256; j++)
        {
                if (p[j][0] > pal[j][0]) p[j][0]--;
                if (p[j][0] < pal[j][0]) p[j][0]++;
                if (p[j][1] > pal[j][1]) p[j][1]--;
                if (p[j][1] < pal[j][1]) p[j][1]++;
                if (p[j][2] > pal[j][2]) p[j][2]--;
                if (p[j][2] < pal[j][2]) p[j][2]++;
        }
        VRetrace;
        SetPalette(p);
        delay(d);
     }
}

// Pantallas virtuales

void SetupVirtual(PTVirtual &VScr, word &VSeg)
{
        VScr = (byte *) farcalloc(64000, 1);
        if (VScr) VSeg = FP_SEG(VScr);
}

void ShutDownVirtual(PTVirtual &VScr)
{
        farfree(VScr);
        VScr = NULL;
}

void CopyScreen(word source, word dest)
{
     asm {
           push ds
           mov es, [dest]
           mov ds, [source]
           xor si, si
           xor di, di
           mov cx, 16000
           db 0xF3, 0x66, 0xA5   // rep movsd
           pop ds
         }
}

// Funciones diversas

void VRetrace()
{
     asm mov dx, 0x03DA;
     loop1: asm {
                  in al, dx
                  test al, 0x08
                  jnz loop1
                }
     loop2: asm {
                  in al, dx
                  test al, 0x08
                  jz loop2
                }
}


void LoadPCX(const char *fn, word where, word dimX, word dimY,
             word offX, word offY, TPalette &pal)
{
     FILE *file;
     word x, y;
     byte c, a, i, r, g, b;
     int flag;

     if ((file=fopen(fn, "rb")) == NULL) return;
     fseek(file, 128, SEEK_SET);
     flag = 1;
     x = y = 0;

     while (flag)
     {
          c = fgetc(file);

          if ((c & 0xC0) == 0xC0)
          {
               a = fgetc(file);
               for (i = 0; i < (c & 0x3F); i++)
               {
                    PutPixel(offX + x, offY + y, a, where);
                    if (++x == dimX)
                    {
                         x = 0;
                         if (++y == dimY) flag = 0;
                    }
               }
          }
          else
          {
               PutPixel(offX + x, offY + y, c, where);
               if (++x == dimX)
               {
                    x = 0;
                    if (++y == dimY) flag = 0;
               }
          }
     }

     fseek(file, -768, SEEK_END);

     for (x = 0; x < 256; x++)
     {
          pal[x][0] = ((byte)fgetc(file)) >> 2;
          pal[x][1] = ((byte)fgetc(file)) >> 2;
          pal[x][2] = ((byte)fgetc(file)) >> 2;
     }

     fclose(file);
}
