
program ScrollH;
{ Programa que muestra cmo hacer el scroll horizontal de pantalla completa
  en el modo 13.

  Por: FAC productions.
}


uses Mode_13, Crt;

var VirScr : PTVirtual; { Apuntador a la pantalla virtual }
    VirSeg : word;      { Segmento de la pantalla virtual }


procedure DibujaFondo;
{ Dibuja un fondo ajedrezado en la pantalla virtual (sin comentarios) }
var x, y, i : word;
    color : byte;

begin
     color := 1;
     for y := 0 to 7 do
     begin
         for x := 0 to 9 do
         begin
              for i := 0 to 24 do
                  hline(x * 32, x * 32 + 31, y * 25 + i, color, VirSeg);
              inc(color);
              if color > 2 then color := 1;
         end;
         inc(color);
         if color > 2 then color := 1;
     end;
end;


procedure ScrollIzquierda;
{ Hace un scroll hacia la izquierda y mueve la lnea izquierda
  a la derecha }

var buffer : array[0..199] of byte; { buffer temporal para guardar la }
    i : word;                       { lnea izquierda }

begin
     for i := 0 to 199 do buffer[i] := mem[VirSeg:i*320]; { Guarda la lnea
                                                            izquierda }
     Move(mem[VirSeg:1], mem[VirSeg:0], 63999); { mueve la pantalla
                                                  una lnea hacia la izq. }

     for i := 0 to 199 do mem[VirSeg:i*320+319] := buffer[i];
     { copia la lnea izquierda a la derecha }

     VRetrace; { Espera al retrazado vertical }
     CopyScreen(VirSeg, VGA); { Y copia la pantalla virtual a VGA }
end;


procedure ScrollDerecha;
{ Hace un scroll hacia la derecha y mueve la lnea derecha a la izquierda }
{ La idea es la misma que en el procedimiento anterior }

var buffer : array[0..199] of byte;
    i : word;

begin
     for i := 0 to 199 do buffer[i] := mem[VirSeg:i*320+319];
     Move(mem[VirSeg:0], mem[VirSeg:1], 63999);
     for i := 0 to 199 do mem[VirSeg:i*320] := buffer[i];
     VRetrace;
     CopyScreen(VirSeg, VGA);
end;



begin
     clrscr;
     writeln;
     writeln(' Programa de ejemplo de scroll horizontal de pantalla completa.');
     writeln;
     writeln(' El programa dibuja un fondo ajedrezado y luego hace un scroll');
     writeln(' de pantalla completa hacia la izquierda. Al oprimir una tecla, la');
     writeln(' direccin del scroll cambia hacia la derecha.');
     writeln;
     writeln(' oPrImE uNa TeClA...');
     readkey;


     SetupVirtual(VirScr, VirSeg); { inicializamos la pantalla virtual }

     DibujaFondo; { dibujamos el fondo ajedrezado (en la pantalla virtual) }

     SetMode13; { iniciamos el modo grfico }

     while keypressed do readkey; { Esto sirve para borrar el buffer
                                    del teclado (por si se haba oprimido
                                    alguna tecla) }

     { Se hace scroll hacia la izquierda hasta que se oprima una tecla }
     while not keypressed do ScrollIzquierda;
     readkey;

     { Se hace scroll hacia la derecha hasta que se oprima una tecla }
     while not keypressed do ScrollDerecha;
     readkey;

     SetTextMode; { regresa al modo texto }
     ShutDownVirtual(VirScr); { y libera la memoria de la pantalla virtual }
     clrscr;
end.