{
  Ejemplo de las rutinas bsicas de 3D:

             - Generacin de un objeto tridimensional
             - Proyeccin a dos dimensiones
             - Rotacin y traslacin

 Como efectos extra se incluyen: estela de movimiento y FadeOut controlado

 Codificado por FAC, para el tutorial de grficos #8
}

program Base3D;

uses Mode13, FMath, Crt;
{              |
               |----- Se incluye la unidad de nmeros de punto fijo
}

const MaxVertices = 8;  { Nmero mximo de vrtices (8 para un cubo) }
      MaxCaras = 6;     { Nmero mximo de caras (6 para un cubo) }
      MaxVerticesCara = 4; { Nmero mximo de vrtices en cada cara }


{ Definicin de tipos }

     { Tipo Vrtice }
type TVertice = record
                x, y, z : Fixed;  { Coordenadas del vrtice }
                x2d, y2d : integer; { Coordenadas de la proyeccin en 2D }
                end;

     { Tipo cara (polgono) }
     TCara = record
             NVertices : byte;  { Nmero de vrtices en el polgono }
             Vertice : array[1..MaxVerticesCara] of integer;
                       { Indices correspondientes a cada vrtice }
             end;

     { Tipo Objeto Tridimensional }
     TObjeto3D = record
                 NVertices : integer;  { Nmero de vrtices }
                 NCaras : integer;     { Nmero de caras }
                 ox, oy, oz : integer; { Coordenadas del origen del objeto }
                 Vertice : array[1..MaxVertices] of TVertice; { Vrtices }
                 Cara : array[1..Maxcaras] of TCara;          { Caras }
                 end;



var Seno, Coseno : array[0..359] of Fixed;  { Tablas trigonomtricas }

    Cubo : TObjeto3D;  { Objeto tridimensional }
    pal : TPalette;    { paleta utilizada }


{ El siguiente procedimiento genera las tablas trigonomtricas en formato
  de punto fijo 16.16 }
procedure GeneraTablas;
var a : integer;
begin
     for a := 0 to 359 do
     begin
          Seno[a] := Real2Fixed(sin(a * Pi / 180.0));
          Coseno[a] := Real2Fixed(cos(a * Pi / 180.0));
     end;
end;


{ Procedimientos de los vrtices }

{ Este procedimiento calcula la proyeccin a 2D de un vrtice }
procedure VerticeCalcula2D(var v : TVertice; Zdist : integer);
var p : Fixed;
begin
     { Zdist es la coordenada Z del origen del objeto tridimensional }
     p := Int2Fixed(1024 - Zdist) - v.z;
     v.x2d := Fixed2Int(FDiv(v.x, p) shl 9) + 160;
     v.y2d := Fixed2Int(FDiv(v.y, -p) shl 9) + 100;
     { shl 9 equivale a multiplicar por 512 (perspectiva) }
end;

{ Este procedimiento rota un vrtice sobre cualquier eje }
procedure VerticeRota(var v : TVertice; ax, ay, az : integer);
var nx, ny, nz : Fixed;
begin
     { Aseguramos que los ngulos sean positivos (entre 0 y 359) }
     if ax < 0 then inc(ax, 360);
     if ay < 0 then inc(ay, 360);
     if az < 0 then inc(az, 360);

     { Rotacin sobre el eje X }
     if ax <> 0 then
     begin
          ny := FMul(v.y, Coseno[ax]) - FMul(v.z, Seno[ax]);
          nz := FMul(v.y, Seno[ax]) + FMul(v.z, Coseno[ax]);
          v.y := ny;
          v.z := nz;
     end;

     { Rotacin sobre el eje Y }
     if ay <> 0 then
     begin
          nx := FMul(v.x, Coseno[ay]) - FMul(v.z, Seno[ay]);
          nz := FMul(v.x, Seno[ay]) + FMul(v.z, Coseno[ay]);
          v.x := nx;
          v.z := nz;
     end;

     { Rotacin sobre el eje Z }
     if az <> 0 then
     begin
          nx := FMul(v.x, Coseno[az]) - FMul(v.y, Seno[az]);
          ny := FMul(v.x, Seno[az]) + FMul(v.y, Coseno[az]);
          v.x := nx;
          v.y := ny;
     end;
end;


{ Procedimientos de las caras }

{ Este procedimiento resetea las variables principales de una cara }
procedure CaraReinicia(var cara : TCara);
begin
     cara.NVertices := 0;
end;

{ Este procedimiento aade un vrtice (su ndice) a una cara }
{ IMPORTANTE!!! Los vrtices se deben aadir en el sentido OPUESTO
                a las manecillas del reloj.                       }
procedure CaraAgregaVertice(var cara : TCara; vertice : integer);
begin
     { Primero comprobamos si podemos aadir otro vrtice }
     if cara.NVertices = MaxVerticesCara then exit;
     { Si es as, lo aadimos }
     inc(cara.NVertices);
     cara.Vertice[cara.NVertices] := vertice;
end;


{ Procedimientos de los objetos 3D }

{ Este procedimiento reinicia las variables importantes de un objeto 3D }
procedure Objeto3DReinicia(var obj : TObjeto3D);
begin
     obj.NVertices := 0;
     obj.NCaras := 0;
     obj.ox := 0;
     obj.oy := 0;
     obj.oz := 0;
end;


{ Este procedimiento agrega un vrtice al objeto tridimensional }
{ (no importa el orden, pero hay que recordar el ndice de cada vrtice
   a la hora de especificar los polgonos) }
procedure Objeto3DAgregaVertice(var obj : TObjeto3D; nx, ny, nz : integer);
begin
     { Comprobamos si se le puede aadir otro vrtice al objeto }
     if obj.NVertices = MaxVertices then exit;
     { Si se puede, lo agregamos }
     inc(obj.NVertices);
     obj.Vertice[obj.NVertices].x := Int2Fixed(nx);
     obj.Vertice[obj.NVertices].y := Int2Fixed(ny);
     obj.Vertice[obj.NVertices].z := Int2Fixed(nz);
end;


{ Este procedimiento aade una cara (o polgono) al objeto }
procedure Objeto3DAgregaCara(var obj : TObjeto3D; cara : TCara);
begin
     { Comprobamos que se pueda aadir otra cara }
     if obj.NCaras = MaxCaras then exit;
     { Si es as, la aadimos }
     inc(obj.NCaras);
     obj.Cara[obj.NCaras] := cara;
end;

{ Este procedimiento rota un objeto mediante la rotacin de sus vrtices }
procedure Objeto3DRota(var obj : TObjeto3D; ax, ay, az : integer);
var i : integer;
begin
     { Simplemente rotamos todos los vrtices }
     for i := 1 to obj.NVertices do
         VerticeRota(obj.Vertice[i], ax, ay, az);
end;

{ Este procedimiento mueve el origen del objeto (y por lo tanto, el objeto)
  al punto (nx, ny, nz) con respecto al centro de la pantalla }
procedure Objeto3DMueve(var obj : TObjeto3D; nx, ny, nz : integer);
begin
     obj.ox := nx;
     obj.oy := ny;
     obj.oz := nz;
end;

{ Este procedimiento calcula la proyeccin bidimensional de sus vrtices
  y los traslada respecto al origen del objeto }
procedure Objeto3DCalcula2D(var obj : TObjeto3D);
var i : integer;
begin
     { Calcula la proyeccin 2D de cada vrtice y lo desplaza con respecto
       al origen del objeto }
     for i := 1 to obj.NVertices do
     begin
          VerticeCalcula2D(obj.Vertice[i], obj.oz);
          inc(obj.Vertice[i].x2d, obj.ox);
          inc(obj.Vertice[i].y2d, obj.oy);
     end;
end;


{ Procedimientos para dibujar objetos 3D }
{ IMPORTANTE!!! No se hace ninguna comprobacin acerca de si los objetos
                quedan dentro de los lmites de la pantalla (0, 0, 319, 199),
                por lo tanto se pueden producir resultados inesperados si
                no se controla el movimiento de los objetos }

{ Este procedimiento simplemente dibuja un punto en cada vrtice del objeto }
procedure Objeto3DDibujaVertices(obj : TObjeto3D; color : byte; where : word);
var i : integer;
begin
     Objeto3DCalcula2D(obj); { Primero calculamos la proyeccin en 2D }
     for i := 1 to obj.NVertices do
         PutPixel(obj.Vertice[i].x2d, obj.Vertice[i].y2d, color, where);
end;


{ Este procedimiento dibuja un "modelo de alambre" del objeto, es decir,
  dibuja nicamente las aristas }
procedure Objeto3DDibujaMalla(obj : TObjeto3D; color : byte; where : word);
var x1, y1, x2, y2 : Fixed;
    i, j : integer;
begin
     Objeto3DCalcula2D(obj);  { Calculamos la proyeccin en 2D }
     for j := 1 to obj.NCaras do { Dibujamos todas las caras }
     begin
          { Si una cara tiene menos de 3 vrtices entonces es invisible }
          if obj.cara[j].NVertices < 3 then exit;

          { Obtenemos las coordenadas del primer vrtice }
          x1 := obj.Vertice[obj.Cara[j].Vertice[1]].x2d;
          y1 := obj.Vertice[obj.Cara[j].Vertice[1]].y2d;

          { y hacemos un ciclo para dibujar todas las aristas }
          for i := 2 to obj.cara[j].NVertices do
          begin
               { Obtenemos las coordenadas del siguiente vrtice }
               x2 := obj.Vertice[obj.Cara[j].Vertice[i]].x2d;
               y2 := obj.Vertice[obj.Cara[j].Vertice[i]].y2d;
               { Dibujamos una lnea entre los dos vrtices }
               Line(x1, y1, x2, y2, color, where);
               x1 := x2;
               y1 := y2;
          end;

          { Obtenemos nuevamente las coordenadas del primer vrtice para
            dibujar una lnea entre el primero y el ltimo vrtices }
          x2 := obj.Vertice[obj.Cara[j].Vertice[1]].x2d;
          y2 := obj.Vertice[obj.Cara[j].Vertice[1]].y2d;
          Line(x1, y1, x2, y2, color, where);
     end;
end;


{ Este procedimiento genera un cubo con centro en el origen }
{ Se puede alterar este procedimiento (y solamente este) para
  generar otros objetos diferentes (pirmides, letras, etc...) }
procedure GeneraCubo;
const lado = 80;

var cara : TCara;

{  Nuestro cubo est formado de la siguiente manera:

                                 3       4
                                 o-------o
                                /|      /|
                               / |     / |
                           1  /  |  2 /  |
                             o---|---o   |
                             |   o---|---o
                             |  / 5  |  / 6
                             | /     | /
                             |/      |/
                             o-------o
                             7       8

}
begin
     { Agregamos los 8 vrtices del cubo }
     Objeto3DReinicia(Cubo);
     Objeto3DAgregaVertice(Cubo, -lado, lado, lado);
     Objeto3DAgregaVertice(Cubo, lado, lado, lado);
     Objeto3DAgregaVertice(Cubo, -lado, lado, -lado);
     Objeto3DAgregaVertice(Cubo, lado, lado, -lado);
     Objeto3DAgregaVertice(Cubo, -lado, -lado, -lado);
     Objeto3DAgregaVertice(Cubo, lado, -lado, -lado);
     Objeto3DAgregaVertice(Cubo, -lado, -lado, lado);
     Objeto3DAgregaVertice(Cubo, lado, -lado, lado);

     { Ahora agregamos las 6 caras, construyndolas una por una }
     CaraReinicia(cara);
     CaraAgregaVertice(cara, 2);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 7);
     CaraAgregaVertice(cara, 8);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 2);
     CaraAgregaVertice(cara, 8);
     CaraAgregaVertice(cara, 6);
     CaraAgregaVertice(cara, 4);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 4);
     CaraAgregaVertice(cara, 6);
     CaraAgregaVertice(cara, 5);
     CaraAgregaVertice(cara, 3);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 3);
     CaraAgregaVertice(cara, 5);
     CaraAgregaVertice(cara, 7);
     CaraAgregaVertice(cara, 1);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 2);
     CaraAgregaVertice(cara, 4);
     CaraAgregaVertice(cara, 3);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 6);
     CaraAgregaVertice(cara, 8);
     CaraAgregaVertice(cara, 7);
     CaraAgregaVertice(cara, 5);
     Objeto3DAgregaCara(Cubo, cara);
end;


{ Como ejemplo, aqu se muestra OTRO procedimiento GeneraCubo que
  genera un objeto diferente (una pirmide), aunque el nombre del
  objeto sigue siendo "cubo" :) }

{
                                    1
                                    o
                                   /|\
                                  / |  \
                                 o--|----o
                                / 5 |   / 4
                               /    |  /
                              /     | /
                             o-------o
                             2       3
}
procedure GeneraPiramide;
const lado = 80;
var cara : TCara;
begin
     Objeto3DReinicia(Cubo);
     Objeto3DAgregaVertice(Cubo, 0, lado, 0);
     Objeto3DAgregaVertice(Cubo, -lado, -lado, lado);
     Objeto3DAgregaVertice(Cubo, lado, -lado, lado);
     Objeto3DAgregaVertice(Cubo, lado, -lado, -lado);
     Objeto3DAgregaVertice(Cubo, -lado, -lado, -lado);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 2);
     CaraAgregaVertice(cara, 3);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 3);
     CaraAgregaVertice(cara, 4);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 4);
     CaraAgregaVertice(cara, 5);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 1);
     CaraAgregaVertice(cara, 5);
     CaraAgregaVertice(cara, 2);
     Objeto3DAgregaCara(Cubo, cara);

     CaraReinicia(cara);
     CaraAgregaVertice(cara, 5);
     CaraAgregaVertice(cara, 4);
     CaraAgregaVertice(cara, 3);
     CaraAgregaVertice(cara, 2);
     Objeto3DAgregaCara(Cubo, cara);
end;


{ Procedimiento que realiza la demostracin }
procedure Demo;
var x, y, z : integer;  { Coordenadas del origen del objeto }
    ax, ay, az : integer;  { Angulos de rotacin sobre cada eje }
    VirScr, FondoScr : PTVirtual;  { Usaremos 2 pantallas virtuales }
    VirSeg, FondoSeg : word;

    Estela : array[0..7] of TObjeto3D; { Arreglo de objetos para formar
                                         una "estela de movimiento" }
    i, j : byte;

begin
     { Iniciamos las pantallas virtuales y cargamos la imagen de fondo }
     SetupVirtual(VirScr, VirSeg);
     SetupVirtual(FondoScr, FondoSeg);
     LoadPCX('fondo.pcx', FondoSeg, 320, 200, 0, 0, pal);

     { Hacemos un degradado de grises en los ltimos 16 colores de la paleta }
     for i := 0 to 15 do
     begin
          pal[240 + i][0] := i;
          pal[240 + i][1] := i;
          pal[240 + i][2] := i;
     end;

     x := -110;
     y := 0;  { Coordenadas iniciales del objeto }
     z := -400;
     ax := 30;
     ay := -30; { Angulos iniciales de rotacin }
     az := 0;

     SetMode13;  { Entramos al modo grfico }
     FadeOut(0); { Y hacemos negra toda la paleta }
     CopyScreen(FondoSeg, VGA); { Copiamos la imagen de fondo a VGA }
     FadeTo(pal, 5); { Y la iluminamos }

     { Primera parte }
     while not keypressed do  { mientras no se presione una tecla... }
     begin
          Objeto3DMueve(Cubo, x, y, z); { Mueve el cubo a (x, y, z) }
          CopyScreen(FondoSeg, VirSeg); { Copia el fondo a la pantalla virtual }
          Objeto3DDibujaVertices(Cubo, 255, VirSeg); { Dibuja el objeto }
          VRetrace;       { Espera al retrazado vertical }
          CopyScreen(VirSeg, VGA);  { y muestra todo en VGA }

          { Rota el objeto y actualiza los ngulos de rotacin }
          Objeto3DRota(Cubo, ax div 10, ay div 10, az div 10);
          if ax < 50 then inc(ax) else ax := -50;
          if ay < 50 then inc(ay) else ay := -50;
          if az > -50 then dec(az) else az := 50;

          { Modifica las coordenadas del objeto (hacia el centro) }
          if x < 0 then inc(x);
          if z < 0 then inc(z);
     end;
     readkey;  { lee la tecla pulsada y la desecha }

     x := 0; { Establece las nuevas coordenadas del objeto (en caso de   }
     z := 0; { que se haya pulsado una tecla antes de tiempo) }

     { Segunda parte }
     while not keypressed do  { mientras no se oprima una tecla... }
     begin
          Objeto3DMueve(Cubo, x, y, z);  { Establece el origen del cubo }
          CopyScreen(FondoSeg, VirSeg);  { copia el fondo a la p. virtual }
          Objeto3DDibujaMalla(Cubo, 240 + z div 20, VirSeg); { dibuja el cubo }
          Objeto3DDibujaVertices(Cubo, 255, VirSeg); { y sus vrtices }
          VRetrace;   { espera al retrazo vertical }
          CopyScreen(VirSeg, VGA); { muestra todo en VGA }

          { Rota el objeto y actualiza los ngulos }
          Objeto3DRota(Cubo, ax div 10, ay div 10, az div 10);
          if ax < 50 then inc(ax) else ax := -50;
          if ay < 50 then inc(ay) else ay := -50;
          if az > -50 then dec(az) else az := 50;

          { Acerca el objeto al observador }
          if z < 300 then inc(z);
     end;
     readkey; { lee y desecha la tecla pulsada }

     z := 300; { Asegura la nueva posicin del objeto }
     Objeto3DMueve(Cubo, 0, 0, 300);

     { Copia el cubo en su posicin actual a los objetos que forman
       la estela de movimiento }
     for i := 0 to 7 do Estela[i] := Cubo;

     { Tercera parte }
     while not keypressed do { mientras bla bla bla... }
     begin
          CopyScreen(FondoSeg, VirSeg); { copia el fondo a bla bla bla }
          for i := 0 to 7 do { Dibuja los 8 objetos que forman la estela }
              Objeto3DDibujaMalla(Estela[i], 240 + i * 2, VirSeg);
          { Notar que cada objeto tiene una intensidad mayor que el anterior }
          VRetrace; { espera a que se sincronize la pantalla }
          CopyScreen(VirSeg, VGA); { y muestra todo en VGA }

          { "Desplaza" la estela de movimiento }
          for i := 0 to 6 do Estela[i] := Estela[i + 1];
          { Y rota el objeto (solamente el ltimo de la estela) }
          Objeto3DRota(Estela[7], ax div 8, ay div 8, az div 8);
          if ax < 50 then inc(ax) else ax := -50;
          if ay < 50 then inc(ay) else ay := -50;
          if az > -50 then dec(az) else az := 50;
     end;
     readkey; { bla bla bla con la tecla pulsada }

     { Cuarta Parte (Hace un fadeout en la imagen del fondo) }
     for j := 1 to 64 do { El fadeout toma 64 pasos }
     begin
          CopyScreen(FondoSeg, VirSeg); { copiamos el fondo a la p.v. }
          for i := 0 to 7 do { Dibujamos la estela de movimiento }
              Objeto3DDibujaMalla(Estela[i], 240 + i * 2, VirSeg);
          VRetrace; { esperamos al retrazado }
          CopyScreen(VirSeg, VGA); { y mostramos en VGA }
          SetPalette(pal); { y actualizamos la paleta }

          { Movemos la estela de movimiento y rotamos el ltimo objeto }
          for i := 0 to 6 do Estela[i] := Estela[i + 1];
          Objeto3DMueve(Estela[7], x, y, z);
          Objeto3DRota(Estela[7], ax div 8, ay div 8, az div 8);
          if ax < 50 then inc(ax) else ax := -50;
          if ay < 50 then inc(ay) else ay := -50;
          if az > -50 then dec(az) else az := 50;

          dec(z, 15); { Alejamos el objeto poco a poco }

          { Hacemos el fadeout de los colores 1 a 8 y 40 a 185 }
          { La imagen de fondo usa los colores 1 a 185, pero los
            colores del 9 al 39 son usados por el logotipo de "FAC",
            por lo tanto si no hacemos fade out en estos colores,
            el logotipo permanecer en la pantalla }
          for i := 1 to 8 do
          begin
               if pal[i][0] > 0 then dec(pal[i][0]);
               if pal[i][1] > 0 then dec(pal[i][1]);
               if pal[i][2] > 0 then dec(pal[i][2]);
          end;
          for i := 40 to 185 do
          begin
               if pal[i][0] > 0 then dec(pal[i][0]);
               if pal[i][1] > 0 then dec(pal[i][1]);
               if pal[i][2] > 0 then dec(pal[i][2]);
          end;
     end;

     { Hacemos el fade out del logotipo }
     for j := 1 to 64 do
     begin
          CopyScreen(FondoSeg, VirSeg); { copiamos el fondo a la p. v. }
          for i := 0 to 7 do  { Dibujamos el cubo con su estela }
              Objeto3DDibujaMalla(Estela[i], 240 + i * 2, VirSeg);
          VRetrace; { Sincronizamos con la pantalla }
          CopyScreen(VirSeg, VGA); { y mostramos todo en VGA }
          SetPalette(pal); { Actualizamos la paleta }
          { Actualizamos la estela de movimiento }
          for i := 0 to 6 do Estela[i] := Estela[i + 1];
          Objeto3DMueve(Estela[7], x, y, z);
          Objeto3DRota(Estela[7], ax div 8, ay div 8, az div 8);
          if ax < 50 then inc(ax) else ax := -50;
          if ay < 50 then inc(ay) else ay := -50;
          if az > -50 then dec(az) else az := 50;

          { Y alejamos el objeto }
          dec(z, 15);
          inc(x, 2);
          dec(y);

          { Hacemos fadeout en los colores del logotipo }
          for i := 9 to 39 do
          begin
               if pal[i][0] > 0 then dec(pal[i][0]);
               if pal[i][1] > 0 then dec(pal[i][1]);
               if pal[i][2] > 0 then dec(pal[i][2]);
          end;
     end;

     { Hacemos fadeout en el objeto tridimensional }
     for j := 1 to 64 do
     begin
          ClearScreen(0, VirSeg); { Borramos la pantalla virtual }
          for i := 0 to 7 do  { Dibujamos el objeto y su estela }
              Objeto3DDibujaMalla(Estela[i], 240 + i * 2, VirSeg);
          VRetrace; { Esperamos el retrazado vertical }
          CopyScreen(VirSeg, VGA); { copiamos a VGA }
          SetPalette(pal); { Actualizamos la paleta }
          { Actualizamos la estela de movimiento y rotamos el cubo }
          for i := 0 to 6 do Estela[i] := Estela[i + 1];
          Objeto3DMueve(Estela[7], x, y, z);
          Objeto3DRota(Estela[7], ax div 8, ay div 8, az div 8);
          if ax < 50 then inc(ax) else ax := -50;
          if ay < 50 then inc(ay) else ay := -50;
          if az > -50 then dec(az) else az := 50;

          { Continuamos alejando el objeto }
          dec(z, 15);
          inc(x);
          dec(y, 2);

          { hacemos fadeout en los colores del cubo }
          for i := 240 to 255 do
          begin
               if pal[i][0] > 0 then dec(pal[i][0]);
               if pal[i][1] > 0 then dec(pal[i][1]);
               if pal[i][2] > 0 then dec(pal[i][2]);
          end;
     end;

     { Liberamos la memoria de las pantallas virtuales }
     ShutDownVirtual(VirScr);
     ShutDownVirtual(FondoScr);
end;


{ Secuencia principal }
begin
     clrscr;
     writeln;
     writeln('Demostracin de las rutinas bsicas de 3D.');
     writeln('Tambin se aade un efecto de estela de movimiento.');
     writeln;
     writeln('Presiona una tecla...');
     readkey;

     GeneraTablas;
     GeneraCubo;  { Se puede cambiar por GeneraPiramide }
     Demo;
     SetTextMode;
end.
