
// Programa CIRCULOS.PAS
// por FAC

// Este programa corresponde al tercer tutorial de grficos FAC

// Ejemplo de cmo dibujar circunferencias usando tablas precalculadas


#include <iostream.h>      // cout
#include <conio.h>         // clrscr, getch
#include <math.h>          // sin, cos
#include "mode13.h"
#include "mode13.cpp"


typedef double Tabla[1441];

Tabla Seno, Coseno;

void GeneraTablas()
{
     double ang;
     int i;

     ang = 0.0;
     i = 0;
     while (!(ang > 360.0))
     {
          Seno[i] = sin(ang * 3.14159265 / 180);
          Coseno[i] = cos(ang * 3.14159265 / 180);
          ang = ang + 0.25;
          i++;
     }
}


void Circulo(int cx, int cy, word radio, byte color)
{
     int x, y, i;

     for (i = 0; i <= 1440; i++)
     {
          x = cx + (int)(radio * Coseno[i]);
          y = cy + (int)(radio * Seno[i]);

          if ((x >= 0) && (y >= 0) && (x < 320) && (y < 200))
             PutPixel(x, y, color, VGA);
     }
}


void main()
{
     TPalette pal;
     word i;

     clrscr();
     cout << "\nEjemplo de uso del algoritmo de crculos y el uso de tablas\n"
          << "precalculadas.\n"
          << "\nOprime una tecla para continuar...\n";
     getch();

     GeneraTablas();

     for (i = 0; i < 64; i++)
     {
          pal[i][0] = pal[i][2] = i;
          pal[i][1] = 0;

          pal[i+64][0] = 0;
          pal[i+64][1] = i;
          pal[i+64][2] = 16;

          pal[i+128][0] = pal[i+128][1] = i;
          pal[i+128][2] = 0;

          pal[i+192][0] = 0;
          pal[i+192][1] = pal[i+192][2] = i;
     }

     SetMode13();
     SetPalette(pal);

     for (i = 0; i < 64; i++) Circulo(100, 50, 63 - i, i);
     for (i = 0; i < 64; i++) Circulo(220, 150, 63 - i, i + 64);
     for (i = 0; i < 64; i++) Circulo(220, 50, 63 - i, i + 128);
     for (i = 0; i < 64; i++) Circulo(100, 150, 63 - i, i + 192);

     getch();

     while (!kbhit())
     {
          RotatePalette(pal, 255, 0);
          VRetrace();
          SetPalette(pal);
     }

     getch();
     SetTextMode();
}
