/************************************************************************/
/* polygon.h, VESA polygoni-rutiinit. Copyright (c) Chem/Hubris.        */
/************************************************************************/
/* Kommentit lytyvt 3dicasta.                                         */
/************************************************************************/

#ifndef _chem_polygon_h
#define _chem_polygon_h

#include "bstructs.h"
extern unsigned char *VESAvirscr;
extern VBECurrentMode_type VBECurrentMode;


/************************************************************************/
/* klippausrajat. nit voipi surutta muutella.                         */
/************************************************************************/
/* huom. scene-rytinet muuttavat nit automaagisesti kameran mukaan.  */
/************************************************************************/
int c_left;
int c_right;
int c_up;
int c_down;


/************************************************************************/
/* flat polygon -rutiini.                                               */
/************************************************************************/
/* ykksverteksin vri (ver1.c) mr polygonin vrin.                 */
/* vaaditut verteksiparametrit: x,y,c, c vain ekassa verteksiss        */
/************************************************************************/
void kol(pol_vertex_type *v1, pol_vertex_type *v2,
         pol_vertex_type *v3);
/************************************************************************/
/* gouraud polygon-rutiini.                                             */
/************************************************************************/
/* vaaditut verteksiparametrit: x,y,c                                   */
/************************************************************************/
void gkol(pol_vertex_type *v1, pol_vertex_type *v2,
          pol_vertex_type *v3);
/************************************************************************/
/* linear texture polygon -rutiini.                                     */
/************************************************************************/
/* vaaditut verteksiparametrit: x,y,u,v                                 */
/************************************************************************/

void ltkol(pol_vertex_type *v1, pol_vertex_type *v2,
           pol_vertex_type *v3, char *from,
           char *palette);

/************************************************************************/
/* perspektiivikorjattu texture polygon -rutiini.                       */
/************************************************************************/
/* korjaus joka pikselille, hilpen vauhdikasta.                        */
/* vaaditut verteksiparametrit: x,y,z,u,v                               */
/************************************************************************/
void ptkol(pol_vertex_type *v1, pol_vertex_type *v2,
           pol_vertex_type *v3, char *from,
           char *palette);

/************************************************************************/
/* "aito" phong polygon -rutiini.                                       */
/************************************************************************/
/* vaaditut verteksiparametrit: x,y,nx,ny,nz ja rgb verteksille 1.      */
/************************************************************************/

void pkol(pol_vertex_type *v1, pol_vertex_type *v2,
          pol_vertex_type *v3, valo_type valo);

/************************************************************************/
/* linear gouraudtexture polygon -rutiini.                              */
/************************************************************************/
/* vaaditut verteksiparametrit: x,y,u,v,c                               */
/************************************************************************/
void lgtkol(pol_vertex_type *v1, pol_vertex_type *v2,
           pol_vertex_type *v3, char *from,
           char *palette);
#endif
