/*************************************************************************************/
/* DXSTART.H                                                                         */
/*                                                                                   */
/* This file was created by the DirectX Application Wizard. It's for easy startup of */
/* DirectX mode and initialization of all DirectDraw objects.                        */
/*                                                                                   */
/* Do not change this generated file!                                                */
/*                                                                                   */
/* (C)1997 by Franz Polzer & Peter Koen                                                        */
/*************************************************************************************/

#ifndef __DEF_DX_START_FRANZ_
#define __DEF_DX_START_FRANZ_	100

#define WIN32_LEAN_AND_MEAN

#include <ddraw.h>

#define TIMER_ID        1


LPDIRECTDRAW            lpDD;
LPDIRECTDRAWSURFACE     lpDDSView;
LPDIRECTDRAWSURFACE     lpDDSBack;
HCURSOR									mDDCursorShape;
BOOL                    bActive;

long FAR PASCAL WindowProc(HWND, UINT, WPARAM, LPARAM);
void DDDrawFrame(HWND);

static void DDReleaseAll(void)
{
	if(lpDD != NULL)
	{
		if(lpDDSView!=NULL)
		{
			lpDDSView->Release();
			lpDDSView = NULL;
		}
		lpDD->Release();
		lpDD = NULL;
	}
}

void DDSetCursor(HCURSOR nCursor)
{
	mDDCursorShape = nCursor;
}

static BOOL DDInitAll(HINSTANCE hInstance, int nCmdShow, int nTimerRate, int nXRes, int nYRes, int nBits)
{
	WNDCLASS						wc;
	HWND								hwnd;

	DDSURFACEDESC				ddsd;
  DDSCAPS							ddscaps;
	HRESULT             ddrval;
	
	char                buf[256];

	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = NULL;
	wc.lpszMenuName = NAME;
	wc.lpszClassName = NAME;
	RegisterClass(&wc);
    
	hwnd = CreateWindowEx(WS_EX_TOPMOST, NAME, TITLE, WS_POPUP, 0, 0,
												GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
												NULL, NULL, hInstance, NULL);

	if(!hwnd)	return FALSE;

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	ddrval = DirectDrawCreate(NULL, &lpDD, NULL);
	
	if(ddrval == DD_OK)
	{
		ddrval = lpDD->SetCooperativeLevel(hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
		if(ddrval == DD_OK)
		{
			ddrval = lpDD->SetDisplayMode(nXRes, nYRes, nBits);
			if(ddrval == DD_OK)
			{
				ddsd.dwSize = sizeof(ddsd);
				ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
				ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
				ddsd.dwBackBufferCount = 1;
				ddrval = lpDD->CreateSurface(&ddsd, &lpDDSView, NULL);
				if(ddrval == DD_OK)
				{					
					ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
					ddrval = lpDDSView->GetAttachedSurface(&ddscaps, &lpDDSBack);
					if(ddrval == DD_OK)
					{
						if( SetTimer(hwnd, TIMER_ID, nTimerRate, NULL))
						{
							return TRUE;
						}	
					}
				}
			}
		}
	}
	wsprintf(buf, "DirectDraw initialization failed with error code %08lX\n", ddrval);
	MessageBox(hwnd, buf, "DirectX ERROR", MB_OK);
	DDReleaseAll();
	DestroyWindow(hwnd);
	return FALSE;
}

void DDSwitchFrame()
{
	HRESULT ddrval;
	ddrval = lpDDSView->Flip(NULL, 0);
	if(ddrval == DD_OK) return;
	if(ddrval == DDERR_SURFACELOST)
	{
		ddrval = lpDDSView->Restore();
		if(ddrval != DD_OK)	return;
	}
	if(ddrval != DDERR_WASSTILLDRAWING)	return;
}

long FAR PASCAL WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch( message )
	{
		case WM_ACTIVATEAPP:
			bActive = wParam;
			break;

		case WM_CREATE:
			break;

		case WM_SETCURSOR:
			SetCursor(mDDCursorShape);
			return TRUE;

		case WM_TIMER:
			if(bActive)
			{
				DDDrawFrame(hWnd);
			}
			break;
 
    case WM_KEYDOWN:
			switch( wParam )
			{
				case VK_ESCAPE:
					PostMessage(hWnd, WM_CLOSE, 0, 0);
					break;
			}
			break;

		case WM_PAINT:
			break;

		case WM_DESTROY:
			DDReleaseAll();
			PostQuitMessage(0);
			break;
	}
	return DefWindowProc(hWnd, message, wParam, lParam);
}

#endif // __DEF_DX_START_FRANZ_
