/*
	Document Title : Free Diretion Rendering
	Author         : Ohad Eder Pressman aka Kombat/Immortals
	Date           : 20/02/1998

	Graphical and Mathematical routines/variables
*/


// Includes

#include <stdio.h>
#include <iostream.h>
#include <math.h>
#include <dos.h>

// Graphics

void mode(int);
#pragma aux mode=\
"int 0x10"\
parm [eax] modify exact [eax];

char *vga = (char *)0xA0000, texture[256*256];

void outp(unsigned short, char);
#pragma aux outp=\
"out dx, al"\
parm [dx] [al] modify exact [dx al];

void init_txtr()
{
	int i, j;

#ifdef GENERATE_UGLY_TEXTURE
	// Generate A Xor Texture
	for (i=0; i<256; i++)
		for (j=0; j<256; j++)
			texture[i + j*256] = i^j;
#else
	FILE *f;
	f = fopen("texture.raw","rb");
	fread(texture,256*256,1,f);
	fclose(f);
#endif

	// Setup A Fading Palette
	outp(0x3c8, 0);
	for (i=0;i<256;i++)
	{
		outp(0x3c9, i>>2);
		outp(0x3c9, i>>2);
		outp(0x3c9, i>>2);
	}
}


// Math

#define PI 3.141

#define EPSILON 1.0E-6 // a tiny number

#define FOV 120.0

typedef struct Vector
{
	float x, y, z;
} Vector;

#define sqr(a)		((a)*(a))
#define sgn(a)    (((a) > 0) ? 1 : -1)

void vec_norm(Vector *v)
{
	float l = 1.0 / sqrt(v->x*v->x + v->y*v->y + v->z*v->z);

	v->x *= l;
	v->y *= l;
	v->z *= l;
}

