#include <stdio.h>
#include <conio.h>
#include <malloc.h>
#include <types.h>
#include <graphs.h>
#include <font.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <timer.h>
#include <keyb_hnd.h>
#include <icp.h>
#include <log.h>

#include "3dtypes.h"
#include "ray.h"

DWORD   __add_15(DWORD c1, DWORD c2){
    return(add_15(c1,c2));
}

DWORD   __add_16(DWORD c1, DWORD c2){
    return(add_16(c1,c2));
}

DWORD __32to16 (DWORD c) {
    return(_32to16(c));
}

DWORD __32to15 (DWORD c) {
    return(_32to15(c));
}

DWORD   __Blend_16(DWORD c1, DWORD c2){
    return(Blend_16(c1,c2));
}

DWORD   __Blend_15(DWORD c1, DWORD c2){
    return(Blend_15(c1,c2));
}

void    end_ray(void) {

    free(map);
    if (graphics_system.gfxmode==4) free(virtual2);

}


// Angel!! A ver si tabulamos mejor el cdigo ;-)))

void    frame_ray (DWORD frames_pos) {

if (graphics_system.gfxmode==4)
    memmove (virtual2, virtual, graphics_system.bytes_scanline*
                                graphics_system.yresolution);

//clean new frame 95
memset (virtual, 0, graphics_system.xresolution*2*(graphics_system.yresolution));

FrameType=!FrameType;

if (!K_K && frames_pos<700) {

    sphere2.a=((plightpath->data)[frames_pos]).x;
    sphere2.b=((plightpath->data)[frames_pos]).y;
    sphere2.c=((plightpath->data)[frames_pos]).z;

    sphere1.a=((psphere1path->data)[frames_pos]).x;
    //sphere1.b=((psphere1path->data)[frames_pos]).y;
    sphere1.b=22;
    sphere1.c=((psphere1path->data)[frames_pos]).z;

    sphere3.a=((psphere3path->data)[frames_pos]).x;
    //sphere3.b=((psphere3path->data)[frames_pos]).y;
    sphere3.b=10;
    sphere3.c=((psphere3path->data)[frames_pos]).z;

    sphere4.a=((psphere4path->data)[frames_pos]).x;
    //sphere4.b=((psphere4path->data)[frames_pos]).y;
    sphere4.b=-20;
    sphere4.c=((psphere4path->data)[frames_pos]).z;

    if (frames_pos>40) {
        sphere1.b= fabs(sin((frames_pos+40)/10.0)*40)-15;
        sphere3.b= fabs(sin(frames_pos/10.0)*40)-20;
        sphere4.b= fabs(sin((frames_pos+20)/10.0)*30)-26;
    }
}

if(icg_boss) {

//8
    if (K_UP) sphere1.b+=step;
//2
    if (K_DOWN) sphere1.b-=step;
//6
    if (K_RIGHT) sphere1.a+=step;
//4                    
    if (K_LEFT) sphere1.a-=step;
//+
    if (K_GRAY_PLUS) sphere1.c-=step;
//-            
    if (K_GRAY_MINUS) sphere1.c+=step;

    if (K_W) sphere2.b+=step;
    if (K_S) sphere2.b-=step;
    if (K_D) sphere2.a+=step;
    if (K_A) sphere2.a-=step;
    if (K_R) sphere2.c+=step;
    if (K_F) sphere2.c-=step;

}

SortScene();

CalculateSlab (&sphere1);
CalculateSlab (&sphere3);
CalculateSlab (&sphere4);
CalculateSlab (&sphere5);



//Draw plane
    if (FrameType==0) {
        if (graphics_system.centery&1==1) Xstart=1;              //impar
        else Xstart=0;                      //par
    }
    else {
        if (graphics_system.centery&1==1) Xstart=0;              //impar
        else Xstart=1;                      //par
    }

sPtr=virtual + graphics_system.xresolution*graphics_system.centery*2 + 2;

for (Y1=graphics_system.centery; Y1<graphics_system.yresolution-30; Y1++, sPtr+=graphics_system.bytes_scanline ) {

Xstart=!Xstart;
    for (X1=Xstart<<1; X1<=graphics_system.xresolution-4; X1+=cell, color=0, intens=0) {
    
TempRay = RayTable [Y1*graphics_system.xresolution+X1];
t=IntersectPlane (plane1, TempRay);
if (t>1) {

    TempRay.x*=t;
    TempRay.y*=t;
    TempRay.z*=t;

    // textura
    TempRay1.x=TempRay.x/320;
    TempRay1.z=TempRay.z/240;

    TempRay1.x=TempRay1.x - (SDWORD) (TempRay1.x);
    TempRay1.z=TempRay1.z - (SDWORD) (TempRay1.z);

    texu=fabs(TempRay1.x*320);
    texv=fabs(TempRay1.z*240);
    color=(*(DWORD *)(map + texu*4 + texv*320*4));
    
    //Ray intersects floor, let's see if it's shadowed
    //Calculating distance from plane point to lightsource
    TempRay1.x= sphere2.a - TempRay.x;
    TempRay1.y= sphere2.b - TempRay.y;
    TempRay1.z= sphere2.c - TempRay.z;

    //Normalize ray
    t= sqrt (TempRay1.x*TempRay1.x + TempRay1.y*TempRay1.y +
                TempRay1.z*TempRay1.z);
    TempRay1.x/=t;
    TempRay1.y/=t;
    TempRay1.z/=t;

    for (pSphere2=HeadSphere.pNext; (pSphere2!=&TailSphere);
         pSphere2=pSphere2->pNext) {
         
         t1=IntersectSphere0 (*pSphere2, TempRay, TempRay1);
         //if ( (t1>1) && (t>=t1)) {
         if ( (t1>1) ) {
         //ray from plane point to lightsource intersects current object
         //Calculating distance from plane point to current object
         //in order to be a shadow, must be smaller than distance from
         //plane point to lightsource
            TempRay2.x= TempRay.x - pSphere2->a;
            TempRay2.y= TempRay.y - pSphere2->b;
            TempRay2.z= TempRay.z - pSphere2->c;

            //Find the vector's modulo
            t1= sqrt (TempRay2.x*TempRay2.x + TempRay2.y*TempRay2.y +
                        TempRay2.z*TempRay2.z);

            if (t>t1) {
                //light is 'after'object: cast shadow
                intens=ambient*ShadowFactor;
                color=Blend_32(color, 0);
                goto pinta;

            }
         }
    }

    //Not shadowed, let's find light intensity
    TempRay2.x=plane1.A;
    TempRay2.y=plane1.B;
    TempRay2.z=plane1.C;

    //Find angle between normal and plane point->lightsource vector
    t=FindCos(TempRay2, TempRay1);
    if (t>0)
        intens=((t*t*t*t*t*t + t)*32 + ambient);
    else intens=ambient;
    }
    pinta:

    color=_32to16or15(intensify_32(color, (DWORD)(intens)+addintens));


    if (graphics_system.gfxmode==4)
        last_virtual_frame_buffer=virtual2;

    color=Blend_16or15 (color,*((WORD*)(last_virtual_frame_buffer+(X1)*2 + graphics_system.xresolution*Y1*2)));
    
    //pPixel_16 (virtual+X1*2 + graphics_system.xresolution*Y1*2, 
    //     color);
    
    pPixel_16 (sPtr+X1*2, color);
    
    *((WORD*)(sPtr+(X1-2)*2))=
    *((WORD*)(last_virtual_frame_buffer+(X1-2)*2-virtual+sPtr));

    pPixel_16 ( sPtr+(X1-1)*2, 
         Blend_16or15(color,*((WORD*)(last_virtual_frame_buffer+(X1-2)*2-virtual+sPtr))));
                
    pPixel_16 (sPtr+(X1-3)*2, 
         Blend_16or15(*((WORD*)(sPtr+(X1-4)*2)),*((WORD*)(last_virtual_frame_buffer+(X1-2)*2-virtual+sPtr))));
    
    /*
    *((WORD*)(virtual+(X1-2)*2 + graphics_system.xresolution*Y1*2))=
    *((WORD*)(last_virtual_frame_buffer+(X1-2)*2 + graphics_system.xresolution*Y1*2));

    pPixel_16 (virtual+(X1-1)*2 + graphics_system.xresolution*Y1*2, 
         Blend_15(color,*((WORD*)(last_virtual_frame_buffer+(X1-2)*2 + graphics_system.xresolution*Y1*2))));
                
    pPixel_16 (virtual+(X1-3)*2 + graphics_system.xresolution*Y1*2, 
         Blend_15(*((WORD*)(virtual+(X1-4)*2 + graphics_system.xresolution*Y1*2)),*((WORD*)(last_virtual_frame_buffer+(X1-2)*2 + graphics_system.xresolution*Y1*2))));
    */
    
}
}



//texture map NormalTable
//VertArray[0].x=160+(sphere1.a-sphere1.r)/(sphere1.c-sphere1.r)*SDist;
//VertArray[0].y=100-(sphere1.b+sphere1.r)/(sphere1.c-sphere1.r)*SDist;
/*
VertArray[1].x=160+(sphere1.a+sphere1.r)/(sphere1.c)*SDist;
VertArray[1].y=100-(sphere1.b+sphere1.r)/(sphere1.c)*x;
VertArray[2].x=160+(sphere1.a+sphere1.r)/(sphere1.c)*SDist;
VertArray[2].y=100-(sphere1.b-sphere1.r)/(sphere1.c)*SDist;
VertArray[3].x=160+(sphere1.a-sphere1.r)/(sphere1.c-sphere1.r)*SDist;
VertArray[3].y=100-(sphere1.b-sphere1.r)/(sphere1.c-sphere1.r)*SDist;
*/


/*
VertArray[0].x=272;
VertArray[0].y=26;
VertArray[1].x=292;
VertArray[1].y=30;
VertArray[2].x=292;
VertArray[2].y=56;
VertArray[3].x=272;
VertArray[3].y=53;
*/
                              

//pPixel_16 (virtual+VertArray[0].x*2 + graphics_system.xresolution*VertArray[0].y*2, 0x12345600);
        
/*
pPixel_16 (virtual2+VertArray[1].x*2 + graphics_system.xresolution*VertArray[1].y*2, 0x12345600,
        00);
pPixel_16 (virtual2+VertArray[2].x*2 + graphics_system.xresolution*VertArray[2].y*2, 0x12345600,
        00);
pPixel_16 (virtual2+VertArray[3].x*2 + graphics_system.xresolution*VertArray[3].y*2, 0x12345600,
        00);
*/

/*
//find topmost and lowest vertex
if (VertArray[0].y<VertArray[1].y) {
    ActVertR=ActVertL=0;
    NextVertR=1;
    NextVertL=3;
}
else {
    ActVertR=ActVertL=1;
    NextVertR=2;
    NextVertL=0;
}

if (VertArray[2].y<VertArray[3].y) BottomVert=3;
else BottomVert=2;

//Initialise to topmost vertex
ptrL=ptrR=
VertArray[ActVertL].x + graphics_system.xresolution*VertArray[ActVertL].y;

//find heights until height>0
for (heightL=(VertArray[NextVertL].y - VertArray[ActVertL].y);
    (heightL==0) && (ActVertL!=BottomVert);
    heightL=(VertArray[NextVertL].y - VertArray[ActVertL].y)) {
        ptrL+=((SDWORD)(VertArray[NextVertL].x) - 
              (SDWORD)(VertArray[ActVertL].x));
        if (NextVertL==0) {
        ActVertL=NextVertL;
        NextVertL=3;
        }
        else {
            ActVertL=NextVertL;
            NextVertL--;
        }
}
if (heightL==0) goto nopoly;         //Poly has zero height

//find heights until height>0
for (heightR=(VertArray[NextVertR].y - VertArray[ActVertR].y);
    (heightR==0) && (ActVertR!=BottomVert);
    heightR=(VertArray[NextVertR].y - VertArray[ActVertR].y)) {
        ptrR+=((SDWORD)(VertArray[NextVertR].x) - 
              (SDWORD)(VertArray[ActVertR].x));
        if (NextVertR==3) {
        ActVertR=NextVertR;
        NextVertR=0;
        }
        else {
            ActVertR=NextVertR;
            NextVertR++;
        }
}

if (heightR==0) goto nopoly;         //Poly has zero height

SlopeL= ((float)(VertArray[NextVertL].x) -(float)(VertArray[ActVertL].x))/
        (float)(heightL);

SlopeR= ((float)(VertArray[NextVertR].x) - (float)(VertArray[ActVertR].x))/
        (float)(heightR);

while (TRUE) {
pPixel_16 (virtual2+(DWORD)(ptrL)*2, 0xffffff00, 00);
pPixel_16 (virtual2+(DWORD)(ptrR)*2, 0xffffff00, 00);
ptrL+=SlopeL+320;
ptrR+=SlopeR+320;
heightR--;
heightL--;
if (heightR<=0) {
    //edge has finished, calculate new slope
    if (NextVertR==BottomVert) break;   //poly has finished

    //update ActVertR and NextVertR and find new slope
    //find heights until height>0
    for (;(heightR==0) && (ActVertR!=BottomVert);) {
            if (NextVertR==3) {
            ActVertL=NextVertL;
            NextVertL=0;
            }
            else {
                ActVertR=NextVertR;
                NextVertR++;
            }
            heightR=(VertArray[NextVertR].y - VertArray[ActVertR].y);
            if (heightR==0)
                    ptrR+=((SDWORD)(VertArray[NextVertR].x) - 
                          (SDWORD)(VertArray[ActVertR].x));
    }
    if (heightR==0) goto nopoly;         //Poly has zero height left
    SlopeR= ((float)(VertArray[NextVertR].x) - (float)(VertArray[ActVertR].x))/
            (float)(heightR);
}

if (heightL==0) {
    //edge has finished, calculate new slope
    if (NextVertL==BottomVert) break;   //poly has finished

    //update ActVertL and NextVertL and find new slope
    //find heights until height>0
    for (;(heightL==0) && (ActVertL!=BottomVert);) {
            if (NextVertL==0) {
            ActVertL=NextVertL;
            NextVertL=3;
            }
            else {
                ActVertL=NextVertL;
                NextVertL--;
            }
            heightL=(VertArray[NextVertL].y - VertArray[ActVertL].y);
            if (heightL==0)
                ptrL+=((SDWORD)(VertArray[NextVertL].x) - 
                      (SDWORD)(VertArray[ActVertL].x));

    }
    if (heightL==0) goto nopoly;         //Poly has zero height left
    SlopeL= ((float)(VertArray[NextVertL].x) - (float)(VertArray[ActVertL].x))/
            (float)(heightL);
}

}

nopoly:
*/

// Draw all spheres from back to front

for (pSphere=TailSphere.pPrev; pSphere!=&HeadSphere; pSphere=pSphere->pPrev) {

    if ((sphere2.c>=pSphere->c) && (sphere2.c<pSphere->pNext->c) && (sphere2.c>0))
    
    Draw_Main_Flare (virtual,
                    mainligt,
                    graphics_system.centerx+(sphere2.a-75)/sphere2.c*graphics_system.xratio,
                    graphics_system.centery-(sphere2.b+78)/sphere2.c*graphics_system.yratio,
                    150,
                    156,
                    graphics_system.centerx+(sphere2.a+75)/sphere2.c*graphics_system.xratio-
                    (graphics_system.centerx+(sphere2.a-75)/sphere2.c*graphics_system.xratio),
                    graphics_system.centery-(sphere2.b-78)/sphere2.c*graphics_system.yratio-
                    (graphics_system.centery-(sphere2.b+78)/sphere2.c*graphics_system.yratio));

    Y1=pSphere->bv.ymin;

    if (FrameType==1) {
            if (Y1&1==1) {
                //impar
                Xstart=1;
                
            }
            else {
                //par
                Xstart=0;
            }
    }
    else    {
            if (Y1&1==1) {
                //impar
                Xstart=0;
            }
            else {
                //par
                Xstart=1;
            }
    }

    pSphere->bv.xmin&=0xfffffffc;

    for (Y1=pSphere->bv.ymin; Y1<=pSphere->bv.ymax; Y1++, Xstart=!Xstart) {

        for (X1=pSphere->bv.xmin+(Xstart<<1); X1<=pSphere->bv.xmax; X1+=cell, color=0, intens=0) {
        
        //X1=(DWORD) (Xc);
        //Y1=(DWORD) (Yc);

        TempRay = RayTable [Y1*graphics_system.xresolution+X1];

        //t=IntersectSphere (*pSphere, TempRay);
        IntersectSphereAsm (pSphere, &TempRay, &t, SrootTable);
        if (t>1) {
            // Ray intersects object
            last_hit_sphere=TRUE;
            TempRay1.x = TempRay.x * t;
            TempRay1.y = TempRay.y * t;
            TempRay1.z = TempRay.z * t;

            //Calculating Point->LightSource vector
            TempRay2.x = sphere2.a - TempRay1.x;
            TempRay2.y = sphere2.b - TempRay1.y;
            TempRay2.z = sphere2.c - TempRay1.z;

            //Normalize vector
            t= sqrt (TempRay2.x*TempRay2.x + TempRay2.y*TempRay2.y +
                        TempRay2.z*TempRay2.z);
            TempRay2.x/=t;
            TempRay2.y/=t;
            TempRay2.z/=t;

            //Let's see if it's a shadow
            if (sphere2.c < pSphere->c) {
            //Light is before actual sphere - otherwise we don't cast shadow
            //not very reallistic, but who cares :-)
                for (pSphere2=pSphere->pPrev; (pSphere2!=&HeadSphere) && (pSphere2->c >= sphere2.c) ;
                    pSphere2=pSphere2->pPrev) {
                     if (IntersectSphere0 (*pSphere2, TempRay1, TempRay2)>1) {
                        intens=ambient*ShadowFactor;
                        color=pSphere->col;
                        goto reflection;
                     }
                }
            }

            //It's not a shadowed point
            TempRay3= NormalSphere (*pSphere,
                                    TempRay1.x, TempRay1.y, TempRay1.z);
            t=-FindCos(TempRay3, TempRay2);
            if (t<0)
                intens=FindIllum (t, *pSphere, sphere2);
            else intens=ambient;
            color=pSphere->col;
            

reflection:
            //Let's deal with reflections

            TempRay2=NormalSphere (*pSphere, TempRay1.x, TempRay1.y, TempRay1.z);
            t=FindCos(TempRay, TempRay2);

            TempRay2.x=-2*TempRay2.x*t - TempRay.x;
            TempRay2.y=-2*TempRay2.y*t - TempRay.y;
            TempRay2.z=-2*TempRay2.z*t - TempRay.z;

            t= sqrt(TempRay2.x*TempRay2.x + TempRay2.y*TempRay2.y +
                        TempRay2.z*TempRay2.z);

            TempRay2.x/=t;
            TempRay2.y/=t;
            TempRay2.z/=t;

            for (pSphere2=pSphere->pPrev; pSphere2!=&HeadSphere;
                 pSphere2=pSphere2->pPrev) {

                t=IntersectSphere0 (*pSphere2, TempRay1, TempRay2);
                if (t>1) {
                    //Reflection ray intersects sphere.  Let's see if it's a
                    //shadowed point.
                    TempRay1.x = TempRay2.x * t + TempRay1.x;
                    TempRay1.y = TempRay2.y * t + TempRay1.y;
                    TempRay1.z = TempRay2.z * t + TempRay1.z;

                    TempRay3.x = sphere2.a - TempRay1.x;
                    TempRay3.y = sphere2.b - TempRay1.y;
                    TempRay3.z = sphere2.c - TempRay1.z;

                    //Normalize ray
                    t= sqrt (TempRay3.x*TempRay3.x + TempRay3.y*TempRay3.y +
                                TempRay3.z*TempRay3.z);
                    TempRay3.x/=t;
                    TempRay3.y/=t;
                    TempRay3.z/=t;
                    
                    if (sphere2.c > pSphere2->c) {
                    //Light is after actual sphere - otherwise we don't cast shadow
                    //not very reallistic, but who cares :-)

                        for (pSphere3=pSphere2->pNext; (pSphere3!=&TailSphere) && (pSphere3->c <= sphere2.c) ;
                            pSphere3=pSphere3->pNext) {
                            if (IntersectSphere0 (*pSphere3, TempRay1, TempRay3)>1) {
                                intens+=(pSphere3->kr*ShadowFactor + ambient);
                                intens/=2;
                                goto DoubleReflect;
                            }
                        }
                    }
                    
                    //It's not a shadowed point, let's find intensity.
                    TempRay4= NormalSphere (*pSphere2,
                                            TempRay1.x, TempRay1.y, TempRay1.z);

                    t=-FindCos(TempRay3, TempRay4);
                    if (t<0) {
                            intens+=0.8*FindIllum (t, *pSphere, sphere2);
                            intens/=2;
                    }
                    else {
                        intens+=0.8*ambient;
                        intens/=2;
                    }
DoubleReflect:
                    //This bit draws the plane reflection onto the reflected
                    //sphere
                    TempRay3=NormalSphere (*pSphere2, TempRay1.x, TempRay1.y, TempRay1.z);

                    color=Blend_32(pSphere2->col,color);
                    
                    /*
                    // using normal for reflection! (ie wrong)
                    t=FindCos(TempRay3, TempRay2);

                    TempRay2.x=-2*TempRay3.x*t - TempRay2.x;
                    TempRay2.y=-2*TempRay3.y*t - TempRay2.y;
                    TempRay2.z=-2*TempRay3.z*t - TempRay2.z;

                    t= sqrt(TempRay2.x*TempRay2.x + TempRay2.y*TempRay2.y +
                                TempRay2.z*TempRay2.z);

                    TempRay2.x/=t;
                    TempRay2.y/=t;
                    TempRay2.z/=t;
                    */
                    
                    

                    t=IntersectPlane0 (plane1, TempRay1, TempRay3);
                    if (t>1) {
                        intens+=255/t*0.8*0.8;
                        intens/=2;
                        //color=
                        }
                }
            }

        //This draws the plane reflection onto the sphere
        t=IntersectPlane0 (plane1, TempRay1, TempRay2);
        if (t>1) {
            intens+=3000/t+ambient;
            intens/=2;

            //texture
            TempRay1.x=TempRay1.x + TempRay2.x*t;
            TempRay1.y=TempRay1.y + TempRay2.y*t;
            TempRay1.z=TempRay1.z + TempRay2.z*t;
            
            TempRay1.x=TempRay1.x/320;
            TempRay1.z=TempRay1.z/240;

            TempRay1.x=TempRay1.x - (SDWORD) (TempRay1.x);
            TempRay1.z=TempRay1.z - (SDWORD) (TempRay1.z);

            texu=fabs(TempRay1.x*320);
            texv=fabs(TempRay1.z*240);
            color=Blend_32((*(DWORD *)(map + texu*4 + texv*320*4)),color);
        }

    color=_32to16or15(intensify_32(color, (DWORD)(intens)+addintens));

    color=Blend_16or15 (color,*((WORD*)(last_virtual_frame_buffer+(X1)*2 + graphics_system.xresolution*Y1*2)));
    
    pPixel_16 (virtual+X1*2 + graphics_system.xresolution*Y1*2,
         color);


    *((WORD*)(virtual+(X1-2)*2 + graphics_system.xresolution*Y1*2))=
    *((WORD*)(last_virtual_frame_buffer+(X1-2)*2 + graphics_system.xresolution*Y1*2));
    
    pPixel_16 (virtual+(X1-1)*2 + graphics_system.xresolution*Y1*2, 
         Blend_16or15(color,*((WORD*)(last_virtual_frame_buffer+(X1-2)*2 + graphics_system.xresolution*Y1*2))));
                
    pPixel_16 (virtual+(X1-3)*2 + graphics_system.xresolution*Y1*2, 
         Blend_16or15(*((WORD*)(virtual+(X1-4)*2 + graphics_system.xresolution*Y1*2)),*((WORD*)(last_virtual_frame_buffer+(X1-2)*2 + graphics_system.xresolution*Y1*2))));
    
    }
    
    else  {
        if (last_hit_sphere==TRUE) {
            pPixel_16 (virtual+(X1-3)*2 + graphics_system.xresolution*Y1*2, 
                     Blend_16or15(*((WORD*)(virtual+(X1-4)*2 + graphics_system.xresolution*Y1*2)),*((WORD*)(last_virtual_frame_buffer+(X1-2)*2 + graphics_system.xresolution*Y1*2))));
                     
                *((WORD*)(virtual+(X1-2)*2 + graphics_system.xresolution*Y1*2))=
                *((WORD*)(last_virtual_frame_buffer+(X1-2)*2 + graphics_system.xresolution*Y1*2));
                last_hit_sphere=FALSE;
        
        }

    last_hit_sphere=FALSE;
    }
    
}
}
}
    if ((sphere2.c<HeadSphere.pNext->c) && (sphere2.c>0))
    Draw_Main_Flare (virtual,
                    mainligt,
                    graphics_system.centerx+(sphere2.a-75)/sphere2.c*graphics_system.xratio,
                    graphics_system.centery-(sphere2.b+78)/sphere2.c*graphics_system.yratio,
                    150,
                    156,
                    graphics_system.centerx+(sphere2.a+75)/sphere2.c*graphics_system.xratio-
                    (graphics_system.centerx+(sphere2.a-75)/sphere2.c*graphics_system.xratio),
                    graphics_system.centery-(sphere2.b-78)/sphere2.c*graphics_system.yratio-
                    (graphics_system.centery-(sphere2.b+78)/sphere2.c*graphics_system.yratio));


    //is lightsource visible?
    if (sphere2.c>0) {
    TempRay.x=sphere2.a;
    TempRay.y=sphere2.b;
    TempRay.z=sphere2.c;

    t=sqrt(TempRay.x*TempRay.x+TempRay.y*TempRay.y+TempRay.z*TempRay.z);

    TempRay.x/=t;
    TempRay.y/=t;
    TempRay.z/=t;

    for (pSphere=HeadSphere.pNext; pSphere!=&TailSphere; pSphere=pSphere->pNext) {
        IntersectSphereAsm (pSphere, &TempRay, &t, SrootTable);
        if ((t>1) && (sphere2.c>pSphere->c)) goto no_lens_flare;
    }
    

    draw_lens_flares();

}

else {
no_lens_flare:
addintens=0;
}


//for (mi=0; mi<graphics_system.xresolution*graphics_system.yresolution*2; mi++) 
//    virtual[mi]=virtual2[mi];

//Smooth();
//memmove (virtual, virtual2, graphics_system.xresolution*graphics_system.yresolution*2);




    // Esto se hace una vez por loop para mostrar los fps arriba a la izquierda
        temp_frame=frames_dr;
        temp_time=lib_get_time();
        if (temp_time-last_time>0.25) {
            fps=(float)(temp_frame-last_frame)/(temp_time-last_time);
            last_time=temp_time;
            last_frame=temp_frame;
        }

        if(K_F && icg_boss) {
            sprintf(fps_info,"Fps: %4.3f",fps);
            lib_write_string(fps_info,0,0,255*256,virtual);
        }



//memset (virtual, 0, graphics_system.xresolution*2*(graphics_system.yresolution-0));
//pPixel_16 (virtual+VertArray[0].x*2 + graphics_system.xresolution*VertArray[0].y*2, 0x12345600);        

//virtual = lib_flush_vga();

/*if (graphics_system.gfxmode==4)
    memmove (virtual2, virtual, graphics_system.bytes_scanline*
                                graphics_system.yresolution);

//clean new frame 95
memset (virtual, 0, graphics_system.xresolution*2*(graphics_system.yresolution));

FrameType=!FrameType;   */

};

void    init_ray (DWORD xres, DWORD yres) {

    Xstart=0;

    HeadSphere.a=1;
    HeadSphere.b=2;
    HeadSphere.c=-9000;
    HeadSphere.r=4;
    HeadSphere.ka=1;
    HeadSphere.kd=1;
    HeadSphere.ks=1;
    HeadSphere.kr=0.8;
    HeadSphere.pPrev=NULL;
    HeadSphere.pNext=&sphere1;

    sphere1.a=-1;
    sphere1.b=39;
    sphere1.c=270;
    sphere1.r=35;
    sphere1.ka=1;
    sphere1.kd=1;
    sphere1.ks=1;
    sphere1.kr=0.8;
    sphere1.col=0x10001500;
    sphere1.pPrev=&HeadSphere;
    sphere1.pNext=&sphere3;

    sphere2.a=0;
    sphere2.b=20;
    sphere2.c=300;
    sphere2.r=50;
    sphere2.ip=2;
    sphere2.pPrev=NULL;
    sphere2.pNext=NULL;

    sphere3.a=80;
    sphere3.b=39;
    sphere3.c=500;
    sphere3.r=29;
    sphere3.ka=1;
    sphere3.kd=1;
    sphere3.ks=1;
    sphere3.kr=0.8;
    sphere3.col=0x20200000;
    sphere3.pPrev=&sphere1;
    sphere3.pNext=&sphere4;

    sphere4.a=-80;
    sphere4.b=39;
    sphere4.c=370;
    sphere4.r=23;
    sphere4.ka=1;
    sphere4.kd=1;
    sphere4.ks=1;
    sphere4.kr=0.8;
    sphere4.col=0x23001000;
    sphere4.pPrev=&sphere3;
    sphere4.pNext=&TailSphere;

    sphere5.a=-80;
    sphere5.b=39;
    sphere5.c=400;
    sphere5.r=39;
    sphere5.ka=1;
    sphere5.kd=1;
    sphere5.ks=1;
    sphere5.kr=0.8;
    sphere5.col=0x03050600;
    sphere5.pPrev=&sphere4;
    sphere5.pNext=&TailSphere;

    TailSphere.a=80;
    TailSphere.b=-90;
    TailSphere.c=5000;
    TailSphere.r=39;
    TailSphere.ka=1;
    TailSphere.kd=1;
    TailSphere.ks=1;
    TailSphere.kr=0.8;
    TailSphere.pPrev=&sphere4;
    TailSphere.pNext=NULL;

    plane1.A=0;
    plane1.B=1;
    plane1.C=0;
    plane1.D=50;


//Trying modes

    emulate_32=FALSE;

    lib_log(2,"set_mode 16");
    virtual=lib_set_mode(xres, yres, 16, GINFO);
    if (virtual==NULL) {
        lib_log(2,"set_mode 15");
        virtual=lib_set_mode(xres, yres, 15, GINFO);
        if (virtual==NULL) {
         fatal_error("Your card doesn't seem to support %d*%d HiColor modes.\nGo load UniVBE, man :).",xres,yres);
        }
        else {
        mode_avail_x=xres;
        mode_avail_y=yres;
        mode_avail_depth=15;
        }
    }
    else {
        mode_avail_x=xres;
        mode_avail_y=yres;
        mode_avail_depth=16;
    }

    lib_log(2,"set_mode - GINFO - emulate32");
    emulate_32=TRUE;
    virtual=lib_set_mode(mode_avail_x, mode_avail_y, mode_avail_depth, GINFO);
    if(virtual==NULL) fatal_error("Emulate 32 - lib_set_mode");

    map= (BYTE *) malloc (  320*240*4+
                            15*14*2+
                            29*28*2+
                            150*156*2+
                            18*17*2+
                            35*33*2+
                            11*11*2+
                            14*14*2+
                            61*61*2+
                            51*51*2+
                            8192*sizeof(float)+                    //SrootTable
                            graphics_system.xresolution*
                            graphics_system.yresolution*sizeof(ray)+            //RayTable
                            sizeof(path)+                          //plightpath
                            sizeof(path)+                         //psphere1path
                            sizeof(path)+                         //psphere3path
                            sizeof(path)                         //psphere4path
                        );

    if (map==NULL)
        fatal_error("Not enough memory");


    far1=map+320*240*4;
    far3= far1+15*14*2;
    mainligt= far3+29*28*2;
    near1= mainligt+150*156*2;
    near2= near1+18*17*2;
    near3= near2+35*33*2;
    near4= near3+11*11*2;
    near5= near4+14*14*2;
    near6= near5+61*61*2;

    lib_log(2,"CalculateRoots()");
    SrootTable= (float*) (near6+51*51*2);
    CalculateRoots();

//Read texture
    lib_log(2,"read_tga_picture('newdone.tga')");
    if(read_tga_picture ("newdone.tga", (map), 320, 240))
        fatal_error("Loading newdone.tga");


    lib_log(2,"set_mode - GINFO - noemulate32");
    emulate_32=FALSE;
    lib_set_mode(mode_avail_x, mode_avail_y, mode_avail_depth, GINFO);

//    if (graphics_system.gfxmode==4) {
        //Banks
        virtual2=malloc(graphics_system.image_size);
        if (virtual2==NULL) {
          fatal_error ("You're in banks mode, this requires more mem than you have");
        }
    memset (virtual2, 0, graphics_system.image_size);
//    }

    if  (graphics_system.bbp==15) {
            add_16or15=__add_15;
            _32to16or15=__32to15;
            Blend_16or15=__Blend_15;
    }

    if  (graphics_system.bbp==16) {
            add_16or15=__add_16;
            _32to16or15=__32to16;
            Blend_16or15=__Blend_16;
    }



//Read flares

    lib_log(2,"read_tga_picture('far1.tga')");
    if(read_tga_picture ("far1.tga", (far1), 15, 14))
        fatal_error("Loading far1.tga");
    lib_log(2,"read_tga_picture('far3.tga')");
    if(read_tga_picture ("far3.tga", (far3), 29, 28))
        fatal_error("Loading far3.tga");
    lib_log(2,"read_tga_picture('mainligt.tga')");
    if(read_tga_picture ("mainligt.tga", (mainligt), 150,156))
        fatal_error("Loading mainlight.tga");
    lib_log(2,"read_tga_picture('near1.tga')");
    if(read_tga_picture ("near1.tga", (near1), 18, 17))
        fatal_error("Loading near1.tga");
    lib_log(2,"read_tga_picture('near2.tga')");
    if(read_tga_picture ("near2.tga", (near2), 35, 33))
        fatal_error("Loading near2.tga");
    lib_log(2,"read_tga_picture('near3.tga')");
    if(read_tga_picture ("near3.tga", (near3), 11, 11))
        fatal_error("Loading near3.tga");
    lib_log(2,"read_tga_picture('near4.tga')");
    if(read_tga_picture ("near4.tga", (near4), 14, 14))
        fatal_error("Loading near4.tga");
    lib_log(2,"read_tga_picture('near5.tga')");
    if(read_tga_picture ("near5.tga", (near5), 61, 61))
        fatal_error("Loading near5.tga");
    lib_log(2,"read_tga_picture('near6.tga')");
    if(read_tga_picture ("near6.tga", (near6), 51, 51))
        fatal_error("Loading near6.tga");

//Initialise array and calculate ray table
    RayTable=(VECTOR3D *) ((BYTE *)(SrootTable)+8192*sizeof(float));

    lib_log(2,"CalculateRays()");
    CalculateRays();


    lib_log(2,"CalculateNormals()");
/*
//Calculate Normals
NormalTable=(vector *) malloc (256*256*sizeof(vector));
PointTable=(vector *) malloc (256*256*sizeof(vector));
CalculateNormals();
*/

    lib_log(2,"LoadPath('light.pth')");
plightpath=(path*)((DWORD)(RayTable)+graphics_system.xresolution*graphics_system.yresolution*sizeof(ray));
LoadPath(plightpath, "light.pth");

    lib_log(2,"LoadPath('sphere1.pth')");
psphere1path=(path*)((DWORD)(plightpath)+sizeof(path));
LoadPath(psphere1path, "sphere1.pth");

    lib_log(2,"LoadPath('sphere3.pth')");
psphere3path=(path*)((DWORD)(psphere1path)+sizeof(path));
LoadPath(psphere3path, "sphere3.pth");

    lib_log(2,"LoadPath('sphere4.pth')");
psphere4path=(path*)((DWORD)(psphere3path)+sizeof(path));
LoadPath(psphere4path, "sphere4.pth");

    lib_log(2,"lib_set_mode() - GBANKS start");
    virtual=lib_set_mode(mode_avail_x, mode_avail_y, mode_avail_depth, GBANKS);
    if(virtual==NULL) fatal_error("lib_set_mode(GBANKS)");
    lib_log(2,"lib_set_mode() - GBANKS end");
    lib_log(2,"Freq: %d",frequency);

    last_time=lib_get_time();       // Inicializacin de variables. Una
    frames_dr=0;                    //  vez al principio del programa
    last_frame=0;

   }

void LoadPath (path *ppath, BYTE *name) {

    BYTE *buffer;
    DWORD fs;

    if((buffer=lib_fopen(name))==NULL)
        fatal_error("Can't load path");

    fs=lib_filesize(name);

    if(fs>sizeof(path)) fs=sizeof(path);

    memcpy(ppath,buffer,fs);

    free(buffer);

}

void    draw_lens_flares (void) {

    FlareVector.x=sphere2.a/sphere2.c*graphics_system.xratio;
    FlareVector.y=sphere2.b/sphere2.c*graphics_system.yratio;

    if (fabs(FlareVector.x) + fabs(FlareVector.y)<50)
    addintens=50-((fabs(FlareVector.x) + fabs(FlareVector.y)));
    else addintens=0;

    FlareOrigin.x=graphics_system.centerx+FlareVector.x;
    FlareOrigin.y=graphics_system.centery-FlareVector.y;

    
    FlarePos.x=FlareVector.x*0.1 + FlareOrigin.x;
    FlarePos.y=FlareVector.y*(-0.1) + FlareOrigin.y;
    
    ClipBitmap_16 (virtual,
                    far1,
                    FlarePos.x-7,
                    FlarePos.y-7,
                    15,
                    14);
    

    FlarePos.x=FlareVector.x*0.15 + FlareOrigin.x;
    FlarePos.y=FlareVector.y*(-0.15) + FlareOrigin.y;

    
    ClipBitmap_16 (virtual,
                    far1,
                    FlarePos.x-7,
                    FlarePos.y-7,
                    15,
                    14);
    

    FlarePos.x=FlareVector.x*0.75 + FlareOrigin.x;
    FlarePos.y=FlareVector.y*(-0.75) + FlareOrigin.y;

    ClipBitmap_16 (virtual,
                    far3,
                    FlarePos.x-14,
                    FlarePos.y-14,
                    29,
                    28);

    FlarePos.x=FlareVector.x*0.8 + FlareOrigin.x;
    FlarePos.y=FlareVector.y*(-0.8) + FlareOrigin.y;

    ClipBitmap_16 (virtual,
                    far3,
                    FlarePos.x-14,
                    FlarePos.y-14,
                    29,
                    28);

    FlarePos.x=FlareVector.x*(-0.7) + FlareOrigin.x;
    FlarePos.y=FlareVector.y*0.7 + FlareOrigin.y;

    ClipBitmap_16 (virtual,
                    near1,
                    FlarePos.x-9,
                    FlarePos.y-9,
                    18,
                    17);

    FlarePos.x=FlareVector.x*(-0.9) + FlareOrigin.x;
    FlarePos.y=FlareVector.y*0.9 + FlareOrigin.y;

    ClipBitmap_16 (virtual,
                    near2,
                    FlarePos.x-17,
                    FlarePos.y-16,
                    35,
                    33);

    FlarePos.x=FlareVector.x*(-1.5) + FlareOrigin.x;
    FlarePos.y=FlareVector.y*1.5 + FlareOrigin.y;

    ClipBitmap_16 (virtual,
                    near3,
                    FlarePos.x-5,
                    FlarePos.y-5,
                    11,
                    11);

    FlarePos.x=FlareVector.x*(-1.6) + FlareOrigin.x;
    FlarePos.y=FlareVector.y*1.6 + FlareOrigin.y;

    ClipBitmap_16 (virtual,
                    near4,
                    FlarePos.x-7,
                    FlarePos.y-7,
                    14,
                    14);

    FlarePos.x=FlareVector.x*(-1.9) + FlareOrigin.x;
    FlarePos.y=FlareVector.y*1.9 + FlareOrigin.y;

    ClipBitmap_16 (virtual,
                    near5,
                    FlarePos.x-30,
                    FlarePos.y-30,
                    61,
                    61);

    FlarePos.x=FlareVector.x*(-2.0) + FlareOrigin.x;
    FlarePos.y=FlareVector.y*2.0 + FlareOrigin.y;

    ClipBitmap_16 (virtual,
                    near6,
                    FlarePos.x-25,
                    FlarePos.y-25,
                    51,
                    51);

}


void CalculateNormals (void) {
sphere      s;
ray         TempRay;
float       modulo;
DWORD       x,y;
SDWORD      x2,y2;
float       t;

s.a=0;
s.b=0;
s.c=285;
s.r=128;

for (y=0; y<=199; y++)
    for (x=0; x<=255; x++) {
    x2=x-128;
    y2=128-y;

    TempRay.x=x2;
    TempRay.y=y2;
    TempRay.z=graphics_system.xratio;
    modulo= sqrt (TempRay.x*TempRay.x + TempRay.y*TempRay.y + TempRay.z*TempRay.z);

    TempRay.x/=modulo;
    TempRay.y/=modulo;
    TempRay.z/=modulo;
    
    if (t=IntersectSphere(s, TempRay)>1) {
        TempRay.x*=t;
        TempRay.y*=t;
        TempRay.z*=t;
        NormalTable[x+y*256]=
            NormalSphere (s, TempRay.x, TempRay.y, TempRay.z);
        PointTable[x+y*256]=TempRay;
    //pPixel_16 (virtual+x*2 + graphics_system.xresolution*y*2, 0x19000000,
    //        100);
    }

    else { 
        NormalTable[x+y*256].x=0;
        NormalTable[x+y*256].y=0;
        NormalTable[x+y*256].z=0;
        PointTable[x+y*256].x=0;
        PointTable[x+y*256].y=0;
        PointTable[x+y*256].z=0;

        //pPixel_16(virtual+x*2+y*320*2,0x12345600,0);
    }

    }
}

void CalculateRoots (void) {
DWORD   i;

for (i=0; i<8192; i++) SrootTable[i]=sqrt(i);
}

void CalculateRays (void)
{
    int         X1, Y1;
    float       modulo;

    for (Y1=(int) (-(graphics_system.yresolution>>1)+1); Y1<=(int) (graphics_system.yresolution>>1); Y1+=1)
        for (X1=(int) (-(graphics_system.xresolution>>1)+1); X1<=(int) (graphics_system.xresolution>>1); X1+=1) {

        modulo= sqrt (X1*X1 + Y1*Y1 + graphics_system.xratio*graphics_system.xratio);

        RayTable [((graphics_system.yresolution>>1)-Y1)*graphics_system.xresolution + X1+(graphics_system.xresolution>>1)-1].x = X1/modulo;
        RayTable [((graphics_system.yresolution>>1)-Y1)*graphics_system.xresolution + X1+(graphics_system.xresolution>>1)-1].y = Y1/modulo;
        RayTable [((graphics_system.yresolution>>1)-Y1)*graphics_system.xresolution + X1+(graphics_system.xresolution>>1)-1].z = graphics_system.xratio/modulo;
    }

}

void    CalculateSlab (sphere *ps) {
    ps->bv.xmax = (SDWORD) ( graphics_system.centerx+(ps->a+ps->r)/ps->c*graphics_system.xratio );
    ps->bv.xmin = (SDWORD) ( graphics_system.centerx+(ps->a-ps->r)/ps->c*graphics_system.xratio );
    ps->bv.ymin = (SDWORD) ( graphics_system.centery-(ps->b+ps->r)/ps->c*graphics_system.yratio  );
    ps->bv.ymax = (SDWORD) ( graphics_system.centery-(ps->b-ps->r)/ps->c*graphics_system.yratio );

}

// Draws and clips a bitmap on the screen.  x,y are the CENTER of the
// bitmap, and may be negative.
void    Draw_Main_Flare (BYTE * virtual, BYTE * bitmap, SDWORD xs, SDWORD ys, DWORD w, DWORD h, DWORD ws, DWORD hs) {

    DWORD   xbstart, ybstart, xbend, ybend;
    DWORD   j=0;
    DWORD   i=0;
    float   is=0;
    float   js=0;

    WORD    temp2;

    float   xquo=(float)(w)/(float)(ws);
    float   yquo=(float)(h)/(float)(hs);

    if (xs+(SDWORD)(ws)<0) return ;
    if (xs>((SDWORD)(graphics_system.xresolution-1))) return ;
    if (ys+(SDWORD)(hs)<0) return ;
    if (ys>((SDWORD)(graphics_system.yresolution-1))) return ;


xbend=ws;
xbstart=0;


    //  se sale por arriba y por abajo
    if ((xs<0) && (xs+ws>((SDWORD)(graphics_system.xresolution-1)))) {        
        xbstart=(-xs)*xquo;
        xs=0;
        xbend=((SDWORD)(graphics_system.xresolution-1))-xs;       
    }

    // se sale slo por arriba
    else if ((xs<0) && (xs+ws<=((SDWORD)(graphics_system.xresolution-1)))) {
        xbstart=(-xs)*xquo;
        xbend=ws+xs;
        xs=0;
    }

    // se sale slo por abajo
    else if ((xs>0) && (xs+ws>((SDWORD)(graphics_system.xresolution-1)))) {
        xbend=ws-(xs+ws-(((SDWORD)(graphics_system.xresolution-1))));
    }


ybend=hs;
ybstart=0;


    //  se sale por arriba y por abajo
    if ((ys<0) && (ys+hs>((SDWORD)(graphics_system.yresolution-1)))) {
        
        ybstart=(0-ys)*yquo;
        ybend=ys+h-(((SDWORD)(graphics_system.yresolution-1)));        
        ys=0;
        //ybend=(((SDWORD)(graphics_system.yresolution-1)));        
        
    }

    // se sale slo por arriba
    else if ((ys<0) && (ys+hs<=((SDWORD)(graphics_system.yresolution-1)))) {
        ybstart=(0-ys)*yquo;
        ybend=hs-(0-ys);
        ys=0;
    }

    // se sale slo por abajo
    else if ((ys>=0) && (ys+hs>((SDWORD)(graphics_system.yresolution-1)))) {
        ybend=hs-(ys+hs-(((SDWORD)(graphics_system.yresolution-1))));
    }

    if ( (xs>=0) && (ys>=0) && (xs+xbend<((SDWORD)(graphics_system.xresolution))) && (ys+ybend<=((SDWORD)(graphics_system.yresolution))) ) {
        for (j=0; j<ybend; j++, js+=yquo) {
            
            for (i=is=0; i<xbend; i++, is+=xquo) {
                temp2=*((WORD *)(bitmap+((DWORD)(js)+ybstart)*w*2+((DWORD)(is)+xbstart)*2));
                if (temp2>000) {
                    if (*((WORD *)(virtual+(xs+i)*2 + graphics_system.xresolution*(ys+j)*2))!=0)
                        *((WORD *)(virtual+(xs+i)*2 + graphics_system.xresolution*(ys+j)*2))=
                        add_16or15(temp2, (*((WORD *)(virtual+(xs+i)*2 + graphics_system.xresolution*(ys+j)*2))
                        ));
                    else
                        *((WORD *)(virtual+(xs+i)*2 + graphics_system.xresolution*(ys+j)*2))=
                        temp2;
                
                }
                
            }
        }
    }
    /*
    else {
        cell++;
        temp2=cell-4;
    }
    */
                
    
}


void    ClipBitmap_16 (BYTE * virtual, BYTE * bitmap, SDWORD xs, SDWORD ys, DWORD w, DWORD h ) {

    DWORD   xbstart, ybstart, xbend, ybend;
    DWORD   j=0;
    DWORD   i=0;

    WORD    temp2;

    if (xs+(SDWORD)(w)<0) return ;
    if (xs>((SDWORD)(graphics_system.xresolution-1))) return ;
    if (ys+(SDWORD)(h)<0) return ;
    if (ys>((SDWORD)(graphics_system.yresolution-1))) return ;

    xbend=w;
    xbstart=0;

    //  se sale por arriba y por abajo
    if ((xs<0) && (xs+w>((SDWORD)(graphics_system.xresolution-1)))) {
        
        xbstart=-xs;
        xs=0;
        xbend=((SDWORD)(graphics_system.xresolution-1))-xs;
    }

    // se sale slo por arriba
    else if ((xs<0) && (xs+w<=((SDWORD)(graphics_system.xresolution-1)))) {
        xbstart=(-xs);
        xbend=w+xs;
        xs=0;
    }

    // se sale slo por abajo
    else if ((xs>0) && (xs+w>((SDWORD)(graphics_system.xresolution-1)))) {
        xbend=w-(xs+w-(((SDWORD)(graphics_system.xresolution-1))));
    }

    ybend=h;
    ybstart=0;

    //  se sale por arriba y por abajo
    if ((ys<0) && (ys+h>((SDWORD)(graphics_system.yresolution-1)))) {
        
        ybstart=-ys;
        ys=0;
        ybend=(((SDWORD)(graphics_system.yresolution-1))-ys);
    }

    // se sale slo por arriba
    else if ((ys<0) && (ys+h<=((SDWORD)(graphics_system.yresolution-1)))) {
        ybstart=-ys;
        ybend=h+ys;
        ys=0;
    }

    // se sale slo por abajo
    else if ((ys>=0) && (ys+h>((SDWORD)(graphics_system.yresolution-1)))) {
        ybend=h-(ys+h-(((SDWORD)(graphics_system.yresolution-1))));
    }
    
    if ( (xs>=0) && (ys>=0) && (xs+xbend<((SDWORD)(graphics_system.xresolution))) && (ys+ybend<((SDWORD)(graphics_system.yresolution))) ) {
        for (j=0; j<ybend; j++) {
            
            for (i=0; i<xbend; i++) {
                temp2=*((WORD *)(bitmap+((DWORD)(j)+ybstart)*w*2+((DWORD)(i)+xbstart)*2)) & 0x0f7de;
                if (temp2>000) {
                //temp=(temp2 + 
                //     (*((WORD *)(virtual+(xs+i)*2 + graphics_system.xresolution*(ys+j)*2))
                //        & 0x0f7de))>>1;
                *((WORD *)(virtual+(xs+i)*2 + graphics_system.xresolution*(ys+j)*2))=
                add_16or15(temp2, (*((WORD *)(virtual+(xs+i)*2 + graphics_system.xresolution*(ys+j)*2))
                ));
                }
                
            }
        }
    }
                
    
}

                                                       

// for normalized rays starting at 0,0,0 only!
float IntersectSphere (sphere s, VECTOR3D r)
{
float       B1, C1, t1, a, b;

    //A1=1, as the rays are normalized
    B1= -2 * ( r.x*s.a + r.y*s.b + r.z*s.c );
    C1= s.a*s.a + s.b*s.b + s.c*s.c - s.r*s.r;
    a=B1*B1;
    b=4*C1;

    /*
    if ( (X1>(int)((s.a+s.r)/s.c*SDist+165)) || (X1<(int)((s.a-s.r)/s.c*SDist+155)) ||
         (Y1<(int)(95-(s.b+s.r)/s.c*SDist)) || (Y1>(int)(105-(s.b-s.r)/s.c*SDist)) )
         return (-1);
    */

    /*
    if ( (X1>s.bv.xmax) || (X1<s.bv.xmin) ||
        (Y1>s.bv.ymax) || (Y1<s.bv.ymin) ) 
            return (-1);
    */
    
    if (a >= b) {
        t1=(-B1 - sqrt (a - b)) / 2;
        if (t1>0) return t1;
        else return (-B1 + sqrt (a - b)) / 2;
    }
    return (-1);
};

// for normalized rays starting at 0,0,0 only!
float IntersectPlane (plane p, VECTOR3D r)
{
    float       temp;

    temp=p.A*r.x + p.B*r.y + p.C*r.z;
    if (temp!=0)
            return (-p.D/temp);
    else return (-1);

};

float IntersectPlane0 (plane p, VECTOR3D r0, VECTOR3D r1)
{
    float       temp;

    temp=p.A*r1.x + p.B*r1.y + p.C*r1.z;
    if (temp!=0)
            return -((p.A*r0.x + p.B*r0.y + p.C*r0.z + p.D)/temp);
    else return (-1);

};


//ray r must be normalized, startes at x0
float IntersectSphere0 (sphere s, VECTOR3D x0, VECTOR3D r)
{
float B1, C1, t1, a, b;

//A=1, as the rays are normalized

    B1= 2 * ( r.x*(x0.x-s.a) + r.y*(x0.y-s.b) + r.z*(x0.z-s.c) );
    C1= (x0.x-s.a)*(x0.x-s.a) + (x0.y-s.b)*(x0.y-s.b) + (x0.z-s.c)*(x0.z-s.c) 
        - s.r*s.r;
    a=B1*B1;
    b=4*C1;

    if (a >= b) {
        t1=(-B1 - sqrt (a - b)) / 2;
        if (t1>0) return t1;
        else return (-B1 + sqrt (a - b)) / 2;
    }
    return (-1);
};


float IntersectLight0 (light s, VECTOR3D x0, VECTOR3D r)
{
float B1, C1, t1, a, b;

//A=1, as the rays are normalized

    B1= 2 * ( r.x*(x0.x-s.a) + r.y*(x0.y-s.b) + r.z*(x0.z-s.c) );
    C1= (x0.x-s.a)*(x0.x-s.a) + (x0.y-s.b)*(x0.y-s.b) + (x0.z-s.c)*(x0.z-s.c) 
        - s.r*s.r;
    a=B1*B1;
    b=4*C1;

    if (a >= b) {
        t1=(-B1 - sqrt (a - b)) / 2;
        if (t1>0) return t1;
        else return (-B1 + sqrt (a - b)) / 2;
    }
    return (-1);
};


VECTOR3D         NormalSphere (sphere s, float x, float y, float z)
{
VECTOR3D         r;

            r.x = (x-s.a)/s.r;
            r.y = (y-s.b)/s.r;
            r.z = (z-s.c)/s.r;

            return (r);
}

VECTOR3D         NormalLight (light s, float x, float y, float z)
{
VECTOR3D         r;

            r.x = (x-s.a)/s.r;
            r.y = (y-s.b)/s.r;
            r.z = (z-s.c)/s.r;

            return (r);
}



// Modulo r1 = Modulo r2 = 1 !!!
float       FindCos (VECTOR3D r1, VECTOR3D r2)
{
    return (r1.x*r2.x + r1.y*r2.y + r1.z*r2.z);

}


float FindIllum (float a, sphere s, light l)
{
    float       temp;

    temp = (a*a*a*a*a*a*s.ks*l.ip - a*s.kd)*255/4 + ambient*s.ka*l.ip;
    
    //if (temp>255) return (255);
    //if (temp<0) return (0);
    return (temp);
}

void        SortScene (void)
{
    sphere      *pSphere, *pSphere2, *pTemp;

    for (pSphere=HeadSphere.pNext; pSphere!=&TailSphere;) {
        pTemp=pSphere->pNext;

        while (pSphere->c < pSphere->pPrev->c) {
            pSphere2=pSphere->pPrev;
            pSphere2->pNext=pSphere->pNext;
            pSphere->pNext->pPrev=pSphere2;
            pSphere2->pPrev->pNext=pSphere;
            pSphere->pPrev=pSphere2->pPrev;
            pSphere->pNext=pSphere2;
            pSphere2->pPrev=pSphere;
        }
        pSphere=pTemp;
            
        
    }
}


void        Smooth (void)
{

int         Yc;
BYTE       *FilTemp;
BYTE       *FilIndex;

if (FrameType==1)
    Xstart=0;
else Xstart=2;

for (Yc=30; Yc<=graphics_system.yresolution-cell-10; Yc+=1, Xstart=!Xstart) {
    
FilTemp= (BYTE*) (Xstart*2*2 + graphics_system.xresolution*Yc*2);

for (FilIndex=FilTemp; FilIndex<FilTemp+graphics_system.xresolution*2; 
    FilIndex+=8) {

            *((WORD *)(FilIndex+(int)(virtual)))=
                ((*((WORD *)((int)(virtual)+FilIndex))&0xf7de) + (*((WORD *)((int)(last_virtual_frame_buffer)+FilIndex))&0xf7de))>>1;
            
            *((WORD *)(FilIndex+4+(int)(virtual)))=
                (*((WORD *)((int)(last_virtual_frame_buffer)+4+FilIndex)));

            *((WORD *)(FilIndex+2+(int)(virtual)))=
                ((*((WORD *)((int)(virtual)+FilIndex))&0xf7de) + (*((WORD *)((int)(last_virtual_frame_buffer)+FilIndex+4))&0xf7de))>>1;

            *((WORD *)(FilIndex-2+(int)(virtual)))=
                ((*((WORD *)((int)(virtual)+FilIndex))&0xf7de) + (*((WORD *)((int)(last_virtual_frame_buffer)+FilIndex-4))&0xf7de))>>1;

}            

}
}
