;------------------------------------------------------------------------------
;                  Relleno de tringulos en ALAMBRICO
;                           nt/*INCOGNITA*
;------------------------------------------------------------------------------

.386p

_DATA SEGMENT PAGE PUBLIC 'DATA'

EXTRN C virtual:dword
EXTRN C graphics_system:dword

XR equ [graphics_system]
YR equ [graphics_system+4]
YS equ [graphics_system+8]

color   dw ?

ALIGN 4

LVar    DD 0            ; Incremento cuando hay acarreo
        DD 0            ; Incremento obligatorio
AdjDown DD ?            ; Idem
        DD 0

LineJmpTbl LABEL WORD
LineDumpLabel MACRO p
        DD OFFSET LineLoop&p
ENDM
        DD LineLoop0
        I = 15
        REPT 15
         LineDumpLabel %I
         I = I - 1
        ENDM

_DATA ENDS

_TEXT SEGMENT PAGE PUBLIC 'CODE'
        assume cs:_text, ds:_data

PUBLIC DRAW_LINE_
PUBLIC DRAW_CLIP_LINE_

DRAW_LINE_ PROC

; (x1,y1) = (ECX,EAX) --- (x2,y2) --- (ESI,EBX) -- Color -- Dl

        pushad

        mov [color],dx
        jmp @@nclip

DRAW_LINE_ ENDP

DRAW_CLIP_LINE_ PROC

; (x1,y1) = (ECX,EAX) --- (x2,y2) --- (ESI,EBX) -- Color -- Dl

        pushad

        mov [color],dx                  ; Guardar color para luego

        call clip_line  ;!!!!!!!
        jc @@exit

@@nclip:cmp eax,ebx                     ; Pintar siempre de arriba a abajo
        jb @@up2down
        mov edx,ecx                     ; Intercambiar
        mov ecx,esi
        mov esi,edx

        mov edx,eax                     ; Intercambiar
        mov eax,ebx
        mov ebx,edx
@@up2down:

        sub ebx,eax                     ; DeltaY - Siempre positivo
        mov edi,eax
        imul edi,YS
        lea edi,[edi+2*ecx]
        add edi,[virtual]               ; Edi -> Memory(x1,y1)

        mov eax,2                       ; Por defecto, hacia la dcha
        sub esi,ecx                     ; DeltaX
        ja @@pos
        neg esi
        neg eax                         ; Hacia la izq

@@pos:  cmp esi,ebx                     ; DeltaX > DeltaY
        ja @@dx_mayor
        mov edx,esi
        mov esi,eax                     ; Menor inc
        mov eax,YS                      ; Mayor inc (siempre ocurre)
        jmp @@dy_mayor
@@dx_mayor:
        mov edx,ebx
        mov ebx,esi
        mov esi,YS                      ; Menor inc

@@dy_mayor:
        mov ecx,ebx                     ; Ecx -> DELTA MAYOR
        test ecx,ecx
        jz @@exit

@@no_izq:
        add esi,eax                     ; Avance total (dx+dy)
        mov [LVar],esi
        mov [LVar+4],eax                ; Avance que siempre ocurre

        neg ebx
        mov ebp,ebx
        add ebx,ebx
        mov [AdjDown],ebx               ; AdjDown = -2*Delta_Mayor
        add edx,edx                     ; Edx = 2*Delta_Menor
        inc ecx

        mov esi,ecx                     ; Calculamos cuantos inner_loop de
        add ecx,0fh                     ;  16 pixels cada uno son necesarios
        shr ecx,4

        and esi,01111b                  ; Resto de dividir entre 16
        shl esi,2
        add esi,OFFSET LineJmpTbl

        mov ax,[color]                  ; Preparar el color

        add ebp,edx                     ; Preparamos ebx para evitar AGI
        sbb ebx,ebx

        jmp dword ptr [esi]       ; A pintar!


LineDumpPixel MACRO p
LineLoop&p:
        mov [edi],ax
        add ebp,[AdjDown+4*ebx+4]
        add edi,[LVar+4*ebx+4]
        add ebp,edx
        sbb ebx,ebx                 ; -1  0
ENDM

        ALIGN 32

@@LineLoop:
        I = 0
        REPT 16
        LineDumpPixel %I
        I = I + 1
        ENDM
EndLineLoop:
        dec     ecx
        jnz     @@LineLoop
        jmp     @@exit


@@exit:
        popad

        ret

DRAW_CLIP_LINE_ ENDP


;       Algorimo Cohen-Sutherland para recorte de lneas en la pantalla
;       Y0=0    Y1=HEIGHT       -       X0=0    X1=WIDTH

;    1001 | 1000 | 1010
;    ------------------
;    0001 | 0000 | 0010
;    ------------------
;    0101 | 0100 | 0110

CLIP_LINE PROC

@@clipping:
        xor edx,edx             ; Borrar estado

        ; PUNTO 1

        test ecx,ecx
        jns @@P1I
        or dl,01b
@@P1I:  cmp ecx,XR
        jl @@P1D
        or dl,10b
@@P1D:  test eax,eax
        jns @@P1A
        or dl,1000b
@@P1A:  cmp eax,YR
        jl @@P1B
        or dl,100b
@@P1B:

        ; PUNTO 2

        test esi,esi
        jns @@P2I
        or dh,1b
@@P2I:  cmp esi,XR
        jl @@P2D
        or dh,10b
@@P2D:  test ebx,ebx
        jns @@P2A
        or dh,1000b
@@P2A:  cmp ebx,YR
        jl @@P2B
        or dh,100b
@@P2B:

        test edx,edx
        jz @@dentro             ; Dos ptos dentro

        test dh,dl
        jnz @@fuera             ; Los dos ptos fuera en un mismo lado

        or dl,dh                ; P1+P2

        cmp eax,ebx             ; Ordenar de arriba a abajo
        jle @@vsort
        mov edi,ecx             ; Intercambiar
        mov ecx,esi
        mov esi,edi

        mov edi,eax             ; Intercambiar
        mov eax,ebx
        mov ebx,edi

@@vsort:test dl,1000b           ; Clipping Y=0
        jz @@Y0

        ; Y1 = 0
        ; X1 = x2 + y2*((x1-x2)/(y2-y1))

        push ebx

        mov ebp,ebx
        sub ebx,eax             ; y2-y1
        sub ecx,esi             ; x1-x2
        mov eax,ecx             ; eax = x1-x2
        imul ebp                ; eax = y2*(x1-x2)
        idiv ebx                ; eax = y2*(x1-x2)/(y2-y1)
        add eax,esi             ; eax = x2+ y2*(x1-x2)/(y2-y1)
        mov ecx,eax
        xor eax,eax

        pop ebx
        jmp @@clipping

@@Y0:   test dl,0100b           ; Clipping Y=HEIGHT
        jz @@YUP

        ; X2 = X1+(X2-X1)*Y1/(Y1-Y2)
        ; Y2 = HEIGHT

        push eax

        sub eax,YR
        sub ebx,YR
        dec eax
        dec ebx

        mov ebp,eax
        sub ebx,eax             ; y2-y1
        neg ebx                 ; y1-y2
        sub esi,ecx             ; x2-x1
        mov eax,esi             ; Eax = x2-x1
        imul ebp                ; Eax = y1*(x2-x1)
        idiv ebx                ; Eax= y1*(x2-x1)/(y1-y2)
        add eax,ecx
        mov esi,eax
        mov ebx,YR
        dec ebx

        pop eax

        jmp @@clipping

@@YUP:  cmp ecx,esi             ; Ordenar de izquierda a derecha
        jle @@hsort

        mov edi,ecx             ; Intercambiar
        mov ecx,esi
        mov esi,edi

        mov edi,eax             ; Intercambiar
        mov eax,ebx
        mov ebx,edi

@@hsort:test dl,1b              ; Clipping X=0
        jz @@XLF

        ; Y1 = Y2+(Y1-Y2)*X2/(X2-X1)
        ; X1 = 0

        push esi

        mov ebp,esi
        sub esi,ecx             ; x2-x1
        sub eax,ebx             ; y1-y2
        imul ebp                ; Eax = x2*(y1-y2)
        idiv esi                ; Eax = x2*(y1-y2)/(x2-x1)
        add eax,ebx             ; Eax = y2+x2*(y1-y2)/(x2-x1)
        xor ecx,ecx

        pop esi

        jmp @@clipping

@@XLF:  test dl,10b             ; Clipping X=WIDTH
        jz @@dentro

        ; Y2 = Y1+(Y2-Y1)*X1/(X1-X2)
        ; X2 = WIDTH

        push ecx
        push eax

        sub ecx,XR
        sub esi,XR
        dec ecx
        dec esi

        mov edi,eax
        mov ebp,ecx
        sub ecx,esi             ; x1-x2
        sub ebx,eax             ; y2-y1
        mov eax,ebx             ; Eax = y2-y1
        imul ebp                ; Eax= x1*(y2-y1)
        idiv ecx                ; Eax= x1*(y2-y1)/(x1-x2)
        add eax,edi             ; Eax= y1+x1*(y2-y1)/(x1-x2)
        mov ebx,eax
        mov esi,XR
        dec esi

        pop eax
        pop ecx

        jmp @@clipping

@@dentro:

        clc
        ret


@@fuera:
        stc
        ret

CLIP_LINE ENDP


_TEXT ENDS

	END
