/*
Code: Thomas Austad
Info: 3x3 matrix class
*/

#include <math.h>
#include "matrix3.h"

/*
   ============
   constructors
   ============
*/

Matrix3T::Matrix3T(void)
{
   for(int r=0; r<3; r++)
      for(int c=0; c<3; c++)
         if(r==c)
            Elms[r][c] = 1.;
         else
            Elms[r][c] = 0.;
}

Matrix3T::Matrix3T(const Matrix3T& m)
{
   for(int r=0; r<3; r++)
      Elms[r] = m.Elms[r];
}

Matrix3T::Matrix3T(VecMat_t* nElms)
{
   for(int r=0; r<3; r++)
      for(int c=0;  c<3; c++)
         Elms[r][c] = nElms[r*3+c];
}

/*
   ===============================
   overloaded assignment operators
   ===============================
*/

void Matrix3T::operator = (const Matrix3T& m)
{
   for(int r=0; r<3; r++)
      Elms[r] = m.Elms[r];
}

void Matrix3T::operator = (VecMat_t* nElms)
{
   for(int r=0; r<3; r++)
      for(int c=0; c<3; c++)
         Elms[r][c] = nElms[r*3+c];
}


void Matrix3T::operator += (const Matrix3T& m)
{
   for(int r=0; r<3; r++)
      Elms[r] += m.Elms[r];
}

void Matrix3T::operator -= (const Matrix3T& m)
{
   for(int r=0; r<3; r++)
      Elms[r] -= m.Elms[r];
}

void Matrix3T::operator *= (Matrix3T& m)
{
   Vector3T Tmp[3];
   
   for(int r=0; r<3; r++)
      for(int c=0; c<3; c++)
         Tmp[r][c] =  Elms[r][0]*m.Elms[0][c] +
                      Elms[r][1]*m.Elms[1][c] +
                      Elms[r][2]*m.Elms[2][c];
   for(int r=0; r<3; r++)
      Elms[r] = Tmp[r];
}

void Matrix3T::operator *= (VecMat_t k)
{
   for(int r=0; r<3; r++)
      Elms[r] *= k;
}

/*
   ===================================================
   overloaded operators which returns a new 3x3 matrix
   ===================================================
*/

#ifdef __GNUG__
Matrix3T Matrix3T::operator + (const Matrix3T& m) return r;
#else
Matrix3T Matrix3T::operator + (const Matrix3T& m)
#endif
{
#ifndef __GNUG__
   Matrix3T r;
#endif
   for(int i=0; i<3; i++)
      r.Elms[i] = Elms[i] + m.Elms[i];
   return r;
}


#ifdef __GNUG__
Matrix3T Matrix3T::operator - (const Matrix3T& m) return r;
#else
Matrix3T Matrix3T::operator - (const Matrix3T& m)
#endif
{
#ifndef __GNUG__
   Matrix3T r;
#endif
   for(int i=0; i<3; i++)
      r.Elms[i] = Elms[i] - m.Elms[i];
   return r;
}


#ifdef __GNUG__
Matrix3T Matrix3T::operator * (Matrix3T& m) return r;
#else
Matrix3T Matrix3T::operator * (Matrix3T& m)
#endif
{
#ifndef __GNUG__
   Matrix3T r;
#endif
   for(int i=0; i<3; i++)
      for(int j=0; j<3; j++)
         r.Elms[i][j] = Elms[i][0]*m.Elms[0][j] +
                        Elms[i][1]*m.Elms[1][j] +
                        Elms[i][2]*m.Elms[2][j];
   return r;
}


#ifdef __GNUG__
Matrix3T Matrix3T::operator * (VecMat_t k) return r;
#else
Matrix3T Matrix3T::operator * (VecMat_t k)
#endif
{
#ifndef __GNUG__
   Matrix3T r;
#endif
   for(int i=0; i<3; i++)
      r.Elms[i] = Elms[i] * k;
   return r;
}
