/*
Code: Thomas Austad
Info: 4x4 matrix class
*/

#include "matrix4.h"

/*
   ============
   constructors
   ============
*/
Matrix4T::Matrix4T(void)
{
   for(int r=0; r<4; r++)
      for(int c=0; c<4; c++)
         if(r==c)
            Elms[r][c] = 1.;
         else
            Elms[r][c] = 0.;
}

Matrix4T::Matrix4T(const Matrix4T& m)
{
   for(int r=0; r<4; r++)
      Elms[r] = m.Elms[r];
}

Matrix4T::Matrix4T(VecMat_t* nElms)
{
   for(int r=0; r<4; r++)
      for(int c=0; c<4; c++)
         Elms[r][c] = nElms[r*4+c];
}

/*
   ===============================
   overloaded assignment operators
   ===============================
*/

void Matrix4T::operator = (const Matrix4T& m)
{
   for(int r=0; r<4; r++)
      Elms[r] = m.Elms[r];
}

void Matrix4T::operator = (VecMat_t* nElms)
{
   for(int r=0; r<4; r++)
      for(int c=0; c<4; c++)
         Elms[r][c] = nElms[r*4+c];
}

void Matrix4T::operator += (const Matrix4T& m)
{
   for(int r=0; r<4; r++)
      Elms[r] += m.Elms[r];
}

void Matrix4T::operator -= (const Matrix4T& m)
{
   for(int r=0; r<4; r++)
      Elms[r] -= m.Elms[r];
}

void Matrix4T::operator *= (Matrix4T& m)
{
   Vector4T Tmp[4];
   for(int r=0; r<4; r++)
      for(int c=0; c<4; c++)
         Tmp[r][c] = Elms[r][0]*m.Elms[0][c] +
                     Elms[r][1]*m.Elms[1][c] +
                     Elms[r][2]*m.Elms[2][c] +
                     Elms[r][3]*m.Elms[3][c];
   for(int r=0; r<4; r++)
      Elms[r] = Tmp[r];
}

void Matrix4T::operator *= (VecMat_t k)
{
   for(int r=0; r<4; r++)
      Elms[r] *= k;
}

/*
   ===================================================
   overloaded operators which returns a new 4x4 matrix
   ===================================================
*/

#ifdef __GNUG__
Matrix4T Matrix4T::operator + (const Matrix4T& m) return r;
#else
Matrix4T Matrix4T::operator + (const Matrix4T& m)
#endif
{
#ifndef __GNUG__
   Matrix4T r;
#endif
   for(int i=0; i<4; i++)
      r.Elms[i] = Elms[i] + m.Elms[i];
   return r;
}


#ifdef __GNUG__
Matrix4T Matrix4T::operator - (const Matrix4T& m) return r;
#else
Matrix4T Matrix4T::operator - (const Matrix4T& m)
#endif
{
#ifndef __GNUG__
   Matrix4T r;
#endif
   for(int i=0; i<4; i++)
      r.Elms[i] = Elms[i] - m.Elms[i];
   return r;
}


#ifdef __GNUG__
Matrix4T Matrix4T::operator * (Matrix4T& m) return r;
#else
Matrix4T Matrix4T::operator * (Matrix4T& m)
#endif
{
#ifndef __GNUG__
   Matrix4T r;
#endif
   for(int i=0; i<4; i++)
      for(int j=0; j<4; j++)
         r.Elms[i][j] = Elms[i][0]*m.Elms[0][j] +
                        Elms[i][1]*m.Elms[1][j] +
                        Elms[i][2]*m.Elms[2][j] +
                        Elms[i][3]*m.Elms[3][j];         
   return r;
}


#ifdef __GNUG__
Matrix4T Matrix4T::operator * (VecMat_t k) return r;
#else
Matrix4T Matrix4T::operator * (VecMat_t k)
#endif
{
#ifndef __GNUG__
   Matrix4T r;
#endif
   for(int i=0; i<4; i++)
      r.Elms[i] = Elms[i] * k;
   return r;
}

