/*
Code: Thomas Austad
Info: 2d vector class
*/

#include <math.h>
#include "vector2.h"

/*
   ============
   constructors
   ============   
*/

Vector2T::Vector2T(void)
{
   Vec[0] = Vec[1] = 0;
}

Vector2T::Vector2T(const Vector2T& v)
{
   Vec[0] = v.Vec[0];	
   Vec[1] = v.Vec[1];
}

Vector2T::Vector2T(VecMat_t x,VecMat_t y)
{
   Vec[0] = x;
   Vec[1] = y;
}

/*
   ==============================
   overloaded assignmet operators
   ==============================
*/

void Vector2T::operator = (const Vector2T& v)
{
   Vec[0] = v.Vec[0];
   Vec[1] = v.Vec[1];
}

void Vector2T::operator += (const Vector2T& v)
{
   Vec[0] += v.Vec[0];
   Vec[1] += v.Vec[1];
}

void Vector2T::operator -= (const Vector2T& v)
{
   Vec[0] -= v.Vec[0];
   Vec[1] -= v.Vec[1];
}

void Vector2T::operator *= (const Vector2T& v)
{
   Vec[0] *= v.Vec[0];
   Vec[1] *= v.Vec[1];
}

void Vector2T::operator *= (VecMat_t k)
{
   Vec[0] *= k;
   Vec[1] *= k;
}

/*
   ===============================================
   overloaded operators which returns a new vector
   ===============================================

If your wondering about:
   Vector2T Vector2T::operator + (const Vector2T& v) return r;
It is perfectly legal in GNU c/c++.
The constructor is called before we enter the '+' operator.
For more info on this read the info manual for gcc(DJGPP or Linux).
*/
#ifdef __GNUG__
Vector2T Vector2T::operator + (const Vector2T& v) return r;
#else
Vector2T Vector2T::operator + (const Vector2T& v)
#endif
{
#ifndef __GNUG__
   Vector2T r;
#endif
   r.Vec[0] = Vec[0] + v.Vec[0];
   r.Vec[1] = Vec[1] + v.Vec[1];
   return r;
}


#ifdef __GNUG__
Vector2T Vector2T::operator - (const Vector2T& v) return r;
#else
Vector2T Vector2T::operator - (const Vector2T& v)
#endif
{
#ifndef __GNUG__
   Vector2T r;
#endif
   r.Vec[0] = Vec[0] - v.Vec[0];
   r.Vec[1] = Vec[1] - v.Vec[1];   
   return r;
}


#ifdef __GNUG__
Vector2T Vector2T::operator * (const Vector2T& v) return r;
#else
Vector2T Vector2T::operator * (const Vector2T& v)
#endif
{
#ifndef __GNUG__
   Vector2T r;
#endif
   r.Vec[0] = Vec[0] * v.Vec[0];
   r.Vec[1] = Vec[1] * v.Vec[1];   
   return r;
}


#ifdef __GNUG__
Vector2T Vector2T::operator * (VecMat_t k) return r;
#else
Vector2T Vector2T::operator * (VecMat_t k)
#endif
{
#ifndef __GNUG__
   Vector2T r;
#endif
   r.Vec[0] = Vec[0] * k;
   r.Vec[1] = Vec[1] * k;
   return r;
}


/*
   =========
   operators
   =========   
*/
VecMat_t Vector2T::Length(void)
{
#define SQR(a)  ((a)*(a))
   return sqrt(SQR(Vec[0])+SQR(Vec[1]));
#undef SQR
}

VecMat_t Vector2T::Distance(const Vector2T& v)
{
#define SQR(a)  ((a)*(a))
   return sqrt(SQR(v.Vec[0]-Vec[0])+SQR(v.Vec[1]-Vec[1]));
#undef SQR
}

VecMat_t Vector2T::Dot(const Vector2T& v)
{
   return (Vec[0]*v.Vec[0]+Vec[1]*v.Vec[1]);
}

void Vector2T::Unit(void)
{
   VecMat_t l=Length();
   if(l!=0.||l!=1.) {
      Vec[0] /= l;
      Vec[1] /= l;
   }
}

