/*
Code: Thomas Austad
Info: 4d vector class (homogenous 3d vector)
*/

#include <math.h>
#include "vector4.h"

/*
   ============
   constructors
   ============
*/
Vector4T::Vector4T(void)
{
}

Vector4T::Vector4T(const Vector4T& v)
{
   Vec[0] = v.Vec[0];
   Vec[1] = v.Vec[1];
   Vec[2] = v.Vec[2];
   Vec[3] = v.Vec[3];
}


Vector4T::Vector4T(VecMat_t x,VecMat_t y,VecMat_t z,VecMat_t w)
{
   Vec[0] = x;
   Vec[1] = y;
   Vec[2] = z;
   Vec[3] = w;
}

/*
   ===============================
   overloaded assignment operators
   ===============================
*/

void Vector4T::operator = (const Vector4T& v)
{
   Vec[0] = v.Vec[0];
   Vec[1] = v.Vec[1];
   Vec[2] = v.Vec[2];
   Vec[3] = v.Vec[3];
}

void Vector4T::operator += (const Vector4T& v)
{
   Vec[0] += v.Vec[0];
   Vec[1] += v.Vec[1];
   Vec[2] += v.Vec[2];
   Vec[3] += v.Vec[3];
}

void Vector4T::operator -= (const Vector4T& v)
{
   Vec[0] -= v.Vec[0];
   Vec[1] -= v.Vec[1];
   Vec[2] -= v.Vec[2];
   Vec[3] -= v.Vec[3];
}

void Vector4T::operator *= (const Vector4T& v)
{
   Vec[0] *= v.Vec[0];
   Vec[1] *= v.Vec[1];
   Vec[2] *= v.Vec[2];
   Vec[3] *= v.Vec[3];
}

void Vector4T::operator *= (VecMat_t k)
{
   Vec[0] *= k;
   Vec[1] *= k;
   Vec[2] *= k;
   Vec[3] *= k;
}

/*
   ===============================================
   overloaded operators which returns a new vector
   ===============================================
*/

#ifdef __GNUG__
Vector4T Vector4T::operator + (const Vector4T& v) return r;
#else
Vector4T Vector4T::operator + (const Vector4T& v)
#endif
{
#ifndef __GNUG__
   Vector4T r;
#endif
   r.Vec[0] = Vec[0] + v.Vec[0];
   r.Vec[1] = Vec[1] + v.Vec[1];
   r.Vec[2] = Vec[2] + v.Vec[2];
   r.Vec[3] = Vec[3] + v.Vec[3];
   return r;
}


#ifdef __GNUG__
Vector4T Vector4T::operator - (const Vector4T& v) return r;
#else
Vector4T Vector4T::operator - (const Vector4T& v)
#endif
{
#ifndef __GNUG__
   Vector4T r;
#endif
   r.Vec[0] = Vec[0] - v.Vec[0];
   r.Vec[1] = Vec[1] - v.Vec[1];
   r.Vec[2] = Vec[2] - v.Vec[2];
   r.Vec[3] = Vec[3] - v.Vec[3];
   return r;
}


#ifdef __GNUG__
Vector4T Vector4T::operator * (const Vector4T& v) return r;
#else
Vector4T Vector4T::operator * (const Vector4T& v)
#endif
{
#ifndef __GNUG__
   Vector4T r;
#endif
   r.Vec[0] = Vec[0] * v.Vec[0];
   r.Vec[1] = Vec[1] * v.Vec[1];
   r.Vec[2] = Vec[2] * v.Vec[2];
   r.Vec[3] = Vec[3] * v.Vec[3];
   return r;
}


#ifdef __GNUG__
Vector4T Vector4T::operator * (VecMat_t k) return r;
#else
Vector4T Vector4T::operator * (VecMat_t k)
#endif
{
#ifndef __GNUG__
   Vector4T r;
#endif
   r.Vec[0] = Vec[0] * k;
   r.Vec[1] = Vec[1] * k;
   r.Vec[2] = Vec[2] * k;
   r.Vec[3] = Vec[3] * k;
   return r;
}

/*
   ================
   public operators
   ================
*/

VecMat_t Vector4T::Length(void)
{
#define SQR(a)  ((a)*(a))
   return sqrt(SQR(Vec[0])+SQR(Vec[1])+SQR(Vec[2])+SQR(Vec[3]));
#undef SQR
}

VecMat_t Vector4T::Distance(const Vector4T& v)
{
#define SQR(a) ((a)*(a))
   return sqrt(SQR(v.Vec[0]-Vec[0])+SQR(v.Vec[1]-Vec[1])+SQR(v.Vec[2]-Vec[2])+SQR(v.Vec[3]-Vec[3]));
#undef SQR
}

VecMat_t Vector4T::Dot(const Vector4T& v)
{
   return (Vec[0]*v.Vec[0]+Vec[1]*v.Vec[1]+Vec[2]*v.Vec[2]+Vec[3]*v.Vec[3]);
}

VecMat_t Vector4T::CrossZ(const Vector4T& v)
{
   return (Vec[0]*v.Vec[1]-Vec[1]*v.Vec[0]);
}

#ifdef __GNUG__
Vector4T Vector4T::Cross(const Vector4T& v) return r;
#else
Vector4T Vector4T::Cross(const Vector4T& v)
#endif
{
#ifndef __GNUG__
   Vector4T r;
#endif
   r.Vec[0] = Vec[1]*v.Vec[2] - Vec[2]*v.Vec[1];
   r.Vec[1] = Vec[2]*v.Vec[3] - Vec[3]*v.Vec[2];
   r.Vec[2] = Vec[3]*v.Vec[0] - Vec[0]*v.Vec[3];
   r.Vec[3] = Vec[0]*v.Vec[1] - Vec[1]*v.Vec[0];
   return r;
}

void Vector4T::Unit(void)
{
   VecMat_t l = Length();
   if(l!=0.||l!=1.) {
      Vec[0] /= l;
      Vec[1] /= l;
      Vec[2] /= l;
      Vec[3] /= l;
   }
}
