;;
;;  Protected Mode version of WRITE1.LIB
;;

FPU_DECKIIR_DWORD::
; DD-hez:
;FILD DPT [SI] ;SZAM1
FBSTP SZAM_BCD ;EZ TKONVERTLTA BCD-RE (18 SZMJEGY)
IF BPT SZAM_BCD[9] THENCMD WRITE'-'
AL:=BPT SZAM_BCD[4]
!HEXBYTE
EAX:=DPT SZAM_BCD    ;KIIRS 10 SZMJEGGYEL!
!HEXDWORD
{VAR SZAM_BCD DT ?}
RET

FPU_DECKIIR_QWORD::
; DQ-hoz:
;FILD QPT [SI] ;SZAM2
FBSTP SZAM_BCD ;EZ TKONVERTLTA BCD-RE (18 SZMJEGY)
IF BPT SZAM_BCD[9] THENCMD WRITE'-'
AL:=BPT SZAM_BCD[8]
!HEXBYTE
EAX:=DPT SZAM_BCD[4]
!HEXDWORD
EAX:=DPT SZAM_BCD   ;KIIRS 18 SZMJEGGYEL!
!HEXDWORD
{VAR SZAM_BCD DT ?}
RET


DECKIIR::
  ; AX-ET IRJA KI  1..5 SZMJEGGYEL (AMENNYI KELL)
  ; BE: AX=SZAM
  MOV     CX,10
^DECKIIR:
.DEFPROC ^DECKIIR
  XOR     DX
  DIV     CX
  OR      AX//JZ ^DKI_CIM
  PUSH(DX) CALL ^DECKIIR ;!!
^DKI_CIM:
  ADD DL,'0'
  WRITECHR DL
RET

DECKIIR_EDI::
  ; AX-ET IRJA KI [ES:DI]-RE 1..5 SZMJEGGYEL (AMENNYI KELL)
  ; BE: AX=SZAM
  MOV     CX,10
^DECKIIR:
.DEFPROC ^DECKIIR
  XOR     DX
  DIV     CX
  OR      AX//JZ ^DKI_CIM
  PUSH(DX) CALL ^DECKIIR ;!!
^DKI_CIM:
  AX<>DX//AL+='0'//STOSB
RET

DECKIIR32::
  ; EAX-ET IRJA KI  1..10 SZMJEGGYEL (AMENNYI KELL)
  ; BE: EAX=SZAM
  MOV     ECX,10
^_DECKIIR:
.DEFPROC ^_DECKIIR
  XOR     EDX
  DIV     ECX
  OR      EAX//JZ ^DKI_CIM
  PUSH(DX) CALL ^_DECKIIR ;!!
^DKI_CIM:
  ADD DL,'0'
  WRITECHR DL
RET


GETHEX::
;BE:  ESI=OFS szam      PL.: SZAM DB '123C',0
;KI:  ESI=SZAM UTAN, AX=SZAM
XOR AX,AX
MOV CX,4 ;MAX JEGY
^UJSZAMJEGY:
MOV BL,[ESI]
IF BL=0 THEN ^SZAMVEGE
CMP BL,'0'//JC ^NEMSZAM
CMP BL,'9'+1//JC ^DESZAM
CMP BL,'A'//JC ^NEMSZAM
CMP BL,'F'+1//JNC ^NEMNAGY
  SUB BL,'A'-10
  JMP ^DEBETU
^NEMNAGY:
CMP BL,'a'//JC ^NEMSZAM
CMP BL,'f'+1//JNC ^NEMSZAM
  SUB BL,'a'-'0'-10
^DESZAM:
  SUB BL,'0'
^DEBETU:
INC ESI
SHL AX,4
ADD AL,BL
ADC AH,0
LOOP ^UJSZAMJEGY
^SZAMVEGE:
CLC//RET
^NEMSZAM:
STC//RET


GETHEX2::
;BE:  ESI=OFS szam      PL.: SZAM DB '123C',0
;KI:  ESI=SZAM UTAN, EAX=SZAM
XOR EAX
MOV CX,8 ;MAX JEGY
^UJSZAMJEGY:
MOV BL,[ESI]
CMP BL,'0'
JC ^NEMSZAM
CMP BL,'9'+1
JC ^DESZAM
CMP BL,'A'
JC ^NEMSZAM
CMP BL,'F'+1
JNC ^NEMNAGY
  SUB BL,'A'-10
  JMP ^DEBETU
^NEMNAGY:
CMP BL,'a'
JC ^NEMSZAM
CMP BL,'f'+1
JNC ^NEMSZAM
  SUB BL,'a'-'0'-10
^DESZAM:
  SUB BL,'0'
^DEBETU:
++ESI
SHL EAX,4
AL+=BL
LOOP ^UJSZAMJEGY
^NEMSZAM:
RET


GETNUM::
; BE:  ESI=OFS SZAM,  ECX=SZAM HOSSZA
; KI:  BX=SZM  (ELJELES)
ESI+=ECX
--ESI
MOV DI,OFS ^TIZ+8
CMP CX,6
JC ^OK_NSIZE
  MOV CX,5
^OK_NSIZE:
XOR BX,BX

^ERTEK_CKL:
  MOV AL,[ESI]
  DEC ESI
  SUB AL,'0'
  JC ^ILL_NUM
  CMP AL,10
  JNC ^ILL_NUM
XOR AH,AH
MUL WPT [DI]
ADD BX,AX
  ^ILL_NUM:
SUB DI,2
LOOP ^ERTEK_CKL
CMP BYTE PTR [ESI],'-'
JNZ ^POZITIV
  NEG BX
^POZITIV:
; BX=SZAM
RET
^TIZ DW 10000,1000,100,10,1


GETNUM2S::
; BE: ESI=OFS SZAM
; KI: EBX=SZAM  (ELJELES)
CMP BPT [ESI],'-'
JNZ GETNUM2
++ESI
CALL GETNUM2
NEG EBX
RET


GETNUM2::
; BE: ESI=OFS SZAM
; KI: EBX=SZAM  (NEM ELJELES!)
XOR EBX
@: LODSB
SUB AL,'0'//JC ^VEGE
IF AL>=10 THEN ^VEGE
MOVZX EAX,AL
SHL EBX,1//EAX+=EBX
SHL EBX,2//EBX+=EAX   ;EBX=10*EBX+EAX
=>@
^VEGE:
RET    ;EBX=SZAM


HEXDWORD::
  ROR EAX,16
    CALL HEXWORD
  ROR EAX,16
HEXWORD::
  PUSH AX
  MOV AL,AH
    CALL HEXBYTE
  POP AX
HEXBYTE::
  MOV DL,AL
  SHR DL,4
    CALL HEXJEGY
  MOV DL,AL
  AND DL,15
HEXJEGY::
PUSH AX
 CMP DL,10
 JC ^HEX_OKDL
  ADD DL,7
^HEX_OKDL:
 ADD DL,'0'
 WRITECHR DL
POP AX
RET



DECKIIR5_ESEDI::
; ECX KIIRASA [ES:EDI]-RE, AH SZINNEL,  1..10 SZMJEGGYEL (ELTTE SPC-K)
XOR BL,BL ; DECJEL
MOV EDX,1000000000
CALL ^DECCIKL1
MOV EDX,100000000
CALL ^DECCIKL1
MOV EDX,10000000
CALL ^DECCIKL1
MOV EDX,1000000
CALL ^DECCIKL1
MOV EDX,100000
CALL ^DECCIKL1
MOV EDX,10000
CALL ^DECCIKL1
MOV DX,1000
CALL ^DECCIKL1
MOV DX,100
CALL ^DECCIKL1
MOV DL,10
CALL ^DECCIKL1
MOV AL,CL
ADD AL,'0'    ;
STOSW         ;
RET           ;<= DECJEL MIATT IS FONTOS! (LEGALBB 1 NULLA KELL!)

^DECCIKL1::
XOR AL,AL
CMP ECX,EDX
JNC ^DECCIKL12
OR BL,BL
JNZ ^DEC4JEGY
MOV AL,' '
STOSW
RET

^DECCIKL11:
CMP ECX,EDX
JC ^DEC4JEGY
^DECCIKL12:
SUB ECX,EDX
INC AL
JNZ ^DECCIKL11
^DEC4JEGY:
ADD AL,'0'
INC BL
STOSW
RET



DECKIIR5::
; ECX KIIRASA, 1..10 SZMJEGGYEL (AMENNYI KELL)
XOR BL,BL ; DECJEL
MOV EDX,1000000000
CALL ^DECCIKL1
MOV EDX,100000000
CALL ^DECCIKL1
MOV EDX,10000000
CALL ^DECCIKL1
MOV EDX,1000000
CALL ^DECCIKL1
MOV EDX,100000
CALL ^DECCIKL1
MOV EDX,10000
CALL ^DECCIKL1
MOV DX,1000
CALL ^DECCIKL1
MOV DX,100
CALL ^DECCIKL1
MOV DL,10
CALL ^DECCIKL1
CL+='0'
WRITECHR CL
RET           ;<= DECJEL MIATT IS FONTOS! (LEGALBB 1 NULLA KELL!)

^DECCIKL1:
XOR AL,AL
CMP ECX,EDX
JNC ^DECCIKL12
OR BL,BL
JNZ ^DEC4JEGY
RET

^DECCIKL11:
CMP ECX,EDX
JC ^DEC4JEGY
^DECCIKL12:
SUB ECX,EDX
INC AL
JNZ ^DECCIKL11
^DEC4JEGY:
INC BL
AL+='0'
WRITECHR AL
RET


SETSCRSEG::
 AL:=11H//INT 33H
 AX:=v86r_AX
 NOT AX
 TEST AL,30H
 AX:=0B000H
 IF FLAG NZ THENCMD AH+=8 
 VAR SCRSEG:DW=AX
RET

;-----------------------------------------------------------------------------

CURSOR_OFF::
PUSHA
  v86r_AH:=1 // v86r_CH:=20h // BIOS
POPA
RET

;-----------------------------------------------------------------------------
SAVE_CURSOR::
PUSHA
  v86r_BH:=0 // v86r_AH:=3 // BIOS
  CX:=v86r_CX
  VAR OLD_CURSOR:DW=CX
POPA
RET

;-----------------------------------------------------------------------------

CURSOR_ON::
PUSHA
  CX:=OLD_CURSOR//v86r_CX:=CX
  v86r_AH:=1 // BIOS
POPA
RET

;-----------------------------------------------------------------------------

BIOS_CLRSCR::
PUSHA
v86r_AH:=15  // BIOS
v86r_AX&=127 // BIOS
POPA
RET

;-----------------------------------------------------------------------------

BINBYTE::
; BL=ADAT
CX:=8//@: XOR AL//SHL BL//ADC AL,'0'//WRITECHR AL//LOOP @
RET

BINWORD::
; BX=ADAT
CX:=16//@: XOR AL//SHL BX//ADC AL,'0'//WRITECHR AL//LOOP @
RET

BINDWORD::
; EBX=ADAT
CX:=32//@: XOR AL//SHL EBX//ADC AL,'0'//WRITECHR AL//LOOP @
RET

;-----------------------------------------------------------------------------
CLREOLN::
PUSH CX
WRITECHR 13
v86r_DL:=' '//CX:=79//@:DOS//LOOP @
v86r_DL:=13//DOS
POP CX
RET





