;Ŀ
;            Starry Night screen saver            
;                                                 
;      Original by Joe Forster/STA                
;      BAssPasC version by GyikSoft/ESP-Team      
;

;
;                              SCREEN SAVER
;
;
;            Optimized for the BapEdit by GyikSoft/ESP-Team
;
;


{CONST
SaverStarMax    equ     32              ;Number of stars to be displayed
BlankChar       equ     0720h           ;Blank character used to clear screen

Factor          dw      8405h           ;Multiplication factor for "Random"
RandSeed        dd      0               ;Seed number for "Random"

StarChars       db      '', '', '', '', '', ' '    ;Chars for star phases
SaverStarVis    db      0               ;Number of stars on the screen
}

VAR StarsX,StarsY,StarsPhase,StarsCount:DB*SaverStarMax

Screen_Saver::
PUSHA // PUSH ES
ES:=SCREENSEG

AH:=3 // BIOS // PUSH CX DX
AX:=3 // MOUSE // CS:^MouseX:=CX // CS:^MouseY:=DX
call Mouse_OFF

si:=ofs ^SCREEN
call Screen_Save

IF EXTERNAL_SAVER<>0 THEN
  AH:=15 // BIOS // PUSH AX
  DX->EXTERNAL_SAVER // SI:=STROFS 0 // !EXEC
  POP AX // AX&=127 // BIOS
  =>^Quit
ENDIF

!CLRSCR2 // AH:=1 // CH:=20h // BIOS

                mov     ah, 2Ch         ;Fill up seed number for "Random"
                int     21h             ; with a value read from the timer
                mov     word ptr RandSeed, cx
                mov     word ptr RandSeed + 2, dx

                xor     bx, bx          ;Initialize star-related variables
                mov     cx, SaverStarMax
                mov     ax, 0500h
^04_NewInt1C:   mov     [bx + Offset StarsPhase], ah
                mov     [bx + Offset StarsCount], al
                mov     [bx + Offset StarsX], al
                mov     [bx + Offset StarsY], al
                inc     BX
                loop    ^04_NewInt1C

                mov     SaverStarVis, 0 ;No stars are currently displayed
                ES=0B800H

^FOCIKL:
                AH:=86h // CX:=0 // dx:=55000 // INT 15h  ; KB 18.2/SEC

                xor     bx, bx          ;Start working with the first star
^15_NewInt1C:   mov     al, [bx + StarsCount]
                or      al, al          ;If the star timer has reached zero
                je      ^06_NewInt1C    ; then its phase must be changed
                jmp     ^07_NewInt1C
^06_NewInt1C:   mov     al, [bx + StarsPhase]
                inc     al              ;Change phase of the current star
                cmp     al, 6           ;Wrap to zero if more than 5
                jne     ^08_NewInt1C
                mov     al, 0
^08_NewInt1C:   mov     [bx + StarsPhase], al
                cmp     al, 2           ;If phase of current star is 2 then
                jne     ^09_NewInt1C    ; a random number must decide whether
                push    bx              ; the star blows up or disappears
                mov     ax, 10
                call    Random
                pop     bx
                cmp     ax, 8           ;8 stars out of 10 disappear
                jae     ^09_NewInt1C
                mov     al, 5           ;Clear star if it has to disappear
                mov     [bx + StarsPhase], al
^09_NewInt1C:   mov     al, [bx + StarsPhase]
                cmp     al, 0
                jne     ^10_NewInt1C    ;If a new star is born then delete it
                mov     ax, BlankChar   ; from its previous coordinates
                call    DrawStar
                push    bx
                movzx ax,XSize
                call    Random          ;Generate new X coordinate
                pop     bx
                mov     [bx + StarsX], al
                push    bx
                movzx ax,YSize
                call    Random          ;Generate new Y coordinate
                pop     bx
                mov     [bx + StarsY], al
                push    bx
                mov     ax, 182         ;Generate new lifetime: 1-182 ticks,
                call    Random
                pop     bx
                inc     al              ;Store lifetime to the star timer
                mov     [bx + StarsCount], al
                jmp     ^11_NewInt1C
^10_NewInt1C:   mov     al, 3           ;Set star timer to phase change delay
                mov     [bx + StarsCount], al
^11_NewInt1C:   mov     ah, 0Bh ;StarColor   ;Load default color of star
                mov     al, [bx + StarsPhase]
                or      al, al          ;If star is blowing up then set its
                je      ^12_NewInt1C    ; color to white
                mov     ah, 0Fh
^12_NewInt1C:   push    bx
                mov     bl, al          ;Load the character representing the
                xor     bh, bh          ; current phase of the star
                mov     al, [bx + StarChars]
                pop     bx
                call    DrawStar        ;Display star on the screen
^07_NewInt1C:   mov     al, SaverStarVis
                cmp     al, SaverStarMax - 1
                jne     ^13_NewInt1C    ;Decrease star timer if all stars are
                dec     [bx + StarsCount]       ; displayed on the screen
^13_NewInt1C:   cmp     bl, SaverStarVis
                jae     ^14_NewInt1C    ;If not all stars were handled then
                inc     bl              ; get working on the next star
                jmp     ^15_NewInt1C
^14_NewInt1C:   AL:=SaverStarVis//IF AL<SaverStarMax-1 THENCMD ++SaverStarVis


;-------------------------------;

AX:=3 // MOUSE // IF ^MouseX<>CX or ^MouseY<>DX then ^QUIT

READKEY // JZ ^FOCIKL
WAITKEY

^QUIT:
si:=ofs ^SCREEN
call Screen_Load

pop dx // ah:=2 // BIOS
pop cx // --ah // BIOS

AX:=3 // MOUSE
MOVZX AX,XSIZE // --AX // AX<0<3
IF CX<>AX OR DX<>0 THEN ^QUIT2

CX:=AX // CX-=8 // AX:=4 // MOUSE

^QUIT2:
call Mouse_ON
POP ES // POPA // Ret

{VAR
^SCREEN DW ?
^MouseX DW ?
^MouseY DW ?
}

;******************************************************************************;
;******************************************************************************;
;******************************************************************************;

DrawStar::      push    ax              ;Draw star on the screen
                mov     al, [bx + StarsY]
                xor     ah, ah          ;Compute offset in screen segment
                MOVZX DX,XSize
                ADD DX ;shl     dx, 1
                mul     dx
                mov     di, ax
                mov     al, [bx + StarsX]
                xor     ah, ah
                shl     ax, 1
                add     di, ax
                pop     ax
                mov     es:[di], ax     ;Write star char into screen segment
                retn

Random::        PUSH AX
                   call    NextRand        ;Generate a random integer
                POP BX
                mov     cx, dx
                mul     BX
                mov     ax, cx
                mov     cx, dx
                mul     BX
                add     ax, cx
                adc     dx, 0
                mov     ax, dx
                ret

NextRand::      mov     ax, word ptr RandSeed   ;Subroutine for "Random"
                mov     bx, word ptr RandSeed + 2
                mov     cx, ax
                mul     Factor
                shl     cx, 1
                shl     cx, 1
                shl     cx, 1
                add     ch, cl
                add     dx, cx
                add     dx, bx
                shl     bx, 1
                shl     bx, 1
                add     dx, bx
                add     dh, bl
                mov     cl, 5
                shl     bx, cl
                add     dh, bl
                add     ax, 1
                adc     dx, 0
                mov     word ptr RandSeed, ax
                mov     word ptr RandSeed + 2, dx
                retn


