
const SoundCard:db=SC_SB16
SC_SB16=1
SC_SB8=2
SC_GUS16=3
SC_SPEAKER=4
SC_SPEAKER1B=5

DmaBufSize=1000H
VAR DmaBuffer:DW
VAR: .ALIGN 4 ; DMA16 MIATT MUSZJ!!!!
VAR DoubleBuffer:DB*2*DmaBufSize

DmaInit::
ES=DS//DI->DoubleBuffer//REP*DmaBufSize STOSW 8000h

                AX->DoubleBuffer
                mov     cx,DS
                shl     cx,4 ; SEG->OFS
                add     cx,ax
                ; cx=lineris cm als 16 bitje
                neg cx//IF CX<DmaBufSize THENCMD AX+=CX
                mov     [DmaBuffer],ax
RET

;--------------------------------------------------------------------------

CONST CHANNEL1_ON:DB=1
CONST CHANNEL2_ON:DB=1
CONST CHANNEL3_ON:DB=1
CONST CHANNEL4_ON:DB=1
CONST CHANNEL5_ON:DB=1
CONST CHANNEL6_ON:DB=1
CONST CHANNEL7_ON:DB=1
CONST CHANNEL8_ON:DB=1

Max_period=1712

;--------------------------------------------------------------------------
;               Equates.
;--------------------------------------------------------------------------

NumTracks       equ     8
DefTempo        equ     6
DefBpm          equ     125
MidCRate        equ     8448
MixBufSize      equ     4096

;--------------------------------------------------------------------------
;               Structures.
;--------------------------------------------------------------------------

.ASM

TrackInfo       Struc

Samples         dd      ?
Position        dw      ?
Len             dw      ?
Repeat          dw      ?
RepLen          dw      ?
Volume          db      ?
Error           db      ?
Period          dw      ?
Pitch           dw      ?
Effect          dw      ?
PortTo          dw      ?
PortParm        db      ?
VibPos          db      ?
VibParm         db      ?
TremPos         db      ?
TremParm        db      ?
OldSampOfs      db      ?
Arp             dw      ?,?,?
ArpIndex        dw      ?
FineValue       dw ?

TrackInfo       EndS

.BAP


;--------------------------------------------------------------------------
;               Resources and Data.
;--------------------------------------------------------------------------

{CONST

;Credits         db      'Amiga Module Player v0.3b by Carlos Hasan.'

SinTable        db      0,25,50,74,98,120,142,162,180,197,212,225
                db      236,244,250,254,255,254,250,244,236,225
                db      212,197,180,162,142,120,98,74,50,25

ALIGN 2
PeriodTable     dw      856,808,762,720,678,640,604,570,538,508,480,453
                dw      428,404,381,360,339,320,302,285,269,254,240,226
                dw      214,202,190,180,170,160,151,143,135,127,120,113


MixSpeed DW 22050
MasterVolume DW 256
}

CONST FAST_PLAY:DW=0  ; HA NEM 0 AKKOR GYORSTEKERS ELRE!

{VAR
.ALIGN 4

ModInfo         Label   Byte

OrderLen        db      ?
ReStart         db      ?
Order           db      128 dup (?)
Patterns        dd      ?

.ALIGN 4
SampOfs         dw      31 dup (?)
SampSeg         dw      31 dup (?)
SampLen         dw      31 dup (?)
SampRep         dw      31 dup (?)
SampRepLen      dw      31 dup (?)
SampVol         dw      31 dup (?)
SampFineValue   dw      31 dup (?)

MODINFO_SIZE=$-OFS MODINFO     ; Clear_MODINFO:: -nak kell

OrderPos        db      ?
Tempo           db      ?
TempoWait       db      ?
Bpm             db      ?
Row             db      ?
BreakRow        db      ?
BpmSamples      dw      ?
BufPtr          dw      ?
BufLen          dw      ?
BufRep          dw      ?
Note            dd      ?

.ALIGN 4
PitchTable      dw      Max_period dup (?)
MixBuffer       DW      2*MixBufSize dup (?)  ; 16 BIT, STEREO!
}

{VAR
.ALIGN 4
Tracks          TrackInfo NumTracks dup (?)
}

;--------------------------------------------------------------------------
;               Start of Code.
;--------------------------------------------------------------------------



;--------------------------------------------------------------------------
; BeatTrack:  Process the next beat in one track.
;  In:
;    ds:di -  Track info Address.
;--------------------------------------------------------------------------

BeatTrack       Proc    Near

                mov     dx,[di+Effect]
                test    dx,dx  //je      None
                cmp     dh,00h //je      Arpeggio
                cmp     dh,01h //je      PortUp
                cmp     dh,02h //je      PortDown
                cmp     dh,03h //je      TonePort
                cmp     dh,04h //je      Vibrato
                cmp     dh,07h //je      Tremolo
                cmp     dh,05h //je      PortSlide
                cmp     dh,06h //je      VibSlide
                cmp     dh,0Ah //je      VolSlide
None:           ret


Arpeggio:       mov     bx,[di+ArpIndex]
                mov     ax,[di+Arp+bx]
                mov     [di+Pitch],ax
                add     bx,2
                cmp     bx,6
                jb      SetArpIndex
                xor     bx,bx
SetArpIndex:    mov     [di+ArpIndex],bx
                ret


PortUp:         xor     dh,dh
                mov     bx,[di+Period]
                sub     bx,dx
                cmp     bx,113
                jge     NotSmall
                mov     bx,113
NotSmall:       mov     [di+Period],bx
                add     bx,bx
                mov     ax,[PitchTable+bx]
                mov     [di+Pitch],ax
                ret


PortDown:       xor     dh,dh
                mov     bx,[di+Period]
                add     bx,dx
                cmp     bx,856
                jle     NotBig
                mov     bx,856
NotBig:         mov     [di+Period],bx
                add     bx,bx
                mov     ax,[PitchTable+bx]
                mov     [di+Pitch],ax
                ret


TonePort:       xor     dh,dh
                mov     ax,[di+PortTo]
                mov     bx,[di+Period]
                cmp     bx,ax
                je      NoPort
                jg      PortToUp
PortToDown:     add     bx,dx
                cmp     bx,ax
                jle     SetPort
FixPort:        mov     bx,ax
                jmp     SetPort
PortToUp:       sub     bx,dx
                cmp     bx,ax
                jl      FixPort
SetPort:        mov     [di+Period],bx
                add     bx,bx
                mov     ax,[PitchTable+bx]
                mov     [di+Pitch],ax
NoPort:         ret


Vibrato:        mov     dh,dl
                and     dl,0Fh
                shr     dh,4
                shl     dh,2
                add     [di+VibPos],dh
                mov     dh,[di+VibPos]
                mov     bl,dh
                shr     bl,2
                and     bx,1Fh
                mov     al,[SinTable+bx]
                mul     dl   ; hanger
                ;;rol ax,1
                ;;xchg    al,ah
                shr ax,7
;;                and     ah,1
                test    dh,dh
                jns     VibUp
                neg     ax
VibUp:          add     ax,[di+Period]
                mov     bx,ax
                cmp     bx,113
                jge     NoLoVib
                mov     bx,113
NoLoVib:        cmp     bx,856
                jle     NoHiVib
                mov     bx,856
NoHiVib:        add     bx,bx
                mov     ax,[PitchTable+bx]
                mov     [di+Pitch],ax
                ret


Tremolo:        mov     dh,dl
                shr     dh,4
                shl     dh,2
                add     [di+TremPos],dh
                mov     dh,[di+TremPos]
                mov     bl,dh
                shr     bl,2
                and     bx,1Fh ; 5 bit
                mov     al,[SinTable+bx]
                and     dl,0Fh
                mul     dl
                shr ax,7
                test    dh,dh
                jns     TremUp
                neg     ax
TremUp:         mov bl,[di+Volume] ; BH=0
                add ax,bx
                jge     NoLoTrem
                xor ax,ax
NoLoTrem:       cmp     ax,64
                jbe NoHiTrem
                mov     al,64
NoHiTrem:
                mov     [di+Volume],al
                ret



PortSlide:      call    VolSlide
                mov     dl,[di+PortParm]
                jmp     TonePort


VibSlide:       call    VolSlide
                mov     dl,[di+VibParm]
                jmp     Vibrato


VolSlide::      mov     dh,dl
                and     dl,0Fh
                shr     dh,4
                mov     al,[di+Volume]
                sub     al,dl
                jge     NoLoVol
                xor     al,al
NoLoVol:        add     al,dh
                cmp     al,64
                jbe     NoHiVol
                mov     al,64
NoHiVol:        mov     [di+Volume],al
                ret

BeatTrack       EndP




;--------------------------------------------------------------------------
; GetTrack:   Get the next Note from a pattern.
;  In:
;    ds:di -  Track info Address.
;    es:si -  Pattern Note Address.
; Out:
;    es:si -  The Next Pattern Note address.
;--------------------------------------------------------------------------

GetTrack        Proc    Near
                seges   lodsw
                xchg    al,ah
                mov     bl,ah
                and     ah,0Fh
                AX<>CX                 ; CX = note
                seges   lodsw
                xchg    al,ah
                mov     bh,ah
                and     ah,0Fh
                mov     dx,ax
                mov     [di+Effect],dx ; DX=Effect
                and     bl,0F0h        ; Instrument
                shr     bh,4
                or      bl,bh
                je      SetPeriod      ; Nincs hangszer megadva

SetSample:      xor     bh,bh // dec bx // add bx,bx
                mov     ax,[SampVol+bx] //mov     [di+Volume],al
                mov     ax,[SampOfs+bx] //mov     Word Ptr [di+Samples],ax
                mov     ax,[SampSeg+bx] //mov     Word Ptr [di+Samples+2],ax
                mov     ax,[SampLen+bx] //mov     [di+Len],ax
                mov     ax,[SampRep+bx] //mov     [di+Repeat],ax
                mov     ax,[SampRepLen+bx]    //mov [di+RepLen],ax
                mov     ax,[SampFineValue+bx] //mov [di+FineValue],ax

SetPeriod:      test    cx,cx
                je      SetEffect              ; Nincs PERIOD megadva?

;                AX:=20000 ;32768 ;
                MOV AX,[FineValue+DI] ;***
                PUSH DX
                MUL CX
                SHL AX//RCL DX
                SHL AX//ADC DX,0
                AX<>DX
                POP DX

                mov     [di+PortTo],AX
                cmp     dh,03h //je SetEffect

                mov     [di+Period],AX
                AX<>BX ;MOV BX,AX
                add     bx,bx
                mov     ax,[PitchTable+bx] // mov [di+Pitch],ax
                mov     [di+Position],0

SetEffect:      test    dx,dx  //je      InitNone
                cmp     dh,00h //je      InitArpeggio
                cmp     dh,03h //je      InitTonePort
                cmp     dh,04h //je      InitVibrato
                cmp     dh,07h //je      InitTremolo
                cmp     dh,09h //je      SampleOfs
                cmp     dh,0Bh //je      PosJump
                cmp     dh,0Ch //je      SetVolume
                cmp     dh,0Dh //je      Break
                cmp     dh,0Fh //je      SetSpeed
                cmp     dh,0Eh //jne     InitNone
                dh:=dl//shr dh,4 ; Exy effektek
                if dh=5 then InitFineTune              ; SetFineTune FX
                if dh=0Ah then InitFineVolumeUp
                if dh=0Bh then InitFineVolumeDown
                ;

InitNone:       ret

InitFineVolumeUp::
  DL&=15//[DI+Volume]+=DL
  IF BPT[DI+Volume]>64 THENCMD BPT[DI+Volume]:=64
RET

InitFineVolumeDown::
  DL&=15//[DI+Volume]-=DL
  IF FLAG C THENCMD BPT[DI+Volume]:=0
RET

InitFineTune::
                BL:=DL//NEG BL//AND BX,15//ADD BX//AX:=FINETUNE_TABL[BX]
                MUL CX
                SHL AX//RCL DX
                SHL AX//ADC DX,0
                mov     [di+PortTo],DX
                mov     [di+Period],DX
                DX<>BX ;MOV BX,AX
                add     bx,bx
                mov     ax,[PitchTable+bx]
                mov     [di+Pitch],ax
                mov     [di+Position],0
RET


InitTonePort:   test    dl,dl
                jne     SetPortParm
                mov     dl,[di+PortParm]
SetPortParm:    mov     [di+PortParm],dl
                mov     [di+Effect],dx
                ret


InitVibrato::   mov     al,[di+VibParm]
                mov     ah,al
                and     al,0Fh
                and     ah,0F0h
                test    dl,0Fh
                jne     ^OkDepth
                or      dl,al
^OkDepth:       test    dl,0F0h
                jne     ^OkRate
                or      dl,ah
^OkRate:        mov     [di+VibParm],dl
                mov     [di+Effect],dx
                test    cx,cx
                je      ^OkPos
                mov     [di+VibPos],0
^OkPos:         ret


InitTremolo::   mov     al,[di+TremParm]
                mov     ah,al
                and     al,0Fh
                and     ah,0F0h
                test    dl,0Fh
                jne     ^OkDepth
                or      dl,al
^OkDepth:       test    dl,0F0h
                jne     ^OkRate
                or      dl,ah
^OkRate:        mov     [di+TremParm],dl
                mov     [di+Effect],dx
                test    cx,cx
                je      ^OkPos
                mov     [di+TremPos],0
^OkPos:         ret



SampleOfs:      test    dl,dl
                jne     SetSampleOfs
                mov     dl,[di+OldSampOfs]
SetSampleOfs:   mov     [di+OldSampOfs],dl
                mov     dh,dl
                xor     dl,dl
                mov     [di+Position],dx
                ret


PosJump:        mov     [OrderPos],dl
                mov     [Row],64
                ret


SetVolume:      cmp     dl,64
                jbe     ^OkVol
                mov     dl,64
^OkVol:          mov     [di+Volume],dl
                ret


Break:          mov     dh,dl
                and     dl,0Fh
                shr     dh,4
                add     dh,dh
                add     dl,dh
                shl     dh,2
                add     dl,dh
                mov     [BreakRow],dl
                mov     [Row],64
                ret


SetSpeed:       test    dl,dl
                je      Skip
                cmp     dl,31
                ja      SetBpm
SetTempo:       mov     [Tempo],dl
                mov     [TempoWait],dl
                ret
SetBpm:         mov     [Bpm],dl
;                mov     al,103
;                mul     dl
;                mov     bl,ah
;                xor     bh,bh
;                mov     ax,[MixSpeed]
;                xor     dx,dx
;                div     bx
;               ;; AX=MixSpeed/(103*Bpm/256)
        AL:=24//MUL DL//AX<>BX ; EZT MEG LEHET CSINLNI SHL+ADD-vel is!
        AX:=60//MUL MixSpeed//DIV BX

                mov     [BpmSamples],ax
Skip:           ret


InitArpeggio:   mov     dh,dl
                and     dl,0Fh
                shr     dh,4
                mov     cx,36
                xor     bx,bx
                mov     ax,[di+Period]
ScanPeriod:     cmp     ax,[PeriodTable+bx]
                jae     SetArp
                add     bx,2
                loop    ScanPeriod
SetArp:         add     dx,dx
                add     dh,bl
                add     dl,bl
                mov     bx,[PeriodTable+bx]
                add     bx,bx
                mov     ax,[PitchTable+bx]
                mov     [di+Arp],ax
                mov     bl,dh
                xor     bh,bh
                mov     bx,[PeriodTable+bx]
                add     bx,bx
                mov     ax,[PitchTable+bx]
                mov     [di+Arp+2],ax
                mov     bl,dl
                xor     bh,bh
                mov     bx,[PeriodTable+bx]
                add     bx,bx
                mov     ax,[PitchTable+bx]
                mov     [di+Arp+4],ax
                mov     [di+ArpIndex],0
                ret

GetTrack        EndP




;--------------------------------------------------------------------------
; UpdateTracks:  Main code to process the next tick to be played.
;--------------------------------------------------------------------------

UpdateTracks    Proc    Near

                dec     [TempoWait]
                je      GetTracks

BeatTracks:     _Ofs = offset Tracks
                REP(4) di:=_Ofs//!BeatTrack//_Ofs = _Ofs + Size TrackInfo
                IF TrackDb=4 THEN ^RET
                REP(2) di:=_Ofs//!BeatTrack//_Ofs = _Ofs + Size TrackInfo
                IF TrackDb=6 THEN ^RET
                REP(2) di:=_Ofs//!BeatTrack//_Ofs = _Ofs + Size TrackInfo
.ALIGN 4,DB 0C3H ; RET
^RET:
                ret


GetTracks:      mov     al,[Tempo]
                mov     [TempoWait],al


                les     si,[Note]
                cmp     [Row],64
                jb      NoPattWrap

                les     si,[Patterns]
                mov     bl,[OrderPos]
                cmp     bl,[OrderLen]
                jb      NoOrderWrap
                mov     bl,[ReStart]
                mov     [OrderPos],bl
                cmp     bl,[OrderLen]
                jae     NoUpdate
NoOrderWrap:    xor     bh,bh
                mov     bl,[Order+bx]
;;                shl     bx,10 ; IGY LENNE 4 CHN-NL
;;              IMUL BX,BX,NumTracks
                PUSH(AX,DX) AX:=TrackDb//MUL BX//AX<>BX
                SHL BX,8
                add     si,bx
                mov     bl,[BreakRow]
                mov     [Row],bl
                xor     bh,bh
                mov     [BreakRow],bh
                shl     bx,4
                add     si,bx
                mov     Word Ptr [Note],si
                mov     Word Ptr [Note+2],es
                inc     [OrderPos]
NoPattWrap:     inc     [Row]

                cld
                _Ofs = offset Tracks

                REP(4) di:=_Ofs//!GetTrack//_Ofs = _Ofs + Size TrackInfo
                IF TrackDb=4 THEN ^OK_GET
                REP(2) di:=_Ofs//!GetTrack//_Ofs = _Ofs + Size TrackInfo
                IF TrackDb=6 THEN ^OK_GET
                REP(2) di:=_Ofs//!GetTrack//_Ofs = _Ofs + Size TrackInfo
^OK_GET:

                mov     Word Ptr [Note],si
NoUpdate:       ret

UpdateTracks    EndP


;--------------------------------------------------------------------------
; StartPlaying: Initializes the Sound System.
;  In:
;   Module Information Resources.
;--------------------------------------------------------------------------

StartPlaying    Proc

                pusha
                push    ds
                push    es

SetModParms:    mov     [OrderPos],0
                mov     [Tempo],DefTempo
                mov     [TempoWait],DefTempo
                mov     [Bpm],DefBpm
                mov     [Row],64
                mov     [BreakRow],0
                mov     ax,[MixSpeed]
                xor     dx,dx
                mov     bx,24*DefBpm/60
                div     bx
                mov     [BpmSamples],ax

ClearTracks:    mov     di,offset Tracks
                mov     ax,ds
                mov     es,ax
                mov     cx,NumTracks * (Size TrackInfo)
                xor     ax,ax
                cld
                rep     stosb

                mov     [BufPtr],ax
                mov     [BufLen],ax

MakePitch:      mov     ax,MidCRate
                mov     bx,428
                mul     bx
                div     [MixSpeed]
                xor     dh,dh
                mov     dl,ah
                mov     ah,al
                xor     al,al

                mov     cx,max_period ;907 ;857
                xor     bx,bx
                mov     di,offset PitchTable
PitchLoop:      push    ax
                push    dx
                  cmp     dx,bx
                  jae     NoDiv
                  div     bx
NoDiv:            stosw
                pop     dx
                pop     ax
                inc     bx
              loop    PitchLoop

              ; Start sound!
                call DmaInit  ; Kiszmolja a DmaBuffer helyt s kinullzza

                case SoundCard OF
                  SC_SB16,SC_SB8:  call Sb16Init   ; Elindtja a lejtszst!
                  SC_GUS16: call GusInit
                  SC_SPEAKER,SC_SPEAKER1B: call Speaker_Init
                endcase

                pop     es
                pop     ds
                popa
                ret

StartPlaying    EndP

StopPlaying::
                case SoundCard OF
                  SC_SB16,SC_SB8: call Sb16Uninit   ; Elindtja a lejtszst!
                  SC_GUS16: call GusUninit
                  SC_SPEAKER,SC_SPEAKER1B: call Speaker_UnInit
                endcase
RET



