
; 1998.07.12.  bugfix: IF AH>=8 THEN => If AL>=8 THEN         by GyikSoft


;           Include az interrupt-vezrl felprogramozshoz

; ES:DI=Az interrupt-rutin cme
; AX=Az IRQ szma

CONST IRQ_masktabl db 1, 2, 4, 8, 16, 32, 64, 128
{VAR
OldIRQOffset    dw ?
OldIRQSegment   dw ?
}

IRQSet::
        pusha
        push ds
        cli                  ; megszaktsok tiltsa
        ds=0
        mov dx, 21h          ; az els interruptvezrl engedlyezs-portja
        mov si, 20h          ; az IRQ0 (INT 08h) vektornak cme
if al>=8 then
        mov dl, 0a1h         ; a msodik interruptvezrl engedlyezs-portja
        mov si, 1c0h         ; az IRQ8 (INT 70h) vektornak cme
        sub AL, 8            ; IRQ8-IRQ15 helyett a msodik vezrl 0-7 megszaktsaira fogunk hivatkozni
endif
        BX:=AX
        shl AX, 2
        add si, AX           ; a vektor cmnek kiszmtsa

        LODSW
        mov cs:OldIRQOffset,AX  ; az aktulis rutin offsetjnek trolsa
        LODSW
        mov cs:OldIRQSegment,AX ; az aktulis rutin szegmensnek trolsa
        mov [si-4], DI          ; az j rutin offsetje
        mov [si-2], es          ; az j rutin szegmense

        mov cl, cs:IRQ_masktabl[bx]
        not cl                    ; maszk elksztse

        in al, dx
        and al, cl                ; a megfelel bit trlse
        out dx, al                ; az j maszk kirsa

        sti                  ; megszaktsok engedlyezse
        pop ds
        popa
        ret

;==============================================================================;

IRQReset::
        pusha
        push ds
        cli                  ; megszaktsok tiltsa
        ds=0
        mov dx, 21h          ; az els interruptvezrl engedlyezs-portja
        mov si, 20h          ; az IRQ0 (INT 08h) vektornak cme
if al>=8 then
        mov dl, 0a1h         ; a msodik interruptvezrl engedlyezs-portja
        mov si, 1c0h         ; az IRQ8 (INT 70h) vektornak cme
        sub AL, 8            ; IRQ8-IRQ15 helyett a msodik vezrl 0-7 megszaktsaira fogunk hivatkozni
endif
        BX:=AX
        shl AX, 2
        add si, AX           ; a vektor cmnek kiszmtsa

        in  al, dx
        OR  AL, cs:IRQ_masktabl[bx]
        out dx, al

        mov AX, cs:OldIRQOffset
        mov [si], AX              ; a rgi megszakts offsetjnek visszarsa
        mov AX, cs:OldIRQSegment
        mov [si+2], AX            ; a rgi megszakts szegmensnek visszarsa


^exit:
        sti                  ; megszaktsok engedlyezse
        pop ds
        popa
        ret

