/*  INT 16h emulation v0.1     (C) 1999. A'rpi/ESP-team  */

#include "rulez.h"

static int em_int16 ( struct vm86_regs *r )
{
  int ax=(r->eax & 0xffff);
  int ah=(ax>>8);

  /* Wait for a key */
  if(ah==0 || ah==0x10){
    unsigned char c;
    read(0,&c,1);
    if(c==27) AX=0x011B; else AX=c;  /* FIX IT! */
    return 1;
  }

  /* Keypressed() */
  if(ah==1 || ah==0x11){
    struct timeval tv;
    fd_set fds;
    int fd = fileno(stdin);
    char c;

    tv.tv_sec = tv.tv_usec = 0;
    FD_ZERO(&fds);
    FD_SET(fd, &fds);
    if (select(fd + 1, &fds, 0, 0, &tv) > 0) {
      /* is something in buffer */
      r->eflags&=~0x40;
      AX=0;                  /* FIX IT!!! */
    } else {
      /* buffer is empty */
      r->eflags|=0x40;
    }
    return 1;
  }

  /* get shift state */
  if(ah==2 || ah==0x12){
    regL(r->eax)=0;          /* FIX IT! FAKE! */
    return 1;
  }

  fprintf(stderr,"INT16: not implemented AX=%04Xh\n",ax);
  return 0;
}

