/*  INT 21h emulation v0.3     (C) 1999. A'rpi/ESP-team  */
/* Implemented:

  AH - function
 ---------------
  02 - write char
  09 - write string
  0B - get keyboard status (AL=keypressed())
  1A - set DTA address
  25 - set intvect
  2A - get system date
  2C - get system time  (FIX!  msec=0)
  2F - get DTA address
  30 - get dos version  (returns 5.00)
  35 - get intvect
  3700 - get switch char (returns '-')
  38 - set country code (FAKE, but TASM requires)
  39 - mkdir
  3a - rmdir
  3b - chdir
  3c - create file
  3d - open file
  3e - close file
  3f - read file
  40 - write file
  41 - erase file
  42 - seek file
  47 - get cwd
  48 - allocmem
  49 - freemem
  4A - resize mem (FIX!  FAKE)
  5700 - get file date/time

*/

int convert_path=1;  /*  Automatic "/" <-> "\" conversion  */
int downcase_path=1; /*  Automatic [A..Z] -> [a..z] conversion  */

int DTA_ofs,DTA_seg;

static char newpath[256];

char * path_u2d(char *p,char *newpath){
  int i,j;
/*  if(!convert_path) return p; */
  j=strlen(p);if(j>255)j=255;
  for(i=0;i<j;i++){
    int c=p[i];
    if(c=='/') c='\\'; else
    if(c=='\\') c='/';
    newpath[i]=c;
  }
  newpath[j]=0;
  return newpath;
}

char * path_d2u(char *p,char *newpath){
  int i,j;
  if(!convert_path) return p;
  j=strlen(p);if(j>255)j=255;
  for(i=0;i<=j;i++){
    int c=p[i];
    if(c=='\\') c='/';
    if(downcase_path && c>='A' && c<='Z') c+=32;
    newpath[i]=c;
  }
  return newpath;
}


static int em_int21(struct vm86_regs *r){
int ax=(r->eax & 0xffff);
int al=(ax&0xff);
int ah=(ax>>8);
#define SET_AX(x) r->eax = r->eax&0xffff0000 | x
#define CLC r->eflags = r->eflags & (~1)
#define STC r->eflags = r->eflags | 1

  /* Exit prg */
  if(ah==0 || ah==0x4c) return -1;

  /* Write char (DL) */
  if(ah==2){
    putchar(r->edx & 0xff);
    fflush(stdout);
    return 1;
  }

  /* Write string (DS:DX) */
  if(ah==9){
    char *p=(char*)( (r->ds<<4)+(r->edx&0xffff) );
    while(p[0]!='$'){ putchar(p[0]);p++; }
    fflush(stdout);
    return 1;
  }

  /* Set int vector  AL=int DS:DX->int */
  if(ah==0x25){
    unsigned short int *p; 
    p=(unsigned short int *)(al*4);
    p[0]=r->edx & 0xffff;
    p[1]=r->ds;
    return 1;
  }

  /* Get int vector  AL=int DS:DX->int */
  if(ah==0x35){
    unsigned short int *p; 
    p=(unsigned short int *)(al*4);
    r->ebx=(r->ebx&0xffff0000) | p[0];
    r->es=p[1];
    return 1;
  }

  /* get DOS version (AL=major  AH=minor) */
  if(ah==0x30){
    SET_AX(5);
    return 1;
  }

  /* Open file (DS:DX) */
  if(ah==0x3D){
    char *p=(char*)( (r->ds<<4)+(r->edx&0xffff) );
    int flags,f;
    if((al&3)==0) flags=O_RDONLY; else 
    if((al&3)==1) flags=O_WRONLY; else
                  flags=O_RDWR;
    f=open(path_d2u(p,newpath),flags);
    if(f<0){
      printf("!!! open='%s'\n",path_d2u(p,newpath));
      STC; SET_AX(errno);
    }else{
      CLC; SET_AX(f);
    }
    return 1;
  }

  /* Create file (DS:DX) */
  if(ah==0x3C){
    char *p=(char*)( (r->ds<<4)+(r->edx&0xffff) );
    int f;
    f=open(path_d2u(p,newpath),O_RDWR|O_CREAT|O_TRUNC,0777);
    if(f<0){
      printf("!!! create='%s'\n",path_d2u(p,newpath));
      STC; SET_AX(errno);
    }else{
      CLC; SET_AX(f);
    }
    return 1;
  }

  /* Close file (BX) */
  if(ah==0x3E){
    int f=close(r->ebx & 0xffff);
    if(f<0){STC;SET_AX(errno);}else{CLC;}
    return 1;
  }

  /* Read file (BX=f, CX=size, DS:DX=p) */
  if(ah==0x3F){
    void *p=(void*)( (r->ds<<4)+(r->edx&0xffff) );
    int i=read(r->ebx & 0xffff,p,r->ecx & 0xffff);
    if(i<0){
      STC; SET_AX(errno);
    }else{
      CLC; SET_AX(i);
    }
    return 1;
  }

  /* Write file (BX=f, CX=size, DS:DX=p) */
  if(ah==0x40){
    void *p=(void*)( (r->ds<<4)+(r->edx&0xffff) );
    int i=write(r->ebx & 0xffff,p,r->ecx & 0xffff);
    if(i<0){
      STC; SET_AX(errno);
    }else{
      CLC; SET_AX(i);
    }
    return 1;
  }

  /* SEEK file (BX=f, CX:DX=pos -> DX:AX=pos) */
  if(ah==0x42){
    int p=( ((r->ecx&0xffff)<<16)+(r->edx&0xffff) );
    int i,w;
    if(al==1) w=SEEK_CUR; else
    if(al==2) w=SEEK_END; else
              w=SEEK_SET;
    i=lseek(r->ebx & 0xffff,p,w);
    if(i<0){
      STC; SET_AX(errno);
    }else{
      CLC;
      r->edx = (r->edx&0xffff0000) | (i>>16);
      SET_AX((i&0xffff));
    }
    return 1;
  }

  /* Erase file (DS:DX) */
  if(ah==0x41){
    char *p=(char*)( (r->ds<<4)+(r->edx&0xffff) );
    int f=unlink(path_d2u(p,newpath));
    if(f<0){STC;SET_AX(errno);}else{CLC;}
    return 1;
  }

  /* MkDir (DS:DX) */
  if(ah==0x39){
    char *p=(char*)( (r->ds<<4)+(r->edx&0xffff) );
    int f=mkdir(path_d2u(p,newpath),0777);
    if(f<0){STC;SET_AX(errno);}else{CLC;}
    return 1;
  }

  /* RMDIR (Erase subdir) (DS:DX) */
  if(ah==0x3A){
    char *p=(char*)( (r->ds<<4)+(r->edx&0xffff) );
    int f=rmdir(path_d2u(p,newpath));
    if(f<0){STC;SET_AX(errno);}else{CLC;}
    return 1;
  }

  /* CHDIR (Change directory) (DS:DX) */
  if(ah==0x3B){
    char *p=(char*)( (r->ds<<4)+(r->edx&0xffff) );
    int f=chdir(path_d2u(p,newpath));
    if(f<0){STC;SET_AX(errno);}else{CLC;}
    return 1;
  }

  /* GETCWD (Get current directory) ->(DS:SI) */
  if(ah==0x47){
    char *p=(char*)( (r->ds<<4)+(r->esi&0xffff) );
    char *f;
    if(convert_path){
      f=getcwd(newpath,64);
      if(f) path_u2d(newpath,p);
    } else {
      f=getcwd(p,64);
    }
    if(f==NULL){STC;SET_AX(errno);}else{CLC;}
    return 1;
  }

  /* Malloc  ->BX */
  if(ah==0x48){
    int size=(r->ebx&0xffff)<<4;
    int m=dosmem_alloc(size);
    if(m<=0){
      STC;
      r->ebx=(r->ebx&0xffff0000) | (dosmem_largest()>>4);
    } else {
      CLC;
      SET_AX((m>>4));
    }  
    return 1;
  }

  /* Mfree ES */
  if(ah==0x49){
    if(dosmem_free(r->es<<4)) CLC; else STC;
    return 1;
  }

  /* Mchange ES */
  if(ah==0x4A){
    int size=(r->ebx&0xffff)<<4;
    int m=dosmem_resize(r->es<<4,size);
    if(m<=0){
      STC;
      r->ebx=(r->ebx&0xffff0000) | (dosmem_largest()>>4);
      SET_AX(8); /* ??? */
    } else {
      CLC;
    }  
    return 1;
  }

  /* get system datee */
  if(ah==0x2A){
    time_t x;
    struct tm *y;
    time(&x);
    y=gmtime(&x);
    r->ecx=(r->ecx & 0xffff0000) + (y->tm_year);
    r->edx=(r->edx & 0xffff0000) + (y->tm_mon<<8) + (y->tm_mday);
    r->eax=(r->eax & 0xffffff00) + (y->tm_wday);
    return 1;
  }

  /* get system time */
  if(ah==0x2C){
    time_t x;
    struct tm *y;
    time(&x);
    y=gmtime(&x);
    r->ecx=(r->ecx & 0xffff0000) + (y->tm_hour<<8) + (y->tm_min);
    r->edx=(r->edx & 0xffff0000) + (y->tm_sec<<8) + 0;
    return 1;
  }

  /* get file date/time */
  if(ax==0x5700){
    time_t x;
    struct tm *y;
    struct stat s;
    if(fstat(r->ebx&0xffff,&s)==-1){ STC; SET_AX(errno);return 1;}
    y=gmtime(&s.st_mtime);
    r->ecx=(r->ecx & 0xffff0000) + (y->tm_sec>>2) + (y->tm_min<<5) + (y->tm_hour<<11);
    r->edx=(r->edx & 0xffff0000) + (y->tm_mday) + (y->tm_mon<<5) + ((y->tm_year-1980)<<9);
    CLC;
    return 1;
  }

  /* set country code */
  if(ah==0x38){
    CLC;
    return 1;
  }

  /* Keypressed() */
  if(ah==0x0B){
    struct timeval tv;
    fd_set fds;
    int fd = fileno(stdin);

    tv.tv_sec = tv.tv_usec = 0;
    FD_ZERO(&fds);
    FD_SET(fd, &fds);
    if (select(fd + 1, &fds, 0, 0, &tv) > 0) {
      /* is something in buffer */
      r->eax|=0xff;
    } else {
      /* buffer is empty */
      r->eax&=(~0xff);
    }
    return 1;
  }
  
  /* get DTA address */
  if(ah==0x2F){
    r->es=DTA_seg;
    r->ebx=(r->ebx&0xffff0000) | DTA_ofs;
    return 1;
  }

  /* set DTA address */
  if(ah==0x1A){
    DTA_seg=r->ds;
    DTA_ofs=r->edx & 0xffff;
    return 1;
  }

  /* get switch char */
  if(ax==0x3700){
    r->eax=(r->eax&0xffffff00) | '-';
    return 1;
  }

  
  fprintf(stderr,"INT21: not implemented AX=%04Xh BX=%04Xh\n",ax,r->ebx & 0xffff);
  STC;

  return 0;
}

#undef SET_AX
#undef CLC
#undef STC


