#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/vm86.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <dirent.h>
#include "rulez.h"

/*  INT 21h emulation v0.41     (C) 1999. A'rpi/ESP-team  
                                (C) 1999  LGB of DC
*/

int downcase_path=1; /*  Automatic [A..Z] -> [a..z] conversion on DOS->UNIX */
int convert_path=1;

int current_drive=2;  /* C: */
int DTA_ofs,DTA_seg;

static char newpath[256];


#define ERRNO_TAB_SIZE 31
static const signed char errno_tab[ERRNO_TAB_SIZE] = {
     5, /* EPERM		 1	Operation not permitted */
     2, /* ENOENT		 2	No such file or directory */
     0, /* ESRCH		 3	No such process */
     0, /* EINTR		 4	Interrupted system call */
    23, /* EIO		 	 5	I/O error */
     0, /* ENXIO		 6	No such device or address */
     0, /* E2BIG		 7	Arg list too long */
     0, /* ENOEXEC		 8	Exec format error */
     6, /* EBADF		 9	Bad file number */
     0, /* ECHILD		10	No child processes */
     0, /* EAGAIN		11	Try again */
     8, /* ENOMEM		12	Out of memory */
     5, /* EACCES		13	Permission denied */
     0, /* EFAULT		14	Bad address */
     0, /* ENOTBLK		15	Block device required */
    32, /* EBUSY		16	Device or resource busy */
    80, /* EEXIST		17	File exists */
     0, /* EXDEV		18	Cross-device link */
     0, /* ENODEV		19	No such device */
     0, /* ENOTDIR		20	Not a directory */
     0, /* EISDIR		21	Is a directory */
     0, /* EINVAL		22	Invalid argument */
     4, /* ENFILE		23	File table overflow */
     4, /* EMFILE		24	Too many open files */
     0, /* ENOTTY		25	Not a typewriter */
    32, /* ETXTBSY		26	Text file busy */
     0, /* EFBIG		27	File too large */
     8, /* ENOSPC		28	No space left on device */
     0, /* ESPIPE		29	Illegal seek */
    19, /* EROFS		30	Read-only file system */
     5  /* EMLINK		31	Too many links */
};

int errno_u2d ( int err )
{
  if (err>ERRNO_TAB_SIZE) return 31;
  if (!errno_tab[err]) return 31;
  return errno_tab[err];
}


/* path conversion : UNIX -> DOS */
char *path_u2d ( char *p , char *newpath )
{
  int i=256;
  while (*p&&i--) {
    *(newpath++)=(*p=='/')?'\\':*p;
    p++;
  }
  *newpath='\0';
  return newpath;
}


/* path conversion : DOS -> UNIX */
char *path_d2u ( char *p , char *newpath )
{
  int i=256;
  if (p[1]==':') {   /* LGB : ignore drive letter, all 'drive' access the whole UNIX root */
    p+=2;
    i-=2;
  }
  while (*p&&i--) {
    char c=*(p++);
    if (c=='\\') c='/';
    if (downcase_path && c>='A' && c<='Z') c+=32;
    *(newpath++)=c;
  }
  *newpath='\0';
/*  if (!strcmp(newpath,"con"))
  if (!strcmp(newpath,"nul")) newpath="/dev/null";  */
  return newpath;
}

#include "int21_misc.c"

int em_int21 ( struct vm86_regs *r )
{
  switch (AH) {
  
    case 0x00 :     /* exit program */
    case 0x4C :  {  /* exit program */
      return -1;
    }
    
    case 0x01 :  {   /* char in/out, NOT TESTED !!, LGB */
      char c;
      read(0,&c,1);
      write(1,&c,1);
      fflush(stdout);
      return 1;
    }
    
    case 0x02 :  {   /* write char from DL */
      putchar(DL);
      fflush(stdout);
      return 1;
    }
    
    case 0x06 :  {  /* char direct I/O, LGB */
      if (DL==0xff) {
        char c;
	read(0,&c,1);
	AL=c;
      } else {
        putchar(DL);
	fflush(stdout);
      }
      return 1;
    }
    
    case 0x08 :  {  /* char input , LGB */
      unsigned char c;
      read(0,&c,1);
      AL=c;
      return 1;
    }
    
    case 0x09 :  {  /* write string DS:DX */
      char *p=DOS_POINTER(DS,DX);
      while (*p!='$') putchar(*(p++));
      fflush(stdout);
      return 1;
    }
    
    case 0x0A :  {  /* get string, BUGGY !!, LGB */
      char *p=DOS_POINTER(DS,DX);
      fflush(stdin);
      fgets(p+2,*p,stdin);
      p[1]=strlen(p+2);
      return 1;
    }

    case 0x0B :  {  /* Keypressed() */
      struct timeval tv;
      fd_set fds;
      int fd = fileno(stdin);
      tv.tv_sec = tv.tv_usec = 0;
      FD_ZERO(&fds);
      FD_SET(fd, &fds);
      if (select(fd + 1, &fds, 0, 0, &tv) > 0) {
        /* is something in buffer */
        AL=255;
      } else {
        /* buffer is empty */
        AL=0;
      }
      return 1;
    }
    
    case 0x0D :  {  /* reset block devices a'la sync ? LGB */
      return 1;
    }
    
    case 0x0E :  {  /* select drive, LGB , FAKE !! */
      current_drive=DL;
      AL=3;  /* ??? installed drives in system, let's say we have A,B,C */
      return 1;
    }
    
    case 0x0F : /* FCB functions, LGB */
    case 0x10 :
    case 0x11 :
    case 0x12 :
    case 0x13 :
    case 0x14 :
    case 0x15 :
    case 0x16 :
    case 0x17 :
    case 0x21 :
    case 0x22 :
    case 0x23 :
    case 0x24 :
    case 0x27 :
    case 0x28 :
    case 0x29 :
      fprintf(stderr,"INT21: FCB function (%02Xh) not implemented\n",AH);
      AL=255;  /* FCB error code or something */
      return 1;
    
    case 0x19 :  {  /* get current drive, LGB */
      AL=current_drive;
      return 1;
    }

    case 0x1A :  {  /* set DTA address */
      DTA_seg=DS;
      DTA_ofs=DX;
      return 1;
    }
    
    case 0x25 :  {  /* set int vector AL DS:DX */
      word *p=(word *)(AL<<2);
      *p=DX;
      p[1]=DS;
      return 1;
    }

    case 0x2A :  {  /* get system date */
      time_t x;
      struct tm *y;
      time(&x);
      y=localtime(&x);
      CX=y->tm_year;
      DX=(y->tm_mon<<8) + y->tm_mday;
      AL=y->tm_wday;
      return 1;
    }
    
    case 0x2C :  {  /* get system time */
      time_t x;
      struct tm *y;
      time(&x);
      y=localtime(&x);
      CX=(y->tm_hour<<8) + y->tm_min;
      DX=(y->tm_sec<<8) + 0;
      return 1;
    }

    case 0x2F :  {  /* get DTA address */
      ES=DTA_seg;
      BX=DTA_ofs;
      return 1;
    }
    
    case 0x30 :  {  /* get DOS version (AL=major  AH=minor) */
      AX=22*256+6;
      return 1;
    }

    case 0x35 :  {  /* Get int vector  AL=int DS:DX->int */
      word *p=(word *)(AL<<2);
      BX=*p;
      ES=*(p+1);
      return 1;
    }
    
    case 0x36 :  {  /* get free disk space, LGB , FAKEEEEEEE */
      AX=1;
      BX=30000;
      DX=32000;
      CX=512;
      return 1;
    }

    case 0x37 :  {  /* get switch char */
      if (AL==0) {
        AL='-';
        return 1;
      } else {
        AX=1;
	STC;
	return 1;
      }
    }

    case 0x38 :  {  /* set country code */
      CLC;
      return 1;
    }

    case 0x39 :  {  /* MkDir (DS:DX) */
      char *p=DOS_POINTER(DS,DX);
      int f=mkdir(path_d2u(p,newpath),0777);
      if (f<0) {
        STC;
	AX=ERRNO;
      } else
        CLC;
      return 1;
    }

    case 0x3A :  {  /* RMDIR (Erase subdir) (DS:DX) */
      char *p=DOS_POINTER(DS,DX);
      int f=rmdir(path_d2u(p,newpath));
      if (f<0) {
        STC;
	AX=ERRNO;
      } else
        CLC;
      return 1;
    }

    case 0x3B :  {  /* CHDIR (Change directory) (DS:DX) */
      char *p=DOS_POINTER(DS,DX);
      int f=chdir(path_d2u(p,newpath));
      if (f<0) {
        STC;
	AX=ERRNO;
      } else
        CLC;
      return 1;
    }

    case 0x3C :  {  /* Create file (DS:DX) */
      char *p=DOS_POINTER(DS,DX);
      int f;
      path_d2u(p,newpath);
      f=open(newpath,O_RDWR|O_CREAT|O_TRUNC,0777);
      fprintf(stderr,"!!! create='%s UNIX(%s)'\n",p,newpath);
      perror("create file");
      if(f<0){
        STC;
        AX=ERRNO;
      } else {
        CLC; 
        AX=f;
      }
      return 1;
    }

    case 0x3D :  {  /* Open file (DS:DX) */
      char *p=DOS_POINTER(DS,DX);
      int flags,f;
      if((AL&3)==0) flags=O_RDONLY;
        else if((AL&3)==1) flags=O_WRONLY; 
          else flags=O_RDWR;
      path_d2u(p,newpath);
      f=open(newpath,flags);
      fprintf(stderr,"!!! open='%s UNIX(%s)'\n",p,newpath);
      perror("open");
      if (f<0) {
        STC; 
        AX=ERRNO;
      } else {
        CLC; 
        AX=f;
      }
      return 1;
    }

    case 0x3E :  {  /* Close file (BX) */
      int f=close(BX);
      if (f<0) {
        STC;
        AX=ERRNO;
      } else 
        CLC;
      return 1;
    }

    case 0x3F :  {  /* Read file (BX=f, CX=size, DS:DX=p) */
      char *p=DOS_POINTER(DS,DX);
      int i=read(BX,p,CX);
      if (i<0) {
        STC;
        AX=ERRNO;
      } else {
        CLC;
        AX=i;
      }
      return 1;
    }

    case 0x40 :  {  /* Write file (BX=f, CX=size, DS:DX=p) */
      void *p=DOS_POINTER(DS,DX);
      int i=write(BX,p,CX);
      if (i<0) {
        STC; 
        AX=ERRNO;
      } else {
        CLC; 
	AX=i;
      }
      return 1;
    }

    case 0x41 :  {  /* Erase file (DS:DX) */
      char *p=DOS_POINTER(DS,DX);
      int f=unlink(path_d2u(p,newpath));
      if (f<0) {
        STC;
	AX=ERRNO;
      } else 
        CLC;
      return 1;
    }

    case 0x42 :  {  /* SEEK file (BX=f, CX:DX=pos -> DX:AX=pos) */
      int p=DOS_LONGINT(CX,DX);
      int i,w;
      switch (AL) {
        case 0  : w=SEEK_SET; break;
	case 1  : w=SEEK_CUR; break;
	case 2  : w=SEEK_END; break;
	default : AX=1;
	          STC;
		  return 1;
      }
      i=lseek(BX,p,w);
      if (i<0) {
        STC; 
	AX=ERRNO;
      } else {
        CLC;
        DX=i>>16;
        AX=i&0xffff;
      }
      return 1;
    }

    case 0x43 :  {   /* get attr of file (DS:DX) LGB */
      char *p=DOS_POINTER(DS,DX);
      struct stat st;
      int ret=stat(path_d2u(p,newpath),&st);
      if (ret) {
        STC;
        AX=ERRNO;
      } else {
        ret=0;
        CLC;
        if (S_ISDIR(st.st_mode)) ret|=16;
//        if (S_IWUSR(&st)) ret|=1;
        CX=ret;
      }
      return 1;
    }
    
    case 0x44 :  {  /* IOCTL functions, LGB */
      em_int21_ioctl(r);
      return 1;
    }
    
    case 0x47 :  {  /* GETCWD (Get current directory) ->(DS:SI) */
      char *p=DOS_POINTER(DS,SI);
      char *f=getcwd(newpath,64);
      if (f) {
        path_u2d(newpath,p);
	CLC;
      } else {
        STC;
	AX=ERRNO;
      }
      return 1;
    }

    case 0x48 :  {  /* Malloc  ->BX */
      int size=BX<<4;
      int m=dosmem_alloc(size);
      if (m<=0) {
        STC;
        BX=dosmem_largest()>>4;
      } else {
        CLC;
        AX=m>>4;
      }  
      return 1;
    }

    case 0x49 :  {  /* Mfree ES */
      if (dosmem_free(ES<<4)) CLC; 
        else STC;
      return 1;
    }

    case 0x4A :  {  /* Mchange ES */
      int size=BX<<4;
      int m=dosmem_resize(ES<<4,size);
      if (m<=0) {
        STC;
        BX=dosmem_largest()>>4;
        AX=8; /* ??? */
      } else {
        CLC;
      }  
      return 1;
    }
    
    case 0x4E :  {  /* find first directory entry , LGB */
      em_int21_findfirst(r);
      return 1;
    }
    
    case 0x4F :  {  /* find NEXT directory entry, LGB */
      em_int21_findnext(r);
      return 1;
    }
    
    case 0x56 :  {  /* rename file, LGB */
      char *old=DOS_POINTER(DS,DX);
      char *new=DOS_POINTER(ES,DI);
      char *newpath2;
      path_d2u(new,newpath);
      newpath2=strdup(newpath);
      path_d2u(old,newpath);
      if (rename(newpath,newpath2)) {
        STC;
	AX=ERRNO;
      } else
        CLC;
      free(newpath2);
      return 1;
    }

    case 0x57 :  {  /* get/set file date/time */
      switch (AL) {
        case 0x00 :  {  /* get file date/time */
          time_t x;
          struct tm *y;
          struct stat s;
          if (fstat(BX,&s)==-1) { 
	    STC; 
	    AX=ERRNO;
	    return 1;
	  }
          y=localtime(&s.st_mtime);
          CX=(y->tm_sec>>2) + (y->tm_min<<5) + (y->tm_hour<<11);
          DX=y->tm_mday + (y->tm_mon<<5) + ((y->tm_year-1980)<<9);
          CLC;
          return 1;
        }
	default :
	  AX=1;
	  STC;
	  return 1;
      }
    }

    default :
      fprintf(stderr,"INT21: not implemented AX=%04Xh BX=%04Xh\n",AX,BX);
      STC;
      AX=1;
      return 0;

  } /* SWITCH */
  return 0;
}
