static inline void em_int21_ioctl ( struct vm86_regs *r )
{
  switch (AL) {
    case 0  : { /* get device attrs */
      int ret=16384+8129;
      if (BX==0) ret|=1;
      if (BX==1) ret|=2;
      CLC;
      AL=ret;
      return;
    }
    
    case 1 : { /* set device attrs */
      CLC; /* ignore */
      return;
    }
    
    case 2 : { /* read from device */
      char *p=DOS_POINTER(DS,DX);
      int ret=read(BX,p,CX);
      if (ret<0) {
        AX=ERRNO;
	STC;
      } else {
        AX=ret;
	CLC;
      }
      return;
    }
    
    case 3 : { /* write to device */
      char *p=DOS_POINTER(DS,DX);
      int ret=write(BX,p,CX);
      if (ret<0) {
        AX=ERRNO;
	STC;
      } else {
        AX=ret;
	CLC;
      }
      return;
    }
    
    default :
      fprintf(stderr,"INT21: unimplemented ioctl function (44h, %02Xh).\n",AL);
      return;
  }
}





struct dta_sys_vars_st {
  DIR *dir;
  char *path;
  char *mask;
  int attr;
};

#define DTA ((struct dta_sys_vars_st*)(dta))


static inline int check_dos_fnamechar ( char c , char d )
{
  if (c>='A'&&c<='Z') c+=32;
  if (d>='A'&&d<='Z') d+=32;
  return c==d;
}


static word attr_u2d ( mode_t m )
{
  word ret=0;
  if (m&S_IWUSR) ret|=1;
  if (S_ISDIR(m)) ret|=16;
  return ret;
}


static void ftime_u2d ( time_t t , word *d_date , word *d_time )
{
  struct tm *unx=localtime(&t);
  *d_date=((unx->tm_year-1980)<<9) | (unx->tm_mon<<5) | unx->tm_mday;
  *d_time=(unx->tm_hour<<11) | (unx->tm_min<<5) | unx->tm_sec>>1;
}



static int check_dos_subfmask ( char *name , char *mask , int max )
{
  while (max--&&*mask&&*name&&(*mask=='?'||check_dos_fnamechar(*mask,*name))) {
    mask++;
    name++;
  }
  return *mask=='*'||max==0||(*mask==0&&*name==0);
}


static int check_dos_fmask ( char *name , char *mask )
{
  char *n=strdup(name);
  char *m=strdup(mask);
  char *nd=strchr(n,'.');
  char *md=strchr(m,'.');
  int ok;
  fprintf(stderr,"INT21: check_dos_fmask %s %s ",name,mask);
  if ((md&&!nd)||(!md&&nd)) ok=0; else {
    if (nd) {
      *nd='\0';
      *md='\0';
      ok=check_dos_subfmask(n,m,8)&&check_dos_subfmask(nd+1,md+1,3);
    } else
      ok=check_dos_subfmask(n,m,8);
  }
  free(n);
  free(m);
  fprintf(stderr,"%d\n",ok);
  return ok;
}


static int check_dos_amask ( mode_t m , int mask )
{
  if ( (mask&16&&S_ISDIR(m)) || (!(mask&16)&&!S_ISDIR(m))  ) return 1;
  return 1;
}

static char fname_u2d_char ( char c )
{
  if (c>='A'&&c<='Z') return c+32; else return c;
}

static void fname_u2d ( char *unx , char *dos )
{
  char *q=strchr(unx,'.');
  if (!q) {
    int max=8;
    while (max--&&*unx) *(dos++)=fname_u2d_char(*(unx++));
  } else {
    int max=8;
    while (max--&&*unx!='.') *(dos++)=fname_u2d_char(*(unx++));
    max=4;  /*  '.123' */
    while (max--&&*q) *(dos++)=fname_u2d_char(*(q++));
  }
  *dos='\0';
}


static void em_findfile ( struct vm86_regs *r , char *dta )
{
  int ok=0;
  struct dirent *ent;
  struct stat st;
  do {
    ent=readdir(DTA->dir);
    if (ent) {
      if (check_dos_fmask(ent->d_name,DTA->mask)) {
        char *p=malloc(strlen(ent->d_name)+strlen(DTA->path)+2);
        strcpy(p,DTA->path);
	strcat(p,"/");
	strcat(p,ent->d_name);
	stat(p,&st);
	free(p);
	ok=check_dos_amask(st.st_mode,DTA->attr);
      }
    }
  } while (ent&&!ok);
  if (ok&&ent) {
    fname_u2d(ent->d_name,dta+30);
    *((byte*)(dta+21))=attr_u2d(st.st_mode);
    *((unsigned int *)(dta+26))=st.st_size;
    ftime_u2d(st.st_mtime,(word*)(dta+24),(word*)(dta+22));
    fprintf(stderr,"INT21: findfile, found %s\n",dta+30);
    CLC;
    return;
  }
  free(DTA->path);
  free(DTA->mask);
  closedir(DTA->dir);
  STC;
  AX=18;
}


static inline void em_int21_findfirst ( struct vm86_regs *r )
{
  char *dta=DOS_POINTER(DTA_seg,DTA_ofs),*p;
  path_d2u(DOS_POINTER(DS,DX),newpath);
  p=strrchr(newpath,'/');
  if (!p) {
    DTA->mask=strdup(newpath);
    DTA->path=getcwd(NULL,0);
  } else {
    *p='\0';
    DTA->path=strdup(newpath);
    DTA->mask=strdup(p+1);
  }
  DTA->attr=CX;
  DTA->dir=opendir(DTA->path);
  if (!DTA->dir) {
    AX=ERRNO;
    STC;
    free(DTA->mask);
    free(DTA->path);
    return;
  }
  fprintf(stderr,"INT21: findfirst (dos=%s (%s), path=%s, fmask=%s)\n",DOS_POINTER(DS,DX),newpath,DTA->path,DTA->mask);
  em_findfile(r,dta);
}



static inline void em_int21_findnext ( struct vm86_regs *r )
{
  char *dta=DOS_POINTER(DTA_seg,DTA_ofs);
  fprintf(stderr,"INT21: findnext (path=%s, fmask=%s)\n",DTA->path,DTA->mask);
  em_findfile(r,dta);
}
