/* instruction "emulation" :) */


#include <stdio.h>
#include "dosrun.h"

extern void dump ( void );

/* broken privilegized instrunction 'emulation' :) */

int inst_emu ( void )
{
  byte *r=DOS_PB(CS,IP);
  fprintf(stderr,"INST: emulation of ");
  /*      opsize   addrsize  rep       lock      CS:       SS:       DS:       FS:       GS: */
  while (*r==0x66||*r==0x67||*r==0xF3||*r==0xF0||*r==0x2E||*r==0x36||*r==0x3E||*r==0x64||*r==0x65) {
    fprintf(stderr,"%02X ",*r);
    r++;    /* skip prefixes. later versions may emulate some I/O instructions, then we should see prefixes as well ... */
    IP++;
  }
  fprintf(stderr,"%02X\n",*r);
  /* insb */
  if (*r==0x6C) {
    IP++;
    return 1;
  }
  /* insw */
  if (*r==0x6D) {
    IP++;
    return 1;
  }
  /* outsb */
  if (*r==0x6E) {
    IP++;
    return 1;
  }
  /* outsw */
  if (*r==0x6F) {
    IP++;
    return 1;
  }
  /* in al,dx */
  if (*r==0xEC) {
    IP++;
    return 1;
  }
  /* in ax,dx */
  if (*r==0xED) {
    IP++;
    return 1;
  }
  /* out dx,al */
  if (*r==0xEE) {
    IP++;
    return 1;
  }
  /* out dx,ax */
  if (*r==0xEF) {
    IP++;
    return 1;
  }
  /* oh-oh, trouble ...
     if you get here, welcome to post output for us, or better : write
     some code to emulate or correct our code and send the patch */
  fprintf(stderr,"CAN'T EMULATE by vm86() and dosrun :\n");
  dump();
  return 0;
}
