#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

/* linux kernel source is "only" 5484 files/dirs */
#define MAX_FILES 16384

char sor[1024];

typedef struct {
  char *path;
  char *name;
  char *ext;
  int size;
  int mode;
  int type;  /* ddccss  dd=dir/link/file  cc=class  ss=subtype */
} entry_st;

entry_st files[MAX_FILES];
int entry_db=0;

#define TYPE_SRC 0x0100
#define TYPE_TXT 0x0200

void add_file(char *name){
struct stat stb;
entry_st* e=&files[entry_db++];
char *m=strdup(name);
char *n=strrchr(m,'/');
char *o;

  e->type=0;

  if(lstat(name,&stb)){
    printf("Cannot lstat file: %s\n",name);
    e->mode=0; e->size=0;
  } else {
    e->mode=stb.st_mode;
    e->size=stb.st_size;
  }
  
  if(n){
    *n=0; ++n;
    e->path=m;
  } else {
    n=m;
    e->path="";
  }
  e->name=n;
  o=strrchr(n,'.');
  if(strncmp(n,"README.",7)==0){ o=NULL; e->type=TYPE_TXT+1; }
  if(o==n) o=NULL;  /* .depend -> depend */
  if(o){
    *o=0; ++o;
    e->ext=o;
  } else {
    e->ext="";
  }

  if(strcmp(e->ext,"h")==0) e->type=TYPE_SRC+0;
  if(strcmp(e->ext,"c")==0) e->type=TYPE_SRC+1;
  if(strcmp(e->ext,"C")==0) e->type=TYPE_SRC+2;
  if(strcmp(e->ext,"c++")==0) e->type=TYPE_SRC+3;
  if(strcmp(e->ext,"cpp")==0) e->type=TYPE_SRC+4;
  if(strcmp(e->ext,"S")==0) e->type=TYPE_SRC+10;

  if(strcmp(e->ext,"txt")==0) e->type=TYPE_TXT+2;
  if(strcmp(e->ext,"doc")==0) e->type=TYPE_TXT+3;
  
//  printf("p=%-40s  n=%-12s  e=%-4s\n",e->path,e->name,e->ext);

}

int compare(const void *p1,const void *p2){
entry_st *e1=(entry_st*) p1;
entry_st *e2=(entry_st*) p2;
int i;

#define COMPARE_N(a) if((e1->a)<(e2->a)) return -1; if((e1->a)>(e2->a)) return +1;
#define COMPARE_RN(a) if((e1->a)<(e2->a)) return +1; if((e1->a)>(e2->a)) return -1;
#define COMPARE_S(a) if((i=strcmp(e1->a,e2->a))) return i;

{ int f1=S_ISREG(e1->mode);
  int f2=S_ISREG(e2->mode);
  if( f1 && !f2) return +1;
  if(!f1 &&  f2) return -1;
  if(!f1 && !f2){
    if(p1<p2) return -1;
    if(p1>p2) return +1;
    return 0;
  }
}

  COMPARE_N(type&0xff00);
  COMPARE_S(name);
  COMPARE_N(type&0x00ff);
  COMPARE_S(ext);
  COMPARE_N(size);
  COMPARE_S(path);

  return 0;
}


int main(){
FILE *f;
int i;

f=stdin; /* f=fopen("l2","rt"); if(!f) return 1; */
while(fgets(sor,1000,f)){
  if(sor[strlen(sor)-1]==10) sor[strlen(sor)-1]=0;
  add_file(sor);
}
fclose(f);

qsort((void*)&files, entry_db, sizeof(entry_st),compare);

for(i=0;i<entry_db;i++){
  entry_st *e=&files[i];
//  printf("m=%4X  p=%-35s  n=%-12s  e=%-4s\n",e->mode,e->path,e->name,e->ext);
  if(*(e->path)) printf("%s/",e->path);
  printf("%s",e->name);
  if(*(e->ext)) printf(".%s",e->ext);
  printf("\n");
}

return 0;
}
