/* Macro HTML Compiler v1.0    (C) 1999 by A'rpi/ESP-team */

/* CHANGES in 1d.c
  - macro param.reader: don't search for ',' if zj>0
  - macro param.reader: pass backslash to the output (don't cut)
*/  

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* #define DEBUG */

typedef struct _macro {
  char *name;
  char *body;
  struct _macro *next;
} macro;

macro *m_first=(macro*)NULL;

char macromem[65536];
char *mem=macromem;

int g_argc;
char **g_argv;

#define GETC ((cp && *cp)?( **cp ? *(*cp)++ : 0 ):getchar())

int putc_10=10;

void print_str(char **cp,int argc,char **argv);
int exec_macro(char **cp,int argc,char **argv);
void define_macro(char **cp);


void define_macro(char **cp){
macro *p;
char *mname;
int c;

  /* get name */
  mname=mem;
  while(1){
    c=GETC; if(c<0)exit(1);
    if(c=='=') break;
    *mem++=c;
  }
  *mem++=0;
  
  p=m_first;
  while(p){
    if(strcmp(p->name,mname)==0){
      /* megvan! macro redefinition... */
#ifdef DEBUG
  fprintf(stderr,"macro re-def: '%s'\n",mname);
#endif
      goto megvan;
    }
    p=p->next;
  }
  /* not found, allocate mem. for a new... */
  p=malloc(sizeof(macro));
  p->next=m_first; m_first=p; /* SAVE macro */

#ifdef DEBUG
  fprintf(stderr,"macro def: '%s'\n",mname);
#endif

megvan:

  /* get body */
  p->name=mname;
  p->body=mem;
  while(1){
    c=GETC; if(c<0)exit(1);
    if(c=='\\'){ *mem++=c; c=GETC; } else
    if(c=='#') break;
    *mem++=c;
  }
  *mem++=0;
  
}




int exec_macro(char **cp,int argc,char **argv){
char mname[64];
char *mac=malloc(8192);  /* for the parameters */
char *m=mac;
int id=0,zj=0;
int i=0;
int c;
int ret=0;
int p_db=0;
char* params[10];
macro *p;

  while(1){
    c=GETC; if(c<=0) break;
    if(c=='(') break;
    if(!(c>='A' && c<='Z') && !(c>='0' && c<='9') && c!='_') break;
    mname[i++]=c;
  }
  mname[i]=0;
  
  if(c=='('){    /* read parameters */
    do{
      params[p_db++]=m;
      while(1){
        c=GETC; if(c<=0){ fprintf(stderr,"Unexpected EOF in macrocall\n");exit(1);}
        if(c=='\\'){ *m++=c; c=GETC;} else{
          if(c=='%'){
            c=GETC;
            c=(c=='0') ? 9 : (c-'1');
            if(c>=0 && c<argc){
              char *p=argv[c];
              while(*p) *m++=*p++;
            } else fprintf(stderr,"Missing argument: %%%d\n",c+1);
            continue;
          }
          if(c && c==id){ id=0;continue; }
          if(id==0){
            if(c==39 || c==34 || c==96){ id=c; continue; }
            if(zj==0 && c==',') break;
            if(c=='(') ++zj;
            if(c==')'){ --zj;if(zj<0) break;}
          }
        }
        *m++=c;
      }
      *m++=0;
    }while(c==',');
    ret=GETC; /* !!! */
  } else ret=c;
  
#ifdef DEBUG
  fprintf(stderr,"Macro call! name='%s'  p_db=%d\n",mname,p_db);
#endif
#if 0
  for(i=0;i<p_db;i++){
    fprintf(stderr,"p[%d]='%s'\n",i,params[i]);
  }
#endif

  if(strcmp(mname,"ARG")==0 && p_db==1){
    int i=atoi(params[0]);
    if(i>=0 && i<g_argc){
      char *m=g_argv[i];
      print_str(&m,0,NULL);
      goto vege;
    }
  }

  if(strcmp(mname,"DOWNCASE")==0 && p_db==1){
    char *m=params[0];
    while(*m){
      int c=*m++;
      if(c>='A' && c<='Z') c+=32;
      putchar(c);
    }
    goto vege;
  }

  p=m_first;
  while(p){
    if(strcmp(p->name,mname)==0){ /* megvan */
      m=p->body;
      print_str(&m,p_db,params);
      goto vege;
    }
    p=p->next;
  }

  fprintf(stderr,"Macro NOT FOUND! name='%s'  p_db=%d\n",mname,p_db);

vege:
free(mac);
return ret;
}



void print_str(char **cp,int argc,char **argv){
int c;

while((c=GETC)>0){
ujchr:
  if(c==13) continue;  /* skip DOS-style newlines */
  if(c=='\\') c=GETC;  /* quote char */
  else {
    if(c=='`'){  /* comment */
      do{ c=GETC; if(c<=0) return;
      } while (c!='`');
      continue;
    }
    if(c=='$'){  /* macro call */
      c=exec_macro(cp,argc,argv);
      if(c>0) goto ujchr;
      continue;
    } else
    if(c=='#'){  /* macro def. */
      define_macro(cp);
      continue;
    }
    if(c=='%'){  /* macro parameter */
      c=GETC;
      if(c=='%') goto okchr;
      if(c=='.') continue;  /* skip ENDIF */
      if(c=='?'){  /* begin IF */
        c=GETC; c=(c=='0') ? 9 : (c-'1');
	if(c>=0 && c<argc && argv[c][0]){
	  /* OK */
	  continue;
	} else {
	  /* not, FALSEMOD */
	  int fc=0;
	  while(1){
		c=GETC; if(c<=0){ fprintf(stderr,"Unexpected EOF between %?n and %.\n");exit(1);}
		if(c=='\\'){ c=GETC;continue;}
		if(c=='%'){
		  c=GETC;
		  if(c=='%') continue;
		  if(c=='?') ++fc; else
		  if(c=='.'){ --fc; if(fc<0) break;}
		}
	  }
	  continue;
	}
      }
      c=(c=='0') ? 9 : (c-'1');
      if(c>=0 && c<argc){
        char *m=argv[c];
        print_str(&m,argc,argv);
      }
      else fprintf(stderr,"Missing argument: %%%d\n",c+1);
      continue;
    }
  }
okchr:
  if(c==10) ++putc_10; else putc_10=0;
  if(putc_10<3) putchar(c); 
}

}


int main(int argc, char* argv[]){

g_argc=argc; g_argv=argv;

print_str(NULL,argc,argv);

#if 0
fprintf(stderr,"------------- MACRO LIST: ------------------\n");
{macro *p;
p=m_first;
while(p){
  fprintf(stderr,"name='%s'  content='%s'\n",p->name,p->body);
p=p->next;
}}
#endif

return 0;
}
