#define VERSION "\nAdvanced FTP v0.3   (C) 1999 by Arpad Gereoffy (A'rpi/ESP-team)"

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "ftplib.h"

/*****************************************************************************/

#define KEEPALIVE

// #define FIX_NAME
#define SOR_MAXSIZE 256
#define MAX_NAMELEN 80
#define MAX_BACK 64
#define WGET_FILE "wget-it"
#define WGET_OPTS "wget -c -x -r -t 0 -T 120"
#define TMP_BASE "/tmp/tmp.aftp-%d"
#define FAKE_EMAIL "aftpuser@mail.untraceable.org"

int reconnect_timeout=-1;

/*****************************************************************************/

#define TMP_LS tmp_name
char tmp_name[32];

typedef struct _entry_st {
  char name[MAX_NAMELEN];
  char mode[12];
  int size;
  int selected;
  struct _entry_st *next;
} entry_st;

typedef struct _list_st {
  char path[128];
  entry_st *e_first;
  int n;
  struct _list_st *next;
} list_st;

list_st *back_list[MAX_BACK];
int back_ptr=0;
int back_max=0;

#define E_NULL (entry_st *)NULL
#define L_NULL (list_st *)NULL
#define E_ALLOC(e) e=malloc(sizeof(entry_st));
#define E_DISP(e) printf("%10s [%8d] '%s'\n",e->mode,e->size,e->name);
#define L_ALLOC(e) e=malloc(sizeof(list_st));

list_st *l_first=L_NULL;
list_st *l_current=L_NULL;
entry_st *e_first;

static netbuf *conn = NULL;
char path[256];
int path_ok=0;
int refresh=0;

/*****************************************************************************/

#ifdef USE_READLINE

// #include <readline/readline.h>

extern char *readline(char *prompt);
extern void add_history(char *line);

void do_gets(char *prompt, char *sor){
char *line_read;
  line_read = readline (prompt);
  if(line_read){
    if(*line_read) add_history(line_read);
    strcpy(sor,line_read);
    free(line_read);
  } else sor[0]=0;
}

#else

void do_gets(char *prompt, char *sor){
  printf("%s",prompt);fflush(stdout);   // draw prompt
  gets(sor);                            // read command
  if(sor[strlen(sor)-1]==10) sor[strlen(sor)-1]=0;
}

#endif

/*****************************************************************************/
int waiting_for_key=0;

#ifdef KEEPALIVE

int keepalive_time=25;
int keepalive_maxtime=60*15;
int keepalive_count=0;
int keepalive_enable=0;

#include "signal.c"

#define SET_SIGHANDLER bsd_signal(SIGALRM,sig_handler)

void sig_handler(int signum){
  if(!waiting_for_key){
    alarm(1);  // try again later
  } else {
    alarm(0);
    if( (keepalive_count+=keepalive_time) > keepalive_maxtime && keepalive_maxtime ){
      // timeout :(
      if(FtpClose(conn)) printf("Connection closed.\n");
      unlink(TMP_LS);
      exit(0);
    }
    FtpPwd(path, 256, conn);
    // FtpSendCmd("PWD",'2',conn);  // Doing something
//    printf("[KA#%d]",keepalive_count);fflush(stdout);   //!!!!!
    alarm(keepalive_time);
  }
  SET_SIGHANDLER;
}  

#define KA_ENABLE if(!keepalive_enable){ alarm(keepalive_time);keepalive_enable=1;keepalive_count=0; }
#define KA_DISABLE alarm(0); keepalive_enable=0;

#else

#define KA_ENABLE
#define KA_DISABLE

#endif
/*****************************************************************************/

int cmpnames(char *n,char *m){
next:
  if(m[0]=='*'){
    int i;
    m++;
    if(m[0]==0) return 1;
    while(n[0]){
      if(cmpnames(n,m)) return 1;
      n++;
    }
    return 0;
  }
  if(n[0]==m[0] || (m[0]=='?' && n[0])){
    if(n[0]==0) return 1;
    n++;m++;
    goto next;
  }
  return 0;
}

int cmpnames2(char *n,char *m,int i){
int j;
  if(m[0]=='!'){
    j=atoi(&m[1]);
//    printf("!!! j=%d\n",j);
    if(j==i) return 1;
    return 0;
  } else return cmpnames(n,m);
}

/*****************************************************************************/

int cut_symlink(char *sor){
char *p=strstr(sor," -> ");
  if(!p)  return 0;
  p[0]=0; return 1;
}

int cut_symlink2(char *sor_in, char *sor){
char *p;
  strcpy(sor,sor_in);
  p=strstr(sor," -> ");
  if(!p)  return 0;
  p[0]=0; return 1;
}

/*****************************************************************************/


entry_st* parse_line(char *sor){
int p[32];
int i=0,j=0,k;
char *err;
entry_st *e;

uj:
  while(sor[i]==' ' || sor[i]==9) i++;      // skip spaces
  p[j]=i;j++;
  while(sor[i]!=' ' && sor[i]) i++;
  if(sor[i] && j<9){
    sor[i]=0;i++;
    goto uj;
  }

// for(i=0;i<j;i++) printf("p[%d] = '%s'\n",i,&sor[p[i]]);

  if(j<9) return E_NULL;
  E_ALLOC(e);

  strncpy(e->mode,&sor[p[0]],12);
  e->size=strtol(&sor[p[4]],&err,10); if(err[0]!=0) e->size=-1;
  strcpy(e->name,&sor[p[8]]);
  e->next=E_NULL;
  e->selected=0;
  
//  E_DISP(e);
  return e;
}

/*****************************************************************************/

void free_list(list_st *l){
entry_st *e,*ee;
  e=l->e_first;
  while(e){
    ee=e->next;
    free(e);
    e=ee;
  }
  free(l);
}

int read_list(){
char sor[SOR_MAXSIZE];
list_st *lp,*lpp;
entry_st *e,*ep;
FILE *ls;

if(!path_ok){
//   printf("*** PWD x ***\n");
  KA_DISABLE; FtpPwd(path, 256, conn);
  path_ok=1;
}

lp=l_first;
while(lp){
  if(strcmp(path,lp->path)==0){
    e_first=lp->e_first;    // megvan!
    l_current=lp;
    if(refresh){
      if(lp==l_first) l_first=lp->next; else lpp->next=lp->next;
      free_list(lp);
      goto readdir;
    }
    return 0;
  }
  lpp=lp;
  lp=lp->next;
}

readdir: printf("Reading FTP directory...");fflush(stdout);
refresh=0;

KA_DISABLE;
if(!FtpDir(TMP_LS, NULL, conn))  {printf(" Failed\n");return 1;}
ls=fopen(TMP_LS,"rb"); if(!ls) {printf(" Failed\n");return 1;}

L_ALLOC(lp); l_current=lp;
strcpy(lp->path,path);
lp->next=l_first; l_first=lp;  // beszuras lista elejere!
lp->e_first=E_NULL;
lp->n=0;

while(!feof(ls)){
  fgets(sor,SOR_MAXSIZE,ls); if(sor[strlen(sor)-1]==10) sor[strlen(sor)-1]=0;
  e=parse_line(sor);
  if(e){  // beszuras lista vegere!
    if(lp->e_first) ep->next=e; else lp->e_first=e;
    ep=e;
    lp->n++;
  }
}
fclose(ls);
printf(" OK.\n");
e_first=lp->e_first;
return 0;
}

void disp_list(){
entry_st *e;
//  if(!read_list()) return;
  read_list();
  printf("DIRECTORY of '%s'\n",path);
  e=e_first;
  while(e){
    E_DISP(e);
    e=e->next;
  }
  printf("--------- end ------------\n");
}

/*****************************************************************************/

#ifdef FIX_NAME

static char fixed_name[256];

/* beteszi ""-be a nevet ha speci */
char* fix_name(char *p){
int i;
  for(i=0;i<strlen(p);i++){
    int c=p[i];
    if( (c>='0' && c<='9') || (c>='a' && c<='z') || (c>='A' && c<='Z')
        || (i && c=='-') || c=='_' || c=='%' ){
    } else {
      sprintf(fixed_name,"\"%s\"",p);
      return fixed_name;
    }
  }
  return p;
}

#else
#define fix_name(x) x
#endif

/*****************************************************************************/

int aftp_chdir(char *p){
  int ret;
  KA_DISABLE;
  ret=FtpChdir(fix_name(p), conn);
  if(!ret){
    char p2[256];
    if(cut_symlink2(p,p2)){
      ret=FtpChdir(fix_name(p2), conn);
    }
  }
  printf("%s",FtpLastResponse(conn));
  path_ok=0;
  return ret;
}

int aftp_cdup(){
  path_ok=0;
  KA_DISABLE;
  return FtpCDUp(conn);
}

entry_st* aftp_names[8192];
int aftp_name_db=0;

#define BACK_SAVE back_list[back_ptr % MAX_BACK]=l_current

void aftp_build_dir(){
entry_st *e;
  read_list(); BACK_SAVE;
  e=e_first;
  aftp_name_db=0;
  while(e){
    aftp_names[aftp_name_db]=e; ++aftp_name_db;
    e=e->next;
  }
}

/*
void aftp_list_dir(char *mask,int sel){
int i;
int siz=0;
int db=0;
  printf("--------- DIRECTORY of '%s' ---------\n",path);
  for(i=0;i<aftp_name_db;i++){
    if(  (mask==NULL || cmpnames2(aftp_names[i]->name,mask,i)) &&
         (!sel || aftp_names[i]->selected)  ){
	if(aftp_names[i]->selected) printf("* "); else printf(". ");
	printf("%3d: ",i);E_DISP(aftp_names[i]);
	++db;siz+=aftp_names[i]->size;
    }
  }  
  printf("------- %d files in %d bytes-------\n",db,siz);
}
*/

static int log_progress(netbuf *ctl, int xfered, void *arg)
{
    int fsz = *(int *)arg;
    if(fsz>0){
      int pct = (xfered * 100) / fsz;
      printf("\r%3d%%  %d/%d", pct, xfered,fsz);
    }else{
      printf("\r%d", xfered);
    }  
    fflush(stdout);
    return 1;
}

int aftp_get(char *fnm_in,int fsz){
int ret;
int xfered;
list_st *prev_path;
char fnm[256];
  KA_DISABLE;
  strcpy(fnm,fnm_in); // symlink miatt
  do{
    if(fsz<=0) if (!FtpSize(fnm, &fsz, 'I', conn)) fsz=0;    // get file size
    FtpOptions(FTPLIB_CALLBACK, (long) log_progress, conn);
    FtpOptions(FTPLIB_IDLETIME, (long) 1000, conn);
    FtpOptions(FTPLIB_CALLBACKARG, (long) &fsz, conn);
    FtpOptions(FTPLIB_CALLBACKBYTES, (long) 4096, conn);
    printf("GET %s\n",fnm);
    ret=FtpGet(fnm,fix_name(fnm),'I',conn,&xfered);
    log_progress(conn, xfered, (void*) &fsz);
    FtpOptions(FTPLIB_CALLBACK, (long) NULL, conn);
    if(ret){printf("  Ok.\n"); return ret;}
    // Failed. Talan link???
  }while(cut_symlink(fnm));
    printf("  Not found\n");
    // Failed. Talan directory???
    prev_path=l_current;
    ret=aftp_chdir(fnm);
    if(ret){
      // igen, directory! :)    na akkor rekurzio rulez...
      if( mkdir(fnm,0777) || chdir(fnm) ){
        printf("Cannot create local directory!\n");
      } else {
        int i;
        aftp_build_dir();          // read directory
	printf("[!!!] path=%s    names=%d\n",path,aftp_name_db);
	for(i=0;i<aftp_name_db;i++)
	  if(strcmp(aftp_names[i]->name,".") && strcmp(aftp_names[i]->name,"..")){
	    aftp_get(aftp_names[i]->name,aftp_names[i]->size);
	  }
      }
      chdir("..");
      aftp_chdir(prev_path->path);
      aftp_build_dir();  // "read" directory  (it MUST be in the cache)
    }
return ret;
}

/*****************************************************************************/
int prompt_ask(char *name,int size){
char ret[256];
  while(1){
    printf("[%8d] %s (Y/n)? ",size,name);fflush(stdout);
    KA_ENABLE;
    waiting_for_key=1; gets(ret); waiting_for_key=0;
//    printf("[%d][%d]\n",(int)ret[0],(int)ret[1]);
    if(ret[0]==10 || ret[0]==0) return 1;
    if(ret[1]!=10 && ret[1]!=0 ) continue;
    if(ret[0]=='Y' || ret[0]=='y') return 1;
    if(ret[0]=='N' || ret[0]=='n') return 0;
  }
}

/*****************************************************************************/

int main(int argc, char *argv[])
{
char user[32];
char pass[32];
char host[64];
char _sor[256];
char *sor=_sor;
int req_do_list=0;
// int files_only,dirs_only,selected_only;
char prompt[256];
char cmd;

puts(VERSION);

sprintf(tmp_name,TMP_BASE,getpid());
#ifdef DEVELOPMENT
  printf("Using %s for temp.\n",TMP_LS);
#endif

if(argc>1){
  int i;
  char *s=strchr(argv[1],'@');
  if(s){
    s[0]=0;s++;
    strcpy(user,argv[1]);
    if(user[0]==0) strcpy(user,"anonymous");
    strcpy(host,s);
    strcpy(pass,getpass("Password: "));
  }else{
    strcpy(user,"anonymous");
    strcpy(host,argv[1]);
    strcpy(pass,FAKE_EMAIL);
  }
} else {
#ifdef DEVELOPMENT
  strcpy(user,"arpi");
  strcpy(host,"localhost");
  strcpy(pass,"");
#else
  puts("\nUsage:");
  puts("  aftp host         - connect to 'host' as anonymous with fake password");
  puts("  aftp @host        - connect to 'host' as anonymous and ask password");
  puts("  aftp user@host    - connect to 'host' as 'user' and ask password");
  exit(1);
#endif
}

puts("Type ? for quick help or read aftp.txt for details!\n");

reconnect:
    	if (!FtpConnect(host,&conn))
    	{
	    fprintf(stderr,"Unable to connect\n%s",ftplib_lastresp);
	    return 1;
    	}
printf("Connected to host: %s\n",host);
    	if (!FtpLogin(user,pass,conn))
    	{
	    fprintf(stderr,"Login failure\n%s",FtpLastResponse(conn));
	    if(FtpClose(conn)) printf("Connection closed.\n");
	    if(reconnect_timeout<0){
	      printf("Reconnect timeout: ");gets(sor);
	      if(sor[0]>='0' && sor[0]<='9') reconnect_timeout=atoi(sor);
	    }
	    if(reconnect_timeout>=0){
	      if(reconnect_timeout>0) sleep(reconnect_timeout);
	      goto reconnect;
	    }
	    return 1;
    	}
printf("%s",FtpLastResponse(conn));

/************** MAIN LOOP **********************/

#ifdef KEEPALIVE
    SET_SIGHANDLER;
#endif

    refresh=1;
    req_do_list=0;

while(1){
    
    aftp_build_dir();

    if(req_do_list){
      strcpy(sor,"l");
      req_do_list=0;
    } else {
      sprintf(prompt,"%s:>",path);
      KA_ENABLE;
      waiting_for_key=1;  do_gets(prompt,sor);  waiting_for_key=0;
    }
    
    if(sor[0]==0) continue;

    if(sor[0]=='q') break;                   // q = QUIT


    cmd=sor[0];
    if(cmd=='l' || cmd=='g' || cmd=='+' || cmd=='-' || cmd=='w'){
      int files_only=0,dirs_only=0,selected_only=0,prompt_mode=0;
      int i;
      char prefix=0;
      int siz=0;
      int db=0;
      int list=0;
      FILE* wget;

      ++sor;
      if(cmd=='+' || cmd=='-')
        if(sor[0]=='+' || sor[0]=='-')
          { prefix=cmd;cmd=sor[0];++sor; }
      if(sor[0]=='s'){++selected_only;++sor;}
      if(sor[0]=='f'){++files_only;++sor;}
      if(sor[0]=='d'){++dirs_only;++sor;}
      if(sor[0]=='p'){++prompt_mode;++sor;}
      if(sor[0]==' ') ++sor;
      if(cmd=='w' || cmd=='l' || cmd=='+') list=1;

      if(cmd=='w'){      
        wget=fopen(WGET_FILE,"a");
        if(!wget){
          printf("Cannot open script file '%s'\n",WGET_FILE);
	  continue;
        }
      }

      if(list) printf("--------- DIRECTORY of '%s' ---------\n",path);

      for(i=0;i<aftp_name_db;i++){
        entry_st *e=aftp_names[i];
	  if( (!sor[0] || cmpnames2(e->name,sor,i) )
           && (!selected_only || e->selected)
           && (!files_only || e->mode[0]=='-')
           && (!dirs_only  || e->mode[0]=='d')
           && (!prompt_mode || prompt_ask(e->name,e->size) )
	  ){
	    if(cmd=='+') e->selected=1; else
	    if(cmd=='-') e->selected=0; else
	    if(cmd=='g') aftp_get(e->name,e->size);
	    if(cmd=='w') fprintf(wget,"%s \"ftp://%s:%s@%s%s/%s\"\n",WGET_OPTS,user,pass,host,path,e->name);
	    if(list) {
	      printf("%c %3d: ",(e->selected ? '*':'.'),i);
	      E_DISP(aftp_names[i]);
	      ++db;siz+=e->size;
	    }
	  } else {
            if(prefix=='+') e->selected=1; else
            if(prefix=='-') e->selected=0;
	  }
      }

      if(cmd=='w') fclose(wget);

      if(list) printf("------- %d files in %d bytes-------\n",db,siz);
      continue;
    
    }


    if(strcmp(sor,"help")==0 || sor[0]=='?'){                    // ? = HELP
      FILE *f;
      int i;
      char nev[256];
      sprintf(nev,"%s.help",argv[0]);
      f=fopen(nev,"r");
      if(!f){
        printf("Cannot open help file: %s\n",nev);
	continue;
      }
      while(i=fread(nev,1,256,f)) fwrite(nev,1,i,stdout);
      fclose(f);
      continue;
    }

    if(strncmp(sor,"keep ",4)==0){                    // KEEP alive
#ifdef KEEPALIVE
      char *p=strchr(&sor[5],',');
      if(p){
	keepalive_maxtime=60*atoi(&p[1]);
        p[0]=0;
      }
      if(sor[5]) keepalive_time=atoi(&sor[5]);
      printf("Keepalive set to time: %d sec  max: %d minutes\n",keepalive_time,keepalive_maxtime);
      alarm(keepalive_time);
#else
      printf("This version of aftp is compiled WITHOUT keepalive function\n");
#endif
      continue;
    }

    if(sor[0]=='.'){                        // .|..   = REFRESH | CDUP
      if(sor[1]=='.') {
        if(!aftp_cdup()) continue;
	back_max=++back_ptr;
      } else refresh=1;
      req_do_list=1;
      continue;
    }

    if(sor[0]=='>' || sor[0]=='<'){              // < | > | > dir   back|fw|CD
      if(sor[1]==0 || sor[1]=='<' || sor[1]=='>'){
        while(sor[0]){
	  if(sor[0]=='<') if(back_ptr>0) --back_ptr;
	  if(sor[0]=='>') if(back_ptr<back_max) ++back_ptr;
	  ++sor;
	}
        aftp_chdir(back_list[back_ptr % MAX_BACK]->path);
      } else {
        char *s=&sor[1];
	int i,j=0;
	if(s[0]=='!'){
	  i=atoi(&s[1]);
	  if(i>0 && i<aftp_name_db) s=s=aftp_names[i]->name;
	} else
	for(i=0;i<aftp_name_db;i++){
	  if( ( aftp_names[i]->mode[0]=='d' ||  aftp_names[i]->mode[0]=='l' )
 	   && cmpnames(aftp_names[i]->name,&sor[1]) ){
  	    ++j;s=aftp_names[i]->name;
	  }
        }
        if(!aftp_chdir(s)) continue;
	back_max=++back_ptr;
      }
      req_do_list=1;
      continue;
    }
    
    if(sor[0]=='h'){                    // h = path History
      int i;
      for(i=0;i<=back_max;i++){
        printf("%2d [%c] %s\n",i,(i==back_ptr ? 'X' : ' '),back_list[i]->path);
      }
      continue;
    }
    

    printf("Unknown command: %s\n",sor);

}
#ifdef KEEPALIVE
    alarm(0);
#endif

    if(FtpClose(conn)) printf("Connection closed.\n");
    unlink(TMP_LS);
    return 0;
}


