/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * From: @(#)display.c	5.4 (Berkeley) 6/1/90
 */
char display_rcsid[] = 
  "$Id: display.c,v 1.6 1997/04/06 00:07:37 dholland Exp $";

/*
 * The window 'manager', initializes curses and handles the actual
 * displaying of text
 */
#include "talk.h"
#include <string.h>
#include <unistd.h>

/**************************************************/

history_line *log_next=H_NULL;
history_line *log_first=H_NULL;
char remote_name[256];

void add_history(history *h,int local){
history_line *last=h->last;
history_line *hl=(history_line*)malloc(sizeof(history_line)+h->curr_len);
char *line=&hl->first_char;
  if(!hl) return;
  memcpy(line,h->curr_line,h->curr_len); line[h->curr_len]=0;
  h->curr_len=0;
  hl->prev=last; if(last) last->next=hl;
  hl->next=H_NULL;
  hl->local=local;
  if(log_next) log_next->log_next=hl; log_next=hl; if(!log_first) log_first=hl;
  h->last=hl;    if(!h->first) h->first=hl;
  ++h->line_db;
}


history* alloc_history(){
history *h=(history*)malloc(sizeof(history));
  if(!h) return h;
  h->line_db=0;
  h->first=H_NULL;
  h->last=H_NULL;
  h->curr_len=0;
  return h;
}

void save_history(){
history_line *hl=log_first;
FILE *f;
char name0[256];
char name1[256];
  add_history(my_win.hist,1);
  add_history(his_win.hist,0);
  f=fopen("talk.log","w");
  if(strcmp(getlogin(),remote_name)==0){
    /* ugyanaz az usernevuk */
    strcpy(name0,"R");
    strcpy(name1,"L");
  } else {
    int len=strlen(getlogin());
    if(len<strlen(remote_name)) len=strlen(remote_name);
    sprintf(name0,"%*s",len,remote_name);
    sprintf(name1,"%*s",len,getlogin());
  }
  while(hl){
    fprintf(f,"%s> %s\n",hl->local ? name1 : name0, &hl->first_char);
    hl=hl->log_next;
  }
  fclose(f);
}

/**************************************************/

void draw_scrolled_window(xwin_t *win){
history* h=win->hist;
history_line* hl=h->last;
int i;
  for(i=0;i<win->scroll-1 && hl;i++) hl=hl->prev;
  
  i=win->x_nlines; if(win->scroll==0) --i;
  while(--i>=0){
    wmove(win->x_win, i, 0);
    if(hl){
	char *sor=&hl->first_char;
	while(sor[0]) {waddch(win->x_win,sor[0]);++sor;}
	hl=hl->prev;
    }
    wclrtoeol(win->x_win);
  }

  if(win->scroll==0){
    wmove(win->x_win, win->x_nlines-1, 0);
    for(i=0;i<h->curr_len;i++) waddch(win->x_win, h->curr_line[i]);
    wclrtoeol(win->x_win);
  }
  wrefresh(win->x_win);
}

/**************************************************/

static void xscroll(xwin_t *win, int flag);

xwin_t	my_win;
xwin_t	his_win;
WINDOW	*line_win;

int	curses_initialized = 0;

/*
 * max HAS to be a function, it is called with
 * a argument of the form --foo at least once.
 */
/*
static int max(int a, int b)
{
	return (a > b ? a : b);
}
*/

#define DEL_CHAR(n) {memcpy(text,text+n,n);size-=n;siz-=n-1;}

/*
 * Display some text on somebody's window, processing some control
 * characters while we are at it.
 */
int display(xwin_t *win, unsigned char *text, int size, int local)
{
	unsigned char cch;
	int siz=size;
	history* h=win->hist;

	while(--siz>=0){

		if (*text == '\n') {
			xscroll(win, 0);
			text++;
			continue;
		}

		/* someday erase characters will work properly in unix */
		/* backspace=del=ctrl+d= erase_char */
		if (*text == 8 || *text == 127 || *text == 4 || *text == win->cerase)
		{
		        *text=win->cerase; /* will sent to remote host */
		if(win->scroll==0){
#if 0
			wmove(win->x_win, win->x_line, max(--win->x_col, 0));
			getyx(win->x_win, win->x_line, win->x_col);
			waddch(win->x_win, ' ');
			wmove(win->x_win, win->x_line, win->x_col);
#else
			waddch(win->x_win, '\b');
			waddch(win->x_win, ' ');
			waddch(win->x_win, '\b');
#endif
			getyx(win->x_win, win->x_line, win->x_col);
		}
			if(h->curr_len) --h->curr_len;
			text++;
			continue;
		}
		/*
		 * On word erase search backwards until we find
		 * the beginning of a word or the beginning of
		 * the line.
		 */
		if (*text == win->werase || *text=='O'-64) {
			int xcol,c;
			*text=win->werase;  /* will sent */

#if 0
			endcol = win->x_col;
			xcol = endcol - 1;
			while (xcol >= 0) {
				c = readwin(win->x_win, win->x_line, xcol);
				if (c != ' ')
					break;
				xcol--;
			}
			while (xcol >= 0) {
				c = readwin(win->x_win, win->x_line, xcol);
				if (c == ' ')
					break;
				xcol--;
			}
			wmove(win->x_win, win->x_line, xcol + 1);
			for (i = xcol + 1; i < endcol; i++)
				waddch(win->x_win, ' ');
			wmove(win->x_win, win->x_line, xcol + 1);
			getyx(win->x_win, win->x_line, win->x_col);
#else
			xcol = h->curr_len-1;
			while (xcol >= 0) {
				c = h->curr_line[xcol];
				if (c != ' ')break;
				xcol--;
			}
			while (xcol >= 0) {
				c = h->curr_line[xcol];
				if (c == ' ')break;
				xcol--;
			}

			h->curr_len=xcol+1;
		if(win->scroll==0){
			wmove(win->x_win, win->x_line, xcol + 1);
			wclrtoeol(win->x_win);
			getyx(win->x_win, win->x_line, win->x_col);
		}
#endif
  		        text++;
			continue;
		}
		
	if(local){
		
		if(*text=='P'-64) {    /* ctrl+P = local up */
		  ++win->scroll;
		  draw_scrolled_window(win);
		  /* wscrl(win->x_win,-3); */
		  DEL_CHAR(1);  continue;
		}
		if(*text=='N'-64) {    /* ctrl+N = local down */
		  if(win->scroll>0){
		      --win->scroll;
		      draw_scrolled_window(win);
		  }
		  DEL_CHAR(1);  continue;
		}

		if(*text=='U'-64) {    /* ctrl+U = remote up */
		  ++his_win.scroll;
		  draw_scrolled_window(&his_win);
		  return 0;
		  /* DEL_CHAR(1);  continue; */
		}
		if(*text=='V'-64) {    /* ctrl+V = remote down */
		  if(his_win.scroll>0){
		      --his_win.scroll;
		      draw_scrolled_window(&his_win);
		  }
		  return 0;
		  /* DEL_CHAR(1);  continue; */
	    }
		
	}
		
		/* line kill */
		if (*text == win->kill) {
		    if(win->scroll==0){
			wmove(win->x_win, win->x_line, 0);
			wclrtoeol(win->x_win);
			getyx(win->x_win, win->x_line, win->x_col);
		    }
			h->curr_len=0;
			text++;
			continue;
		}
		if (*text == '\f') {
			if (win == &my_win) wrefresh(curscr);
			text++;
			continue;
		}
		if (*text == '\a') {
			beep();
			wrefresh(curscr);
			text++;
			continue;
		}
		if (win->x_col == COLS-1) {
			/* check for wraparound */
			xscroll(win, 0);
		}
		if (*text < ' ' && *text != '\t') {
			cch = (*text & 63) + 64;
		    if(win->scroll==0){
			waddch(win->x_win, '^');
			getyx(win->x_win, win->x_line, win->x_col);
			if (win->x_col == COLS-1) /* check for wraparound */
				xscroll(win, 0);
			waddch(win->x_win, cch);
		    }
			h->curr_line[h->curr_len++]='^';
			h->curr_line[h->curr_len++]=cch;
		} else {
		    if(win->scroll==0)	waddch(win->x_win, *text);
		    h->curr_line[h->curr_len++] = *text;
		}
		getyx(win->x_win, win->x_line, win->x_col);
		text++;
	}
	wrefresh(win->x_win);
return size;
}


/*
 * Scroll a window, blanking out the line following the current line
 * so that the current position is obvious
 */
 
/* flag==0 !! */
static void xscroll(xwin_t *win, int flag)
{

	if (flag == -1) {
		wmove(win->x_win, 0, 0);
		win->x_line = 0;
		win->x_col = 0;
		return;
	}
	if(win->scroll==0) waddch(win->x_win, '\n');
	add_history(win->hist,win->local);
/*
	win->x_line = (win->x_line + 1) % win->x_nlines;
	win->x_col = 0;
	wmove(win->x_win, win->x_line, win->x_col);
	wclrtoeol(win->x_win);
	wmove(win->x_win, (win->x_line + 1) % win->x_nlines, win->x_col);
	wclrtoeol(win->x_win);
	wmove(win->x_win, win->x_line, win->x_col);
*/
}
