/*

	####################################################################

	Programa Ejemplo de un Codificador Digital Catico

	####################################################################

	Autor         : JEM, El Gran Cirimbolo
	Fecha					: 10 de Agosto 1994
	Versin				: 0.0
	Descripcin   : Se implementan dos rutinas para realizar la codificacin
								 y decodificacin de un texto introduccido por teclado y se
								 construye un interface para ilustrar someramente el funcio-
								 namiento de este tipo de codificacin.
									En la primera ventana escribimos nuestro texto, el cual
								 aparecer en la segunda ventana codificado para terminar de-
								 codificado en la tercera ventana.

	Para ms informacin:

		Chaotic Digital Encoding: An Approach to Secure Communication
		Douglas R. Frey, Senior Member, IEEE

	IEEE TRANSACTIONS ON CIRCUITS & SYSTEMS-II:ANALOG AND DIGITAL SIGNAL PROCESSING
	Vol. 40 NO.10 October 1993

	########################################################################
*/


#include <conio.h>
#include "twin.h"


typedef unsigned char	letra;

unsigned char	ncodec   (unsigned char);
unsigned char	ndecodec (unsigned char);

main()
{
VENTANA	win,win1,win2;
char		c,d;

textcolor (YELLOW);
textbackground (RED);
clrscr();

/* Inicializamos las ventana */
escribe_centrado ("Ventana transmisin : Mensaje original",1);
win = inic_ventana (1,2,79,6);
color_ventana (win,YELLOW,BLUE);
borrar (win);


escribe_centrado ("Ventana canal : Mensaje codificado",9);
win1 = inic_ventana (1,10,79,6);
color_ventana (win1,BLUE,CYAN);
borrar (win1);

escribe_centrado ("Ventana recepcin : Mensaje decodificado",17);
win2 = inic_ventana (1,18,79,6);
color_ventana (win2,YELLOW,BLUE);
borrar (win2);

textcolor (WHITE);
escribe_centrado ("Codificacin Digital Catica - (c) Josema 10 de Agosto de 1994",25);


do
	{
		c = getch();
		escribe_caracter (win,c);
		d = ncodec (c);
		escribe_caracter (win1,d);
		escribe_caracter (win2,ndecodec(d));

	}while ((c!=27));

/* Liberamos la memoria y terminamos el programa */
free (win);
free (win1);
free (win2);

textcolor (LIGHTGRAY);
textbackground (BLACK);
clrscr();
puts ("\rQue el Chunflusco ciricanzov te acompae...");
puts ("\rSaludos a Rainbowner y McJorge de JEM el Gran Cirimbolo");

}



unsigned char ncodec (unsigned char c)
{
static char e=0,e1=3,e2=132,s=0;

s  = (e2>>7)&1;
e  = (c + (e1 + 2*e2 +s) )&0x00ff;
e2 = e1;
e1 = e;

return (unsigned char) e;
}

unsigned char ndecodec (unsigned char c)
{
static char e=0,e1=240,e2=12,s=0;

s  = (e2>>7)&1;
e  = (c - (e1 + 2*e2 +s) )&0x00ff;
e2 = e1;
e1 = c;

return (unsigned char) e;
}
