*These routines were passed to me for some reason or another,they are
*related to the TNY graphic format.One of them is a decompression routine
*which could be very useful.None of them have been tested or used by me.

*                                                     CHRIS   -  EMERALD CITY





	SECTION TEXT
*===============================================================*
*  TNY file routines        *
* tny_move - Move tny files to odd address   *
* set_palette - Set palette from a tny file   *
* pic_expand - Expands a TNY file    *
*===============================================================*
*****************************************************************
* Move TNY files down by one byte so that the palette is on  *
* an even boundary, as the first byte of a TNY file is the   *
* screen mode indicator.     *
* The TNY files must be from (A0) to (A1)   *
*****************************************************************
tny_move
	MOVEM.L D0/D1/A0/A1,-(SP)
	MOVE.L A1,D0
	SUB.L A0,D0  ;LENGTH IN D0
	SUB.L #1,D0  ;In case over 1 word
	CLR.L D1  ;put upper bit in d1
	MOVE.L D0,D1
	SWAP D1
	MOVE.L A0,A1
	SUB.L #1,A1
.lp MOVE.B (A0)+,(A1)+
	DBF D0,.lp
	DBF D1,.lp
	MOVEM.L (SP)+,D0/D1/A0/A1
	RTS
*****************************************************************
* Sets the palette from TNY data in (A5)   *
* So can be called directly after pic_expand as registers are *
* preserved and will be pointing to the correct place.  *
* To call as stand-alone....     *
* LEA    picture,A5     *
* BSR  set_palette     *
*****************************************************************
set_palette
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L A5,-(SP)  ;Address of palette
	MOVE.W #6,-(SP)
	TRAP #14
	ADDQ.L #6,SP
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS
*****************************************************************
* pic_expand takes a tiny file pointed to by A5    *
* and expands it into address in A3.         *
* eg.        *
* BSR  tny_move     *
*        *
* LEA   pic_0,A5 Address of picture to expand *
* MOVE.L scr_work,A3 Put at address in scr_work *
* BSR  pic_expand Expand it   *
* BSR  set_palette and set the correct palette *
*        *
* dummy  DC.W 0   Dummy required as files moved down  *
* pic_0  INCBIN  "ascreen.tny"    *
* pic_2  INCBIN "bscreen.tny"    *
* etc.....       *
* pic_E  * This marks end of screen files for TNY_MOVE *
*****************************************************************
pic_expand
	MOVEM.L D0-D7/A0-A6,-(SP)
	SUB.L #1,A5   ;Subtract 1 as TNY files on odd boundary!
	LEA tny_work_area,A4 ;A4 IS work area
	BSR.W TNY_CONVERT
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS
*************************************************************
* Expand a TNY format low rez file into 'screen data'       *
*************************************************************
*
TNY_CONVERT ;EXPAND FROM (A5) TNY FILE
	 ;TO (A3) SCREEN USING (A4) WORK AREA
*
	LEA $25(A5),A0 ;ADDR OF 1ST DATA AREA
	MOVE.W $21(A5),D0 ;LENGTH OF 1ST DATA AREA
	EXT.L D0  ;LONG
	ADD.L D0,A0  ;ADD 'EM GIVING START OF 2ND
	CLR.L D0
	MOVE.W $23(A5),D0
	ASL.L #1,D0
	MOVE.L A4,-(SP)
.LOOP MOVE.B (A0)+,(A4)+
	DBF D0,.LOOP
	MOVE.L (SP)+,A4
*
	clr.l d0
	clr.l d2
	clr.l d3
	LEA $25(A5),A2
*
	bra.b NEXT
LOOP1
	BSR.W GET_WORD
	tst.w d1
	bge.b LOOP3
	neg.w d1
	bra.b LOOP2
MOVE2
	move.w $0(a4,d2.w),$0(a3,d0.w)
	addq.w #2,d2
	BSR.S INC_D0
LOOP2
	dbf d1,MOVE2
	bra.b NEXT
MOVE3
	move.w $0(a4,d2.w),$0(a3,d0.w)
	BSR.S INC_D0
LOOP3
	dbf d1,MOVE3
	addq.w #2,d2
NEXT
	CMP.W $21(A5),D3
	blt.b LOOP1
	rts
*****************************************
GET_WORD 
	clr.l d1
	tst.b $0(a2,d3.w)
	beq.b .OK1
	cmpi.b #$1,$0(a2,d3.w)
	beq.b .OK1
	move.b $0(a2,d3.w),d1
	ext.w d1
	addq.w #1,d3
	bra.b .EXIT
.OK1 lea $0(a2,d3.w),a0
	move.b (a0)+,d1
	move.b (a0)+,TNY_WRK1
	move.b (a0)+,TNY_WRK1+1
	addq.w #3,d3
	cmp.b #$1,d1
	bne.b .OK2
	neg.w TNY_WRK1
.OK2 move.w TNY_WRK1,d1
.EXIT rts
********************************
INC_D0 add.l #$A0,d0
	cmp.l #$7D00,d0
	blt.b .EXIT
	sub.l #$7CF8,d0
	cmp.l #$A0,d0
	blt.b .EXIT
	sub.l #$9E,d0
.EXIT rts
	SECTION BSS
TNY_WRK1 DS.B 2
tny_work_area  DS.B 30000 ;Work area to expand tiny files (could
	   ;use a lot less?)
	EVEN
