	include stosmacr.i
interpreter equ 1
debut 	equ 	$92c


* Source name ......: EGCMP2.S
* Object name ......: EG.ECW
* Author ...........: Les Greenhalgh
* Date .............: 27th Oct 1995
* Description ......: Example STOS Compiler Extension II
* Contains 3 new commands and 3 functions
*
*
* Source name .......: EGCMP.S
* Object name .......: EG.ECW
* Author ............: Martin Cubitt
* Date ..............: 15th Oct 1993
* Description .......: Example STOS Compiler extension
*                      Contains 1 new command and 2 new functions:-
*
*			(Remember that a function returns a value)
*
*
*		eg			- this command displays the command
*					list of the EG extension. I think                      
*					all new extensions should have a
*					similar command as an on-line
*					reference to commands available.
*
*		A=range(A,B,C)		- a function which returns a value
*					based on A in the range B to C. If
*					A is less than B then A will become
*					the value of B. If A is greater than
*					C then A will become the value of C.
*					If the value of A >=B and <=C then
*					it will be unchanged.
*
*		A=ndrv			- this function returns the number
*					drives attached to your system (and
*					are available or turned on). If you
*					have the internal, one external and
*					a RAM disk the value will be 2
*					because the internal drive is
*					assumed anyway.
*
*		D=SUM(A)		- this function adds together
*		 =SUM(A,B)		all the parameters which it is
*		 =SUM(A,B,C)		supplied with and returns the
*					result.					
*
*		PUSH(A)			-pushes value onto internal stack
*	
*		=PULL			-retrieves value from internal stack



I	equ	$0
F	equ	$40
S	equ	$80
C	equ	","

* Compiler header

* Parameter list offsets
START:
	dc.l	PARM-START
	dc.l	INIT-START
	dc.l	EG-START

* Library catalog containing length of each library routine
CATALOG:
	dc.w	RANGE-EG	EG
	dc.w	NDRV-RANGE	RANGE
	dc.w	0
	dc.w	PUSH-NDRV	NDRV
	dc.w	SUM-PUSH	push
	dc.w	PULL-SUM 	sum
	dc.w	0
	dc.w	ENDPGM-PULL	pull

* Parameter list for each library routine
* Number of libraries (including dummies)
PARM:
	dc.w	8,8

* Offsets to parameter lists
	dc.w	PEG-PARM
	dc.w	PRANGE-PARM
	dc.w	0
	dc.w	PNDRV-PARM
	dc.w	PPUSH-PARM
	dc.w	PSUM-PARM
	dc.w	0
	dc.w	PNDRV-PARM

* Parameter list
* EG command uses NO parameters so just use end marker of 1,1,0
PEG:
	dc.b	1,1,0
* RANGE function returns 1 integer (1st I) and then A,B,C
PRANGE:
	dc.b	I,I,C,I,C,I,1,1,0
* Dummay parameter list needs no parameter defined
PDUMMY:
	dc.b	1,1,0
* NDRV function returns just one integer parameter
PNDRV:
	dc.b	I,1,1,0

PSUM	dc.b I,I,1
	dc.b I,",",I,1
	dc.b I,",",I,",",I,1,1,0

PPUSH	dc.b I,I,1,1,0

	even
* Initialise the routine
INIT:
	bra	COLDSTART

DATA:
POINTER:	dc.l 0
STORE		ds.l 100

* Actual cold start routine
COLDSTART:
	lea	END(pc),a2
END:
	rts

* eg command
EG:
	init_command 0
	
	lea	EGINFO(pc),a0
	move.w	#1,d7
	trap	#3

	return_to_stos

EGINFO:
	dc.b	10,13,"* EG (Example) extension by M.Cubitt 1993 *"
	dc.b	10,13,"eg................: Information"
	dc.b	10,13,"=range(A,B,C).....: Make A in range B-C"
	dc.b	10,13,"=ndrv.............: No. of drives"
	dc.b	10,13,0

	even

* Range function
RANGE:
	init_command 3
	
	getint d0		;C
	getint d1		;B
	getint d2		;A
	
	cmp.l	d1,d2
	blt.s	TOO_LOW				; A<B so A=B

	cmp.l	d2,d0
	bge.s	OKAY				; Leave A as is

	move.w	d0,d2				; C<A so A=C
	bra.s	OKAY

TOO_LOW:
	move.w	d1,d2

OKAY:
	save_int d2
	return_to_stos

* Number of drives function
NDRV:
	init_command 0

	moveq.l	#0,d0
	move.w	($4a6),d0

	save_int d0			; return parm

	return_to_stos

PUSH:
	init_command 1

	move.l debut(a5),a3
	move.l 0(a3,d1.w),a3
	add.l #4,a3

	getint d0

	lea POINTER-DATA(a3),a0
	move.l (a0),d1
	
	lea STORE-DATA(a3),a1

	add.l d1,a1
	move.l d0,(a1)		

	add.l #4,d1
	move.l d1,(a0)
	return_to_stos


SUM:
	init_command 0
	cmpi.w	#1,d0				;expect 1 parm
	beq.s SUM1
	cmpi.w #2,d0
	beq.s SUM2
	cmpi.w #3,d0
	beq.s SUM3
	SUM1:
	getint d0
	bra.s  EXIT_SUM

SUM2:
	getint d0
	getint d1
	add.l d1,d0
	bra.s EXIT_SUM

SUM3:
	getint d0
	getint d1
	getint d3
	add.l d1,d0
	add.l d3,d0
	bra.s EXIT_SUM 
	

EXIT_SUM
	save_int d0
	return_to_stos


PULL:
	init_command 0

	move.l debut(a5),a3
	move.l 0(a3,d1.w),a3
	add.l #4,a3

	lea POINTER-DATA(a3),a0
	move.l (a0),d1
	sub.l #4,d1

	lea STORE-DATA(a3),a1
	add.l d1,a1
	move.l (a1),d0
	move.l d1,(a0)
	save_int d0
	return_to_stos



ENDPGM:
	dc.w	0