interpreter equ 0
	include stosmacr.i


* Source name ......: EGINT2.S
* Object name ......: EG.EXW
* Author ...........: Les Greenhalgh
* Date .............: 27th Oct 1995
* Description ......: Example STOS Extension II
* Contains 3 new commands and 3 functions

* Source name .......: EGINT.S
* Object name .......: EG.EXW
* Author ............: Martin Cubitt
* Date ..............: 13th Oct 1993
* Description .......: Example STOS Interpreter extension
*                      Contains 1 new command and 2 new functions:-
*
*			(Remember that a function returns a value)
*
*
*		eg			- this command displays the command
*					list of the EG extension. I think                      
*					all new extensions should have a
*					similar command as an on-line
*					reference to commands available.
*
*		A=range(A,B,C)		- a function which returns a value
*					based on A in the range B to C. If
*					A is less than B then A will become
*					the value of B. If A is greater than
*					C then A will become the value of C.
*					If the value of A >=B and <=C then
*					it will be unchanged.
*
*		A=ndrv			- this function returns the number
*					drives attached to your system (and
*					are available or turned on). If you
*					have the internal, one external and
*					a RAM disk the value will be 2
*					because the internal drive is
*					assumed anyway.
*
*		D=SUM(A)		- this function adds together
*		 =SUM(A,B)		all the parameters which it is
*		 =SUM(A,B,C)		supplied with and returns the
*					result.					
*
*		PUSH(A)			-pushes value onto internal stack
*	
*		=PULL			-retrieves value from internal stack



* Jump to initialisation routine
	bra	INIT

* Create token list for commands/functions
* Remember commands have even token numbers and functions odd ones

* The following byte value of 128 is simply required by STOS
	dc.b	128

* Ensure your new command/function names are lower case and do not
* contain any embedded reserved words such as 'printer value=...' as
* this contains print and val!

TOKENS:
	dc.b	"eg",128
	dc.b	"range",129
	dc.b	"ndrv",131
	dc.b	"push",132
	dc.b	"sum",133
	dc.b	"pull",135
	dc.b	0

	even

* Create the jump table
* This extension has THREE new commands (or functions) and ONE dummy!

JUMP:
	dc.w	8

	dc.l	EG
	dc.l	RANGE
	dc.l	DUMMY
	dc.l	NDRV
	dc.l	PUSH
	dc.l	SUM
	dc.l	DUMMY
	dc.l	PULL
		


* Message to be shown when extension installed in STOS
* First message for ENGLISH
* Second for FRENCH

MESSAGE:
	dc.b	10,10,"Example extension for STOSSER Disczine",0
	dc.b	10,10,"Extension Example de STOSSER",0
	dc.b	0

	even

SYSTEM:
	dc.l	0

RETURN:
	dc.l	0

INIT:
	lea	EXIT,a0
	lea	COLDST,a1
	rts

COLDST:
	move.l	a0,SYSTEM	; save address of STOS' system table
	lea	MESSAGE,a0
	lea	WARM,a1
	lea	TOKENS,a2
	lea	JUMP,a3

WARM:
	rts

* eg command
EG:
	init_command 0				;expect no parameters

	lea	EGINFO(pc),a0
	move.w	#1,d7
	trap	#3

	return_to_stos

* Range function
RANGE:
	init_command 3				;expect 3 parameters
	
	getint d0				; C

	getint d1				; B

	getint d2				; A

	cmp.l	d1,d2
	blt.s	TOO_LOW				; A<B so A=B

	cmp.l	d2,d0
	bge.s	OKAY				; Leave A as is

	move.w	d0,d2				; C<A so A=C
	bra.s	OKAY

TOO_LOW:
	move.w	d1,d2

OKAY:
	move.l	d2,d0


	save_int d0
	return_to_stos
	
	
* Number of drives function
NDRV:
	init_command 0				;expect no parms

	moveq.l	#0,d0
	move.w	($4a6),d0

	save_int d0

	return_to_stos

SUM:
	movem.l a2-a6/d5-d7,saveblock
	move.l	(a7)+,RETURN			;Save return address
	cmpi.w	#1,d0				;expect 1 parm
	beq.s SUM1
	cmpi.w #2,d0
	beq.s SUM2
	cmpi.w #3,d0
	beq.s SUM3
	bne	RANGEPARMERROR	

SUM1:
	getint d0
	bra.s  EXIT_SUM

SUM2:
	getint d0
	getint d1
	add.l d1,d0
	bra.s EXIT_SUM

SUM3:
	getint d0
	getint d1
	getint d3
	add.l d1,d0
	add.l d3,d0
	bra.s EXIT_SUM 
	

EXIT_SUM
	save_int d0
	return_to_stos

PUSH:
	init_command 1
	getint d0

	lea POINTER(pc),a0
	move.l (a0),d1
	
	lea STORE(pc),a1
	add.l d1,a1
	move.l d0,(a1)		

	add.l #4,d1
	move.l d1,(a0)
	return_to_stos

PULL:
	init_command 0

	lea POINTER(pc),a0
	move.l (a0),d1
	sub.l #4,d1

	lea STORE(pc),a1
	add.l d1,a1
	move.l (a1),d0
	move.l d1,(a0)
	save_int d0
	return_to_stos
	 

DUMMY:

EGINFO:
	dc.b	10,13,"* EG (Example) extension by M.Cubitt 1993 *"
	dc.b	10,13,"    Modified by L.J.Greenhalgh 1995"
	dc.b	10,13
	dc.b	10,13,"eg................: Information"
	dc.b	10,13,"=range(A,B,C).....: Make A in range B-C"
	dc.b	10,13,"=ndrv.............: No. of drives"
	dc.b	10,13,"=sum(A)...........: adds all parameters" 
	dc.b	10,13,"=sum(A,B).........: together and returns"
	dc.b	10,13,"=sum(A,B,C).......: result"
	dc.b	10,13,"push(A)...........: pushes A onto an internal stack"
	dc.b	10,13,"=pull.............: pulls value from stack"                    
	dc.b	10,13,0

	even

POINTER dc.l 0
STORE:	ds.l 100


MISMATCH:
	moveq.l	#19,d0
	bra.s	STOSERROR


RANGEPARMERROR:
	moveq.l	#12,d0
	lea	RANGEPARMERRTEXT(pc),a2
	bra.s	MYERROR

* STOS error messages handled here
STOSERROR:
	move.l	SYSTEM,a0
	move.l	$14(a0),a0
	jmp	(a0)

* My own error messages handled here!
MYERROR:
	clr.l	d1
	clr.l	d2
	clr.l	d3
	clr.l	d4
	clr.l	d5
	clr.l	d6
	move.l	SYSTEM,a0
	move.l	$18(a0),a0
	jmp	(a0)


RANGEPARMERRTEXT:
	dc.b	"Incorrect number of parameters",0
	dc.b	"le nombre de parameters est inexact",0

	even

NOPARMSERRTEXT:
	dc.b	"No parameters expected",0
	dc.b	"On ne veux pas de parameters",0

	even
	



saveblock ds.l 100

	dc.l	0
EXIT	equ	*
