// Bizarre '97 Linux demo, made by p2, sdog, slay
// Copyright (C) 1997 by p2, sdog, slay

// Linux rules!

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <jlib.h>
#include "demo.h"

// General defines
#define RANDOM(u) ( rand() % ( ((u) + 1)  ) )
#define ODECOLOR 1
#define FADEIN_SPEED UCLOCK_TICKS_PER_SECOND*1
#define FADEOUT_SPEED UCLOCK_TICKS_PER_SECOND*1

// Global stuff
UBYTE *DefaultPal, *CurrentPal;
buffer_rec *offscreen;
int CurrentQuote = 0;
int MaxQuote = 0;
int CurrentImage = 0;
int MaxImage = 0;
char *Quotes[50][2];
char *Images[50];
int FirstTimeFlag = 1;

// Config  stuff
char *QuotesFilename = "data/quotes.dat";
char *ImagesFilename = "data/images.dat";

int Ode1X, Ode1Y, Ode2X, Ode2Y;

void Startup (void) {
  screen_set_app_title("Bizarre 97 Linux Demo made by p2, sdog and slay");
  if (!screen_set_video_mode())
     jlib_exit("Screen Setup failed. Sorry. :(");
  offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
}

void Shutdown () {
  buff_free(offscreen);
  screen_restore_video_mode();
}

void PrepStuff (void) {
  DefaultPal = pal_get_default();
  DefaultPal[0] = 0;
  DefaultPal[1] = 0;
  DefaultPal[2] = 0;
  DefaultPal[3] = 255;
  DefaultPal[4] = 255;
  DefaultPal[5] = 255;

  CurrentPal = pal_init();

  CurrentQuote = 0;
  CurrentImage = 0;
}

void ReadQuotes (char *filename) {
  FILE *QuotesFile;
  char buffer1[256], buffer2[256];

  if (!(QuotesFile = fopen (filename, "r"))) {
    puts ("Whoops! Can't open Quotes file. Sorry. :(");
    exit (1);
  }

  MaxQuote = 0;
  while (!feof(QuotesFile)) {
    fgets (buffer1, 255, QuotesFile);
    buffer1[strlen(buffer1)-1] = '\0';
    fgets (buffer2, 255, QuotesFile);
    buffer2[strlen(buffer2)-1] = '\0';
// debug!
//    printf ("buffer1: %s\n", buffer1);
//    printf ("buffer2: %s\n", buffer2);
// debug
    Quotes[MaxQuote][0] = malloc (strlen(buffer1)+1);
    Quotes[MaxQuote][1] = malloc (strlen(buffer2)+1);
    strcpy (Quotes[MaxQuote][0], buffer1);
    strcpy (Quotes[MaxQuote][1], buffer2);
// debug!
//    printf ("Quotes[%d][0]: %s\n", MaxQuote, Quotes[MaxQuote][0]);
//    printf ("Quotes[%d][1]: %s\n\n", MaxQuote, Quotes[MaxQuote][1]);
// debug
    MaxQuote++;
  }

  MaxQuote--;
  MaxQuote--;

  fclose (QuotesFile);
}

void ReadImages (char *filename) {
  FILE *ImagesFile;
  char buffer[256];

  if (!(ImagesFile = fopen (filename, "r"))) {
    puts ("Whoops! Can't open Images file. Sorry. :(");
    exit (1);
  }

  MaxImage = 0;
  while (!feof(ImagesFile)) {
    fgets (buffer, 255, ImagesFile);
    buffer[strlen(buffer)-1] = '\0';
// debug!
//    printf ("buffer: %s", buffer);
// debug
    Images[MaxImage] = malloc (strlen(buffer)+1);
    strcpy (Images[MaxImage], buffer);
// debug!
//    printf ("Images[%d]: %s\n", MaxImage, Images[MaxImage]);
// debug
    MaxImage++;
  }

  MaxImage--;
  MaxImage--;

  fclose (ImagesFile);
}

void DoImage () {
  image *AnImage;
  int ImageX, ImageY;
  int DeltaX, DeltaY;
  UBYTE MightBeBlack;

  if (!FirstTimeFlag) {
    screen_fade_out_pal (DefaultPal, FADEOUT_SPEED);
    buff_clear (offscreen);
  } else {
    FirstTimeFlag = 0;
  }

// debug
//  printf ("CurrentImage = %d, Images[%d] = %s", CurrentImage, CurrentImage, Images[CurrentImage]);
// debug
  AnImage = image_load_pcx (Images[CurrentImage]);
  CurrentPal = IMG_PALETTE (AnImage);
  
  DeltaX = SCREEN_WIDTH - IMG_WIDTH(AnImage);
  ImageX = DeltaX / 2;
  DeltaY = SCREEN_HEIGHT - IMG_HEIGHT(AnImage);
  ImageY = DeltaY / 2;

//  buff_blit_img_to (offscreen, ImageX, ImageY, AnImage, 0, 0, IMG_WIDTH(AnImage), IMG_HEIGHT(AnImage));
  MightBeBlack = pal_closest_color_rgb (CurrentPal, 0, 0, 0);
  screen_fill (MightBeBlack);
//  buff_fill (offscreen, MightBeBlack);
  buff_blit_img_to (offscreen, ImageX, ImageY, AnImage, 0, 0, IMG_WIDTH(AnImage), IMG_HEIGHT(AnImage));
//  buff_draw_rect (offscreen, 0, 0, ImageX, SCREEN_HEIGHT, MightBeBlack);
//  buff_draw_rect (offscreen, SCREEN_WIDTH-ImageX, 0, SCREEN_WIDTH, SCREEN_HEIGHT, MightBeBlack);
//  buff_draw_rect (offscreen, 0, 0, SCREEN_WIDTH, ImageY, MightBeBlack);
//  buff_draw_rect (offscreen, 0, SCREEN_HEIGHT - ImageY, SCREEN_WIDTH, SCREEN_HEIGHT, MightBeBlack);
  screen_blank_pal();
  screen_blit_fs_buffer (offscreen);
  screen_fade_in_pal (CurrentPal, FADEIN_SPEED);

  image_free (AnImage);

  CurrentImage++;
  if (CurrentImage > MaxImage) CurrentImage = 0;
}

void DoQuote () {
  int Delta1X, Delta2X, DeltaY;
  int Ode1X, Ode1Y, Ode2X, Ode2Y;

  screen_fade_out_pal (CurrentPal, FADEOUT_SPEED);
  buff_clear (offscreen);

  Delta1X = strlen(Quotes[CurrentQuote][0]) * CHAR_WIDTH('A');
  Delta2X = strlen(Quotes[CurrentQuote][1]) * CHAR_WIDTH('A');
  DeltaY = 3 * CHAR_HEIGHT('A');

  Ode1X = (SCREEN_WIDTH - Delta1X) / 2;
  Ode2X = (SCREEN_WIDTH - Delta2X) / 2;
  Ode1Y = (SCREEN_HEIGHT - DeltaY) / 2;
  Ode2Y = (SCREEN_HEIGHT - DeltaY) / 2 + DeltaY;

  buff_draw_string (offscreen, Quotes[CurrentQuote][0], Ode1X, Ode1Y, ODECOLOR);
  buff_draw_string (offscreen, Quotes[CurrentQuote][1], Ode2X, Ode2Y, ODECOLOR);
  screen_blit_fs_buffer (offscreen);
  screen_fade_in_pal (DefaultPal, FADEIN_SPEED);

  CurrentQuote++;
  if (CurrentQuote > MaxQuote) CurrentQuote = 0;
}

int main(int argc, char **argv)
{
        int i=0;
        char fake[16];

        Startup();
        PrepStuff ();
        ReadQuotes (QuotesFilename);
        ReadImages (ImagesFilename);

        do {
          if (feof(stdin)) {
            usleep (5000000);
            break;
          }
          if (!i) {
            DoImage ();
            i = 1;
          } else {
            DoQuote ();
            i = 0;
          }
        } while (gets(fake));

        Shutdown ();
	return 1;
}
