
#include "Blobs.h"

#define _OPTIMIZE_BLOBS

Blobs::Blobs( int num, int32 *pattern, int32 tres )
{
	treshold = tres;
	patt = pattern;
	blobs = new Blob [n = num];
	dist_table = new int32 [512*200];
	int32 *p = dist_table;
	for ( int j = 0; j < 200; j++ )
		for ( int i = 0; i < 512; i++ ) {
			float div = float(sqrt(i*i+j*j));
			if ( div < 0.3f )
				div = 0.3f;
			*p++ = (unsigned)(65536.0f/(div));
		}
}

Blobs::~Blobs()
{
	delete [] blobs;
	delete [] dist_table;
}

void Blobs::update( float t )
{
	for ( int i = 0; i < n; i++ ) {
		blobs[i].x = int(160+120*sin(t*M_PI/180)*cos((t+i*10)*M_PI/100.0)*(i&1?-1:1));
		blobs[i].y = int(100+70*sin(-t*M_PI/155)*sin((t+i*10)*M_PI/100.0)*(i&1?1:-1));
		blobs[i].i = int(768+256.0*cos((t+i*10)*M_PI/128.0));
	}	
}

void Blobs::draw( int32 *surface )
{
	for ( int j = 0; j < 51; j++ ) {
		int y = j<<2;
		for ( int i = 0; i < 81; i++ ) {
			int x = i<<2;
			struct Blob *ptr = blobs;
			int z = n;
			int32 val = 0;
			while ( z-- ) {
				val += ptr->i*dist_table[(abs(y-ptr->y)<<9)+abs(x-ptr->x)];
				ptr++;
			}
			val >>= 16;
			if ( val > 255 )
				val = 255;
			grid[i][j] = val;	
		}
	}

	lerp_grid( surface );
}

void Blobs::lerp_blk( int x, int y, int32 *buff, int32 *pattern )
{

#ifdef _OPTIMIZE_BLOBS
	if ( (grid[x][y] < treshold) && (grid[x+1][y] < treshold) &&
	     (grid[x][y+1] < treshold) && (grid[x+1][y+1] < treshold) )
		return;
#endif
	int iyl = grid[x][y]<<8;
	int diyl = (grid[x][y+1]-grid[x][y])<<6;
	int iyr = grid[x+1][y]<<8;
	int diyr = (grid[x+1][y+1]-grid[x+1][y])<<6;

	for ( int j = 0; j < 4; j++ ) {
		register int ix = iyl;
		register int dix = (iyr-iyl)>>2;
		for ( int i = 0; i < 4; i++ ) {
			if ( char8(ix>>8) > treshold )
				*buff = *pattern;
				//*buff = avg_rgb32( *buff, *pattern );
			ix += dix;
			buff++, pattern++;
		}
		buff += 320-4;
		pattern += 320-4;
		iyr += diyr;
		iyl += diyl;
	}
}

void Blobs::lerp_grid( int32 *buff )
{
	for ( int j = 0; j < 50; j++ ) {
		int offset = j*4*320;
		for ( int i = 0; i < 80; i++ ) {
			lerp_blk( i, j, buff+offset, patt+offset );
			offset += 4;
		}
	}
}


