
// fake free direction floor

#ifndef _FDFLOOR_H_INCLUDED
#define _FDFLOOR_H_INCLUDED

#include <ptc.h>
#include <cmath>
#include "Matrix.h"
#include "TextWarp.h"

class Free_Direction_Floor : public Texture_Warper {
	Matrix mtx;
	float angle_x, angle_y, angle_z;
	float cam_x, cam_y, cam_z;
	float focus_x, focus_y;
	float wave_ampl, wave_index;
	int u_offset, v_offset;
protected:
	// inherited from Texture_Warper interface
	void init_calc();
	void calc( int x, int y, Grid_Item &item );
public:
        Free_Direction_Floor();

	void set_camera( float x, float y, float z ) {
		cam_x = x;
		cam_y = y;
		cam_z = z;
	};

        void rotate( float x, float y, float z ) {
                angle_x = x;
                angle_y = y;
                angle_z = z;
        };

        void set_focus( float x, float y ) {        
                focus_x = x;
                focus_y = y;
        };

	void set_wave_ampl( float ampl ) {
		wave_ampl = ampl*0.5f;
	}

	void update_waves() {
		wave_index++;
	}

	void update_scrolling() {
		u_offset += 7;
		v_offset += 9;
	}
};

#endif // _FDFLOOR_H_INCLUDED
