
#include "Grid.h"

//
//	4 x 4
//

// interpolates (r,g,b) color values accross a 4x4 pixels block
template <int width, int height>
void Lerp_Grid_4x4<width,height>::lerp_rgb( int32 *surface )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*4*320)+(x<<2);
			int ryl = grid[x][y].r<<8;	
			int gyl = grid[x][y].g<<8;	
			int byl = grid[x][y].b<<8;
			int dryl = (grid[x][y+1].r-grid[x][y].r)<<6;
			int dgyl = (grid[x][y+1].g-grid[x][y].g)<<6;
			int dbyl = (grid[x][y+1].b-grid[x][y].b)<<6;
			int ryr = grid[x+1][y].r<<8;	
			int gyr = grid[x+1][y].g<<8;	
			int byr = grid[x+1][y].b<<8;
			int dryr = (grid[x+1][y+1].r-grid[x+1][y].r)<<6;
			int dgyr = (grid[x+1][y+1].g-grid[x+1][y].g)<<6;
			int dbyr = (grid[x+1][y+1].b-grid[x+1][y].b)<<6;

			for ( int j = 0; j < 4; j++ ) {
				int rx = ryl;
				int gx = gyl;
				int bx = byl;
				int drx = (ryr-ryl)>>2;
				int dgx = (gyr-gyl)>>2;
				int dbx = (byr-byl)>>2;
				for ( int i = 0; i < 4; i++ ) {
					*buff++ = ((rx<<8)&0xff0000)|(gx&0x00ff00)|((bx>>8)&0x0000ff);
					rx += drx;
					gx += dgx;
					bx += dbx;
				}
				ryl += dryl;
				gyl += dgyl;
				byl += dbyl;
				ryr += dryr;
				gyr += dgyr;
				byr += dbyr;
				buff += ((width-1)*4)-4;
			}
		}
	}
}

// interpolates (u,v) texture coordinates accross a 4x4 pixels block
template <int width, int height>
void Lerp_Grid_4x4<width,height>::lerp_uv( int32 *surface, int32 *texture )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*4*320)+(x<<2);
			int uyl = grid[x][y].u<<8;	
			int vyl = grid[x][y].v<<8;	
			int duyl = (grid[x][y+1].u-grid[x][y].u)<<6;
			int dvyl = (grid[x][y+1].v-grid[x][y].v)<<6;
			int uyr = grid[x+1][y].u<<8;	
			int vyr = grid[x+1][y].v<<8;	
			int duyr = (grid[x+1][y+1].u-grid[x+1][y].u)<<6;
			int dvyr = (grid[x+1][y+1].v-grid[x+1][y].v)<<6;

			for ( int j = 0; j < 4; j++ ) {
				int ux = uyl;
				int vx = vyl;
				int dux = (uyr-uyl)>>2;
				int dvx = (vyr-vyl)>>2;
				for ( int i = 0; i < 4; i++ ) {
					*buff++ = texture[(vx&0xff00)+(unsigned char)(ux>>8)];
					ux += dux;
					vx += dvx;
				}
				uyl += duyl;
				vyl += dvyl;
				uyr += duyr;
				vyr += dvyr;
				buff += ((width-1)*4)-4;
			}
		}
	}
}

// interpolates (u,v) texture coordinates and intensity accross a 4x4 pixels block
template <int width, int height>
void Lerp_Grid_4x4<width,height>::lerp_uvi( int32 *surface, char8 *texture, const Shade_Table &shade )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*4*320)+(x<<2);
			int uyl = grid[x][y].u<<8;	
			int vyl = grid[x][y].v<<8;	
			int iyl = grid[x][y].i<<8;	
			int duyl = (grid[x][y+1].u-grid[x][y].u)<<6;
			int dvyl = (grid[x][y+1].v-grid[x][y].v)<<6;
			int diyl = (grid[x][y+1].i-grid[x][y].i)<<6;
			int uyr = grid[x+1][y].u<<8;	
			int vyr = grid[x+1][y].v<<8;	
			int iyr = grid[x+1][y].i<<8;	
			int duyr = (grid[x+1][y+1].u-grid[x+1][y].u)<<6;
			int dvyr = (grid[x+1][y+1].v-grid[x+1][y].v)<<6;
			int diyr = (grid[x+1][y+1].i-grid[x+1][y].i)<<6;

			for ( int j = 0; j < 4; j++ ) {
				int ux = uyl;
				int vx = vyl;
				int ix = iyl;
				int dux = (uyr-uyl)>>2;
				int dvx = (vyr-vyl)>>2;
				int dix = (iyr-iyl)>>2;
				for ( int i = 0; i < 4; i++ ) {
					*buff++ = shade.get_color( texture[(vx&0xff00)+(unsigned char)(ux>>8)], ix>>8 );
					ux += dux;
					vx += dvx;
					ix += dix;
				}
				uyl += duyl;
				vyl += dvyl;
				iyl += diyl;
				uyr += duyr;
				vyr += dvyr;
				iyr += diyr;
				buff += (width-1)*4-4;
			}
		}
	}
}

// interpolates (r,g,b) color values accross a 4x4 pixels block
template <int width, int height>
void Lerp_Grid_4x4<width,height>::lerp_rgb_avg( int32 *surface )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*4*320)+(x<<2);
			int ryl = grid[x][y].r<<8;	
			int gyl = grid[x][y].g<<8;	
			int byl = grid[x][y].b<<8;
			int dryl = (grid[x][y+1].r-grid[x][y].r)<<6;
			int dgyl = (grid[x][y+1].g-grid[x][y].g)<<6;
			int dbyl = (grid[x][y+1].b-grid[x][y].b)<<6;
			int ryr = grid[x+1][y].r<<8;	
			int gyr = grid[x+1][y].g<<8;	
			int byr = grid[x+1][y].b<<8;
			int dryr = (grid[x+1][y+1].r-grid[x+1][y].r)<<6;
			int dgyr = (grid[x+1][y+1].g-grid[x+1][y].g)<<6;
			int dbyr = (grid[x+1][y+1].b-grid[x+1][y].b)<<6;

			for ( int j = 0; j < 4; j++ ) {
				int rx = ryl;
				int gx = gyl;
				int bx = byl;
				int drx = (ryr-ryl)>>2;
				int dgx = (gyr-gyl)>>2;
				int dbx = (byr-byl)>>2;
				for ( int i = 0; i < 4; i++ ) {
					*buff++ = avg_rgb32( *buff, ((rx<<8)&0xff0000)|(gx&0x00ff00)|((bx>>8)&0x0000ff) );
					rx += drx;
					gx += dgx;
					bx += dbx;
				}
				ryl += dryl;
				gyl += dgyl;
				byl += dbyl;
				ryr += dryr;
				gyr += dgyr;
				byr += dbyr;
				buff += (width-1)*4-4;
			}
		}
	}
}

// interpolates (u,v) texture coordinates accross a 4x4 pixels block
template <int width, int height>
void Lerp_Grid_4x4<width,height>::lerp_uv_avg( int32 *surface, int32 *texture )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*4*320)+x<<2;
			int uyl = grid[x][y].u<<8;	
			int vyl = grid[x][y].v<<8;	
			int duyl = (grid[x][y+1].u-grid[x][y].u)<<6;
			int dvyl = (grid[x][y+1].v-grid[x][y].v)<<6;
			int uyr = grid[x+1][y].u<<8;	
			int vyr = grid[x+1][y].v<<8;	
			int duyr = (grid[x+1][y+1].u-grid[x+1][y].u)<<6;
			int dvyr = (grid[x+1][y+1].v-grid[x+1][y].v)<<6;

			for ( int j = 0; j < 4; j++ ) {
				int ux = uyl;
				int vx = vyl;
				int dux = (uyr-uyl)>>2;
				int dvx = (vyr-vyl)>>2;
				for ( int i = 0; i < 4; i++ ) {
					*buff++ = avg_rgb32( *buff, texture[(vx&0xff00)+(unsigned char)(ux>>8)] );
					ux += dux;
					vx += dvx;
				}
				uyl += duyl;
				vyl += dvyl;
				uyr += duyr;
				vyr += dvyr;
				buff += (width-1)*4-4;
			}
		}
	}
}

// interpolates (u,v) texture coordinates and intensity accross a 4x4 pixels block
template <int width, int height>
void Lerp_Grid_4x4<width,height>::lerp_uvi_avg( int32 *surface, char8 *texture, const Shade_Table &shade )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*4*320)+(x<<2);
			int uyl = grid[x][y].u<<8;	
			int vyl = grid[x][y].v<<8;	
			int iyl = grid[x][y].i<<8;	
			int duyl = (grid[x][y+1].u-grid[x][y].u)<<6;
			int dvyl = (grid[x][y+1].v-grid[x][y].v)<<6;
			int diyl = (grid[x][y+1].i-grid[x][y].i)<<6;
			int uyr = grid[x+1][y].u<<8;	
			int vyr = grid[x+1][y].v<<8;	
			int iyr = grid[x+1][y].i<<8;	
			int duyr = (grid[x+1][y+1].u-grid[x+1][y].u)<<6;
			int dvyr = (grid[x+1][y+1].v-grid[x+1][y].v)<<6;
			int diyr = (grid[x+1][y+1].i-grid[x+1][y].i)<<6;

			for ( int j = 0; j < 4; j++ ) {
				int ux = uyl;
				int vx = vyl;
				int ix = iyl;
				int dux = (uyr-uyl)>>2;
				int dvx = (vyr-vyl)>>2;
				int dix = (iyr-iyl)>>2;
				for ( int i = 0; i < 4; i++ ) {
					*buff++ = avg_rgb32( *buff, shade.get_color( texture[(vx&0xff00)+(unsigned char)(ux>>8)], ix>>8 ) );
					ux += dux;
					vx += dvx;
					ix += dix;
				}
				uyl += duyl;
				vyl += dvyl;
				iyl += diyl;
				uyr += duyr;
				vyr += dvyr;
				iyr += diyr;
				buff += (width-1)*4-4;
			}
		}
	}
}

//
//	8 x 8
//

// interpolates (r,g,b) color values accross a 8x8 pixels block
template <int width, int height>
void Lerp_Grid_8x8<width,height>::lerp_rgb( int32 *surface )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*8*320)+(x<<3);
			int ryl = grid[x][y].r<<8;	
			int gyl = grid[x][y].g<<8;	
			int byl = grid[x][y].b<<8;
			int dryl = (grid[x][y+1].r-grid[x][y].r)<<5;
			int dgyl = (grid[x][y+1].g-grid[x][y].g)<<5;
			int dbyl = (grid[x][y+1].b-grid[x][y].b)<<5;
			int ryr = grid[x+1][y].r<<8;	
			int gyr = grid[x+1][y].g<<8;	
			int byr = grid[x+1][y].b<<8;
			int dryr = (grid[x+1][y+1].r-grid[x+1][y].r)<<5;
			int dgyr = (grid[x+1][y+1].g-grid[x+1][y].g)<<5;
			int dbyr = (grid[x+1][y+1].b-grid[x+1][y].b)<<5;

			for ( int j = 0; j < 8; j++ ) {
				int rx = ryl;
				int gx = gyl;
				int bx = byl;
				int drx = (ryr-ryl)>>3;
				int dgx = (gyr-gyl)>>3;
				int dbx = (byr-byl)>>3;
				for ( int i = 0; i < 8; i++ ) {
					*buff++ = ((rx<<8)&0xff0000)|(gx&0x00ff00)|((bx>>8)&0x0000ff);
					rx += drx;
					gx += dgx;
					bx += dbx;
				}
				ryl += dryl;
				gyl += dgyl;
				byl += dbyl;
				ryr += dryr;
				gyr += dgyr;
				byr += dbyr;
				buff += (width-1)*8-8;
			}
		}
	}
}

// interpolates (u,v) texture coordinates accross a 8x8 pixels block
template <int width, int height>
void Lerp_Grid_8x8<width,height>::lerp_uv( int32 *surface, int32 *texture )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+y*8*320+(x<<3);
			int uyl = grid[x][y].u<<8;	
			int vyl = grid[x][y].v<<8;	
			int duyl = (grid[x][y+1].u-grid[x][y].u)<<5;
			int dvyl = (grid[x][y+1].v-grid[x][y].v)<<5;
			int uyr = grid[x+1][y].u<<8;	
			int vyr = grid[x+1][y].v<<8;	
			int duyr = (grid[x+1][y+1].u-grid[x+1][y].u)<<5;
			int dvyr = (grid[x+1][y+1].v-grid[x+1][y].v)<<5;

			//cerr << x << "\t" << y << "\t" << int32(buff-surface) << endl;

			for ( int j = 0; j < 8; j++ ) {
				int ux = uyl;
				int vx = vyl;
				int dux = (uyr-uyl)>>3;
				int dvx = (vyr-vyl)>>3;
				for ( int i = 0; i < 8; i++ ) {
					*buff++ = texture[(vx&0xff00)+(unsigned char)(ux>>8)];
					ux += dux;
					vx += dvx;
				}
				uyl += duyl;
				vyl += dvyl;
				uyr += duyr;
				vyr += dvyr;
				buff += ((width-1)*8)-8;
			}
		}
	}
}

// interpolates (u,v) texture coordinates and intensity accross a 8x8 pixels block
template <int width, int height>
void Lerp_Grid_8x8<width,height>::lerp_uvi( int32 *surface, char8 *texture, const Shade_Table &shade )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*8*320)+(x<<3);
			int uyl = grid[x][y].u<<8;	
			int vyl = grid[x][y].v<<8;	
			int iyl = grid[x][y].i<<8;	
			int duyl = (grid[x][y+1].u-grid[x][y].u)<<5;
			int dvyl = (grid[x][y+1].v-grid[x][y].v)<<5;
			int diyl = (grid[x][y+1].i-grid[x][y].i)<<5;
			int uyr = grid[x+1][y].u<<8;	
			int vyr = grid[x+1][y].v<<8;	
			int iyr = grid[x+1][y].i<<8;	
			int duyr = (grid[x+1][y+1].u-grid[x+1][y].u)<<5;
			int dvyr = (grid[x+1][y+1].v-grid[x+1][y].v)<<5;
			int diyr = (grid[x+1][y+1].i-grid[x+1][y].i)<<5;

			for ( int j = 0; j < 8; j++ ) {
				int ux = uyl;
				int vx = vyl;
				int ix = iyl;
				int dux = (uyr-uyl)>>3;
				int dvx = (vyr-vyl)>>3;
				int dix = (iyr-iyl)>>3;
				for ( int i = 0; i < 8; i++ ) {
					*buff++ = shade.get_color( texture[(vx&0xff00)+(unsigned char)(ux>>8)], ix>>8 );
					ux += dux;
					vx += dvx;
					ix += dix;
				}
				uyl += duyl;
				vyl += dvyl;
				iyl += diyl;
				uyr += duyr;
				vyr += dvyr;
				iyr += diyr;
				buff += (width-1)*8-8;
			}
		}
	}
}

// interpolates (r,g,b) color values accross a 8x8 pixels block
template <int width, int height>
void Lerp_Grid_8x8<width,height>::lerp_rgb_avg( int32 *surface )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*8*320)+(x<<3);
			int ryl = grid[x][y].r<<8;	
			int gyl = grid[x][y].g<<8;	
			int byl = grid[x][y].b<<8;
			int dryl = (grid[x][y+1].r-grid[x][y].r)<<5;
			int dgyl = (grid[x][y+1].g-grid[x][y].g)<<5;
			int dbyl = (grid[x][y+1].b-grid[x][y].b)<<5;
			int ryr = grid[x+1][y].r<<8;	
			int gyr = grid[x+1][y].g<<8;	
			int byr = grid[x+1][y].b<<8;
			int dryr = (grid[x+1][y+1].r-grid[x+1][y].r)<<5;
			int dgyr = (grid[x+1][y+1].g-grid[x+1][y].g)<<5;
			int dbyr = (grid[x+1][y+1].b-grid[x+1][y].b)<<5;

			for ( int j = 0; j < 8; j++ ) {
				int rx = ryl;
				int gx = gyl;
				int bx = byl;
				int drx = (ryr-ryl)>>3;
				int dgx = (gyr-gyl)>>3;
				int dbx = (byr-byl)>>3;
				for ( int i = 0; i < 8; i++ ) {
					*buff++ = avg_rgb32( *buff, ((rx<<8)&0xff0000)|(gx&0x00ff00)|((bx>>8)&0x0000ff) );
					rx += drx;
					gx += dgx;
					bx += dbx;
				}
				ryl += dryl;
				gyl += dgyl;
				byl += dbyl;
				ryr += dryr;
				gyr += dgyr;
				byr += dbyr;
				buff += (width-1)*8-8;
			}
		}
	}
}

// interpolates (u,v) texture coordinates accross a 8x8 pixels block
template <int width, int height>
void Lerp_Grid_8x8<width,height>::lerp_uv_avg( int32 *surface, int32 *texture )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*8*320)+(x<<3);
			int uyl = grid[x][y].u<<8;	
			int vyl = grid[x][y].v<<8;	
			int duyl = (grid[x][y+1].u-grid[x][y].u)<<5;
			int dvyl = (grid[x][y+1].v-grid[x][y].v)<<5;
			int uyr = grid[x+1][y].u<<8;	
			int vyr = grid[x+1][y].v<<8;	
			int duyr = (grid[x+1][y+1].u-grid[x+1][y].u)<<5;
			int dvyr = (grid[x+1][y+1].v-grid[x+1][y].v)<<5;

			for ( int j = 0; j < 8; j++ ) {
				int ux = uyl;
				int vx = vyl;
				int dux = (uyr-uyl)>>3;
				int dvx = (vyr-vyl)>>3;
				for ( int i = 0; i < 8; i++ ) {
					*buff++ = avg_rgb32( *buff, texture[(vx&0xff00)+(unsigned char)(ux>>8)] );
					ux += dux;
					vx += dvx;
				}
				uyl += duyl;
				vyl += dvyl;
				uyr += duyr;
				vyr += dvyr;
				buff += (width-1)*8-8;
			}
		}
	}
}

// interpolates (u,v) texture coordinates and intensity accross a 8x8 pixels block
template <int width, int height>
void Lerp_Grid_8x8<width,height>::lerp_uvi_avg( int32 *surface, char8 *texture, const Shade_Table &shade )
{
	for ( int y = 0; y < height-1; y++ ) {
		for ( int x = 0; x < width-1; x++ ) {
			int32 *buff = surface+(y*8*320)+(x<<3);
			int uyl = grid[x][y].u<<8;	
			int vyl = grid[x][y].v<<8;	
			int iyl = grid[x][y].i<<8;	
			int duyl = (grid[x][y+1].u-grid[x][y].u)<<5;
			int dvyl = (grid[x][y+1].v-grid[x][y].v)<<5;
			int diyl = (grid[x][y+1].i-grid[x][y].i)<<5;
			int uyr = grid[x+1][y].u<<8;	
			int vyr = grid[x+1][y].v<<8;	
			int iyr = grid[x+1][y].i<<8;	
			int duyr = (grid[x+1][y+1].u-grid[x+1][y].u)<<5;
			int dvyr = (grid[x+1][y+1].v-grid[x+1][y].v)<<5;
			int diyr = (grid[x+1][y+1].i-grid[x+1][y].i)<<5;

			for ( int j = 0; j < 8; j++ ) {
				int ux = uyl;
				int vx = vyl;
				int ix = iyl;
				int dux = (uyr-uyl)>>3;
				int dvx = (vyr-vyl)>>3;
				int dix = (iyr-iyl)>>3;
				for ( int i = 0; i < 8; i++ ) {
					*buff++ = avg_rgb32( *buff, shade.get_color( texture[(vx&0xff00)+(unsigned char)(ux>>8)], ix>>8 ) );
					ux += dux;
					vx += dvx;
					ix += dix;
				}
				uyl += duyl;
				vyl += dvyl;
				iyl += diyl;
				uyr += duyr;
				vyr += dvyr;
				iyr += diyr;
				buff += (width-1)*8-8;
			}
		}
	}
}

