
//
//	copyleft 1999, brioche/aspirine <xdefrang@csi.com>
//

#include "Main.h"

// here follows a very large buffer pool
static int32 dbuffer[320*200];
static int32 openptc[320*200], linux_inside[320*200];
static int32 banner[1024*80];
static int32 pyr[7][320*200];
static int32 texture[256*256], texture2[256*256];
static PCX_8bpp *floor_text;
static char8 pattern1[320*200], pattern2[320*200];
static int32 aspirine_square[320*200];
static int32 formula1[320*200], formula2[320*200], formula3[320*200];
static int32 studio[320*200], ibm[320*200];
static int32 rayflarez[320*200];
static int32 albert_backgnd[320*200];
static int32 unity[320*200];
static int32 kickass[320*200];
static int32 optimal[320*200];

// 3D engine's texture
static int32 t3d_sol[256*256];
static int32 t3d_col[256*256];
static int32 t3d_col2[256*256];
static int32 t3d_envmap[256*256];
static int32 t3d_fond[256*256];
static int32 t3d_weeve[256*256];
static int32 banner3d[8][320*50];
static int32 bindigits[2][64*400];

static const int magnus_title_h = 102, title_border_h = 49;
static int32 magnus_title[320*102];

// using macros in C++ programs really sucks but they are sometimes useful :)
#define DECLARE_SPRITE(label,w,h)	static const int label##_w = (w), label##_h = (h);\
					static int32 spr_##label[(w)*(h)];

// mad scientists
DECLARE_SPRITE(smalb,98,140);
DECLARE_SPRITE(bigalb,175,200);

// credits
DECLARE_SPRITE(alkas,145,70);
DECLARE_SPRITE(brioche,124,29);
DECLARE_SPRITE(muzeek,75,29);
DECLARE_SPRITE(codepix,88,60);
DECLARE_SPRITE(colas,101,39);
DECLARE_SPRITE(engine,99,44);
DECLARE_SPRITE(alpha,76,38);
DECLARE_SPRITE(addcode,85,22);

// greetings
static int32 spr_greetings[320*200];

// cliparts
DECLARE_SPRITE(camera,107,99);
DECLARE_SPRITE(ear,79,133);
DECLARE_SPRITE(earphones,105,117);
DECLARE_SPRITE(eye,143,79);
DECLARE_SPRITE(loudhailer,166,127);
DECLARE_SPRITE(magtape,114,113);
DECLARE_SPRITE(roundabout,107,116);
DECLARE_SPRITE(satellite,142,106);
DECLARE_SPRITE(synth,148,126);

// misc sprites
DECLARE_SPRITE(alert,127,21);
DECLARE_SPRITE(exercise,206,25);
DECLARE_SPRITE(partcool,170,35);
DECLARE_SPRITE(molecules,254,37);
DECLARE_SPRITE(nrg,258,29);
DECLARE_SPRITE(headache,262,91);
DECLARE_SPRITE(reaction,235,50);
DECLARE_SPRITE(desint,49,370);
DECLARE_SPRITE(fuse,207,48);
DECLARE_SPRITE(kasja,114,101);
DECLARE_SPRITE(meta,194,70);
DECLARE_SPRITE(laspi,294,158);

// customization related data
static void blit_200();
static void blit_240();
static void (*blit)() = blit_200;
static int phys_h = 200;
static bool verbose = false;
static bool shad_sucks = false;

// OpenPTC stuff
static Console con;
static Timer timer;			
static Surface *surf;
int32 *psurf;			// not static -> used in RayTrace.o

// misc stuff
int xdiag[200];

// interpolation rules
static Grid_4x4_320x200 g4x4;
static Grid_8x8_320x200 g8x8;

// global effects (see init)
Tunnel *tun1, *tun2, *tun3;
Big_Tunnel *btun1, *btun2, *btun3;
Blobs *blobs;
Dynamic_System *dynsys;
Slimy_Sinus_Bar *bar;
RAYTR::VIEWPORT vport;
RAYTR::SCENE scn1, scn3;
scene *scene3d; 

//
// blitting functions
//

static void blit_200()
{
	surf->copy( con );	
	con.update();
}

static void blit_240()
{
	surf->copy( con, Area(0,0,319,199), Area(0,20,319,219) );	
	con.update();
}

//
// handle command line arguments
//

static void parse_command_line( int argc, char **argv )
{
	for ( int arg = 1; arg < argc; arg++ ) {
		if ( *argv[arg] == '-' ) {
			if ( !strcmp( argv[arg]+1, "240" ) ) {
				blit = blit_240;
				phys_h = 240;
			} else if ( !strcmp( argv[arg]+1, "v" ) || !strcmp( argv[arg]+1, "verbose" ) ) {
				verbose = true;
			} else if ( !strcmp( argv[arg]+1, "n" ) || !strcmp( argv[arg]+1, "norenice" ) ) {
				norenice = true;
			} else if ( !strcmp( argv[arg]+1, "quake-sucks" ) || !strcmp( argv[arg]+1, "no-more-3d" ) ) {
				shad_sucks = true;
			}
		}
	}
}

//
// load and decompress data
//

static void load_data()
{
	// load "*.rgb.gz" true color pixelmaps
	try {
		cerr << "Loading and inflating data, make yourself at home, feel free to take a seat." << endl;

		Loader l( verbose );

		// intro logo
		l.load( MK_PATH("openptc.rgb.gz"), 320, 200, openptc );
		l.load( MK_PATH("linux-inside.rgb.gz"), 320, 200, linux_inside );
		// title stuff
		l.load( MK_PATH("magnus2.rgb.gz"), 320, magnus_title_h, magnus_title );
		l.load( MK_PATH("square.rgb.gz"), 320, 200, aspirine_square );
		// banner
		l.load( MK_PATH("greets.rgb.gz"), 1024, 80, banner );
		// backgrounds - pyramids
		l.load( MK_PATH("pyr0.rgb.gz"), 320, 200, pyr[0] );
		l.load( MK_PATH("pyr1.rgb.gz"), 320, 200, pyr[1] );
		l.load( MK_PATH("pyr2.rgb.gz"), 320, 200, pyr[2] );
		l.load( MK_PATH("pyr3.rgb.gz"), 320, 200, pyr[3] );
		l.load( MK_PATH("pyr4.rgb.gz"), 320, 200, pyr[4] );
		l.load( MK_PATH("pyr5.rgb.gz"), 320, 200, pyr[5] );
		l.load( MK_PATH("pyr00.rgb.gz"), 320, 200, pyr[6] );
		// other backgrounds
		l.load( MK_PATH("formula.rgb.gz"), 320, 200, formula1 );
		l.load( MK_PATH("formula2.rgb.gz"), 320, 200, formula2 );
		l.load( MK_PATH("formula3.rgb.gz"), 320, 200, formula3 );
		l.load( MK_PATH("studio.rgb.gz"), 320, 200, studio );
		l.load( MK_PATH("ibm360.rgb.gz"), 320, 200, ibm );
		l.load( MK_PATH("rayflarez.rgb.gz"), 320, 200, rayflarez );
		l.load( MK_PATH("bibi.rgb.gz"), 320, 200, albert_backgnd );
		l.load( MK_PATH("optimal.rgb.gz"), 320, 200, optimal );
		// textures
		l.load( MK_PATH("fatkab.rgb.gz"), 256, 256, texture );
		l.load( MK_PATH("green.rgb.gz"), 256, 256, texture2 );
		// sprites - cliparts
		l.load( MK_PATH("camera.rgb.gz"), camera_w, camera_h, spr_camera );
		l.load( MK_PATH("ear.rgb.gz"), ear_w, ear_h, spr_ear );
		l.load( MK_PATH("earphones.rgb.gz"), earphones_w, earphones_h, spr_earphones );
		l.load( MK_PATH("eye.rgb.gz"), eye_w, eye_h, spr_eye );
		l.load( MK_PATH("loudhailer.rgb.gz"), loudhailer_w, loudhailer_h, spr_loudhailer );
		l.load( MK_PATH("magtape.rgb.gz"), magtape_w, magtape_h, spr_magtape );
		l.load( MK_PATH("roundabout.rgb.gz"), roundabout_w, roundabout_h, spr_roundabout );
		l.load( MK_PATH("synth.rgb.gz"), synth_w, synth_h, spr_synth );
		l.load( MK_PATH("satellite.rgb.gz"), satellite_w, satellite_h, spr_satellite );
		// sprites - credits
		l.load( MK_PATH("alkas.rgb.gz"), alkas_w, alkas_h, spr_alkas );
		l.load( MK_PATH("brioche.rgb.gz"), brioche_w, brioche_h, spr_brioche );
		l.load( MK_PATH("muzeek.rgb.gz"), muzeek_w, muzeek_h, spr_muzeek );
		l.load( MK_PATH("codepix.rgb.gz"), codepix_w, codepix_h, spr_codepix );
		l.load( MK_PATH("3deng.rgb.gz"), engine_w, engine_h, spr_engine );
		l.load( MK_PATH("colas.rgb.gz"), colas_w, colas_h, spr_colas );
		l.load( MK_PATH("addcode.rgb.gz"), addcode_w, addcode_h, spr_addcode );
		l.load( MK_PATH("alpha.rgb.gz"), alpha_w, alpha_h, spr_alpha );
		// sprites - scientists
		l.load( MK_PATH( "albert3.rgb.gz"), smalb_w, smalb_h, spr_smalb );
		l.load( MK_PATH( "albert11.rgb.gz"), bigalb_w, bigalb_h, spr_bigalb );
		// sprites - greetings
		l.load( MK_PATH( "greets2.rgb.gz"), 320, 200, spr_greetings );
		l.load( MK_PATH( "k.rgb.gz"), kasja_w, kasja_h, spr_kasja );
		// sprites - misc
		l.load( MK_PATH("alert.rgb.gz"), alert_w, alert_h, spr_alert );
		l.load( MK_PATH("exercise.rgb.gz"), exercise_w, exercise_h, spr_exercise );
		l.load( MK_PATH("partcool.rgb.gz"), partcool_w, partcool_h, spr_partcool );
		l.load( MK_PATH("molecules.rgb.gz"), molecules_w, molecules_h, spr_molecules );
		l.load( MK_PATH("nrg.rgb.gz"), nrg_w, nrg_h, spr_nrg );
		l.load( MK_PATH("headache.rgb.gz"), headache_w, headache_h, spr_headache );
		l.load( MK_PATH("c9h8o4_2.rgb.gz"), reaction_w, reaction_h, spr_reaction );
		l.load( MK_PATH("desint.rgb.gz"), desint_w, desint_h, spr_desint );
		l.load( MK_PATH("fuse.rgb.gz"), fuse_w, fuse_h, spr_fuse );
		l.load( MK_PATH("meta.rgb.gz"), meta_w, meta_h, spr_meta );
		l.load( MK_PATH("laspi.rgb.gz"), laspi_w, laspi_h, spr_laspi );
		// more stuff
		l.load( MK_PATH("unity.rgb.gz"), 320, 200, unity );
		l.load( MK_PATH("kickass.rgb.gz"), 320, 200, kickass );
		// 3D engine textures
		l.load( MK_PATH("sol.rgb.gz"), 256, 256, t3d_sol );
		l.load( MK_PATH("col.rgb.gz"), 256, 256, t3d_col );
		l.load( MK_PATH("col2.rgb.gz"), 256, 256, t3d_col2);
		l.load( MK_PATH("fond.rgb.gz"), 256, 256, t3d_fond );
		l.load( MK_PATH("weeve.rgb.gz"), 256, 256, t3d_weeve );
		// 3D engines sprites
		l.load( MK_PATH("banner21.rgb.gz"), 320, 50, banner3d[0] );
		l.load( MK_PATH("banner22.rgb.gz"), 320, 50, banner3d[1] );
		l.load( MK_PATH("banner23.rgb.gz"), 320, 50, banner3d[2] );
		l.load( MK_PATH("banner24.rgb.gz"), 320, 50, banner3d[3] );
		l.load( MK_PATH("banner25.rgb.gz"), 320, 50, banner3d[4] );
		l.load( MK_PATH("banner26.rgb.gz"), 320, 50, banner3d[5] );
		l.load( MK_PATH("banner27.rgb.gz"), 320, 50, banner3d[6] );
		l.load( MK_PATH("banner28.rgb.gz"), 320, 50, banner3d[7] );
		l.load( MK_PATH("binary1.rgb.gz"), 64, 400, bindigits[0] );
		l.load( MK_PATH("binary2.rgb.gz"), 64, 400, bindigits[1] );
		// patterns
		l.load( MK_PATH("pattern1.gray.gz"), 320*200, pattern1 );
		l.load( MK_PATH("pattern2.gray.gz"), 320*200, pattern2 );
	} catch ( GZ_Error &err ) {
		err.report( cerr << endl );
		exit( 1 );
	}

	// load "*.pcx" indexed pixel map and build shade table if we need it
	floor_text = new PCX_8bpp;
	if ( !floor_text->load( MK_PATH("cooltext.pcx"), 0xffffff, 0xffffff ) ) {
		cerr << "PCX: floor_text load error" << endl;
		exit( 1 );
	}

	// load raytracing scenes and keyframing information
	if ( !RAYTR::load_scene( MK_PATH("final.scn"), &vport, &scn1 ) ) {
		cerr << "RAYTR: load_scene() failed."  << endl;
		exit( 1 );
	}
	
	if ( !RAYTR::load_scene( MK_PATH("atom.scn"), &vport, &scn3 ) ) {
		cerr << "RAYTR: load_scene() failed."  << endl;
		exit( 1 );
	}
}

//
// initialize the effects and make some precalculations
//

static void init()
{
	cerr << "Generating the code of the 3D engine, please wait..." << endl;

	initCrap3d();
 
	// allocate memory and load a scene
	if ( !(scene3d = (scene*)malloc(sizeof(scene) )) ) {
		cerr << "FATAL: failed to allocate memory pool for 3D scene..." << endl;
		exit( 1 );
	}
  
	if ( loadScn( MK_PATH("parodie.scn"), scene3d ) ) {
		cerr << "FATAL: failed to load 3D scene..." << endl;
		exit( 1 );
	}

	cerr << "MMmMm: 3D scene successfully loaded... yahoo!" << endl;

	// some dummy texture
	for ( int i = 0; i < 16; i++ )
		scene3d->textures[i] = t3d_col2; 

	// socle
	scene3d->textures[0] = t3d_col2;
	// collumns
	scene3d->textures[1] = t3d_col;
	// setup textures
	scene3d->textures[2] = t3d_col2;
	//  "3D"
	scene3d->textures[3] = t3d_sol;
	// ground
	scene3d->textures[4] = t3d_weeve;
	// "suck"
	scene3d->textures[5] = t3d_weeve;
	// socle
	scene3d->textures[7] = t3d_weeve;
	// socle
	scene3d->textures[8] = t3d_weeve;
	// socle
	scene3d->textures[9] = t3d_weeve;

	cerr << "Initializing, Calculating, Integrating, Derivating, Waiting..." << endl;

	// global lookup
	Lerp<float> d( 1, 319, 200 );
	for ( int y = 0; y < 200; y++, d.next() )
		xdiag[y] = int( d.value() );

	// tunnels lookup
	tun1 = new Tunnel( Std_Tunnel( 4096.0 ) );
	tun2 = new Tunnel( Flat_Tunnel( 128.0 ) );
	tun3 = new Tunnel( Weird_Tunnel( 2048.0 ) );
	btun1 = new Big_Tunnel( Std_Tunnel( 4096.0 ) );
	btun2 = new Big_Tunnel( Flat_Tunnel( 128.0 ) );
	btun3 = new Big_Tunnel( Weird_Tunnel( 2048.0 ) );

	// bar...
	bar = new Slimy_Sinus_Bar( banner, 1024, 80 );

	// blobs distance lookup
	blobs = new Blobs( 10, pyr[6] );

	// particle blast & dynamic system
	dynsys = new Dynamic_System( 30, 50.0f );

	// spline
	init_spline();	
}

static void intro()
{
	Pattern_Fade *fader = new Pattern_Fade( pattern1, linux_inside );

	// OpenPTC logo
	for ( int x = 0; x <= 40; x++ ) {
		for ( int i = 0; i < 320; i += 40 )
			copyrect( i, 0, x, 200, openptc, psurf );
		blit();	
	}

	// wait end of jingle
	MIDAS_waitfx();

	for ( int y = 0; y <= 20; y++ ) {
		for ( int i = 0; i < 200; i += 20 )
			fillrect( 0, i, 320, y, 0, psurf );
		blit();	
	}

	// fade in
	for ( int i = 0; i < 256; i++ ) {
		memset32( psurf, rgb32(i,i,i), 320*200 );
		blit();
	}

	// fade in "linux inside" logo
	while ( !fader->done() ) {
		fader->draw_static( psurf );
		fader->update();
		blit();
	}

	// wait end of jingle (delay fx in the module)
	MIDAS_waitfx();

	for ( int y = 0; y <= 20; y++ ) {
		for ( int i = 0; i < 200; i += 20 )
			fillrect( 0, i, 320, y, 0xffffff, psurf );
		blit();	
	}

	delete fader;	
}

// i still wonder why this one's called "scientists"
static void scientists()
{
	static Sprite *spr[5];

	spr[0] = new Sprite( spr_exercise, exercise_w, exercise_h, 0xff );
	spr[1] = new Sprite( spr_alert, alert_w, alert_h, 0xff );
	spr[2] = new Sprite( spr_partcool, partcool_w, partcool_h, 0xff );
	spr[3] = new Sprite( spr_molecules, molecules_w, molecules_h, 0xff );
	spr[4] = new Sprite( spr_nrg, nrg_w, nrg_h, 0xff );
	int snum = -1;
	int prev = sync_cnt2;

	Test_Warper warp; 

	// wait for kick 
	MIDAS_waitfx();

	while_MIDAS_waitfx {
		if ( prev != sync_cnt2 ) {
			prev = sync_cnt2;
			snum++;
		}
		float t = timer.time();
		warp.update( t*100 );
		warp.Texture_Warper::calc( g8x8 );
		g8x8.lerp_uv_avg( psurf, texture );
		if ( snum >= 0 ) {
			int x = int(160-(spr[snum]->width()>>1)+30*cos(t*3.0*M_PI));
			int y = int(70+20*sin(t*2.0*M_PI));	 
			spr[snum]->move_to( x, y ); 
			spr[snum]->draw( psurf );
			// THIS ONE WAS ADDED AT THE LAST MINUTE... as usual :)
			//rect_avg( x-3, y-3, spr[snum]->width()+6, spr[snum]->height()+6, 0xffffff, psurf );
		}
		blit();
		t += 0.02f;
	}
	
	int32 col = rgb32(255,255,255);
	for ( int y = 0; y <= 200; y += 2 ) {
		fillrect( 0, 0, 80, y, col, psurf );
		fillrect( 160, 0, 80, y, col, psurf );
		fillrect( 80, 200-y, 80, y, col, psurf );
		fillrect( 240, 200-y, 80, y, col, psurf );
		blit();
	}

	MIDAS_waitfx();
}

static void title()
{
	Pattern_Fade *fader = new Pattern_Fade( pattern2 );
	Cube *q = new Cube( 300.0, rgb32(151,169,196), 160.0f ); 
	float t;

	for ( int x = 0; x <= 320; x += 1 ) {
		fillrect( 320-x, 0, x, title_border_h, rgb32(74,74,140), psurf );	
		fillrect( 0, title_border_h+magnus_title_h, x, title_border_h, rgb32(74,74,140), psurf );	
		blit();
	}

	for ( int y = 0; y <= magnus_title_h; y++ ) {
		int size = y*320;
		memcpy32( psurf+((title_border_h+magnus_title_h)*320)-size, magnus_title, size );
		blit();
	}

	while_MIDAS_waitfx {
		t = timer.time();
		fillrect_avg( 0, 0, 320, title_border_h, rgb32(74,74,140), psurf );	
		fillrect_avg( 0, title_border_h+magnus_title_h, 320, title_border_h, rgb32(74,74,140), psurf );	
		q->rotate( t, t, t );
		q->draw( psurf );
		memcpy32( psurf+title_border_h*320, magnus_title, 320*magnus_title_h );
		blit();
	}

	while ( !fader->done() ) {
		t = timer.time();
		fillrect_avg( 0, 0, 320, title_border_h, rgb32(74,74,140), psurf );	
		fillrect_avg( 0, title_border_h+magnus_title_h, 320, title_border_h, rgb32(74,74,140), psurf );	
		q->rotate( t, t, t );
		q->draw( psurf );
		memcpy32( psurf+title_border_h*320, magnus_title, 320*magnus_title_h );
		fader->draw_dynamic( psurf, 0xffffff );
		fader->update( 2 );
		blit();
	}

	// wait for kasja to start singing
	MIDAS_waitfx();
}

static void vector_cube()
{
	Cube2 *q = new Cube2( 150.0, 0xfffffff );
	Sprite *hdk = new Sprite( spr_headache, headache_w, headache_h, 0xff );
	float t;
	Lerp<float> lampl( 0.0, 60.0, 20.0 );
	float ampl = lampl.value();

	q->set_perspective( 64, 64 );

	int y = 0;
	float z;
	for ( z = 256.0; z <= 768.0; z += 2.0 ) {
		t = timer.time();
		memavg32( psurf, formula1, 320*200 ); 
		hdk->move_to( 20+30*cos(t*2*M_PI), (100-headache_h*0.5)+50*cos(t*3*M_PI) );
		hdk->draw( psurf );
		q->rotate( t*M_PI*0.66, M_PI*0.25f, t*M_PI );
		q->set_center( 160.0+ampl*cos(t), 100.0+ampl*sin(t), z );
		q->draw( psurf );
		blit();
		t += 0.01;
	}

	// stops a bit too early to leave time for transition fx
	while_MIDAS_waitfx {
		t = timer.time();
		memavg32( psurf, formula1, 320*200 ); 
		hdk->move_to( 20+30*cos(t*2*M_PI), (100-headache_h*0.5)+50*cos(t*3*M_PI) );
		hdk->draw( psurf );
		q->rotate( t*M_PI*0.66, M_PI*0.25f, t*M_PI );
		if ( !lampl.done() ) {
			ampl = lampl.value();
			lampl.next();
		}
		q->set_center( 160.0+ampl*cos(t)*sin(-t*0.7), 100.0+ampl*sin(t)*cos(t*0.5), z+ampl*2*sin(t*1.1) );
		q->draw( psurf );
		blit();
	}

	// transition
	for ( int h = 0; h <= 25; h++ ) { 
		t = timer.time();
		memavg32( psurf, formula1, 320*200 ); 
		hdk->move_to( 20+30*cos(t*2*M_PI), (100-headache_h*0.5)+50*cos(t*3*M_PI) );
		hdk->draw( psurf );
		q->rotate( t*M_PI*0.66, M_PI*0.25f, t*M_PI );
		q->draw( psurf );
		for ( int y = 0; y < 200; y += 25 )
			copyrect( 0, y, 320, h, albert_backgnd, psurf );
		blit();
	}

	// wait fx to go the tge next part
	MIDAS_waitfx();

}

static void albert_rules()
{
	Sprite *big = new Sprite( spr_bigalb, bigalb_w, bigalb_h, 0xff );
	Sprite *sm[5]; 
	Cube *q = new Cube( 100.0, 0xfffffff, 50, 170, 256 );

	for ( int i = 0; i < 5; i++ ) {
		sm[i] = new Sprite( spr_smalb, smalb_w, smalb_h, 0xff );
		sm[i]->move_to( i*(smalb_w+10), 20 );
	}

	big->move_to( 320-bigalb_w-20, 0 );

	float t;
	// stop 2 early for transition
	while_MIDAS_waitfx {
		t = timer.time();
		memavg32( psurf, albert_backgnd, 320*200 );
		for ( int i = 0; i < 5; i++ ) {	
			int x = sm[i]->get_x()-2;
			if ( x <= -smalb_w )
				x = 320+smalb_w+15;
			sm[i]->move_to( x, int(20+10*sin((t+i*0.5)*M_PI)) );
			sm[i]->draw_avg( psurf );
		}
		q->rotate( t, t*0.8, -t*0.7 );
		q->set_perspective( 128+64*cos(t*8), 128 );
		q->draw( psurf );
		big->draw( psurf );
		blit();
	}

	// fill right half
	MIDAS_waitfx2();
	copyrect( 160, 0, 160, 100, unity, psurf );
	copyrect( 0, 100, 160, 100, unity, psurf );
	blit();

	// fill left half
	MIDAS_waitfx2();
	copyrect( 0, 0, 160, 100, unity, psurf );
	copyrect( 160, 100, 160, 100, unity, psurf );
	blit();

	// extra wait to avoid sync fuckup's
	MIDAS_waitfx();


}

static void raytracing3()
{
	float t;

	scn3.flags = RAYTR::RND_STD|RAYTR::RND_SHADOWS|RAYTR::RND_REFLECT;

	while_MIDAS_waitfx {
		t = timer.time()*0.1;

		memcpy32( psurf, rayflarez, 30*320 );
		memcpy32( psurf+170*320, rayflarez+170*320, 30*320 );

		scn3.light.x = 400*cos(t*M_PI);
		scn3.light.y = 400-150*cos(cos(t*M_PI)*M_PI);			
		scn3.light.z = 400*sin(t*M_PI);

		float dist = 500+300*sin(t*1.25*M_PI);
		scn3.cam.rvp.x = dist*sin(t*M_PI);
		scn3.cam.rvp.y = 200+150*sin(cos(t*M_PI)*M_PI);			
		scn3.cam.rvp.z = dist*cos(t*M_PI)*cos(-t*M_PI*0.5);

		float angle = -t*2*M_PI;
		((RAYTR::MODEL_SPHERE *)scn3.objects[1].model_info)->loc.x = 120*cos(angle);
		((RAYTR::MODEL_SPHERE *)scn3.objects[1].model_info)->loc.z = 120*sin(angle);
		((RAYTR::MODEL_SPHERE *)scn3.objects[2].model_info)->loc.x = 120*cos(angle+M_PI);
		((RAYTR::MODEL_SPHERE *)scn3.objects[2].model_info)->loc.z = 120*sin(angle+M_PI);
		angle += M_PI*0.5;
		((RAYTR::MODEL_SPHERE *)scn3.objects[3].model_info)->loc.x = 120*cos(angle);
		((RAYTR::MODEL_SPHERE *)scn3.objects[3].model_info)->loc.y = 120*sin(angle);
		((RAYTR::MODEL_SPHERE *)scn3.objects[4].model_info)->loc.x = 120*cos(angle+M_PI);
		((RAYTR::MODEL_SPHERE *)scn3.objects[4].model_info)->loc.y = 120*sin(angle+M_PI);

		RAYTR::render( scn3, vport );
		RAYTR::interp_grid( psurf+30*320 );
		
		blit();
	}	
}

static void floor_thing()
{
	Free_Direction_Floor *floor = new Free_Direction_Floor;
	floor->set_wave_ampl( 25 );

	Sprite *ban = new Sprite( spr_desint, desint_w, desint_h, 0xff );
	Sprite *ban2 = new Sprite( spr_fuse, fuse_w, fuse_h, 0xff );

	ban->replace( 0xffffff, 0x808080 );
	ban2->replace( 0xffffff, 0x808080 );

	float t;
	while_MIDAS_waitfx {
		t = timer.time();
		ban->move_to( 10, (100-(desint_h>>1))+((110-(desint_h>>1))*cos(t*0.5*M_PI)) );
		ban2->move_to( (320-fuse_w-10)+(fuse_w*0.25*cos(t*2.7*M_PI)),
			       (100-(fuse_h>>1))+(fuse_h*0.5*sin(t*0.8*M_PI)) );
		floor->rotate( t*0.5*M_PI, t*0.75*M_PI, -t*0.25*M_PI );
		floor->update_waves();
		floor->Texture_Warper::calc( g8x8 );
		g8x8.lerp_uvi( psurf, floor_text->pixmap, *floor_text->shtab );
		ban->draw_avg( psurf );
		ban2->draw_avg( psurf );
		blit();	
	}

	for ( int w = 0; w <= 80; w += 2 ) {
		// upper left
		copyrect( 0, 0, w, 100, pyr[0], psurf );
		copyrect( 160-w, 0, w, 100, pyr[0], psurf );
		// lower right
		copyrect( 160, 100, w, 100, pyr[0], psurf );
		copyrect( 320-w, 100, w, 100, pyr[0], psurf );
		// upper right
		copyrect( 160+80-w, 0, w, 100, pyr[0], psurf );
		copyrect( 160+80, 0, w, 100, pyr[0], psurf );
		// lower left
		copyrect( 80-w, 100, w, 100, pyr[0], psurf );
		copyrect( 80, 100, w, 100, pyr[0], psurf );
		blit();
	}
	MIDAS_waitfx();

}

static void blobbies()
{
	float t;
	while_MIDAS_waitfx {
		t = timer.time();
		memavg32( psurf, pyr[int(t*2.5)%6], 320*200 );
		blobs->update( t*40 );
		blobs->draw( psurf );
		blit();
	}

	MIDAS_waitfx;
	
	for ( int i = 0; i < 50; i++ ) {
		t = timer.time();
		memavg32( psurf, pyr[int(t*2.5)%6], 320*200 );
		blobs->update( t*40 );
		blobs->draw( psurf );
		// WARNING: this is a really bad use of the switch() statement !!!
		switch ( i/10 ) {
		default:
			// upper left
			copyrect( 0, 0, 80, 50, kickass, psurf );
			copyrect( 160, 0, 80, 50, kickass, psurf );
			copyrect( 0, 100, 80, 50, kickass, psurf );
			copyrect( 160, 100, 80, 50, kickass, psurf );
		case 2:
			// lower right
			copyrect( 80, 50, 80, 50, kickass, psurf );
			copyrect( 240, 50, 80, 50, kickass, psurf );
			copyrect( 80, 150, 80, 50, kickass, psurf );
			copyrect( 240, 150, 80, 50, kickass, psurf );
		case 1:
			// upper right
			copyrect( 80, 0, 80, 50, kickass, psurf );
			copyrect( 240, 0, 80, 50, kickass, psurf );
			copyrect( 80, 100, 80, 50, kickass, psurf );
			copyrect( 240, 100, 80, 50, kickass, psurf );
		case 0:
			// lower left	
			copyrect( 0, 50, 80, 50, kickass, psurf );
			copyrect( 160, 50, 80, 50, kickass, psurf );
			copyrect( 0, 150, 80, 50, kickass, psurf );
			copyrect( 160, 150, 80, 50, kickass, psurf );
		}
		blit();
	}

	MIDAS_waitfx();

}

static void greetings()
{
	Sprite *bigree = new Sprite( spr_greetings, 320, 200, 0xff );
	Sprite *iluvher = new Sprite( spr_kasja, kasja_w, kasja_h, 0xff );
	iluvher->move_to( 160-(kasja_w>>1), 100-(kasja_h>>1) );

	float t, t100;
	int i = 0;

	while_MIDAS_waitfx {
		t = timer.time();
		//bar->update( 200*sin(t*0.5*M_PI), 500*cos(t*0.3*M_PI), 512-320+(512-320)*sin(t*0.5*M_PI), 100*sin(t*0.4*M_PI) );	
		bar->update( 400*sin(t*0.3*M_PI), 500*cos(t*0.2*M_PI), 512-160+(512-160)*sin(t*0.5*M_PI), 100*sin(t*0.4*M_PI) );	
		tun2->set_u_offset( 128*cos(t*0.6*M_PI) );
		tun2->set_v_offset( 128*sin(t*0.8*M_PI) );
		tun2->draw( psurf, texture2 );
		bigree->draw_avg( psurf );
		bar->draw_avg( psurf );
		blit();
	}

	// kasja's tunnel fx - diz 1 is 4 ya and your charming voice! :))
	while_MIDAS_waitfx {
		t = timer.time();
		t100 = t*100;
		tun1->set_u_offset( t100 );
		tun2->set_u_offset( -t100 );
		tun3->set_v_offset( t100 );
		tun1->draw( psurf, texture );
		tun2->draw_avg( psurf, texture );
		tun3->draw_avg( psurf, texture2 );
		iluvher->draw_avg( psurf );
		blit();
	}
}

static void alnajjir_feat_kasja()
{
	Sprite *ear = new Sprite( spr_ear, ear_w, ear_h, 0xff );
	Sprite *earph = new Sprite( spr_earphones, earphones_w, earphones_h, 0xff );
	Sprite *synth = new Sprite( spr_synth, synth_w, synth_h, 0xff );
	Sprite *alkas = new Sprite( spr_alkas, alkas_w, alkas_h, 0xff );
	Sprite *muzk = new Sprite( spr_muzeek, muzeek_w, muzeek_h, 0xff );
	Lerp<float> lear( -ear_w, 320+ear_w, 200 );
	Lerp<float> learph( 320+earphones_w, -earphones_w, 200 );
	Lerp<float> lsynth( 200-synth_h, -synth_h, 200 );
	float t;

	for ( int i = 0; i < 200; i++ ) {
		t = timer.time();
		ear->move_to( lear.value(), 10 );
		earph->move_to( learph.value(), 50 );
		synth->move_to( 100, lsynth.value() );
		alkas->move_to( 3+10*sin(t*2.5*M_PI),
				3+10*cos(t*2.0*M_PI) );
		muzk->move_to( 320-muzeek_w-7+10*cos(t*2.5*M_PI),
			       200-muzeek_h-7+10*sin(t*2.8*M_PI) );
		memavg32( psurf, studio, 320*200 );
		alkas->draw( psurf );
		ear->draw_avg( psurf );
		muzk->draw( psurf );
		earph->draw_avg( psurf );
		synth->draw_avg( psurf );
		lear.next();
		learph.next();
		lsynth.next();
		blit();
	}	
}

static void chemical_reaction()
{
	float t;
	Sprite *form = new Sprite( spr_reaction, reaction_w, reaction_h, 0xff );
	dynsys->set_center( 265, 100 );

	memcpy32( psurf, formula2, 320*200 );

	while_MIDAS_waitfx  {
		t = timer.time();
		memavg32( psurf, formula2, 320*200 );
		form->move_to(10*cos(t*2.0*M_PI), (110-reaction_h*0.5)+20*sin(t*4.0*M_PI) );
		form->draw( psurf );
		dynsys->update( t*100 );
		dynsys->draw( psurf );
		blit();
	}

	delete form;
}


static void multi_tunnels()
{
	Sprite *spr = new Sprite( spr_meta, meta_w, meta_h, 0xff );
	spr->move_to( 160-(meta_w>>1), 100-(meta_h>>1) );
	float t, t100;

	while_MIDAS_waitfx {
		t = timer.time();
		t100 = t*100;
		btun1->set_u_offset( t100 );
		btun1->set_v_offset( ~unsigned(t100) );
		btun1->set_start_offset( 160+150*cos(t), 100+90*sin(t) );
		btun2->set_u_offset( -t100 );
		btun2->set_v_offset( t100 );
		btun2->set_start_offset( 160+150*cos(t+1.0), 100+90*sin(t-1.0) );
		btun3->set_u_offset( t100 );
		btun3->set_v_offset( -t100 );
		btun3->set_start_offset( 160-150*cos(t-2.0), 100+90*sin(t+2.0) );
		btun1->draw( psurf, texture );
		btun2->draw_avg( psurf, texture );
		btun3->draw_avg( psurf, texture2 );
		spr->draw_avg( psurf );
		blit();
	}

	int offset;
	for ( int y = 0; y < 200; y ++ ) {
		offset = y*320;
		memcpy32( psurf+offset, optimal+offset, xdiag[y] ); 	
		offset = (199-y)*320+xdiag[199-y];
		memcpy32( psurf+offset, optimal+offset, 320-xdiag[199-y] ); 	
		blit();
	}	

	MIDAS_waitfx();
}

static void alphatrion_spline()
{
	Sprite *alpha = new Sprite( spr_alpha, alpha_w, alpha_h, 0xff );
	Sprite *addcode= new Sprite( spr_addcode, addcode_w, addcode_h, 0xff );
	float t;
	memcpy32( psurf, formula2, 320*200 );
	// check "zone.c" for further details...
	pixcolor = 0xffffff;
	cubcolor = 0xffffff;
	while_MIDAS_waitfx {
		t = timer.time();
		update_spline( t*1.6 );
		alpha->move_to( 7+10*sin(t*2.5*M_PI), 7+10*cos(t*2.0*M_PI) );
		addcode->move_to( 320-addcode_w-9+10*cos(t*2.5*M_PI),
			       200-addcode_h-9+10*sin(t*2.8*M_PI) );
		memavg32( psurf, formula3, 320*200 );
		draw_spline( psurf );
		alpha->draw( psurf );
		addcode->draw( psurf );
		blit();
	}
}

static void raytracing1()
{
	float t;

	scn1.flags = RAYTR::RND_STD|RAYTR::RND_SHADOWS|RAYTR::RND_REFLECT;

	memcpy32( psurf, rayflarez, 30*320 );
	memcpy32( psurf+170*320, rayflarez+170*320, 30*320 );

	while_MIDAS_waitfx {
		t = timer.time()*0.1;

		float dist = 400+200*sin(t*1.25*M_PI);

		scn1.light.x = 400*cos(t*M_PI);
		scn1.light.y = 400-150*cos(cos(t*M_PI)*M_PI);			
		scn1.light.z = 400*sin(t*M_PI);

		scn1.cam.rvp.x = dist*sin(t*M_PI);
		scn1.cam.rvp.y = 300-250*sin(cos(t*M_PI)*M_PI);			
		scn1.cam.rvp.z = dist*cos(t*M_PI);
		scn1.cam.roll = M_PI*cos(t*M_PI*0.5);

		((RAYTR::MODEL_SPHERE *)scn1.objects[1].model_info)->loc.x = 40*cos(-t*2*M_PI);
		((RAYTR::MODEL_SPHERE *)scn1.objects[1].model_info)->loc.y = 40*cos(-t*2*M_PI);
		((RAYTR::MODEL_SPHERE *)scn1.objects[1].model_info)->loc.z = 40*sin(-t*2*M_PI);
		((RAYTR::MODEL_SPHERE *)scn1.objects[1].model_info)->rad = 30+20*cos(-t*2.5*M_PI);
		((RAYTR::MODEL_SPHERE *)scn1.objects[2].model_info)->loc.x = -40*cos(-t*2*M_PI);
		((RAYTR::MODEL_SPHERE *)scn1.objects[2].model_info)->loc.y = -40*cos(-t*2*M_PI);
		((RAYTR::MODEL_SPHERE *)scn1.objects[2].model_info)->loc.z = -40*sin(-t*2*M_PI);
		((RAYTR::MODEL_SPHERE *)scn1.objects[1].model_info)->rad = 30+20*sin(t*2.5*M_PI);
		
		RAYTR::render( scn1, vport );
		RAYTR::interp_grid( psurf+30*320 );
		
		blit();
	}	
}

static void brioche_and_colas()
{
	Sprite *mag = new Sprite( spr_magtape, magtape_w, magtape_h, 0xff );
	Sprite *sat = new Sprite( spr_satellite, satellite_w, satellite_h, 0xff );
	Sprite *cam = new Sprite( spr_camera, camera_w, camera_h, 0xff );
	Sprite *brioche = new Sprite( spr_brioche, brioche_w, brioche_h, 0xff );
	Sprite *colas = new Sprite( spr_colas, colas_w, colas_h, 0xff );
	Sprite *code = new Sprite( spr_codepix, codepix_w, codepix_h, 0xff );
	Sprite *engine = new Sprite( spr_engine, engine_w, engine_h, 0xff );

	static const int nsteps = 200;

	Lerp<float> lmag( -magtape_w, 320, nsteps );
	BLerp<float> lsat( 320, 200, -satellite_w, -satellite_h, nsteps );
	Lerp<float> lcam( 200, -camera_h, nsteps );

	float t;
	for ( int i = 0; i < nsteps; i++ ) {
		t = timer.time();
		mag->move_to( lmag.value(), 10 );
		sat->move_to( lsat.value1(), lsat.value2() );
		cam->move_to( 100, lcam.value() );
		brioche->move_to( 3+10*sin(t*2.5*M_PI),
				3+10*cos(t*2.0*M_PI) );
		code->move_to( 320-codepix_w-7+10*cos(t*2.5*M_PI),
			       200-codepix_h-7+10*sin(t*2.8*M_PI) );
		memavg32( psurf, ibm, 320*200 );
		brioche->draw( psurf );
		code->draw( psurf );
		mag->draw_avg( psurf );
		sat->draw_avg( psurf );
		cam->draw_avg( psurf );
		lmag.next();
		lsat.next();
		lcam.next();
		blit();
	}

	lmag.set( -magtape_h, 200, nsteps );
	lsat.set( -magtape_w, 200, 320, -magtape_h, nsteps );
	lcam.set( 320, -camera_w, nsteps );

	for ( int i = 0; i < nsteps; i++ ) {
		t = timer.time();
		mag->move_to( 40, lmag.value() );
		sat->move_to( lsat.value1(), lsat.value2() );
		cam->move_to( lcam.value(), 200-camera_h-10 );
		engine->move_to( 3+10*sin(t*2.5*M_PI),
				3+10*cos(t*2.0*M_PI) );
		colas->move_to( 320-codepix_w-7+10*cos(t*2.5*M_PI),
			       200-codepix_h-7+10*sin(t*2.8*M_PI) );
		memavg32( psurf, ibm, 320*200 );
		colas->draw( psurf );
		engine->draw( psurf );
		mag->draw_avg( psurf );
		sat->draw_avg( psurf );
		cam->draw_avg( psurf );
		lmag.next();
		lsat.next();
		lcam.next();
		blit();
	}	
}

void dummy_effect()
{
	float t;
	Test_Warper2 warp; 
	Sprite *spr = new Sprite( spr_laspi, laspi_w, laspi_h );
	spr->move_to( 160-(laspi_w>>1), 100-(laspi_h>>1) );
	while_MIDAS_waitfx {
		t = timer.time();
		warp.update( t*10 );
		warp.Texture_Warper::calc( g8x8 );
		g8x8.lerp_uv_avg( psurf, texture2 );
		spr->draw_add( psurf );
		blit();	
	}

	//int32 col = rgb32(49,49,100);
	for ( int y = 0; y <= 50; y++ ) {
		copyrect( 0, 0, 320, y, aspirine_square, psurf );
		copyrect( 0, 100-y, 320, y, aspirine_square, psurf );
		copyrect( 0, 100, 320, y, aspirine_square, psurf );
		copyrect( 0, 200-y, 320, y, aspirine_square, psurf );
		blit();
	}		

	MIDAS_waitfx();
}

void end_of_file()
{
	MIDAS_waitfx();
	while_MIDAS_waitfx {
		for ( int y = 0; y < 200; y++ ) {	
			int offset = y*320;
			int32 *p = psurf+159+offset;
			int32 *p2 = psurf+161+offset;
			for ( int x = 0; x < 160; x++ ) {
				*(p+1) = inc_rgb32( *(p+1) );
				*(p2-1) = inc_rgb32( *(p2-1) );
				*p = avg_rgb32( *p, *(p+1) );
				*p2 = avg_rgb32( *p2, *(p2-1) );
				p--, p2++;			
			}
		}	
		blit();
	}	
}

void da_scene() 
{
	static int pos[8] = { 10, 84, 140, 75, 110, 34, 95, 134 };
	static Sprite *s[8];
	static Sprite *bin[2];

	for ( int i = 0; i < 8; i++ )
		s[i] = new Sprite( banner3d[i], 320, 50 );

	bin[0] = new Sprite( bindigits[0], 64, 400 );
	bin[1] = new Sprite( bindigits[1], 64, 400 );

	int n = 0;
	int p = sync_cnt;
	int index;
	int blur = 0;

	// restart timer for keyframer to start rendering at 0.0
	timer.stop();
	timer.set(0);
	timer.start();

	float t = 0.0;
	while ( t < 6000 )  {
		t = timer.time()*10.0;
		index = int(t*2)%200;
		if ( t > 100 && con.key() ) 
			break;		
		if ( p != sync_cnt ) {
			blur = 0;
			p = sync_cnt;
			n++;
			n %= 8;
			if ( n == 0 )
				blur = 1;
		}
		buildFrame( scene3d, psurf, t );
		s[n]->draw_add( psurf+pos[n]*320 );
		bin[blur]->move_to( 15, -index );
		bin[blur]->draw_add( psurf );		
		blit();
	}

}


int main( int argc, char **argv )
{
	parse_command_line( argc, argv );
	startup_linux();
	load_data();
	init();

	try {
		Format fmt( 32, 0xff0000, 0xff00, 0xff );
		con.open( "aspirine - magnus' effect", 320, phys_h, fmt );
		surf = new Surface( 320, 200, fmt );
		psurf = (int32 *)surf->lock();
#ifdef __MUSIC
		MIDAS_init( MK_PATH("demo.xm") );
		MIDAS_play();
#endif
		timer.start();
		
		intro();
		scientists();
		title();
		vector_cube();
		albert_rules();
		raytracing3();
		floor_thing();
		blobbies();
		greetings();	
		alnajjir_feat_kasja();	
		chemical_reaction();
		multi_tunnels();
		alphatrion_spline();
		raytracing1();	
		brioche_and_colas();
		dummy_effect();
		end_of_file();

		if ( !shad_sucks ) {
			MIDAS_jump( 0x38 );
			da_scene();
		}
		
		timer.stop();		
		con.close();

		cerr << endl
	             << "copyleft 1999 - aspirine design dept" << endl
	             << "live performance at inscene'99 party" << endl	
		     << "dozens of sleepless hours with vi..." << endl << endl
		     << "peace to you out there!" << endl << endl;

	} catch( Error &err ) {
		err.report();
	}

#ifdef __MUSIC
	MIDAS_stop();
	MIDAS_shutdown();
#endif

	uninitCrap3d();
	unloadScn(scene3d);
	free(scene3d);

	return 0;
}


