
#include <iostream>
#include "Pattern.h"

Pattern_Fade::Pattern_Fade( char8 *pattern, int32 *source )
{
	src = source;
	patt = pattern;
	step = 0;
}

void Pattern_Fade::invert()
{
	char8 *ptr = patt;
	for ( int i = 0; i < 320*200; i++, ptr++ )
		*ptr = ~*ptr;
}

void Pattern_Fade::resample( float k )
{
	char8 *ptr = patt;
	for ( int i = 0; i < 320*200; i++, ptr++ )
		*ptr = int(float(*ptr)*k);
}

void Pattern_Fade::normalize()
{
	char8 *ptr = patt;
	for ( int i = 0; i < 320*200; i++, ptr++ )
		*ptr = 128+(*ptr>>1);
}

void Pattern_Fade::draw_static( int32 *surface )
{
	char8 *p = patt;
	int32 *s = src;
	int32 *d = surface;
	for ( int i = 0; i < 320*200; i++, p++, s++, d++ )
		if ( *p == step )
			*d = *s;
}

void Pattern_Fade::draw_dynamic( int32 *surface )
{
	char8 *p = patt;
	int32 *s = src;
	int32 *d = surface;
	for ( int i = 0; i < 320*200; i++, p++, s++, d++ )
		if ( *p <= step )
			*d = *s;
}

void Pattern_Fade::draw_static( int32 *surface, int32 color )
{
	char8 *p = patt;
	int32 *d = surface;
	for ( int i = 0; i < 320*200; i++, p++, d++ )
		if ( *p == step )
			*d = color;
}

void Pattern_Fade::draw_dynamic( int32 *surface, int32 color )
{
	char8 *p = patt;
	int32 *d = surface;
	for ( int i = 0; i < 320*200; i++, p++, d++ )
		if ( *p <= step )
			*d = color;
}


