
// Pattern guided fading class - brioche/aspirine 98
// previously used in our "Year 2000 Ready" demo, update july y2k-1

#ifndef _PATTERN_H_INCLUDED
#define _PATTERN_H_INCLUDED

#include <ptc.h>
#include "rgb32.h"

class Pattern_Fade {

	int step;
	int32 *src;
	char8 *patt;
		
public:	
	Pattern_Fade( char8 *pattern, int32 *source = 0 );

	void reset() { step = 0; }
	void update( int s = 1 ) { step += s; }
	bool done() const { return step > 255 ? true : false; }
	bool operator ! () const { return step > 255 ? false : true; }
	
	void invert();
	void resample( float k );
	void normalize();

	void draw_static( int32 *surface );
	void draw_dynamic( int32 *surface );	// this one is much slower!

	void draw_static( int32 *dest, int32 color );
	void draw_dynamic( int32 *dest, int32 color );
};

#endif // _PATTERN_H_INCLUDED
