
#include "ShadeTable.h"


Shade_Table::Shade_Table( Palette &pal, int32 lo, int32 hi )
{
	calc( (int32 *)pal.lock(), lo, hi );
	pal.unlock();
}

Shade_Table::Shade_Table( int32 *cmap, int32 lo, int32 hi )
{
	calc( cmap, lo, hi );
}

Shade_Table::~Shade_Table()
{
	delete [] table;
}

void Shade_Table::calc( int32 *cmap, int32 lo, int32 hi )
{
	table = new int32[256*256];
	for ( int index = 0; index < 256; index++ ) {
		int offset = index<<8;
		int32 r = red32( cmap[index] );
		int32 g = green32( cmap[index] );
		int32 b = blue32( cmap[index] );
		float ir = float(red32(lo));
		float ig = float(green32(lo));
		float ib = float(green32(lo));
		float dr = float(r-ir)/128.0;
		float dg = float(g-ig)/128.0;
		float db = float(b-ib)/128.0;
		
		for ( int shade = 0; shade < 128; shade++ ) {
			table[offset+shade] = rgb32( int(ir), int(ig), int(ib) );
			ir += dr;
			ig += dg;
			ib += db;
		}
			
		table[offset+128] = cmap[index];

		ir = float(r);
		ig = float(g);
		ib = float(b);
		dr = float(red32(hi)-r)/128.0;
		dg = float(green32(hi)-g)/128.0;
		db = float(blue32(hi)-b)/128.0;
		
		for ( int shade = 128; shade < 256; shade++ ) {
			table[offset+shade] = rgb32( int(ir), int(ig), int(ib) );
			ir += dr;
			ig += dg;
			ib += db;
		}
	}
}

