

#include <iostream>
#include "Sprite.h"

Sprite::clipping_area Sprite::clip = { 0, 0, 319, 199 };

Sprite::Sprite( int32 *pixmap, int w, int h, int32 transp = 0 )
{
	x = y = 0;
	Sprite::w = w;
	Sprite::h = h;
	Sprite::transp = transp;
	Sprite::pixmap = pixmap;
}

// this one is private thus we may inline the code to increase speed (see header)
// this clipping function returns true if the sprite is invisible
bool Sprite::calc_clipping( int &offset, int &nx, int &ny, int &clipw, int &cliph, int &skip )
{
	// trivial clipping is done right here 

	if ( x > clip.maxx || y > clip.maxy )
		return true;

	int yh = y+h-1;
	if ( yh < clip.miny )
		return true;

	int xw = x+w-1;
	if ( xw < clip.minx )
		return true;

	// non trivial clipping starts here
	nx = x;
	ny = y;
	offset = 0;
	skip = 0;
	clipw = w;
	cliph = h;

	// clip right
	if ( clip.maxx < xw ) {
		int tmp = xw-clip.maxx;
		clipw -= tmp;
		skip += tmp;
	}

	// clip left
	if ( clip.minx > x ) {
		int tmp = clip.minx-x;
		offset += tmp;
		skip += tmp;
		clipw -= tmp;
		nx += tmp;
	}

	// clip bottom
	if ( clip.maxy < yh )
		cliph -= yh-clip.maxy;

	// clip up
	if ( clip.miny > y ) {
		int tmp = clip.miny-y;
		cliph -= tmp;
		ny += tmp;
		offset += tmp*w;	
	}

	return false;
}

void Sprite::draw( int32 *surface )
{
	int offset, clipw, cliph, skip, nx, ny;

	if ( calc_clipping( offset, nx, ny, clipw, cliph, skip ) )
		return;

	register int32 *spr = pixmap+offset;		

	for ( int j = 0; j < cliph; j++ ) {
		register int32 *surf = surface+(ny+j)*320+nx;		
		for ( int i = 0; i < clipw; i++ ) {
			register int32 pix = *spr;
			if ( pix != transp )
				*surf = pix;
			surf++, spr++;
		}
		spr += skip;
	}
}

void Sprite::draw_avg( int32 *surface )
{
	int offset, clipw, cliph, skip, nx, ny;

	if ( calc_clipping( offset, nx, ny, clipw, cliph, skip ) )
		return;

	register int32 *spr = pixmap+offset;		
	for ( int j = 0; j < cliph; j++ ) {
		register int32 *surf = surface+(ny+j)*320+nx;		
		for ( int i = 0; i < clipw; i++ ) {
			register int32 pix = *spr;
			if ( pix != transp )
				*surf = avg_rgb32( *surf, pix );
			surf++, spr++;
		}
		spr += skip;
	}

}

void Sprite::draw_or( int32 *surface )
{
	int offset, clipw, cliph, skip, nx, ny;

	if ( calc_clipping( offset, nx, ny, clipw, cliph, skip ) )
		return;

	register int32 *spr = pixmap+offset;		
	for ( int j = 0; j < cliph; j++ ) {
		register int32 *surf = surface+(ny+j)*320+nx;		
		for ( int i = 0; i < clipw; i++ ) {
			register int32 pix = *spr;
			if ( pix != transp )
				*surf |= pix;
			surf++, spr++;
		}
		spr += skip;
	}

}

void Sprite::draw_add( int32 *surface )
{
	int offset, clipw, cliph, skip, nx, ny;

	if ( calc_clipping( offset, nx, ny, clipw, cliph, skip ) )
		return;

	register int32 *spr = pixmap+offset;		
	for ( int j = 0; j < cliph; j++ ) {
		register int32 *surf = surface+(ny+j)*320+nx;		
		for ( int i = 0; i < clipw; i++ ) {
			register int32 sr = red32( *spr );	
			register int32 sg = green32( *spr );	
			register int32 sb = blue32( *spr );	
			register int32 dr = red32( *surf );	
			register int32 dg = green32( *surf );	
			register int32 db = blue32( *surf );	
			dr += sr; if ( dr > 255 ) dr = 255;	
			dg += sg; if ( dg > 255 ) dg = 255;	
			db += sb; if ( db > 255 ) db = 255;	
			*surf = rgb32( dr, dg, db );
			surf++, spr++;
		}
		spr += skip;
	}

}


void Sprite::replace( int32 this_color, int32 by_this_one )
{
	for ( int i = 0; i < w*h; i++ )
		if ( pixmap[i] == this_color )
			pixmap[i] = by_this_one;
}
