
#include "TextWarp.h"

//
//	Abstract texture warper
//

Texture_Warper::Texture_Warper( bool init = false )
{
	has_init = init;
	t = 0.0f;
}

Texture_Warper::~Texture_Warper()
{
}

void Texture_Warper::calc( Grid_8x8_320x200 &g )
{
	if ( has_init )
		init_calc();	

        for ( int y = 0; y < 26; y++ )
                for ( int x = 0; x < 41; x++ )
			calc( x<<3, y<<3, g.grid[x][y] );
}

void Texture_Warper::calc( Grid_4x4_320x200 &g )
{
	if ( has_init )
		init_calc();	

        for ( int y = 0; y < 51; y++ )
                for ( int x = 0; x < 81; x++ )
			calc( x<<2, y<<2, g.grid[x][y] );
}

//
//	RotoZoomer
//

RotoZoomer::RotoZoomer( float a, float d ) : Texture_Warper( true ), mtx()
{
	ang = a;
	dist = d;
}
	
void RotoZoomer::init_calc()
{
	ang = t;
	dist = 1.1+sin(t*1.5);
	mtx.rotate_xyz( ang, ang*0.33, -ang );
}

void RotoZoomer::calc( int x, int y, Grid_Item &item )
{
	Vector v( (160.0-x)*dist, (100.0-y)*dist, 0 );
	v = mtx*v;
	item.u = int(v.x);	
	item.v = int(v.y);	
}

// 
//	Test warper
//

void Test_Warper::calc( int x, int y, Grid_Item &item )
{
	float ampl = 1.0*sin(t*M_PI/256);
	item.u = int(x+24.0*cos((t+x)*M_PI/256.0)*(2.0+ampl)); 
	item.v = int(y+16.0*cos((t+y)*M_PI/128.0)*(2.0+ampl)); 
	item.u += int(x+30*sin((t*2.1+y*0.75)*M_PI/256)+40*cos(t*M_PI/128));
	item.v += int(y+30*sin((t*2.0+x*0.75)*M_PI/256)+40*sin(t*M_PI/128));
}

// 
//	Test warper 2
//

void Test_Warper2::calc( int x, int y, Grid_Item &item )
{
	float ampl = 2.0+sin(t);
	item.u = int(x+(24*cos((t+x)*M_PI/256)*ampl*sin((x+t)*M_PI/128)));
	item.v = int(y+(16*sin((t+y)*M_PI/256)*ampl*sin((y+t)*M_PI/128)));
}


