
// abstract texture warper - brioche/aspirine <xdefrang@csi.com>

#ifndef _TEXTWARP_H_INCLUDED
#define _TEXTWARP_H_INCLUDED

#include <ptc.h>
#include "Vector.h"
#include "Matrix.h"
#include "Grid.h"

class Texture_Warper {
	bool has_init;
	inline void defaults();
protected:
	float t;
	virtual void init_calc() {};
	virtual void calc( int x, int y, Grid_Item &item ) = 0;
public: 
	Texture_Warper( bool init = false );
	virtual ~Texture_Warper();

	void update( float nt ) { t = nt; }
	void calc( Grid_8x8_320x200 &g );
	void calc( Grid_4x4_320x200 &g );
};

// some quick-n-dirty test fx
class RotoZoomer : public Texture_Warper {
	float ang, dist;
	Matrix mtx;
protected:
	void init_calc();
	void calc( int x, int y, Grid_Item &item );
public:
	RotoZoomer( float a, float d );
	
};

// more interresting stuff here
class Test_Warper : public Texture_Warper {
protected:
	void calc( int x, int y, Grid_Item &item );
public:
	Test_Warper() : Texture_Warper(false) {};
};

class Test_Warper2 : public Texture_Warper {
protected:
	void calc( int x, int y, Grid_Item &item );
public:
	Test_Warper2() : Texture_Warper(false) {};
};


#endif // _TEXTWARP_H_INCLUDED

