#include <math.h>
#include "3dmath.h"

//#include "tinymath.h"

#include <math.h>

/*
long ceil(const double f)
{
 long i;
 //fist(&i,f);
 i=f; // casting
 if(f-i) ++i;
 return(i);
}
*/

void subvectors (vector *v, vector *u)
{
 v->x-=u->x; v->y-=u->y; v->z-=u->z;
}

void addvectors (vector *v, vector *u)
{
 v->x+=u->x; v->y+=u->y; v->z+=u->z;
}

void mulvector (vector *v, const float u)
{
 v->x*=u; v->y*=u; v->z*=u;
}


void crossproduct (vector *r, vector *u, vector *v)
{
    r->x = (u->y * v->z) - (u->z * v->y);
    r->y = (u->z * v->x) - (u->x * v->z);
    r->z = (u->x * v->y) - (u->y * v->x);
}



void dotproduct (float *r, vector *u, vector *v)
{
 *r = u->x * v->x + u->y * v->y + u->z * v->z;
}


void sqrlength (float *r, const vector v)
{
 *r = v.x*v.x + v.y*v.y + v.z*v.z;
}

void length (float *r, const vector v)
{
 *r = sqrt(v.x*v.x + v.y*v.y + v.z*v.z);
}

void normalize (vector *v)
{
 register float distance =1.0/sqrt(v->x*v->x + v->y*v->y + v->z*v->z);
 v->x*=distance; v->y*=distance; v->z*=distance;
}

void setlength (vector *v, const float longueur)
{
 register float distance = longueur/sqrt(v->x*v->x + v->y*v->y + v->z*v->z);
 v->x*=distance;  v->y*=distance; v->z*=distance;
}

// multiplie a par b resultat dans r
// seulement des matrices 3*3
void matmult (float *r, float *a, float *b)
{
    register int i,j;           // row and column counters

    for (j = 0; j < 9; j+=3)    // transform by columns first
     for (i = 0; i < 3; i++)    // then by rows
      r[i+j] = b[i] * a[j] + b[i+3] * a[1+j] + b[i+6] * a[2+j];

}


void transform (vector *s, vector *r, float *matrix)
{
        // 9 muls is faster than the 7 and 6 muls methods

        s->x = r->x * matrix[0] + r->y * matrix[1] + r->z * matrix[2];
        s->y = r->x * matrix[3] + r->y * matrix[4] + r->z * matrix[5];
        s->z = r->x * matrix[6] + r->y * matrix[7] + r->z * matrix[8];
}


// si la matrice est orthogonale inverse = transposee
// matrix(j,k) = source(k,j)
void transpose (float *matrix, float *source)
{
 // here's the inverse matrix calculation
 // here's the inverse matrix calculation
 matrix[0] = source[0];
 matrix[1] = source[3];
 matrix[2] = source[6];

 matrix[3] = source[1];
 matrix[4] = source[4];
 matrix[5] = source[7];

 matrix[6] = source[2];
 matrix[7] = source[5];
 matrix[8] = source[8];
}

void createRotationMatrix(float *matrix, const vector r)
{
  float sy = sin(r.y);
  float sx = sin(r.x);
  float sz = sin(r.z);
  float cy = cos(r.y);
  float cx = cos(r.x);
  float cz = cos(r.z);

  matrix[0] = (cx*cy)+((-sx*-sz)*-sy);
  matrix[1] = ((-sx*cz));
  matrix[2] = (cx*sy)+((-sx*-sz)*cy);
  matrix[3] = (sx*cy)+((cx*-sz)*-sy);
  matrix[4] = ((cx*cz));
  matrix[5] = (sx*sy)+((cx*-sz)*cy);
  matrix[6] = (cz*-sy);
  matrix[7] = sz;
  matrix[8] = (cz*cy);
}


// fonction qui contruit une matrice 3*3 de rotation
// en fonction des vecteurs position et lookat
// rolldegrees = si on tourne la tete

void createViewMatrix(float *matrix, vector position, const vector lookat, const float rolldegrees)
{
 float sz,cz;
 vector xAxis,yAxis,zAxis;
 double roll;

 zAxis=lookat;
 subvectors(&zAxis, &position);
 normalize(&zAxis);

 // le cas degenere est teste
 if (!zAxis.x && !zAxis.z) 
 {
  yAxis.x = -zAxis.y;
  yAxis.y = yAxis.z = 0.0;
 }
 else
 {
  yAxis.y = 1;
  yAxis.x = yAxis.z = 0.0;
 }

 crossproduct(&xAxis, &zAxis, &yAxis);
 normalize(&xAxis);   
 crossproduct(&yAxis, &zAxis, &xAxis); // Correct the Y reference vector

 // le roll = le negatif car camera

 roll=(M_PI-rolldegrees);
 sz=sin(roll);
 cz=cos(roll);

 // optimisation car beaucoup d'elements = 0

 matrix[0]=cz*xAxis.x+sz*yAxis.x;
 matrix[1]=cz*xAxis.y+sz*yAxis.y;
 matrix[2]=cz*xAxis.z+sz*yAxis.z;

 matrix[3]=-sz*xAxis.x+cz*yAxis.x;
 matrix[4]=-sz*xAxis.y+cz*yAxis.y;
 matrix[5]=-sz*xAxis.z+cz*yAxis.z;

 matrix[6]=zAxis.x;
 matrix[7]=zAxis.y;
 matrix[8]=zAxis.z;
}

// calcul du temps -> recherche dichotomique
//for (i=1;(time_track[i]<time) && (i<num_keys); ++i);
int search(short *time_track,const int num_keys,const float time)
{
 register int a=1,b=num_keys-3;
 while(a<=b)
 {
  register int i=(a+b)>>1;
  if (time_track[i] < time) a=i+1; else b=i-1;
 }
 return a;
}

// on considere les parametres tension bias et continuity comme des constantes
void keys_spline_vector(vector *position,vector *track,short *time_track,const int num_keys,const float time)
{
 register int i;
 register float t1;
 register int key1,key3,key4;
 float t2,t3,p1,p2,p3,p4;
 vector r1,r2;

 if((num_keys<4)||(time_track[0]>=time))
 {
  *position=track[0];
  return;
 }
 i=search(time_track,num_keys,time);

 // les quatres keys a envisager
 key1=i-1; key3=i+1; key4=i+2;

 t1=time-time_track[key1];
 t1/=time_track[i]-time_track[key1]; // time est compris entre 0 et 1

 // calculs des tangentes aux deux points

 r1.x = (track[key3].x - track[key1].x) * 0.5;
 r1.y = (track[key3].y - track[key1].y) * 0.5;
 r1.z = (track[key3].z - track[key1].z) * 0.5;

 r2.x = (track[key4].x - track[i].x) * 0.5;
 r2.y = (track[key4].y - track[i].y) * 0.5;
 r2.z = (track[key4].z - track[i].z) * 0.5;

 // calcul des 4 polynomes
 t2=t1*t1;
 t3=t2*t1;

 p1=(2 * t3 - 3 * t2 + 1);
 p2=(t3 - 2 * t2 + t1);
 p3=-p1+1;
 p4=(t3 - t2);

 position->x = track[key1].x * p1 + r1.x * p2 + track[i].x * p3 + r2.x * p4;
 position->y = track[key1].y * p1 + r1.y * p2 + track[i].y * p3 + r2.y * p4;
 position->z = track[key1].z * p1 + r1.z * p2 + track[i].z * p3 + r2.z * p4;

}

void keys_lerp_vector(vector *position,vector *track,short *time_track,const int num_keys,const float time)
{
 register int i,key1;
 register float t;

 if((num_keys<2)||(time_track[0]>=time))
 {
  *position=track[0];
  return;
 }
 i=search(time_track,num_keys,time);

 key1=i-1;

 t=time-time_track[key1];
 t/=time_track[i]-time_track[key1]; // time est compris entre 0 et 1

 position->x = lerp(track[key1].x , track[i].x, t);
 position->y = lerp(track[key1].y , track[i].y, t);
 position->z = lerp(track[key1].z , track[i].z, t);
}

// on considere les parametres tension bias et continuity comme des constantes
void keys_spline_float(float *position,float *track,short *time_track,const int num_keys,const float time)
{
 register int i,key1;
 register float t1;
 float t2,t3,p1,p2,p3,p4,r1,r2;

 if((num_keys<4)||(time_track[0]>=time))
 {
  *position=track[0];
  return;
 }
 i=search(time_track,num_keys,time);

 key1=i-1;

 t1=time-time_track[key1];
 t1/=time_track[i]-time_track[key1]; // time est compris entre 0 et 1
 
 // calculs des tangentes aux deux points

 r1 = (track[i+1] - track[key1]) * 0.5;
 r2 = (track[i+2] - track[i]) * 0.5;

 // calcul des 4 polynomes

 t2=t1*t1;
 t3=t2*t1;

 p1=(2 * t3 - 3 * t2 + 1);
 p2=(t3 - 2 * t2 + t1);
 p3=-p1+1;
 p4=(t3 - t2);

 *position = track[key1] * p1 + r1 * p2 + track[i] * p3 + r2 * p4;
}

void keys_lerp_float(float *position,float *track,short *time_track,const int num_keys,const float time)
{
 register int i,key1;
 register float t;

 if((num_keys<2)||(time_track[0]>=time))
 {
  *position=track[0];
  return;
 }
 i=search(time_track,num_keys,time);

 key1=i-1;

 t=time-time_track[key1];
 t/=time_track[i]-time_track[key1]; // time est compris entre 0 et 1

 *position= lerp(track[key1] , track[i], t);
}
