#include <math.h>
#include "compute.h"
#include "tinymath.h"
#include "clip.h"
#include "screen.h"
#include "3dmath.h"
#include "morphing.h"
#include "typebits.h"

#include "lighting.c"

void computeCamera(scene *scene3d, const float float_timer)
{
 register camera *c;

 //determiner la camera courante == 0
 c=scene3d->curentCamera=&scene3d->cameras[0];

 //interpoler la position et le lookat et le fov

 keys_spline_vector(&c->pos,c->positions,c->positions_times,c->num_positions_keys,float_timer);
 keys_spline_vector(&c->dir,c->lookats,c->lookats_times,c->num_lookats_keys,float_timer);
 keys_spline_float(&c->roll,c->rolls,c->rolls_times,c->num_rolls_keys,float_timer); 
 keys_spline_float(&c->fov,c->fovs,c->fovs_times,c->num_fovs_keys,float_timer);

 // construire une matrice de scaling plutot

  scene3d->DIST_PLANEX = sqrt(sqr(SXDIV2/cos((M_PI-(c->fov*(M_PI/180.0)))*0.5))+SXDIV2*SXDIV2);
  scene3d->DIST_PLANEY = ASPECT_RATIO*scene3d->DIST_PLANEX;

 // la camera
 createViewMatrix(scene3d->CMATRIX, c->pos, c->dir, c->roll);
}

// les calculs pour tous les flares et lensflares visibles
void computeFlares(scene *scene3d, const float float_timer)
{
 register int i;

 for (i=0;i<scene3d->num_FLARES ;++i) 
 {
  vector temp;
  register flare *o=scene3d->flares+i;
  register float invprof;

  keys_spline_vector(&o->pos,o->positions,o->positions_times,o->num_keys_positions,float_timer);

  temp=o->pos;
  subvectors(&temp, &scene3d->curentCamera->pos);
  transform (&temp, &temp, scene3d->CMATRIX); // rotation de l'objet

  // on projette la position
  if (temp.z<1.0)
  {
   o->p.z=0;
   continue;
  }

  invprof=1.0/temp.z;

  o->p.x=SXDIV2+temp.x*invprof*scene3d->DIST_PLANEX;
  o->p.y=SYDIV2-temp.y*invprof*scene3d->DIST_PLANEY;
  o->p.z=invprof;
  o->radius=(int)(o->taille*invprof*scene3d->DIST_PLANEX);
 }
}

// les calculs pour toute les lights ponctuelles
void computePonctuals(scene *scene3d, const float float_timer)
{
 register int i;

 for (i=0; i<scene3d->num_PONCTUALS; ++i) 
 {
  register ponctual *o=scene3d->ponctuals+i;

  keys_spline_vector(&o->pos,o->positions,o->positions_times,o->num_positions_keys,float_timer);
  keys_lerp_vector(&o->intensite,o->intensites,o->intensites_times,o->num_intensites_keys,float_timer);

  subvectors(&o->pos, &scene3d->curentCamera->pos);
  transform (&o->pos, &o->pos, scene3d->CMATRIX); // rotation de l'objet
 }

}

// les calculs pour tous les spots
void computeSpots(scene *scene3d, const float float_timer)
{
 register int i;

 for (i=0;i<scene3d->num_SPOTS; ++i) 
 {
  register spot *o=scene3d->spots+i;

  keys_spline_vector(&o->pos,o->positions,o->positions_times,o->num_positions_keys,float_timer);
  keys_spline_vector(&o->dir,o->lookats,o->lookats_times,o->num_lookats_keys,float_timer);
  keys_lerp_vector(&o->intensite,o->intensites,o->intensites_times,o->num_intensites_keys,float_timer);
  keys_lerp_float(&o->fov,o->fovs,o->fovs_times,o->num_fovs_keys,float_timer);

  subvectors(&o->pos, &scene3d->curentCamera->pos);
  transform (&o->pos, &o->pos, scene3d->CMATRIX); // rotation de l'objet

  subvectors(&o->dir, &scene3d->curentCamera->pos);
  transform (&o->dir, &o->dir, scene3d->CMATRIX); // rotation du point lookat

  subvectors(&o->dir, &o->pos); // vecteur centre
  normalize(&o->dir);
  //setlength(&o->dir,256);
 }
}

// les calculs pour tous les objets visibles
void computeObjects(scene *scene3d, const float float_timer)
{
 register int i;

 for (i=0; i<scene3d->num_OBJECTS ;++i) 
 {
  register object *o=scene3d->objets+i;

  // si il faut le morpher on morphe
  if (o->num_keys_morphing)
   morphing(o, float_timer);

  keys_spline_vector(&o->position,o->keys_position,o->keys_position_times,o->num_keys_position,float_timer);
  keys_spline_vector(&o->angle,o->keys_angle,o->keys_angle_times,o->num_keys_angle,float_timer);
 }
}

 float O[3*3]; // la matrice de rotation de l'objet
 float O1[3*3]; // la matrice de rotation inverse de l'objet
 float L[3*3]; // la matrice de rotation concatenee

void transformPolys(scene *scene3d, M3D_polygon **PIPELINE, int *num_polys)
{

 register int i,j,k;

 int CLIP3D,CLIP2D_AND,CLIP2D_OR;

 vector result_translate;
 vector camera_pos_inv;
 vector temp;

 *num_polys=0;
 ++scene3d->frame; // on change la vue

for (k=0; k< scene3d->num_OBJECTS ; ++k)
{
 object *o=scene3d->objets+k;

 o->num_more_polys=o->num_polygons;
 o->num_more_verts=o->num_vertices; 

 // rotation
 createRotationMatrix(O,o->angle); // l'objet
 transpose (O1,O); // inverse

 // transformer l'objet, le translater, puis appliquer la rotations de la camera
 matmult(L,scene3d->CMATRIX,O);

 //produit la meme matrice :-)
 //matmult (L1,O1,C1);
 //transpose(L1,L);

 temp=o->position;
 subvectors(&temp, &scene3d->curentCamera->pos);
 transform (&result_translate, &temp, scene3d->CMATRIX); // rotation de la translation

 // la lampe -> on lui applique la transformation inverse de l'objet
 // la direction de la lampe (peut changer avec une spline)
 // la position en fait

 // la camera pour le backface

 temp=scene3d->curentCamera->pos;
 subvectors(&temp, &o->position);
 transform (&camera_pos_inv, &temp, O1);

// les calculs pour tous les flares et lensflares visibles de l'objet

/*
for (i=0;i<o->num_flares;++i) 
{
 register flare *f=o->flares+i;

 transform (&temp, &f->pos, L); // rotation du flare
 addvectors(&temp, &result_translate);

 if (temp.z<1.0)
 {
  f->p.z=0;
  continue;
 }

 invprof=1.0/temp.z;

 f->p.x=SXDIV2+temp.x*invprof*scene3d->DIST_PLANEX;
 f->p.y=SYDIV2-temp.y*invprof*scene3d->DIST_PLANEY;
 f->p.z=invprof;
 f->radius=(f->taille*invprof*scene3d->DIST_PLANEX);
}
*/

// fin des calculs des flares

for (i=0;i<o->num_polygons;++i)
{
 float angle;

 // construire un vecteur de la camera a un point de la face

 temp=o->vertices[o->polygons[i].p[0]].pos;
 subvectors(&temp, &camera_pos_inv);
 
 // optimiser le dotproduct en asm !
 dotproduct(&angle, &temp, &o->polygons[i].normal);
 if ((angle < -0.01)&&!(o->polygons[i].type&NOBACKFACE)) continue;
 
 CLIP2D_AND=CLIP2D_OR=CLIP3D=0; 

// on transforme les trois vertices du poly
for (j=0;j<o->polygons[i].n;++j)
{
 float invprof;
 vertex *vert_ptr=o->vertices+o->polygons[i].p[j];

if (vert_ptr->counter == scene3d->frame)
{

 if (!vert_ptr->p.z) ++CLIP3D;
 else
 {
  CLIP2D_OR|=vert_ptr->clip;
  CLIP2D_AND&=vert_ptr->clip;
 }
 continue;
}

 transform (&temp, &vert_ptr->pos, L); // rotation de l'objet
 addvectors(&temp, &result_translate);

 vert_ptr->counter = scene3d->frame;
 vert_ptr->t=temp;

 if (temp.z<1.0)
 {
  vert_ptr->p.z=0;
  ++CLIP3D;
  continue;
 }

  invprof=1.0/temp.z;
  vert_ptr->p.x=SXDIV2+temp.x*invprof*scene3d->DIST_PLANEX;
  vert_ptr->p.y=SYDIV2-temp.y*invprof*scene3d->DIST_PLANEY;
  vert_ptr->p.z=invprof;

  // on indique si la vertice sort de l'ecran
  vert_ptr->clip=outsideBoundaries(vert_ptr->p.x, vert_ptr->p.y);
  CLIP2D_OR|=vert_ptr->clip;
  CLIP2D_AND&=vert_ptr->clip;

  if(!vert_ptr->clip)
   vert_ptr->y=(int)ceil(vert_ptr->p.y); //  d'office visible
   
  vert_ptr->_u=vert_ptr->um*invprof;
  vert_ptr->_v=vert_ptr->vm*invprof;


// on calcule l'illumination recue par ce point
// la lumiere de toute les lights ponctuelles et les spots sont calculees

//vert_ptr->i=128; // pas de lighting
//lighting(vert_ptr, scene3d);

}

if(*num_polys>PIPELINE_SIZE) printf("pipeline overflow");

 if (!CLIP3D)
 {
  if (CLIP2D_AND) continue; // pas visible

  // on clippe le polygone en 2d si besoin est
  if (CLIP2D_OR) // le or de tous les clipcodes
  {
   M3D_polygon *temp=clip2d(o, o->polygons+i);
   if(!temp) continue;
   PIPELINE[*num_polys]=temp; ++*num_polys; // partielement dans l'ecran
  }
  else
  {
   PIPELINE[*num_polys]=&o->polygons[i]; ++*num_polys; // pas clippe
  }
 }
 else if(CLIP3D!=o->polygons[i].n)  // pas toute les vtx deriere le plan
 {
  M3D_polygon *temp;

  temp=clip3d(scene3d, o, &o->polygons[i]);
  if(!temp) continue;
  // dans 90% des cas on devra clipper le poly en 2d aussi
  temp=clip2d(o, temp);
  if(!temp) continue;
  PIPELINE[*num_polys]=temp; ++*num_polys; // partielement dans l'ecran
 }
}
}
}
