#include "genshade.h"

void gen_shading(DWORD *shadeTable,BYTE *palette)
{
 DWORD index,r,g,b,shade;
 float ir,ig,ib,dr,dg,db,invdelta=1/128.0;

 // du noir a la couleur normale
 
	for ( index = 0; index < 256; index++ ) {


		// Extract rgb components from color
		r = palette[index*3];   // RED32		
		g = palette[index*3+1]; // GREEN32	
		b = palette[index*3+2]; // BLUE32

		// Compute starts and deltas from black to the current color
		ir = 0.0;
		ig = 0.0;
		ib = 0.0;
        dr = (float)(r)*invdelta;
        dg = (float)(g)*invdelta;
        db = (float)(b)*invdelta;

		// Let's perform some linear interpolation
		for ( shade = 0; shade < 128; shade++ ) {
                 shadeTable[(index<<8)+shade] = (DWORD)(((BYTE)ir<<16)+((BYTE)ig<<8)+(BYTE)ib); // RGB 888
			ir += dr;
			ig += dg;
			ib += db;
		}

		// Compute starts and deltas from current color to white
		ir = (float)(r);
		ig = (float)(g);
		ib = (float)(b);
        dr = (float)(255.0-r)*invdelta;
        dg = (float)(255.0-g)*invdelta;
        db = (float)(255.0-b)*invdelta;

		// Let's perform some linear interpolation
		for ( shade = 128; shade < 256; shade++ ) {
                 shadeTable[(index<<8)+shade] = (DWORD)(((BYTE)ir<<16)+((BYTE)ig<<8)+(BYTE)ib); // RGB 888
			ir += dr;
			ig += dg;
			ib += db;
		}
          }
}
