
/*
 *
 *      M O D E L - E L L I P S O I D
 *
 */

#include "ray.h"

float ellipsoid_distance( RAY ray, MODEL_ELLIPSOID obj )
{
        float A, B, C, D, sD, t, t0, t1;
        float tmpx, tmpy, tmpz;

        tmpx = (ray.loc.x-obj.loc.x)*obj.exc.x;
        tmpy = (ray.loc.y-obj.loc.y)*obj.exc.y;
        tmpz = (ray.loc.z-obj.loc.z)*obj.exc.z;

        A = SQR(ray.dir.x*obj.exc.x)+SQR(ray.dir.y*obj.exc.y)+SQR(ray.dir.z*obj.exc.z);
        B = 2.0f*(ray.dir.x*tmpx+ray.dir.y*tmpy+ray.dir.z*tmpz);
        C = SQR(tmpx)+SQR(tmpy)+SQR(tmpz)-SQR(obj.rad);
                
        D = SQR(B)-4*A*C;
        
        if ( D >= 0.0f ) {
                sD = sqrt( D );

#ifndef __QUADRATIC_SHORTCUT__
                t0 = (-B-sD)/(2.0f*A);
                t1 = (-B+sD)/(2.0f*A);
                
                if ( (t0 > 0) || (t1 > 0) ) {
                        t = INFINITE;

                        if ( t0 > 0 )
                                t = t0;
                        if ( (t1 < t0) && (t1 >= 0) )
                                t = t1;
                        
                        return t;
                }
#else
                return (t = (-B-sD)/(2.0f*A)) > 0.0 ? t : INFINITE;
#endif
        }

        return INFINITE;
}

void ellipsoid_hitnormal( MODEL_ELLIPSOID obj, VECTOR hit, VECTOR *norm )
{
        float tmp = 1.0f/obj.rad;
        norm->x = (obj.loc.x-hit.x)*tmp;
        norm->y = (obj.loc.y-hit.y)*tmp;
        norm->z = (obj.loc.z-hit.z)*tmp;
}

RGB ellipsoid_text_hitcolor( MODEL_ELLIPSOID_TEXT obj, VECTOR norm )
{
        float u, v;
        u = fabs(norm.z*0.2*256.0);
        v = fabs(atan2(norm.y,norm.x)*256.0/M_PI);
	u = u<0?0:(u>255?255:u);
	v = v<0?0:(v>255?255:v);
        return obj.texmap[(int)v*256+(int)u];
}
